#!/bin/bash
# Extract hardware information from sos report.
# Usage:
#  sutton-sos sosreport-Padme3-P1-2-20200514005914
set -x
SOS_PATH=$1 

if [ "$SOS_PATH" = "" ]; then
  echo "sutton-sos sosreport-Padme3-P1-2-20200514005914"
  exit 1
fi

DATADIR=${SOS_PATH#*-}
DATADIR=${DATADIR%-*}

mkdir -p $DATADIR

if [ -e "${SOS_PATH}/sos_commands/pci/lspci_-nnvv" ]; then
  cp ${SOS_PATH}/sos_commands/pci/lspci_-nnvv ${DATADIR}/lspci_nnvv.list
  cat ${DATADIR}/lspci_nnvv.list | grep ^[0-9] > $DATADIR/lspci_nn.list
  cat ${DATADIR}/lspci_nn.list  | sed 's/.*\[\([0-9a-f]...\)\].*\[\([0-9a-f:]........\)\].*/\1\2/g' | tr -d ':' > ${DATADIR}/lspci.list
fi

if [ -d "${SOS_PATH}/sys/class/dmi/id/" ]; then
  cp ${SOS_PATH}/sys/class/dmi/id/bios_version ${DATADIR}/
  cp ${SOS_PATH}/sys/class/dmi/id/product_version ${DATADIR}/
  cp ${SOS_PATH}/sys/class/dmi/id/modalias ${DATADIR}/
fi

if [ -e "${SOS_PATH}/sos_commands/hardware/dmidecode" ]; then
  cp ${SOS_PATH}/sos_commands/hardware/dmidecode ${DATADIR}/dmidecode.txt
fi

if [ -e "${SOS_PATH}/sos_commands/usb/lsusb" ]; then
  cp ${SOS_PATH}/sos_commands/usb/lsusb ${DATADIR}/lsusb.list
  cat ${SOS_PATH}/sos_commands/usb/lsusb_-t >> ${DATADIR}/lsusb.list
  cat ${SOS_PATH}/sos_commands/usb/lsusb_-v >> ${DATADIR}/lsusb.list
fi
