#!/usr/bin/env python3
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4
# -*- encoding=utf8 -*-
#
# copyright: 2011-2011 Canonical Ltd.
#
# Author 2011 Hsin-Yi Chen
#
# This is a free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# This software is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this software; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA
class Singleton(type):
    def __init__(cls,name,bases,dic):
        super(Singleton,cls).__init__(name,bases,dic)
        cls.instance=None
    def __call__(cls,*args,**kw):
        if cls.instance is None:
            cls.instance=super(Singleton,cls).__call__(*args,**kw)
        return cls.instance

class DataObjectType(type):
    def __init__(mbs, name, bases, dct):
        super(DataObjectType, mbs).__init__(name, bases, dct)
        mbs.__init__ = clsinit
        mbs.__repr__ = clsrepr

def clsinit(self, **kwargs):
    self.__dict__.update(kwargs)

def clsrepr(self):
    return "{}({})".format(self.__class__.__name__,
            ','.join([ "{}={}".format(k,v) for k,v in list(self.__dict__.items())]))
