#!/usr/bin/python
from distutils.core import setup
from DistUtilsExtra.command import *

import glob

setup(
    name="ubuntu-recovery",
    author="Hsin-Yi Chen (hychen)",
    author_email="tyson.chen@canonical.com",
    description="Ubuntu OEM recovery tool",
    packages=["urecovery"],
    data_files=[
                ('share/ubuntu-recovery/imgs', glob.glob('imgs/*')),
                ('share/ubuntu-recovery/boot', glob.glob('boot/*')),
                ('share/ubuntu-recovery/data', glob.glob('data/*')),
                ('lib/ubiquity/plugins', glob.glob('ubiquity/*.py')),
                ('share/ubiquity/gtk', glob.glob('ubiquity/*.ui')),
                ('lib/ubiquity/bin', glob.glob('bin/*.sh')),
    ],
    cmdclass = { 'build': build_extra.build_extra,
                 'build_i18n': build_i18n.build_i18n,
                 "build_help" : build_help.build_help,
                 'build_icons': build_icons.build_icons,
                 'clean': clean_i18n.clean_i18n,
               }
)
