#!/usr/bin/python3
#
# Ubuntu Recovery install script
#
# Copyright (C) 2008-2009, Dell Inc.
# Copyright (C) 2011-2011, Canonical Ltd.
#
#  Author: Mario Limonciello <Mario_Limonciello@Dell.com>
#  Author: Hsin-Yi Chen <hychen@canonical.com>
#  Author: Shih-Yuan Lee (FourDollars) <sylee@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import glob, os.path, os
from distutils.core import setup
from DistUtilsExtra.command import (build_extra, 
                                   build_i18n, 
                                   build_help,
                                   build_icons,
                                   clean_i18n)

def files_only(directory):
    for root, dirs, files in os.walk(directory):
        if root == directory:
            array = []
            for file in files:
                array.append(os.path.join(directory, file))
            return array

I18NFILES = []
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

setup(
    name="ubuntu-recovery",
    author="Canonical OEM Services",
    author_email="oem-services@canonical.com",
    maintainer="Canonical OEM Services",
    maintainer_email="oem-services@canonical.com",
    license="gpl",
    description="Creates a piece of recovery media for a Ubuntu Factory image",
    packages=["ubunturecovery"],
    data_files=[('share/applications', ['recovery-media-creator.desktop']),
                ("share/ubuntu", glob.glob("gtk/*.ui")),
                ('share/pixmaps', glob.glob("gtk/*.svg")),
                ('share/ubuntu/bin', ['backend/recovery-media-backend', 'bin/recovery-media-creator', 'bin/generate-recovery-iso']),
                ('share/ubuntu/casper/scripts', glob.glob('casper/scripts/*')),
                ('share/ubuntu/casper/hooks', glob.glob('casper/hooks/*')),
                ('share/ubuntu/casper/seeds', glob.glob('casper/seeds/*')),
                ('share/ubuntu/hooks/ubuntu-recovery/grub', glob.glob('late/hooks/ubuntu-recovery/grub/*')),
                ('share/ubuntu/scripts', files_only('late/scripts')),
                ('share/ubuntu/scripts/ubiquity.d/success', glob.glob('late/scripts/ubiquity.success/*')),
                ('share/ubuntu/scripts/ubiquity.d/failure', glob.glob('late/scripts/ubiquity.failure/*')),
                ('share/ubuntu/scripts/oem-config.d/early', glob.glob('late/scripts/oem-config.early/*')),
                ('share/ubuntu/scripts/oem-config.d/late', glob.glob('late/scripts/oem-config.late/*')),
                ('share/ubuntu/scripts/non-negotiable', glob.glob('late/chroot_scripts/*')),
                ('/etc/dbus-1/system.d/', glob.glob('backend/*.conf')),
                ('/etc/init/', glob.glob('upstart/*.conf')),
                ('/etc/polkit-1/localauthority/50-local.d/', ['ubuntu-recovery.pkla']),
                ('share/ubuntu/grub', glob.glob('grub/*')),
                ('share/dbus-1/system-services', glob.glob('backend/*.service')),
                ('/lib/udev/rules.d', glob.glob('udev/*')),
                ('lib/ubiquity/dm-scripts/install/', glob.glob('dm-scripts/install/*')),
                ('lib/ubiquity/plugins', glob.glob('ubiquity/*.py')),
                ('share/ubiquity/gtk', glob.glob('ubiquity/*.ui')),
                ('share/ubiquity', ['ubiquity/ubuntu-bootstrap'])]+I18NFILES,
    cmdclass = { 'build': build_extra.build_extra,
                 'build_i18n': build_i18n.build_i18n,
                 "build_help" : build_help.build_help,
                 'build_icons': build_icons.build_icons,
                 'clean': clean_i18n.clean_i18n,
               }
)
