#!/usr/bin/env python
# setup.py - Build system for Ubuntu One Installer
#
# Authors: Natalia B. Bidart <natalia.bidart@canonical.com>
#          Manuel de la Pena <manuel@canonical.com>
#          Alejandro J. Cura <alecu@canonical.com>
#
# Copyright 2010-2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Setup.py: build, distribute, clean."""

# pylint: disable=W0404, W0511

import os
import sys

try:
    import DistUtilsExtra.auto
except ImportError:
    print >> sys.stderr, 'To build this program you need '\
                         'https://launchpad.net/python-distutils-extra'
    sys.exit(1)
assert DistUtilsExtra.auto.__version__ >= '2.18', \
       'needs DistUtilsExtra.auto >= 2.18'

POT_FILE = 'po/ubuntuone-installer.pot'
CLEANFILES = [POT_FILE, 'MANIFEST']


class Clean(DistUtilsExtra.auto.clean_build_tree):
    """Class to clean up after the build."""

    def run(self):
        """Clean up the built files."""
        for built_file in CLEANFILES:
            if os.path.exists(built_file):
                os.unlink(built_file)

        DistUtilsExtra.auto.clean_build_tree.run(self)


DistUtilsExtra.auto.setup(
    name='ubuntuone-installer',
    version='3.0.2',
    license='GPL v3',
    author='Ubuntu One Hackers',
    author_email='ubuntuone-users@lists.launchpad.net',
    description='Ubuntu One Installer',
    long_description='Installer for Ubuntu One client.',
    url='https://launchpad.net/ubuntuone-installer',
    packages=[
        'ubuntuone', 'ubuntuone.installer',
        ],
    extra_path='ubuntuone-installer',
    cmdclass={
        'clean': Clean,
        },
    )
