/* udisks-dbus-interfaces.c generated by valac 0.10.0, the Vala compiler
 * generated from udisks-dbus-interfaces.vala, do not modify */

/* UDisks daemon D-BUS interfaces
 *
 * (C) 2010 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <gio/gio.h>


#define UDISKS_TYPE_DAEMON (udisks_daemon_get_type ())
#define UDISKS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UDISKS_TYPE_DAEMON, UDisksDaemon))
#define UDISKS_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UDISKS_TYPE_DAEMON))
#define UDISKS_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UDISKS_TYPE_DAEMON, UDisksDaemonIface))

typedef struct _UDisksDaemon UDisksDaemon;
typedef struct _UDisksDaemonIface UDisksDaemonIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UDisksDaemonDBusProxy UDisksDaemonDBusProxy;
typedef DBusGProxyClass UDisksDaemonDBusProxyClass;

#define UDISKS_TYPE_DEVICE (udisks_device_get_type ())
#define UDISKS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UDISKS_TYPE_DEVICE, UDisksDevice))
#define UDISKS_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UDISKS_TYPE_DEVICE))
#define UDISKS_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UDISKS_TYPE_DEVICE, UDisksDeviceIface))

typedef struct _UDisksDevice UDisksDevice;
typedef struct _UDisksDeviceIface UDisksDeviceIface;
typedef struct _UDisksDeviceDBusProxy UDisksDeviceDBusProxy;
typedef DBusGProxyClass UDisksDeviceDBusProxyClass;
typedef struct _UDisksDeviceDBusProxyFilesystemMountData UDisksDeviceDBusProxyFilesystemMountData;
typedef struct _UDisksDeviceDBusProxyFilesystemUnmountData UDisksDeviceDBusProxyFilesystemUnmountData;

struct _UDisksDaemonIface {
	GTypeInterface parent_iface;
	char** (*enumerate_devices) (UDisksDaemon* self, int* result_length1, GError** error);
	char** (*enumerate_device_files) (UDisksDaemon* self, int* result_length1, GError** error);
	char* (*get_daemon_version) (UDisksDaemon* self);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _UDisksDaemonDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _UDisksDeviceIface {
	GTypeInterface parent_iface;
	void (*filesystem_mount) (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*filesystem_mount_finish) (UDisksDevice* self, GAsyncResult* _res_, GError** error);
	void (*filesystem_unmount) (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*filesystem_unmount_finish) (UDisksDevice* self, GAsyncResult* _res_, GError** error);
	char* (*get_device_file) (UDisksDevice* self);
	char* (*get_id_usage) (UDisksDevice* self);
	gboolean (*get_device_is_mounted) (UDisksDevice* self);
	gboolean (*get_device_is_partition) (UDisksDevice* self);
	gboolean (*get_device_is_removable) (UDisksDevice* self);
	gboolean (*get_device_is_system_internal) (UDisksDevice* self);
	gboolean (*get_device_presentation_hide) (UDisksDevice* self);
	gboolean (*get_device_presentation_nopolicy) (UDisksDevice* self);
};

struct _UDisksDeviceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _UDisksDeviceDBusProxyFilesystemMountData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _UDisksDeviceDBusProxyFilesystemUnmountData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};



UDisksDaemon* udisks_daemon_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType udisks_daemon_get_type (void) G_GNUC_CONST;
char** udisks_daemon_enumerate_devices (UDisksDaemon* self, int* result_length1, GError** error);
char** udisks_daemon_enumerate_device_files (UDisksDaemon* self, int* result_length1, GError** error);
char* udisks_daemon_get_daemon_version (UDisksDaemon* self);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void udisks_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _udisks_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult udisks_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_udisks_daemon_introspect (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_daemon_property_get (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_daemon_property_get_all (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_daemon_enumerate_devices (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_daemon_enumerate_device_files (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_udisks_daemon_device_added (GObject* _sender, const char* device, DBusConnection* _connection);
static void _dbus_udisks_daemon_device_removed (GObject* _sender, const char* device, DBusConnection* _connection);
static void _dbus_udisks_daemon_device_changed (GObject* _sender, const char* device, DBusConnection* _connection);
GType udisks_daemon_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_udisks_daemon_device_added (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_udisks_daemon_device_removed (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_udisks_daemon_device_changed (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult udisks_daemon_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	UDISKS_DAEMON_DBUS_PROXY_DUMMY_PROPERTY,
	UDISKS_DAEMON_DBUS_PROXY_DAEMON_VERSION
};
static char** udisks_daemon_dbus_proxy_enumerate_devices (UDisksDaemon* self, int* result_length1, GError** error);
static char** udisks_daemon_dbus_proxy_enumerate_device_files (UDisksDaemon* self, int* result_length1, GError** error);
static char* udisks_daemon_dbus_proxy_get_daemon_version (UDisksDaemon* self);
static void udisks_daemon_dbus_proxy_udisks_daemon__interface_init (UDisksDaemonIface* iface);
static void udisks_daemon_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void udisks_daemon_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
UDisksDevice* udisks_device_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType udisks_device_get_type (void) G_GNUC_CONST;
void udisks_device_filesystem_mount (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* udisks_device_filesystem_mount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error);
void udisks_device_filesystem_unmount (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void udisks_device_filesystem_unmount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error);
char* udisks_device_get_device_file (UDisksDevice* self);
char* udisks_device_get_id_usage (UDisksDevice* self);
gboolean udisks_device_get_device_is_mounted (UDisksDevice* self);
gboolean udisks_device_get_device_is_partition (UDisksDevice* self);
gboolean udisks_device_get_device_is_removable (UDisksDevice* self);
gboolean udisks_device_get_device_is_system_internal (UDisksDevice* self);
gboolean udisks_device_get_device_presentation_hide (UDisksDevice* self);
gboolean udisks_device_get_device_presentation_nopolicy (UDisksDevice* self);
void udisks_device_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _udisks_device_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult udisks_device_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_udisks_device_introspect (UDisksDevice* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_device_property_get (UDisksDevice* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_device_property_get_all (UDisksDevice* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_udisks_device_filesystem_mount (UDisksDevice* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_udisks_device_filesystem_mount_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_udisks_device_filesystem_unmount (UDisksDevice* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_udisks_device_filesystem_unmount_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType udisks_device_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult udisks_device_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	UDISKS_DEVICE_DBUS_PROXY_DUMMY_PROPERTY,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_FILE,
	UDISKS_DEVICE_DBUS_PROXY_ID_USAGE,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_MOUNTED,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_PARTITION,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_REMOVABLE,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_SYSTEM_INTERNAL,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_PRESENTATION_HIDE,
	UDISKS_DEVICE_DBUS_PROXY_DEVICE_PRESENTATION_NOPOLICY
};
static void udisks_device_dbus_proxy_filesystem_mount_async (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void udisks_device_dbus_proxy_filesystem_mount_ready (DBusPendingCall* pending, void* user_data);
static char* udisks_device_dbus_proxy_filesystem_mount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error);
static void udisks_device_dbus_proxy_filesystem_unmount_async (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void udisks_device_dbus_proxy_filesystem_unmount_ready (DBusPendingCall* pending, void* user_data);
static void udisks_device_dbus_proxy_filesystem_unmount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error);
static char* udisks_device_dbus_proxy_get_device_file (UDisksDevice* self);
static char* udisks_device_dbus_proxy_get_id_usage (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_is_mounted (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_is_partition (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_is_removable (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_is_system_internal (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_presentation_hide (UDisksDevice* self);
static gboolean udisks_device_dbus_proxy_get_device_presentation_nopolicy (UDisksDevice* self);
static void udisks_device_dbus_proxy_udisks_device__interface_init (UDisksDeviceIface* iface);
static void udisks_device_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void udisks_device_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _udisks_daemon_dbus_path_vtable = {_udisks_daemon_dbus_unregister, udisks_daemon_dbus_message};
static const _DBusObjectVTable _udisks_daemon_dbus_vtable = {udisks_daemon_dbus_register_object};
static const DBusObjectPathVTable _udisks_device_dbus_path_vtable = {_udisks_device_dbus_unregister, udisks_device_dbus_message};
static const _DBusObjectVTable _udisks_device_dbus_vtable = {udisks_device_dbus_register_object};

static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

char** udisks_daemon_enumerate_devices (UDisksDaemon* self, int* result_length1, GError** error) {
	return UDISKS_DAEMON_GET_INTERFACE (self)->enumerate_devices (self, result_length1, error);
}


char** udisks_daemon_enumerate_device_files (UDisksDaemon* self, int* result_length1, GError** error) {
	return UDISKS_DAEMON_GET_INTERFACE (self)->enumerate_device_files (self, result_length1, error);
}


char* udisks_daemon_get_daemon_version (UDisksDaemon* self) {
	return UDISKS_DAEMON_GET_INTERFACE (self)->get_daemon_version (self);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _udisks_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_udisks_daemon_introspect (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.UDisks\">\n  <method name=\"EnumerateDevices\">\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"EnumerateDeviceFiles\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <property name=\"DaemonVersion\" type=\"s\" access=\"read\"/>\n  <signal name=\"DeviceAdded\">\n    <arg name=\"device\" type=\"o\"/>\n  </signal>\n  <signal name=\"DeviceRemoved\">\n    <arg name=\"device\" type=\"o\"/>\n  </signal>\n  <signal name=\"DeviceChanged\">\n    <arg name=\"device\" type=\"o\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_daemon_property_get (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.freedesktop.UDisks") == 0) && (strcmp (property_name, "DaemonVersion") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = udisks_daemon_get_daemon_version (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_daemon_property_get_all (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp3_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp3_);
	if (strcmp (interface_name, "org.freedesktop.UDisks") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp4_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DaemonVersion";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = udisks_daemon_get_daemon_version (self);
			_tmp4_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp4_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_daemon_enumerate_devices (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp5_;
	DBusMessageIter _tmp6_;
	int _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = udisks_daemon_enumerate_devices (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "o", &_tmp6_);
	for (_tmp7_ = 0; _tmp7_ < result_length1; _tmp7_++) {
		const char* _tmp8_;
		_tmp8_ = *_tmp5_;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_OBJECT_PATH, &_tmp8_);
		_tmp5_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp6_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_daemon_enumerate_device_files (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp9_;
	DBusMessageIter _tmp10_;
	int _tmp11_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = udisks_daemon_enumerate_device_files (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp10_);
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		const char* _tmp12_;
		_tmp12_ = *_tmp9_;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp12_);
		_tmp9_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp10_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult udisks_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_udisks_daemon_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_udisks_daemon_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_udisks_daemon_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.UDisks", "EnumerateDevices")) {
		result = _dbus_udisks_daemon_enumerate_devices (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.UDisks", "EnumerateDeviceFiles")) {
		result = _dbus_udisks_daemon_enumerate_device_files (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_udisks_daemon_device_added (GObject* _sender, const char* device, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp13_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.UDisks", "DeviceAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp13_ = device;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp13_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_udisks_daemon_device_removed (GObject* _sender, const char* device, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp14_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.UDisks", "DeviceRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14_ = device;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp14_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_udisks_daemon_device_changed (GObject* _sender, const char* device, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp15_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.UDisks", "DeviceChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp15_ = device;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp15_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void udisks_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_udisks_daemon_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "device-added", (GCallback) _dbus_udisks_daemon_device_added, connection);
	g_signal_connect (object, "device-removed", (GCallback) _dbus_udisks_daemon_device_removed, connection);
	g_signal_connect (object, "device-changed", (GCallback) _dbus_udisks_daemon_device_changed, connection);
}


static void udisks_daemon_base_init (UDisksDaemonIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("daemon-version", "daemon-version", "daemon-version", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("device_added", UDISKS_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("device_removed", UDISKS_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("device_changed", UDISKS_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, DBUS_TYPE_G_OBJECT_PATH);
		g_type_set_qdata (UDISKS_TYPE_DAEMON, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_udisks_daemon_dbus_vtable));
	}
}


GType udisks_daemon_get_type (void) {
	static volatile gsize udisks_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&udisks_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UDisksDaemonIface), (GBaseInitFunc) udisks_daemon_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType udisks_daemon_type_id;
		udisks_daemon_type_id = g_type_register_static (G_TYPE_INTERFACE, "UDisksDaemon", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (udisks_daemon_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (udisks_daemon_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &udisks_daemon_dbus_proxy_get_type);
		g_once_init_leave (&udisks_daemon_type_id__volatile, udisks_daemon_type_id);
	}
	return udisks_daemon_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UDisksDaemonDBusProxy, udisks_daemon_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DAEMON, udisks_daemon_dbus_proxy_udisks_daemon__interface_init) );
UDisksDaemon* udisks_daemon_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	UDisksDaemon* self;
	self = g_object_new (udisks_daemon_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.UDisks", NULL);
	return self;
}


static GObject* udisks_daemon_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (udisks_daemon_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), udisks_daemon_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_udisks_daemon_device_added (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* device = NULL;
	const char* _tmp0_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "o")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	device = g_strdup (_tmp0_);
	g_signal_emit_by_name (self, "device-added", device);
	_g_free0 (device);
}


static void _dbus_handle_udisks_daemon_device_removed (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* device = NULL;
	const char* _tmp1_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "o")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	device = g_strdup (_tmp1_);
	g_signal_emit_by_name (self, "device-removed", device);
	_g_free0 (device);
}


static void _dbus_handle_udisks_daemon_device_changed (UDisksDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* device = NULL;
	const char* _tmp2_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "o")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	device = g_strdup (_tmp2_);
	g_signal_emit_by_name (self, "device-changed", device);
	_g_free0 (device);
}


DBusHandlerResult udisks_daemon_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.UDisks", "DeviceAdded")) {
			_dbus_handle_udisks_daemon_device_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.UDisks", "DeviceRemoved")) {
			_dbus_handle_udisks_daemon_device_removed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.UDisks", "DeviceChanged")) {
			_dbus_handle_udisks_daemon_device_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void udisks_daemon_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((UDisksDaemonDBusProxy*) self)->disposed) {
		return;
	}
	((UDisksDaemonDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), udisks_daemon_dbus_proxy_filter, self);
	G_OBJECT_CLASS (udisks_daemon_dbus_proxy_parent_class)->dispose (self);
}


static void udisks_daemon_dbus_proxy_class_init (UDisksDaemonDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = udisks_daemon_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = udisks_daemon_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = udisks_daemon_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = udisks_daemon_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DAEMON_DBUS_PROXY_DAEMON_VERSION, "daemon-version");
}


static void udisks_daemon_dbus_proxy_init (UDisksDaemonDBusProxy* self) {
}


static char** udisks_daemon_dbus_proxy_enumerate_devices (UDisksDaemon* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	if (((UDisksDaemonDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.UDisks", "EnumerateDevices");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp6_;
			_edomain = DBUS_GERROR;
			_tmp6_ = _dbus_error.name + 27;
			if (strcmp (_tmp6_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp6_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp6_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp6_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp6_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp6_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp6_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp6_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp6_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp6_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp6_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp6_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp6_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp6_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp6_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp6_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp6_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp6_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp6_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp6_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp6_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp6_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp6_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp6_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp6_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp6_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp6_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp6_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp6_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "ao")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "ao", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp3_ = g_new (char*, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		const char* _tmp5_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (char*, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = g_strdup (_tmp5_);
	}
	_result_length1 = _tmp3__length1;
	_tmp3_[_tmp3__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp3_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** udisks_daemon_dbus_proxy_enumerate_device_files (UDisksDaemon* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp7_;
	int _tmp7__length;
	int _tmp7__size;
	int _tmp7__length1;
	DBusMessageIter _tmp8_;
	if (((UDisksDaemonDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.UDisks", "EnumerateDeviceFiles");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp10_;
			_edomain = DBUS_GERROR;
			_tmp10_ = _dbus_error.name + 27;
			if (strcmp (_tmp10_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp10_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp10_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp10_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp10_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp10_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp10_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp10_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp10_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp10_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp10_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp10_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp10_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp10_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp10_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp10_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp10_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp10_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp10_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp10_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp10_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp10_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp10_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp10_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp10_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp10_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp10_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp10_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp10_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp7_ = g_new (char*, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp8_);
	for (; dbus_message_iter_get_arg_type (&_tmp8_); _tmp7__length1++) {
		const char* _tmp9_;
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (char*, _tmp7_, _tmp7__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp8_, &_tmp9_);
		dbus_message_iter_next (&_tmp8_);
		_tmp7_[_tmp7__length++] = g_strdup (_tmp9_);
	}
	_result_length1 = _tmp7__length1;
	_tmp7_[_tmp7__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp7_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* udisks_daemon_dbus_proxy_get_daemon_version (UDisksDaemon* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp11_;
	const char* _tmp12_;
	char* _result;
	const char* _tmp13_;
	if (((UDisksDaemonDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp11_ = "org.freedesktop.UDisks";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp11_);
	_tmp12_ = "DaemonVersion";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp12_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp13_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp13_);
	dbus_message_unref (_reply);
	return _result;
}


static void udisks_daemon_dbus_proxy_udisks_daemon__interface_init (UDisksDaemonIface* iface) {
	iface->enumerate_devices = udisks_daemon_dbus_proxy_enumerate_devices;
	iface->enumerate_device_files = udisks_daemon_dbus_proxy_enumerate_device_files;
	iface->get_daemon_version = udisks_daemon_dbus_proxy_get_daemon_version;
}


static void udisks_daemon_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void udisks_daemon_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void udisks_device_filesystem_mount (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UDISKS_DEVICE_GET_INTERFACE (self)->filesystem_mount (self, filesystem_type, options, options_length1, _callback_, _user_data_);
}


char* udisks_device_filesystem_mount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->filesystem_mount_finish (self, _res_, error);
}


void udisks_device_filesystem_unmount (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UDISKS_DEVICE_GET_INTERFACE (self)->filesystem_unmount (self, options, options_length1, _callback_, _user_data_);
}


void udisks_device_filesystem_unmount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error) {
	UDISKS_DEVICE_GET_INTERFACE (self)->filesystem_unmount_finish (self, _res_, error);
}


char* udisks_device_get_device_file (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_file (self);
}


char* udisks_device_get_id_usage (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_id_usage (self);
}


gboolean udisks_device_get_device_is_mounted (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_is_mounted (self);
}


gboolean udisks_device_get_device_is_partition (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_is_partition (self);
}


gboolean udisks_device_get_device_is_removable (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_is_removable (self);
}


gboolean udisks_device_get_device_is_system_internal (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_is_system_internal (self);
}


gboolean udisks_device_get_device_presentation_hide (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_presentation_hide (self);
}


gboolean udisks_device_get_device_presentation_nopolicy (UDisksDevice* self) {
	return UDISKS_DEVICE_GET_INTERFACE (self)->get_device_presentation_nopolicy (self);
}


void _udisks_device_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_udisks_device_introspect (UDisksDevice* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.UDisks.Device\">\n  <method name=\"FilesystemMount\">\n    <arg name=\"filesystem_type\" type=\"s\" direction=\"in\"/>\n    <arg name=\"options\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"FilesystemUnmount\">\n    <arg name=\"options\" type=\"as\" direction=\"in\"/>\n  </method>\n  <property name=\"DeviceFile\" type=\"s\" access=\"read\"/>\n  <property name=\"IdUsage\" type=\"s\" access=\"read\"/>\n  <property name=\"DeviceIsMounted\" type=\"b\" access=\"read\"/>\n  <property name=\"DeviceIsPartition\" type=\"b\" access=\"read\"/>\n  <property name=\"DeviceIsRemovable\" type=\"b\" access=\"read\"/>\n  <property name=\"DeviceIsSystemInternal\" type=\"b\" access=\"read\"/>\n  <property name=\"DevicePresentationHide\" type=\"b\" access=\"read\"/>\n  <property name=\"DevicePresentationNopolicy\" type=\"b\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_device_property_get (UDisksDevice* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DeviceFile") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = udisks_device_get_device_file (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "IdUsage") == 0)) {
		char* result;
		const char* _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = udisks_device_get_id_usage (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp3_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DeviceIsMounted") == 0)) {
		gboolean result;
		dbus_bool_t _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_is_mounted (self);
		_tmp4_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp4_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DeviceIsPartition") == 0)) {
		gboolean result;
		dbus_bool_t _tmp5_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_is_partition (self);
		_tmp5_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp5_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DeviceIsRemovable") == 0)) {
		gboolean result;
		dbus_bool_t _tmp6_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_is_removable (self);
		_tmp6_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp6_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DeviceIsSystemInternal") == 0)) {
		gboolean result;
		dbus_bool_t _tmp7_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_is_system_internal (self);
		_tmp7_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp7_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DevicePresentationHide") == 0)) {
		gboolean result;
		dbus_bool_t _tmp8_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_presentation_hide (self);
		_tmp8_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp8_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) && (strcmp (property_name, "DevicePresentationNopolicy") == 0)) {
		gboolean result;
		dbus_bool_t _tmp9_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = udisks_device_get_device_presentation_nopolicy (self);
		_tmp9_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp9_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_device_property_get_all (UDisksDevice* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp10_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp10_);
	if (strcmp (interface_name, "org.freedesktop.UDisks.Device") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp11_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DeviceFile";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = udisks_device_get_device_file (self);
			_tmp11_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp11_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp12_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "IdUsage";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = udisks_device_get_id_usage (self);
			_tmp12_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp12_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp13_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DeviceIsMounted";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_is_mounted (self);
			_tmp13_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp13_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp14_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DeviceIsPartition";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_is_partition (self);
			_tmp14_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp14_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp15_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DeviceIsRemovable";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_is_removable (self);
			_tmp15_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp15_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp16_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DeviceIsSystemInternal";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_is_system_internal (self);
			_tmp16_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp16_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp17_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DevicePresentationHide";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_presentation_hide (self);
			_tmp17_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp17_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp18_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DevicePresentationNopolicy";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = udisks_device_get_device_presentation_nopolicy (self);
			_tmp18_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp18_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_udisks_device_filesystem_mount (UDisksDevice* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* filesystem_type = NULL;
	const char* _tmp19_;
	char** options = NULL;
	int options_length1;
	char** _tmp20_;
	int _tmp20__length;
	int _tmp20__size;
	int _tmp20__length1;
	DBusMessageIter _tmp21_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "sas")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp19_);
	dbus_message_iter_next (&iter);
	filesystem_type = g_strdup (_tmp19_);
	options_length1 = 0;
	_tmp20_ = g_new (char*, 5);
	_tmp20__length = 0;
	_tmp20__size = 4;
	_tmp20__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp21_);
	for (; dbus_message_iter_get_arg_type (&_tmp21_); _tmp20__length1++) {
		const char* _tmp22_;
		if (_tmp20__size == _tmp20__length) {
			_tmp20__size = 2 * _tmp20__size;
			_tmp20_ = g_renew (char*, _tmp20_, _tmp20__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp21_, &_tmp22_);
		dbus_message_iter_next (&_tmp21_);
		_tmp20_[_tmp20__length++] = g_strdup (_tmp22_);
	}
	options_length1 = _tmp20__length1;
	_tmp20_[_tmp20__length] = NULL;
	dbus_message_iter_next (&iter);
	options = _tmp20_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	udisks_device_filesystem_mount (self, filesystem_type, options, options_length1, (GAsyncReadyCallback) _dbus_udisks_device_filesystem_mount_ready, _user_data_);
	_g_free0 (filesystem_type);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_udisks_device_filesystem_mount_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp23_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result = udisks_device_filesystem_mount_finish ((UDisksDevice*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp23_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp23_);
	_g_free0 (result);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_udisks_device_filesystem_unmount (UDisksDevice* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char** options = NULL;
	int options_length1;
	char** _tmp24_;
	int _tmp24__length;
	int _tmp24__size;
	int _tmp24__length1;
	DBusMessageIter _tmp25_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	options_length1 = 0;
	_tmp24_ = g_new (char*, 5);
	_tmp24__length = 0;
	_tmp24__size = 4;
	_tmp24__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp25_);
	for (; dbus_message_iter_get_arg_type (&_tmp25_); _tmp24__length1++) {
		const char* _tmp26_;
		if (_tmp24__size == _tmp24__length) {
			_tmp24__size = 2 * _tmp24__size;
			_tmp24_ = g_renew (char*, _tmp24_, _tmp24__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp25_, &_tmp26_);
		dbus_message_iter_next (&_tmp25_);
		_tmp24_[_tmp24__length++] = g_strdup (_tmp26_);
	}
	options_length1 = _tmp24__length1;
	_tmp24_[_tmp24__length] = NULL;
	dbus_message_iter_next (&iter);
	options = _tmp24_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	udisks_device_filesystem_unmount (self, options, options_length1, (GAsyncReadyCallback) _dbus_udisks_device_filesystem_unmount_ready, _user_data_);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_udisks_device_filesystem_unmount_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	udisks_device_filesystem_unmount_finish ((UDisksDevice*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult udisks_device_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_udisks_device_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_udisks_device_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_udisks_device_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.UDisks.Device", "FilesystemMount")) {
		result = _dbus_udisks_device_filesystem_mount (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.UDisks.Device", "FilesystemUnmount")) {
		result = _dbus_udisks_device_filesystem_unmount (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void udisks_device_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_udisks_device_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void udisks_device_base_init (UDisksDeviceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("device-file", "device-file", "device-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("id-usage", "id-usage", "id-usage", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-is-mounted", "device-is-mounted", "device-is-mounted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-is-partition", "device-is-partition", "device-is-partition", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-is-removable", "device-is-removable", "device-is-removable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-is-system-internal", "device-is-system-internal", "device-is-system-internal", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-presentation-hide", "device-presentation-hide", "device-presentation-hide", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("device-presentation-nopolicy", "device-presentation-nopolicy", "device-presentation-nopolicy", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (UDISKS_TYPE_DEVICE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_udisks_device_dbus_vtable));
	}
}


GType udisks_device_get_type (void) {
	static volatile gsize udisks_device_type_id__volatile = 0;
	if (g_once_init_enter (&udisks_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UDisksDeviceIface), (GBaseInitFunc) udisks_device_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType udisks_device_type_id;
		udisks_device_type_id = g_type_register_static (G_TYPE_INTERFACE, "UDisksDevice", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (udisks_device_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (udisks_device_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &udisks_device_dbus_proxy_get_type);
		g_once_init_leave (&udisks_device_type_id__volatile, udisks_device_type_id);
	}
	return udisks_device_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UDisksDeviceDBusProxy, udisks_device_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DEVICE, udisks_device_dbus_proxy_udisks_device__interface_init) );
UDisksDevice* udisks_device_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	UDisksDevice* self;
	self = g_object_new (udisks_device_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.UDisks.Device", NULL);
	return self;
}


static GObject* udisks_device_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (udisks_device_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), udisks_device_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult udisks_device_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void udisks_device_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return;
	}
	((UDisksDeviceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), udisks_device_dbus_proxy_filter, self);
	G_OBJECT_CLASS (udisks_device_dbus_proxy_parent_class)->dispose (self);
}


static void udisks_device_dbus_proxy_class_init (UDisksDeviceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = udisks_device_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = udisks_device_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = udisks_device_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = udisks_device_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_FILE, "device-file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_ID_USAGE, "id-usage");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_MOUNTED, "device-is-mounted");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_PARTITION, "device-is-partition");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_REMOVABLE, "device-is-removable");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_IS_SYSTEM_INTERNAL, "device-is-system-internal");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_PRESENTATION_HIDE, "device-presentation-hide");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UDISKS_DEVICE_DBUS_PROXY_DEVICE_PRESENTATION_NOPOLICY, "device-presentation-nopolicy");
}


static void udisks_device_dbus_proxy_init (UDisksDeviceDBusProxy* self) {
}


static void udisks_device_dbus_proxy_filesystem_mount_async (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp14_;
	char** _tmp15_;
	DBusMessageIter _tmp16_;
	int _tmp17_;
	UDisksDeviceDBusProxyFilesystemMountData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.UDisks.Device", "FilesystemMount");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14_ = filesystem_type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp14_);
	_tmp15_ = options;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp16_);
	for (_tmp17_ = 0; _tmp17_ < options_length1; _tmp17_++) {
		const char* _tmp18_;
		_tmp18_ = *_tmp15_;
		dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_STRING, &_tmp18_);
		_tmp15_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp16_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (UDisksDeviceDBusProxyFilesystemMountData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, udisks_device_dbus_proxy_filesystem_mount_ready, _data_, NULL);
}


static void udisks_device_dbus_proxy_filesystem_mount_ready (DBusPendingCall* pending, void* user_data) {
	UDisksDeviceDBusProxyFilesystemMountData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (UDisksDeviceDBusProxyFilesystemMountData, _data_);
	dbus_pending_call_unref (pending);
}


static char* udisks_device_dbus_proxy_filesystem_mount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error) {
	UDisksDeviceDBusProxyFilesystemMountData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp26_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp20_;
			_edomain = DBUS_GERROR;
			_tmp20_ = _dbus_error.name + 27;
			if (strcmp (_tmp20_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp20_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp20_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp20_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp20_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp20_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp20_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp20_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp20_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp20_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp20_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp20_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp20_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp20_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp20_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp20_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp20_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp20_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp20_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp20_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp20_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp20_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp20_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp20_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp20_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp20_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp20_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp20_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp20_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp26_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp26_);
	dbus_message_unref (_reply);
	return _result;
}


static void udisks_device_dbus_proxy_filesystem_unmount_async (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	char** _tmp27_;
	DBusMessageIter _tmp28_;
	int _tmp29_;
	UDisksDeviceDBusProxyFilesystemUnmountData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.UDisks.Device", "FilesystemUnmount");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp27_ = options;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp28_);
	for (_tmp29_ = 0; _tmp29_ < options_length1; _tmp29_++) {
		const char* _tmp30_;
		_tmp30_ = *_tmp27_;
		dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_STRING, &_tmp30_);
		_tmp27_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp28_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (UDisksDeviceDBusProxyFilesystemUnmountData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, udisks_device_dbus_proxy_filesystem_unmount_ready, _data_, NULL);
}


static void udisks_device_dbus_proxy_filesystem_unmount_ready (DBusPendingCall* pending, void* user_data) {
	UDisksDeviceDBusProxyFilesystemUnmountData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (UDisksDeviceDBusProxyFilesystemUnmountData, _data_);
	dbus_pending_call_unref (pending);
}


static void udisks_device_dbus_proxy_filesystem_unmount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error) {
	UDisksDeviceDBusProxyFilesystemUnmountData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp31_;
			_edomain = DBUS_GERROR;
			_tmp31_ = _dbus_error.name + 27;
			if (strcmp (_tmp31_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp31_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp31_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp31_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp31_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp31_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp31_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp31_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp31_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp31_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp31_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp31_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp31_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp31_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp31_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp31_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp31_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp31_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp31_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp31_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp31_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp31_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp31_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp31_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp31_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp31_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp31_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp31_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp31_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* udisks_device_dbus_proxy_get_device_file (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp36_;
	const char* _tmp37_;
	char* _result;
	const char* _tmp38_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp36_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp36_);
	_tmp37_ = "DeviceFile";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp37_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp38_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp38_);
	dbus_message_unref (_reply);
	return _result;
}


static char* udisks_device_dbus_proxy_get_id_usage (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp39_;
	const char* _tmp40_;
	char* _result;
	const char* _tmp41_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp39_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp39_);
	_tmp40_ = "IdUsage";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp41_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp41_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_is_mounted (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp42_;
	const char* _tmp43_;
	gboolean _result;
	dbus_bool_t _tmp44_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp42_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp42_);
	_tmp43_ = "DeviceIsMounted";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp43_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp44_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp44_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_is_partition (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp45_;
	const char* _tmp46_;
	gboolean _result;
	dbus_bool_t _tmp47_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp45_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp45_);
	_tmp46_ = "DeviceIsPartition";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp46_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp47_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp47_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_is_removable (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp48_;
	const char* _tmp49_;
	gboolean _result;
	dbus_bool_t _tmp50_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	_tmp49_ = "DeviceIsRemovable";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp49_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp50_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp50_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_is_system_internal (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp51_;
	const char* _tmp52_;
	gboolean _result;
	dbus_bool_t _tmp53_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp51_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp51_);
	_tmp52_ = "DeviceIsSystemInternal";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp52_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp53_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp53_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_presentation_hide (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp54_;
	const char* _tmp55_;
	gboolean _result;
	dbus_bool_t _tmp56_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp54_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp54_);
	_tmp55_ = "DevicePresentationHide";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp55_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp56_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp56_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean udisks_device_dbus_proxy_get_device_presentation_nopolicy (UDisksDevice* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp57_;
	const char* _tmp58_;
	gboolean _result;
	dbus_bool_t _tmp59_;
	if (((UDisksDeviceDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp57_ = "org.freedesktop.UDisks.Device";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp57_);
	_tmp58_ = "DevicePresentationNopolicy";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp58_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp59_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp59_;
	dbus_message_unref (_reply);
	return _result;
}


static void udisks_device_dbus_proxy_udisks_device__interface_init (UDisksDeviceIface* iface) {
	iface->filesystem_mount = udisks_device_dbus_proxy_filesystem_mount_async;
	iface->filesystem_mount_finish = udisks_device_dbus_proxy_filesystem_mount_finish;
	iface->filesystem_unmount = udisks_device_dbus_proxy_filesystem_unmount_async;
	iface->filesystem_unmount_finish = udisks_device_dbus_proxy_filesystem_unmount_finish;
	iface->get_device_file = udisks_device_dbus_proxy_get_device_file;
	iface->get_id_usage = udisks_device_dbus_proxy_get_id_usage;
	iface->get_device_is_mounted = udisks_device_dbus_proxy_get_device_is_mounted;
	iface->get_device_is_partition = udisks_device_dbus_proxy_get_device_is_partition;
	iface->get_device_is_removable = udisks_device_dbus_proxy_get_device_is_removable;
	iface->get_device_is_system_internal = udisks_device_dbus_proxy_get_device_is_system_internal;
	iface->get_device_presentation_hide = udisks_device_dbus_proxy_get_device_presentation_hide;
	iface->get_device_presentation_nopolicy = udisks_device_dbus_proxy_get_device_presentation_nopolicy;
}


static void udisks_device_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void udisks_device_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



