/* expose-manager.c generated by valac, the Vala compiler
 * generated from expose-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <mutter-plugins.h>
#include <float.h>
#include <math.h>
#include <unity-static.h>
#include <unity.h>
#include <clutk/clutk.h>
#include <libwnck/libwnck.h>


#define UNITY_TYPE_EXPOSE_CLONE (unity_expose_clone_get_type ())
#define UNITY_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeClone))
#define UNITY_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))
#define UNITY_IS_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_IS_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_EXPOSE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))

typedef struct _UnityExposeClone UnityExposeClone;
typedef struct _UnityExposeCloneClass UnityExposeCloneClass;
typedef struct _UnityExposeClonePrivate UnityExposeClonePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TYPE_EXPOSE_MANAGER (unity_expose_manager_get_type ())
#define UNITY_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManager))
#define UNITY_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))
#define UNITY_IS_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_IS_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_EXPOSE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))

typedef struct _UnityExposeManager UnityExposeManager;
typedef struct _UnityExposeManagerClass UnityExposeManagerClass;
typedef struct _UnityExposeManagerPrivate UnityExposeManagerPrivate;

#define UNITY_TYPE_PLUGIN (unity_plugin_get_type ())
#define UNITY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLUGIN, UnityPlugin))
#define UNITY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLUGIN, UnityPluginClass))
#define UNITY_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLUGIN))
#define UNITY_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLUGIN))
#define UNITY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLUGIN, UnityPluginClass))

typedef struct _UnityPlugin UnityPlugin;
typedef struct _UnityPluginClass UnityPluginClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _UnityExposeClone {
	ClutterGroup parent_instance;
	UnityExposeClonePrivate * priv;
};

struct _UnityExposeCloneClass {
	ClutterGroupClass parent_class;
};

struct _UnityExposeClonePrivate {
	ClutterClone* clone;
	ClutterActor* darken_box;
	gboolean hovered;
	MutterWindow* _source;
	guint8 _hovered_opacity;
	guint8 _unhovered_opacity;
	guint8 _darken;
};

struct _UnityExposeManager {
	GObject parent_instance;
	UnityExposeManagerPrivate * priv;
};

struct _UnityExposeManagerClass {
	GObjectClass parent_class;
};

struct _UnityExposeManagerPrivate {
	GList* exposed_windows;
	ClutterGroup* expose_group;
	UnityPlugin* owner;
	ClutterStage* stage;
	UnityQuicklauncherView* quicklauncher;
	gboolean _expose_showing;
	gboolean _coverflow;
	gint _left_buffer;
	gint _right_buffer;
	gint _top_buffer;
	gint _bottom_buffer;
	guint8 _hovered_opacity;
	guint8 _unhovered_opacity;
	guint8 _darken;
	guint coverflow_index;
	UnityExposeClone* last_selected_clone;
	gboolean menu_in_hover_close_state;
};

struct _Block1Data {
	int _ref_count_;
	UnityExposeManager * self;
	ClutterActor* window;
	ClutterActor* actor;
};


static gpointer unity_expose_clone_parent_class = NULL;
static gpointer unity_expose_manager_parent_class = NULL;

GType unity_expose_clone_get_type (void);
#define UNITY_EXPOSE_CLONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_EXPOSE_CLONE, UnityExposeClonePrivate))
enum  {
	UNITY_EXPOSE_CLONE_DUMMY_PROPERTY,
	UNITY_EXPOSE_CLONE_SOURCE,
	UNITY_EXPOSE_CLONE_HOVERED_OPACITY,
	UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY,
	UNITY_EXPOSE_CLONE_DARKEN
};
void unity_expose_clone_set_darken (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_hovered_opacity (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_unhovered_opacity (UnityExposeClone* self, guint8 value);
static void unity_expose_clone_set_source (UnityExposeClone* self, MutterWindow* value);
guint8 unity_expose_clone_get_darken (UnityExposeClone* self);
UnityExposeClone* unity_expose_clone_new (MutterWindow* source);
UnityExposeClone* unity_expose_clone_construct (GType object_type, MutterWindow* source);
guint8 unity_expose_clone_get_hovered_opacity (UnityExposeClone* self);
static gboolean unity_expose_clone_on_mouse_enter (UnityExposeClone* self, ClutterEvent* evnt);
guint8 unity_expose_clone_get_unhovered_opacity (UnityExposeClone* self);
static gboolean unity_expose_clone_on_mouse_leave (UnityExposeClone* self, ClutterEvent* evnt);
MutterWindow* unity_expose_clone_get_source (UnityExposeClone* self);
static gboolean _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static GObject * unity_expose_clone_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_expose_clone_finalize (GObject* obj);
static void unity_expose_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_expose_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_expose_manager_get_type (void);
GType unity_plugin_get_type (void);
#define UNITY_EXPOSE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerPrivate))
enum  {
	UNITY_EXPOSE_MANAGER_DUMMY_PROPERTY,
	UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING,
	UNITY_EXPOSE_MANAGER_COVERFLOW,
	UNITY_EXPOSE_MANAGER_LEFT_BUFFER,
	UNITY_EXPOSE_MANAGER_RIGHT_BUFFER,
	UNITY_EXPOSE_MANAGER_TOP_BUFFER,
	UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER,
	UNITY_EXPOSE_MANAGER_HOVERED_OPACITY,
	UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY,
	UNITY_EXPOSE_MANAGER_DARKEN
};
static void _g_list_free_g_object_unref (GList* self);
void unity_expose_manager_set_hovered_opacity (UnityExposeManager* self, guint8 value);
void unity_expose_manager_set_unhovered_opacity (UnityExposeManager* self, guint8 value);
void unity_expose_manager_set_darken (UnityExposeManager* self, guint8 value);
UnityExposeManager* unity_expose_manager_new (UnityPlugin* plugin, UnityQuicklauncherView* quicklauncher);
UnityExposeManager* unity_expose_manager_construct (GType object_type, UnityPlugin* plugin, UnityQuicklauncherView* quicklauncher);
void unity_expose_manager_end_expose (UnityExposeManager* self);
static void _unity_expose_manager_end_expose_clutter_actor_destroy (ClutterActor* _sender, gpointer self);
MutterPlugin* unity_plugin_get_plugin (UnityPlugin* self);
guint8 unity_expose_manager_get_hovered_opacity (UnityExposeManager* self);
guint8 unity_expose_manager_get_unhovered_opacity (UnityExposeManager* self);
guint8 unity_expose_manager_get_darken (UnityExposeManager* self);
static gboolean _lambda3_ (UnityExposeManager* self);
static gboolean __lambda3__clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _lambda4_ (UnityExposeManager* self);
static gboolean __lambda4__clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
gboolean unity_expose_manager_get_coverflow (UnityExposeManager* self);
static void unity_expose_manager_position_windows_coverflow (UnityExposeManager* self, GList* windows, ClutterActor* active);
static void unity_expose_manager_position_windows_on_grid (UnityExposeManager* self, GList* _windows);
static void unity_expose_manager_set_expose_showing (UnityExposeManager* self, gboolean value);
static gboolean unity_expose_manager_on_stage_captured_event (UnityExposeManager* self, ClutterEvent* event);
static gboolean _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
void unity_expose_manager_start_expose (UnityExposeManager* self, GSList* windows);
static void unity_expose_manager_restore_window_position (UnityExposeManager* self, ClutterActor* actor);
gint unity_expose_manager_get_left_buffer (UnityExposeManager* self);
gint unity_expose_manager_get_right_buffer (UnityExposeManager* self);
static gint unity_expose_manager_direct_comparison (UnityExposeManager* self, void* a, void* b);
gint unity_expose_manager_get_top_buffer (UnityExposeManager* self);
gint unity_expose_manager_get_bottom_buffer (UnityExposeManager* self);
static void _lambda2_ (Block1Data* _data1_);
static void __lambda2__clutter_animation_completed (ClutterAnimation* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void unity_expose_manager_handle_event_coverflow (UnityExposeManager* self, ClutterEvent* event);
static void unity_expose_manager_handle_event_expose (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor);
static void unity_expose_manager_pick_window (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor);
gboolean unity_expose_manager_get_expose_showing (UnityExposeManager* self);
void unity_expose_manager_set_coverflow (UnityExposeManager* self, gboolean value);
void unity_expose_manager_set_left_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_right_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_top_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_bottom_buffer (UnityExposeManager* self, gint value);
static GObject * unity_expose_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_expose_manager_finalize (GObject* obj);
static void unity_expose_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_expose_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 46 "expose-manager.vala"
UnityExposeClone* unity_expose_clone_construct (GType object_type, MutterWindow* source) {
#line 223 "expose-manager.c"
	UnityExposeClone * self;
	ClutterClone* _tmp0_;
	ClutterActor* _tmp3_;
	ClutterColor _tmp2_;
	ClutterColor _tmp1_ = {0};
#line 46 "expose-manager.vala"
	g_return_val_if_fail (source != NULL, NULL);
#line 231 "expose-manager.c"
	self = g_object_newv (object_type, 0, NULL);
#line 48 "expose-manager.vala"
	unity_expose_clone_set_darken (self, (guint8) 0);
#line 49 "expose-manager.vala"
	unity_expose_clone_set_hovered_opacity (self, (guint8) 255);
#line 50 "expose-manager.vala"
	unity_expose_clone_set_unhovered_opacity (self, (guint8) 255);
#line 52 "expose-manager.vala"
	unity_expose_clone_set_source (self, source);
#line 53 "expose-manager.vala"
	self->priv->clone = (_tmp0_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) source)), _g_object_unref0 (self->priv->clone), _tmp0_);
#line 55 "expose-manager.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->clone);
#line 56 "expose-manager.vala"
	clutter_actor_show ((ClutterActor*) self->priv->clone);
#line 57 "expose-manager.vala"
	clutter_actor_set_position ((ClutterActor*) self->priv->clone, (float) 0, (float) 0);
#line 59 "expose-manager.vala"
	self->priv->darken_box = (_tmp3_ = (ClutterActor*) g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color ((_tmp2_ = (_tmp1_.red = (guint8) 0, _tmp1_.green = (guint8) 0, _tmp1_.blue = (guint8) 0, _tmp1_.alpha = (guint8) 255, _tmp1_), &_tmp2_))), _g_object_unref0 (self->priv->darken_box), _tmp3_);
#line 60 "expose-manager.vala"
	clutter_container_add_actor ((ClutterContainer*) self, self->priv->darken_box);
#line 61 "expose-manager.vala"
	clutter_actor_raise_top (self->priv->darken_box);
#line 63 "expose-manager.vala"
	clutter_actor_set_position (self->priv->darken_box, (float) 0, (float) 0);
#line 64 "expose-manager.vala"
	clutter_actor_set_size (self->priv->darken_box, clutter_actor_get_width ((ClutterActor*) source), clutter_actor_get_height ((ClutterActor*) source));
#line 66 "expose-manager.vala"
	clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
#line 261 "expose-manager.c"
	return self;
}


#line 46 "expose-manager.vala"
UnityExposeClone* unity_expose_clone_new (MutterWindow* source) {
#line 46 "expose-manager.vala"
	return unity_expose_clone_construct (UNITY_TYPE_EXPOSE_CLONE, source);
#line 270 "expose-manager.c"
}


#line 75 "expose-manager.vala"
static gboolean unity_expose_clone_on_mouse_enter (UnityExposeClone* self, ClutterEvent* evnt) {
#line 276 "expose-manager.c"
	gboolean result = FALSE;
#line 75 "expose-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "expose-manager.vala"
	self->priv->hovered = TRUE;
#line 78 "expose-manager.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, self->priv->_hovered_opacity);
#line 79 "expose-manager.vala"
	clutter_actor_set_opacity (self->priv->darken_box, (guint8) 0);
#line 286 "expose-manager.c"
	result = FALSE;
#line 80 "expose-manager.vala"
	return result;
#line 290 "expose-manager.c"
}


#line 83 "expose-manager.vala"
static gboolean unity_expose_clone_on_mouse_leave (UnityExposeClone* self, ClutterEvent* evnt) {
#line 296 "expose-manager.c"
	gboolean result = FALSE;
#line 83 "expose-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 85 "expose-manager.vala"
	self->priv->hovered = FALSE;
#line 86 "expose-manager.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, self->priv->_unhovered_opacity);
#line 87 "expose-manager.vala"
	clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
#line 306 "expose-manager.c"
	result = FALSE;
#line 88 "expose-manager.vala"
	return result;
#line 310 "expose-manager.c"
}


MutterWindow* unity_expose_clone_get_source (UnityExposeClone* self) {
	MutterWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source;
#line 31 "expose-manager.vala"
	return result;
#line 320 "expose-manager.c"
}


static void unity_expose_clone_set_source (UnityExposeClone* self, MutterWindow* value) {
	g_return_if_fail (self != NULL);
	self->priv->_source = value;
	g_object_notify ((GObject *) self, "source");
}


guint8 unity_expose_clone_get_hovered_opacity (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_hovered_opacity;
#line 33 "expose-manager.vala"
	return result;
#line 337 "expose-manager.c"
}


void unity_expose_clone_set_hovered_opacity (UnityExposeClone* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_hovered_opacity = value;
	g_object_notify ((GObject *) self, "hovered-opacity");
}


guint8 unity_expose_clone_get_unhovered_opacity (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_unhovered_opacity;
#line 34 "expose-manager.vala"
	return result;
#line 354 "expose-manager.c"
}


void unity_expose_clone_set_unhovered_opacity (UnityExposeClone* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_unhovered_opacity = value;
	g_object_notify ((GObject *) self, "unhovered-opacity");
}


guint8 unity_expose_clone_get_darken (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_darken;
#line 38 "expose-manager.vala"
	return result;
#line 371 "expose-manager.c"
}


void unity_expose_clone_set_darken (UnityExposeClone* self, guint8 value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
#line 40 "expose-manager.vala"
	self->priv->_darken = value;
#line 41 "expose-manager.vala"
	if (!self->priv->hovered) {
#line 41 "expose-manager.vala"
		_tmp0_ = CLUTTER_IS_ACTOR (self->priv->darken_box);
#line 384 "expose-manager.c"
	} else {
#line 41 "expose-manager.vala"
		_tmp0_ = FALSE;
#line 388 "expose-manager.c"
	}
#line 41 "expose-manager.vala"
	if (_tmp0_) {
#line 42 "expose-manager.vala"
		clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
#line 394 "expose-manager.c"
	}
	g_object_notify ((GObject *) self, "darken");
}


#line 75 "expose-manager.vala"
static gboolean _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
#line 402 "expose-manager.c"
	return unity_expose_clone_on_mouse_enter (self, event);
}


#line 83 "expose-manager.vala"
static gboolean _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
#line 409 "expose-manager.c"
	return unity_expose_clone_on_mouse_leave (self, event);
}


static GObject * unity_expose_clone_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityExposeClone * self;
	parent_class = G_OBJECT_CLASS (unity_expose_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_EXPOSE_CLONE (obj);
	{
#line 71 "expose-manager.vala"
		g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event, self, 0);
#line 72 "expose-manager.vala"
		g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event, self, 0);
#line 426 "expose-manager.c"
	}
	return obj;
}


static void unity_expose_clone_class_init (UnityExposeCloneClass * klass) {
	unity_expose_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityExposeClonePrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_expose_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_expose_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_expose_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_expose_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_SOURCE, g_param_spec_object ("source", "source", "source", MUTTER_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_HOVERED_OPACITY, g_param_spec_uchar ("hovered-opacity", "hovered-opacity", "hovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY, g_param_spec_uchar ("unhovered-opacity", "unhovered-opacity", "unhovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_DARKEN, g_param_spec_uchar ("darken", "darken", "darken", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_expose_clone_instance_init (UnityExposeClone * self) {
	self->priv = UNITY_EXPOSE_CLONE_GET_PRIVATE (self);
}


static void unity_expose_clone_finalize (GObject* obj) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (obj);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->darken_box);
	G_OBJECT_CLASS (unity_expose_clone_parent_class)->finalize (obj);
}


GType unity_expose_clone_get_type (void) {
	static volatile gsize unity_expose_clone_type_id__volatile = 0;
	if (g_once_init_enter (&unity_expose_clone_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityExposeCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_expose_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityExposeClone), 0, (GInstanceInitFunc) unity_expose_clone_instance_init, NULL };
		GType unity_expose_clone_type_id;
		unity_expose_clone_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "UnityExposeClone", &g_define_type_info, 0);
		g_once_init_leave (&unity_expose_clone_type_id__volatile, unity_expose_clone_type_id);
	}
	return unity_expose_clone_type_id__volatile;
}


static void unity_expose_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (object);
	switch (property_id) {
		case UNITY_EXPOSE_CLONE_SOURCE:
		g_value_set_object (value, unity_expose_clone_get_source (self));
		break;
		case UNITY_EXPOSE_CLONE_HOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_clone_get_hovered_opacity (self));
		break;
		case UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_clone_get_unhovered_opacity (self));
		break;
		case UNITY_EXPOSE_CLONE_DARKEN:
		g_value_set_uchar (value, unity_expose_clone_get_darken (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_expose_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (object);
	switch (property_id) {
		case UNITY_EXPOSE_CLONE_SOURCE:
		unity_expose_clone_set_source (self, g_value_get_object (value));
		break;
		case UNITY_EXPOSE_CLONE_HOVERED_OPACITY:
		unity_expose_clone_set_hovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY:
		unity_expose_clone_set_unhovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_CLONE_DARKEN:
		unity_expose_clone_set_darken (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 119 "expose-manager.vala"
UnityExposeManager* unity_expose_manager_construct (GType object_type, UnityPlugin* plugin, UnityQuicklauncherView* quicklauncher) {
#line 531 "expose-manager.c"
	UnityExposeManager * self;
	UnityQuicklauncherView* _tmp0_;
	UnityPlugin* _tmp1_;
	GList* _tmp2_;
	ClutterStage* _tmp3_;
#line 119 "expose-manager.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 119 "expose-manager.vala"
	g_return_val_if_fail (quicklauncher != NULL, NULL);
#line 541 "expose-manager.c"
	self = g_object_newv (object_type, 0, NULL);
#line 121 "expose-manager.vala"
	self->priv->quicklauncher = (_tmp0_ = _g_object_ref0 (quicklauncher), _g_object_unref0 (self->priv->quicklauncher), _tmp0_);
#line 122 "expose-manager.vala"
	self->priv->owner = (_tmp1_ = _g_object_ref0 (plugin), _g_object_unref0 (self->priv->owner), _tmp1_);
#line 123 "expose-manager.vala"
	self->priv->exposed_windows = (_tmp2_ = NULL, __g_list_free_g_object_unref0 (self->priv->exposed_windows), _tmp2_);
#line 124 "expose-manager.vala"
	self->priv->stage = (_tmp3_ = CLUTTER_STAGE (unity_shell_get_stage ((UnityShell*) plugin)), _g_object_unref0 (self->priv->stage), _tmp3_);
#line 126 "expose-manager.vala"
	unity_expose_manager_set_hovered_opacity (self, (guint8) 255);
#line 127 "expose-manager.vala"
	unity_expose_manager_set_unhovered_opacity (self, (guint8) 255);
#line 128 "expose-manager.vala"
	unity_expose_manager_set_darken (self, (guint8) 0);
#line 557 "expose-manager.c"
	return self;
}


#line 119 "expose-manager.vala"
UnityExposeManager* unity_expose_manager_new (UnityPlugin* plugin, UnityQuicklauncherView* quicklauncher) {
#line 119 "expose-manager.vala"
	return unity_expose_manager_construct (UNITY_TYPE_EXPOSE_MANAGER, plugin, quicklauncher);
#line 566 "expose-manager.c"
}


#line 222 "expose-manager.vala"
static void _unity_expose_manager_end_expose_clutter_actor_destroy (ClutterActor* _sender, gpointer self) {
#line 572 "expose-manager.c"
	unity_expose_manager_end_expose (self);
}


#line 184 "expose-manager.vala"
static gboolean _lambda3_ (UnityExposeManager* self) {
#line 579 "expose-manager.c"
	gboolean result = FALSE;
	UnityQuicklauncherQuicklistController* ql_controller;
	gboolean _tmp0_ = FALSE;
#line 185 "expose-manager.vala"
	ql_controller = _g_object_ref0 (unity_quicklauncher_quicklist_controller_get_default ());
#line 186 "expose-manager.vala"
	if (unity_quicklauncher_quicklist_controller_menu_is_open (ql_controller)) {
#line 186 "expose-manager.vala"
		_tmp0_ = self->priv->menu_in_hover_close_state;
#line 589 "expose-manager.c"
	} else {
#line 186 "expose-manager.vala"
		_tmp0_ = FALSE;
#line 593 "expose-manager.c"
	}
#line 186 "expose-manager.vala"
	if (_tmp0_) {
#line 188 "expose-manager.vala"
		ctk_menu_set_close_on_leave (ql_controller->menu, FALSE);
#line 599 "expose-manager.c"
	}
	result = FALSE;
	_g_object_unref0 (ql_controller);
#line 190 "expose-manager.vala"
	return result;
#line 605 "expose-manager.c"
}


#line 184 "expose-manager.vala"
static gboolean __lambda3__clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
#line 611 "expose-manager.c"
	return _lambda3_ (self);
}


#line 193 "expose-manager.vala"
static gboolean _lambda4_ (UnityExposeManager* self) {
#line 618 "expose-manager.c"
	gboolean result = FALSE;
	UnityQuicklauncherQuicklistController* ql_controller;
	gboolean _tmp0_ = FALSE;
#line 194 "expose-manager.vala"
	ql_controller = _g_object_ref0 (unity_quicklauncher_quicklist_controller_get_default ());
#line 195 "expose-manager.vala"
	if (unity_quicklauncher_quicklist_controller_menu_is_open (ql_controller)) {
#line 195 "expose-manager.vala"
		_tmp0_ = self->priv->menu_in_hover_close_state;
#line 628 "expose-manager.c"
	} else {
#line 195 "expose-manager.vala"
		_tmp0_ = FALSE;
#line 632 "expose-manager.c"
	}
#line 195 "expose-manager.vala"
	if (_tmp0_) {
#line 197 "expose-manager.vala"
		ctk_menu_set_close_on_leave (ql_controller->menu, TRUE);
#line 638 "expose-manager.c"
	}
	result = FALSE;
	_g_object_unref0 (ql_controller);
#line 199 "expose-manager.vala"
	return result;
#line 644 "expose-manager.c"
}


#line 193 "expose-manager.vala"
static gboolean __lambda4__clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
#line 650 "expose-manager.c"
	return _lambda4_ (self);
}


#line 519 "expose-manager.vala"
static gboolean _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
#line 657 "expose-manager.c"
	return unity_expose_manager_on_stage_captured_event (self, event);
}


#line 135 "expose-manager.vala"
void unity_expose_manager_start_expose (UnityExposeManager* self, GSList* windows) {
#line 664 "expose-manager.c"
	UnityQuicklauncherQuicklistController* controller;
	GList* _tmp0_;
	ClutterGroup* _tmp1_;
	ClutterActor* window_group;
	ClutterActor* _tmp2_;
	GList* mutter_windows;
#line 135 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 137 "expose-manager.vala"
	controller = _g_object_ref0 (unity_quicklauncher_quicklist_controller_get_default ());
#line 138 "expose-manager.vala"
	if (unity_quicklauncher_quicklist_controller_menu_is_open (controller)) {
#line 140 "expose-manager.vala"
		g_signal_connect_object ((ClutterActor*) controller->menu, "destroy", (GCallback) _unity_expose_manager_end_expose_clutter_actor_destroy, self, 0);
#line 141 "expose-manager.vala"
		self->priv->menu_in_hover_close_state = ctk_menu_get_close_on_leave (controller->menu);
#line 681 "expose-manager.c"
	}
#line 143 "expose-manager.vala"
	self->priv->exposed_windows = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->exposed_windows), _tmp0_);
#line 145 "expose-manager.vala"
	if (self->priv->expose_group != NULL) {
#line 146 "expose-manager.vala"
		clutter_actor_destroy ((ClutterActor*) self->priv->expose_group);
#line 689 "expose-manager.c"
	}
#line 147 "expose-manager.vala"
	self->priv->expose_group = (_tmp1_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (self->priv->expose_group), _tmp1_);
#line 149 "expose-manager.vala"
	window_group = _g_object_ref0 (mutter_plugin_get_normal_window_group (unity_plugin_get_plugin (self->priv->owner)));
#line 151 "expose-manager.vala"
	clutter_container_add_actor ((_tmp2_ = window_group, CLUTTER_IS_CONTAINER (_tmp2_) ? ((ClutterContainer*) _tmp2_) : NULL), (ClutterActor*) self->priv->expose_group);
#line 152 "expose-manager.vala"
	clutter_actor_raise_top ((ClutterActor*) self->priv->expose_group);
#line 153 "expose-manager.vala"
	clutter_actor_show ((ClutterActor*) self->priv->expose_group);
#line 155 "expose-manager.vala"
	mutter_windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->owner));
#line 703 "expose-manager.c"
	{
		GList* w_collection;
		GList* w_it;
#line 156 "expose-manager.vala"
		w_collection = mutter_windows;
#line 709 "expose-manager.c"
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MutterWindow* w;
#line 156 "expose-manager.vala"
			w = _g_object_ref0 ((MutterWindow*) w_it->data);
#line 714 "expose-manager.c"
			{
				gboolean keep;
				gulong xid;
				MutterWindow* _tmp3_;
				MutterWindow* _tmp4_;
#line 158 "expose-manager.vala"
				keep = FALSE;
#line 159 "expose-manager.vala"
				xid = (gulong) meta_window_get_xwindow (mutter_window_get_meta_window (w));
#line 724 "expose-manager.c"
				{
					GSList* window_collection;
					GSList* window_it;
#line 160 "expose-manager.vala"
					window_collection = windows;
#line 730 "expose-manager.c"
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						WnckWindow* window;
#line 160 "expose-manager.vala"
						window = _g_object_ref0 ((WnckWindow*) window_it->data);
#line 735 "expose-manager.c"
						{
#line 162 "expose-manager.vala"
							if (wnck_window_get_xid (window) == xid) {
#line 164 "expose-manager.vala"
								keep = TRUE;
#line 741 "expose-manager.c"
								_g_object_unref0 (window);
#line 165 "expose-manager.vala"
								break;
#line 745 "expose-manager.c"
							}
							_g_object_unref0 (window);
						}
					}
				}
#line 169 "expose-manager.vala"
				if (keep) {
#line 753 "expose-manager.c"
					UnityExposeClone* clone;
#line 171 "expose-manager.vala"
					clone = g_object_ref_sink (unity_expose_clone_new (w));
#line 172 "expose-manager.vala"
					clutter_actor_set_position ((ClutterActor*) clone, clutter_actor_get_x ((ClutterActor*) w), clutter_actor_get_y ((ClutterActor*) w));
#line 173 "expose-manager.vala"
					clutter_actor_set_size ((ClutterActor*) clone, clutter_actor_get_width ((ClutterActor*) w), clutter_actor_get_height ((ClutterActor*) w));
#line 174 "expose-manager.vala"
					self->priv->exposed_windows = g_list_append (self->priv->exposed_windows, _g_object_ref0 (clone));
#line 175 "expose-manager.vala"
					clutter_actor_set_reactive ((ClutterActor*) clone, TRUE);
#line 177 "expose-manager.vala"
					clutter_container_add_actor ((ClutterContainer*) self->priv->expose_group, (ClutterActor*) clone);
#line 179 "expose-manager.vala"
					unity_expose_clone_set_hovered_opacity (clone, self->priv->_hovered_opacity);
#line 180 "expose-manager.vala"
					unity_expose_clone_set_unhovered_opacity (clone, self->priv->_unhovered_opacity);
#line 181 "expose-manager.vala"
					clutter_actor_set_opacity ((ClutterActor*) clone, self->priv->_unhovered_opacity);
#line 182 "expose-manager.vala"
					unity_expose_clone_set_darken (clone, self->priv->_darken);
#line 184 "expose-manager.vala"
					g_signal_connect_object ((ClutterActor*) clone, "enter-event", (GCallback) __lambda3__clutter_actor_enter_event, self, 0);
#line 193 "expose-manager.vala"
					g_signal_connect_object ((ClutterActor*) clone, "leave-event", (GCallback) __lambda4__clutter_actor_leave_event, self, 0);
#line 779 "expose-manager.c"
					_g_object_unref0 (clone);
				}
#line 203 "expose-manager.vala"
				if (mutter_window_get_window_type (w) == META_COMP_WINDOW_DESKTOP) {
#line 784 "expose-manager.c"
					_g_object_unref0 (w);
#line 204 "expose-manager.vala"
					continue;
#line 788 "expose-manager.c"
				}
#line 206 "expose-manager.vala"
				clutter_actor_set_reactive ((_tmp3_ = w, CLUTTER_IS_ACTOR (_tmp3_) ? ((ClutterActor*) _tmp3_) : NULL), FALSE);
#line 207 "expose-manager.vala"
				clutter_actor_set_opacity ((_tmp4_ = w, CLUTTER_IS_ACTOR (_tmp4_) ? ((ClutterActor*) _tmp4_) : NULL), (guint8) 0);
#line 794 "expose-manager.c"
				_g_object_unref0 (w);
			}
		}
	}
#line 209 "expose-manager.vala"
	self->priv->coverflow_index = (guint) 0;
#line 211 "expose-manager.vala"
	if (self->priv->_coverflow) {
#line 212 "expose-manager.vala"
		unity_expose_manager_position_windows_coverflow (self, self->priv->exposed_windows, (ClutterActor*) ((UnityExposeClone*) g_list_nth_data (self->priv->exposed_windows, self->priv->coverflow_index)));
#line 805 "expose-manager.c"
	} else {
#line 214 "expose-manager.vala"
		unity_expose_manager_position_windows_on_grid (self, self->priv->exposed_windows);
#line 809 "expose-manager.c"
	}
#line 216 "expose-manager.vala"
	unity_expose_manager_set_expose_showing (self, TRUE);
#line 218 "expose-manager.vala"
	unity_shell_add_fullscreen_request ((UnityShell*) self->priv->owner, (GObject*) self);
#line 219 "expose-manager.vala"
	g_signal_connect_object ((ClutterActor*) self->priv->stage, "captured-event", (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self, 0);
#line 817 "expose-manager.c"
	_g_object_unref0 (controller);
	_g_object_unref0 (window_group);
}


#line 222 "expose-manager.vala"
void unity_expose_manager_end_expose (UnityExposeManager* self) {
#line 825 "expose-manager.c"
	UnityQuicklauncherQuicklistController* controller;
	GList* mutter_windows;
	gboolean _tmp1_ = FALSE;
	guint _tmp4_;
#line 222 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 224 "expose-manager.vala"
	controller = _g_object_ref0 (unity_quicklauncher_quicklist_controller_get_default ());
#line 225 "expose-manager.vala"
	if (unity_quicklauncher_quicklist_controller_menu_is_open (controller)) {
#line 836 "expose-manager.c"
		guint _tmp0_;
#line 227 "expose-manager.vala"
		g_signal_parse_name ("destroy", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 227 "expose-manager.vala"
		g_signal_handlers_disconnect_matched ((ClutterActor*) controller->menu, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_expose_manager_end_expose_clutter_actor_destroy, self);
#line 228 "expose-manager.vala"
		unity_quicklauncher_quicklist_controller_close_menu (controller);
#line 844 "expose-manager.c"
	}
#line 231 "expose-manager.vala"
	mutter_windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->owner));
#line 848 "expose-manager.c"
	{
		GList* window_collection;
		GList* window_it;
#line 232 "expose-manager.vala"
		window_collection = mutter_windows;
#line 854 "expose-manager.c"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MutterWindow* window;
#line 232 "expose-manager.vala"
			window = _g_object_ref0 ((MutterWindow*) window_it->data);
#line 859 "expose-manager.c"
			{
				gboolean exposed;
#line 234 "expose-manager.vala"
				exposed = FALSE;
#line 864 "expose-manager.c"
				{
					GList* clone_collection;
					GList* clone_it;
#line 235 "expose-manager.vala"
					clone_collection = self->priv->exposed_windows;
#line 870 "expose-manager.c"
					for (clone_it = clone_collection; clone_it != NULL; clone_it = clone_it->next) {
						UnityExposeClone* clone;
#line 235 "expose-manager.vala"
						clone = _g_object_ref0 ((UnityExposeClone*) clone_it->data);
#line 875 "expose-manager.c"
						{
#line 237 "expose-manager.vala"
							if (unity_expose_clone_get_source (clone) == window) {
#line 239 "expose-manager.vala"
								exposed = TRUE;
#line 881 "expose-manager.c"
								_g_object_unref0 (clone);
#line 240 "expose-manager.vala"
								break;
#line 885 "expose-manager.c"
							}
							_g_object_unref0 (clone);
						}
					}
				}
#line 244 "expose-manager.vala"
				if (!exposed) {
#line 245 "expose-manager.vala"
					clutter_actor_animate ((ClutterActor*) window, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "opacity", 255, NULL);
#line 895 "expose-manager.c"
				}
#line 246 "expose-manager.vala"
				clutter_actor_set_reactive ((ClutterActor*) window, TRUE);
#line 899 "expose-manager.c"
				_g_object_unref0 (window);
			}
		}
	}
	{
		GList* actor_collection;
		GList* actor_it;
#line 249 "expose-manager.vala"
		actor_collection = self->priv->exposed_windows;
#line 909 "expose-manager.c"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
#line 249 "expose-manager.vala"
			actor = _g_object_ref0 ((ClutterActor*) ((UnityExposeClone*) actor_it->data));
#line 914 "expose-manager.c"
			{
#line 250 "expose-manager.vala"
				unity_expose_manager_restore_window_position (self, actor);
#line 918 "expose-manager.c"
				_g_object_unref0 (actor);
			}
		}
	}
#line 252 "expose-manager.vala"
	if (UNITY_IS_EXPOSE_CLONE (self->priv->last_selected_clone)) {
#line 253 "expose-manager.vala"
		_tmp1_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (self->priv->last_selected_clone));
#line 927 "expose-manager.c"
	} else {
#line 252 "expose-manager.vala"
		_tmp1_ = FALSE;
#line 931 "expose-manager.c"
	}
#line 252 "expose-manager.vala"
	if (_tmp1_) {
#line 935 "expose-manager.c"
		UnityExposeClone* clone;
		guint32 time_ = 0U;
		MutterWindow* _tmp2_;
		MetaWindow* meta;
		UnityExposeClone* _tmp3_;
#line 255 "expose-manager.vala"
		clone = _g_object_ref0 (self->priv->last_selected_clone);
#line 258 "expose-manager.vala"
		clutter_actor_raise_top ((ClutterActor*) clone);
#line 259 "expose-manager.vala"
		meta = mutter_window_get_meta_window ((_tmp2_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp2_) ? ((MutterWindow*) _tmp2_) : NULL));
#line 261 "expose-manager.vala"
		time_ = meta_display_get_current_time (meta_window_get_display (meta));
#line 262 "expose-manager.vala"
		meta_workspace_activate (meta_window_get_workspace (meta), time_);
#line 263 "expose-manager.vala"
		meta_window_activate (meta, time_);
#line 265 "expose-manager.vala"
		self->priv->last_selected_clone = (_tmp3_ = NULL, _g_object_unref0 (self->priv->last_selected_clone), _tmp3_);
#line 955 "expose-manager.c"
		_g_object_unref0 (clone);
	}
#line 268 "expose-manager.vala"
	unity_expose_manager_set_expose_showing (self, FALSE);
#line 269 "expose-manager.vala"
	unity_shell_remove_fullscreen_request ((UnityShell*) self->priv->owner, (GObject*) self);
#line 270 "expose-manager.vala"
	g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp4_, NULL, FALSE);
#line 270 "expose-manager.vala"
	g_signal_handlers_disconnect_matched ((ClutterActor*) self->priv->stage, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self);
#line 966 "expose-manager.c"
	_g_object_unref0 (controller);
}


#line 273 "expose-manager.vala"
static void unity_expose_manager_position_windows_coverflow (UnityExposeManager* self, GList* windows, ClutterActor* active) {
#line 973 "expose-manager.c"
	ClutterActor* last;
	gint middle_size;
	gint width;
	gint slice_width;
	gint middle_y;
	gint middle_x;
	gint middle_index;
	float scale;
	ClutterActor* _tmp0_;
	gint current_x;
	ClutterActor* _tmp3_;
#line 273 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 273 "expose-manager.vala"
	g_return_if_fail (active != NULL);
#line 275 "expose-manager.vala"
	last = NULL;
#line 277 "expose-manager.vala"
	middle_size = (gint) (clutter_actor_get_width ((ClutterActor*) self->priv->stage) * 0.8f);
#line 278 "expose-manager.vala"
	width = (((gint) clutter_actor_get_width ((ClutterActor*) self->priv->stage)) - self->priv->_left_buffer) - self->priv->_right_buffer;
#line 279 "expose-manager.vala"
	slice_width = width / 10;
#line 281 "expose-manager.vala"
	middle_y = ((gint) clutter_actor_get_height ((ClutterActor*) self->priv->stage)) / 2;
#line 282 "expose-manager.vala"
	middle_x = self->priv->_left_buffer + (width / 2);
#line 284 "expose-manager.vala"
	middle_index = g_list_index (windows, active);
#line 286 "expose-manager.vala"
	scale = MIN (1.f, (clutter_actor_get_height ((ClutterActor*) self->priv->stage) / 2) / MAX (clutter_actor_get_height (active), clutter_actor_get_width (active)));
#line 287 "expose-manager.vala"
	scale = 1.f;
#line 289 "expose-manager.vala"
	clutter_actor_set_anchor_point_from_gravity (active, CLUTTER_GRAVITY_CENTER);
#line 290 "expose-manager.vala"
	clutter_actor_animate (active, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) middle_x, "y", (float) middle_y, "depth", clutter_actor_get_width ((ClutterActor*) self->priv->stage) * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", 0.f, NULL);
#line 297 "expose-manager.vala"
	clutter_actor_raise_top (active);
#line 299 "expose-manager.vala"
	last = (_tmp0_ = _g_object_ref0 (active), _g_object_unref0 (last), _tmp0_);
#line 301 "expose-manager.vala"
	current_x = middle_x - middle_size;
#line 1017 "expose-manager.c"
	{
		gint i;
#line 302 "expose-manager.vala"
		i = middle_index - 1;
#line 1022 "expose-manager.c"
		{
			gboolean _tmp1_;
#line 302 "expose-manager.vala"
			_tmp1_ = TRUE;
#line 302 "expose-manager.vala"
			while (TRUE) {
#line 1029 "expose-manager.c"
				ClutterActor* actor;
				ClutterActor* _tmp2_;
#line 302 "expose-manager.vala"
				if (!_tmp1_) {
#line 302 "expose-manager.vala"
					i--;
#line 1036 "expose-manager.c"
				}
#line 302 "expose-manager.vala"
				_tmp1_ = FALSE;
#line 302 "expose-manager.vala"
				if (!(i >= 0)) {
#line 302 "expose-manager.vala"
					break;
#line 1044 "expose-manager.c"
				}
#line 304 "expose-manager.vala"
				actor = _g_object_ref0 ((ClutterActor*) g_list_nth_data (windows, (guint) i));
#line 305 "expose-manager.vala"
				clutter_actor_set_anchor_point_from_gravity (actor, CLUTTER_GRAVITY_CENTER);
#line 306 "expose-manager.vala"
				clutter_actor_lower (actor, last);
#line 308 "expose-manager.vala"
				scale = MIN (1.f, (clutter_actor_get_height ((ClutterActor*) self->priv->stage) / 2) / MAX (clutter_actor_get_height (actor), clutter_actor_get_width (actor)));
#line 309 "expose-manager.vala"
				scale = 1.f;
#line 311 "expose-manager.vala"
				clutter_actor_animate (actor, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) current_x, "y", (float) middle_y, "depth", clutter_actor_get_width ((ClutterActor*) self->priv->stage) * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", 60.f, NULL);
#line 318 "expose-manager.vala"
				current_x = current_x - slice_width;
#line 319 "expose-manager.vala"
				last = (_tmp2_ = _g_object_ref0 (actor), _g_object_unref0 (last), _tmp2_);
#line 1062 "expose-manager.c"
				_g_object_unref0 (actor);
			}
		}
	}
#line 322 "expose-manager.vala"
	last = (_tmp3_ = _g_object_ref0 (active), _g_object_unref0 (last), _tmp3_);
#line 324 "expose-manager.vala"
	current_x = middle_x + middle_size;
#line 1071 "expose-manager.c"
	{
		gint i;
#line 325 "expose-manager.vala"
		i = middle_index + 1;
#line 1076 "expose-manager.c"
		{
			gboolean _tmp4_;
#line 325 "expose-manager.vala"
			_tmp4_ = TRUE;
#line 325 "expose-manager.vala"
			while (TRUE) {
#line 1083 "expose-manager.c"
				ClutterActor* actor;
				ClutterActor* _tmp5_;
#line 325 "expose-manager.vala"
				if (!_tmp4_) {
#line 325 "expose-manager.vala"
					i++;
#line 1090 "expose-manager.c"
				}
#line 325 "expose-manager.vala"
				_tmp4_ = FALSE;
#line 325 "expose-manager.vala"
				if (!(i < g_list_length (windows))) {
#line 325 "expose-manager.vala"
					break;
#line 1098 "expose-manager.c"
				}
#line 327 "expose-manager.vala"
				actor = _g_object_ref0 ((ClutterActor*) g_list_nth_data (windows, (guint) i));
#line 328 "expose-manager.vala"
				clutter_actor_set_anchor_point_from_gravity (actor, CLUTTER_GRAVITY_CENTER);
#line 329 "expose-manager.vala"
				clutter_actor_lower (actor, last);
#line 331 "expose-manager.vala"
				scale = MIN (1.f, (clutter_actor_get_height ((ClutterActor*) self->priv->stage) / 2) / MAX (clutter_actor_get_height (actor), clutter_actor_get_width (actor)));
#line 332 "expose-manager.vala"
				scale = 1.f;
#line 334 "expose-manager.vala"
				clutter_actor_animate (actor, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) current_x, "y", (float) middle_y, "depth", clutter_actor_get_width ((ClutterActor*) self->priv->stage) * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", -60.f, NULL);
#line 341 "expose-manager.vala"
				current_x = current_x + slice_width;
#line 342 "expose-manager.vala"
				last = (_tmp5_ = _g_object_ref0 (actor), _g_object_unref0 (last), _tmp5_);
#line 1116 "expose-manager.c"
				_g_object_unref0 (actor);
			}
		}
	}
	_g_object_unref0 (last);
}


#line 346 "expose-manager.vala"
static gint unity_expose_manager_direct_comparison (UnityExposeManager* self, void* a, void* b) {
#line 1127 "expose-manager.c"
	gint result = 0;
#line 346 "expose-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 348 "expose-manager.vala"
	if (a > b) {
#line 1133 "expose-manager.c"
		result = 1;
#line 349 "expose-manager.vala"
		return result;
#line 1137 "expose-manager.c"
	} else {
#line 350 "expose-manager.vala"
		if (a < b) {
#line 1141 "expose-manager.c"
			result = -1;
#line 351 "expose-manager.vala"
			return result;
#line 1145 "expose-manager.c"
		}
	}
	result = 0;
#line 352 "expose-manager.vala"
	return result;
#line 1151 "expose-manager.c"
}


#line 355 "expose-manager.vala"
static void unity_expose_manager_position_windows_on_grid (UnityExposeManager* self, GList* _windows) {
#line 1157 "expose-manager.c"
	GList* windows;
	gint count;
	gint cols;
	gint rows;
	gint boxWidth;
	gint boxHeight;
#line 355 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 357 "expose-manager.vala"
	windows = g_list_copy (_windows);
#line 358 "expose-manager.vala"
	windows = g_list_sort (windows, (GCompareFunc) unity_expose_manager_direct_comparison);
#line 360 "expose-manager.vala"
	count = (gint) g_list_length (windows);
#line 361 "expose-manager.vala"
	cols = (gint) ceil (sqrt ((double) count));
#line 362 "expose-manager.vala"
	rows = 1;
#line 364 "expose-manager.vala"
	while (TRUE) {
#line 364 "expose-manager.vala"
		if (!((cols * rows) < count)) {
#line 364 "expose-manager.vala"
			break;
#line 1182 "expose-manager.c"
		}
#line 365 "expose-manager.vala"
		rows++;
#line 1186 "expose-manager.c"
	}
#line 367 "expose-manager.vala"
	boxWidth = (gint) (((clutter_actor_get_width ((ClutterActor*) self->priv->stage) - self->priv->_left_buffer) - self->priv->_right_buffer) / cols);
#line 368 "expose-manager.vala"
	boxHeight = (gint) (((clutter_actor_get_height ((ClutterActor*) self->priv->stage) - self->priv->_top_buffer) - self->priv->_bottom_buffer) / rows);
#line 1192 "expose-manager.c"
	{
		gint row;
#line 370 "expose-manager.vala"
		row = 0;
#line 1197 "expose-manager.c"
		{
			gboolean _tmp0_;
#line 370 "expose-manager.vala"
			_tmp0_ = TRUE;
#line 370 "expose-manager.vala"
			while (TRUE) {
#line 370 "expose-manager.vala"
				if (!_tmp0_) {
#line 370 "expose-manager.vala"
					row++;
#line 1208 "expose-manager.c"
				}
#line 370 "expose-manager.vala"
				_tmp0_ = FALSE;
#line 370 "expose-manager.vala"
				if (!(row < rows)) {
#line 370 "expose-manager.vala"
					break;
#line 1216 "expose-manager.c"
				}
#line 372 "expose-manager.vala"
				if (row == (rows - 1)) {
#line 375 "expose-manager.vala"
					boxWidth = (gint) (((clutter_actor_get_width ((ClutterActor*) self->priv->stage) - self->priv->_left_buffer) - self->priv->_right_buffer) / g_list_length (windows));
#line 1222 "expose-manager.c"
				}
				{
					gint col;
#line 378 "expose-manager.vala"
					col = 0;
#line 1228 "expose-manager.c"
					{
						gboolean _tmp1_;
#line 378 "expose-manager.vala"
						_tmp1_ = TRUE;
#line 378 "expose-manager.vala"
						while (TRUE) {
#line 1235 "expose-manager.c"
							gint centerX;
							gint centerY;
							ClutterActor* window;
							gint windowX;
							gint windowY;
							float scale;
#line 378 "expose-manager.vala"
							if (!_tmp1_) {
#line 378 "expose-manager.vala"
								col++;
#line 1246 "expose-manager.c"
							}
#line 378 "expose-manager.vala"
							_tmp1_ = FALSE;
#line 378 "expose-manager.vala"
							if (!(col < cols)) {
#line 378 "expose-manager.vala"
								break;
#line 1254 "expose-manager.c"
							}
#line 380 "expose-manager.vala"
							if (g_list_length (windows) == 0) {
#line 1258 "expose-manager.c"
								__g_list_free_g_object_unref0 (windows);
#line 381 "expose-manager.vala"
								return;
#line 1262 "expose-manager.c"
							}
#line 383 "expose-manager.vala"
							centerX = ((boxWidth / 2) + (boxWidth * col)) + self->priv->_left_buffer;
#line 384 "expose-manager.vala"
							centerY = ((boxHeight / 2) + (boxHeight * row)) + self->priv->_top_buffer;
#line 386 "expose-manager.vala"
							window = NULL;
#line 1270 "expose-manager.c"
							{
								GList* actor_collection;
								GList* actor_it;
#line 388 "expose-manager.vala"
								actor_collection = windows;
#line 1276 "expose-manager.c"
								for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
									ClutterActor* actor;
#line 388 "expose-manager.vala"
									actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
#line 1281 "expose-manager.c"
									{
										double window_distance;
										double actor_distance;
#line 390 "expose-manager.vala"
										if (window == NULL) {
#line 1287 "expose-manager.c"
											ClutterActor* _tmp2_;
#line 392 "expose-manager.vala"
											window = (_tmp2_ = _g_object_ref0 (actor), _g_object_unref0 (window), _tmp2_);
#line 1291 "expose-manager.c"
											_g_object_unref0 (actor);
#line 393 "expose-manager.vala"
											continue;
#line 1295 "expose-manager.c"
										}
#line 396 "expose-manager.vala"
										window_distance = sqrt (fabs ((double) (centerX - (clutter_actor_get_x (window) + (clutter_actor_get_width (window) / 2)))) + fabs ((double) (centerY - (clutter_actor_get_y (window) + (clutter_actor_get_height (window) / 2)))));
#line 400 "expose-manager.vala"
										actor_distance = sqrt (fabs ((double) (centerX - (clutter_actor_get_x (actor) + (clutter_actor_get_width (actor) / 2)))) + fabs ((double) (centerY - (clutter_actor_get_y (actor) + (clutter_actor_get_height (actor) / 2)))));
#line 405 "expose-manager.vala"
										if (actor_distance < window_distance) {
#line 1303 "expose-manager.c"
											ClutterActor* _tmp3_;
#line 406 "expose-manager.vala"
											window = (_tmp3_ = _g_object_ref0 (actor), _g_object_unref0 (window), _tmp3_);
#line 1307 "expose-manager.c"
										}
										_g_object_unref0 (actor);
									}
								}
							}
#line 409 "expose-manager.vala"
							windows = g_list_remove (windows, window);
#line 411 "expose-manager.vala"
							windowX = centerX - (((gint) clutter_actor_get_width (window)) / 2);
#line 412 "expose-manager.vala"
							windowY = centerY - (((gint) clutter_actor_get_height (window)) / 2);
#line 414 "expose-manager.vala"
							scale = MIN (MIN ((float) 1, (boxWidth - 20) / clutter_actor_get_width (window)), MIN ((float) 1, (boxHeight - 20) / clutter_actor_get_height (window)));
#line 416 "expose-manager.vala"
							g_object_set ((GObject*) window, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
#line 417 "expose-manager.vala"
							clutter_actor_animate (window, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) windowX, "y", (float) windowY, "scale-x", scale, "scale-y", scale, NULL);
#line 1325 "expose-manager.c"
							_g_object_unref0 (window);
						}
					}
				}
			}
		}
	}
	__g_list_free_g_object_unref0 (windows);
}


#line 449 "expose-manager.vala"
static void _lambda2_ (Block1Data* _data1_) {
#line 1339 "expose-manager.c"
	UnityExposeManager * self;
	self = _data1_->self;
#line 450 "expose-manager.vala"
	clutter_actor_destroy (_data1_->actor);
#line 451 "expose-manager.vala"
	clutter_actor_set_opacity (_data1_->window, (guint8) 255);
#line 1346 "expose-manager.c"
}


#line 449 "expose-manager.vala"
static void __lambda2__clutter_animation_completed (ClutterAnimation* _sender, gpointer self) {
#line 1352 "expose-manager.c"
	_lambda2_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (_data1_->actor);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 426 "expose-manager.vala"
static void unity_expose_manager_restore_window_position (UnityExposeManager* self, ClutterActor* actor) {
#line 1375 "expose-manager.c"
	Block1Data* _data1_;
	ClutterActor* _tmp0_;
	guint8 opacity;
	gboolean _tmp1_ = FALSE;
	ClutterActor* _tmp2_;
	ClutterAnimation* anim;
#line 426 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 426 "expose-manager.vala"
	g_return_if_fail (actor != NULL);
#line 1386 "expose-manager.c"
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->actor = _g_object_ref0 (actor);
#line 428 "expose-manager.vala"
	if (!UNITY_IS_EXPOSE_CLONE (_data1_->actor)) {
#line 1393 "expose-manager.c"
		block1_data_unref (_data1_);
#line 429 "expose-manager.vala"
		return;
#line 1397 "expose-manager.c"
	}
#line 431 "expose-manager.vala"
	clutter_actor_set_anchor_point_from_gravity (_data1_->actor, CLUTTER_GRAVITY_NORTH_WEST);
#line 1401 "expose-manager.c"
	_data1_->window = _g_object_ref0 ((ClutterActor*) unity_expose_clone_get_source ((_tmp0_ = _data1_->actor, UNITY_IS_EXPOSE_CLONE (_tmp0_) ? ((UnityExposeClone*) _tmp0_) : NULL)));
#line 434 "expose-manager.vala"
	opacity = (guint8) 0;
#line 435 "expose-manager.vala"
	if (mutter_window_showing_on_its_workspace ((_tmp2_ = _data1_->window, MUTTER_IS_WINDOW (_tmp2_) ? ((MutterWindow*) _tmp2_) : NULL))) {
#line 1407 "expose-manager.c"
		ClutterActor* _tmp3_;
#line 436 "expose-manager.vala"
		_tmp1_ = mutter_window_get_workspace ((_tmp3_ = _data1_->window, MUTTER_IS_WINDOW (_tmp3_) ? ((MutterWindow*) _tmp3_) : NULL)) == meta_screen_get_active_workspace_index (mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->owner)));
#line 1411 "expose-manager.c"
	} else {
#line 435 "expose-manager.vala"
		_tmp1_ = FALSE;
#line 1415 "expose-manager.c"
	}
#line 435 "expose-manager.vala"
	if (_tmp1_) {
#line 437 "expose-manager.vala"
		opacity = (guint8) 255;
#line 1421 "expose-manager.c"
	}
#line 439 "expose-manager.vala"
	g_object_set ((GObject*) _data1_->actor, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
#line 440 "expose-manager.vala"
	anim = _g_object_ref0 (clutter_actor_animate (_data1_->actor, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "scale-x", 1.f, "scale-y", 1.f, "opacity", opacity, "x", clutter_actor_get_x (_data1_->window), "y", clutter_actor_get_y (_data1_->window), NULL));
#line 447 "expose-manager.vala"
	clutter_actor_set_opacity (_data1_->window, (guint8) 0);
#line 449 "expose-manager.vala"
	g_signal_connect_data (anim, "completed", (GCallback) __lambda2__clutter_animation_completed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1431 "expose-manager.c"
	_g_object_unref0 (anim);
	block1_data_unref (_data1_);
}


#line 455 "expose-manager.vala"
static void unity_expose_manager_handle_event_coverflow (UnityExposeManager* self, ClutterEvent* event) {
#line 455 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 457 "expose-manager.vala"
	if ((*event).type == CLUTTER_KEY_RELEASE) {
#line 1443 "expose-manager.c"
		guint16 keycode;
		gboolean _tmp0_ = FALSE;
#line 459 "expose-manager.vala"
		keycode = clutter_event_get_key_code (event);
#line 461 "expose-manager.vala"
		if (keycode == 113) {
#line 461 "expose-manager.vala"
			_tmp0_ = self->priv->coverflow_index > 0;
#line 1452 "expose-manager.c"
		} else {
#line 461 "expose-manager.vala"
			_tmp0_ = FALSE;
#line 1456 "expose-manager.c"
		}
#line 461 "expose-manager.vala"
		if (_tmp0_) {
#line 463 "expose-manager.vala"
			self->priv->coverflow_index--;
#line 1462 "expose-manager.c"
		} else {
			gboolean _tmp1_ = FALSE;
#line 465 "expose-manager.vala"
			if (keycode == 114) {
#line 465 "expose-manager.vala"
				_tmp1_ = self->priv->coverflow_index < (g_list_length (self->priv->exposed_windows) - 1);
#line 1469 "expose-manager.c"
			} else {
#line 465 "expose-manager.vala"
				_tmp1_ = FALSE;
#line 1473 "expose-manager.c"
			}
#line 465 "expose-manager.vala"
			if (_tmp1_) {
#line 467 "expose-manager.vala"
				self->priv->coverflow_index++;
#line 1479 "expose-manager.c"
			} else {
#line 469 "expose-manager.vala"
				if (keycode == 36) {
#line 1483 "expose-manager.c"
					UnityExposeClone* clone;
					MutterWindow* _tmp2_;
					MetaWindow* meta;
#line 471 "expose-manager.vala"
					clone = _g_object_ref0 ((UnityExposeClone*) g_list_nth_data (self->priv->exposed_windows, self->priv->coverflow_index));
#line 472 "expose-manager.vala"
					clutter_actor_raise_top ((ClutterActor*) clone);
#line 473 "expose-manager.vala"
					meta = mutter_window_get_meta_window ((_tmp2_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp2_) ? ((MutterWindow*) _tmp2_) : NULL));
#line 474 "expose-manager.vala"
					meta_workspace_activate (meta_window_get_workspace (meta), clutter_event_get_time (event));
#line 475 "expose-manager.vala"
					meta_window_activate (meta, clutter_event_get_time (event));
#line 476 "expose-manager.vala"
					unity_expose_manager_end_expose (self);
#line 1499 "expose-manager.c"
					_g_object_unref0 (clone);
				}
			}
		}
#line 479 "expose-manager.vala"
		unity_expose_manager_position_windows_coverflow (self, self->priv->exposed_windows, (ClutterActor*) ((UnityExposeClone*) g_list_nth_data (self->priv->exposed_windows, self->priv->coverflow_index)));
#line 1506 "expose-manager.c"
	}
}


#line 483 "expose-manager.vala"
static void unity_expose_manager_handle_event_expose (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor) {
#line 1513 "expose-manager.c"
	gboolean _tmp0_ = FALSE;
#line 483 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 483 "expose-manager.vala"
	g_return_if_fail (actor != NULL);
#line 485 "expose-manager.vala"
	if ((*event).type == CLUTTER_BUTTON_RELEASE) {
#line 485 "expose-manager.vala"
		_tmp0_ = clutter_event_get_button (event) == 1;
#line 1523 "expose-manager.c"
	} else {
#line 485 "expose-manager.vala"
		_tmp0_ = FALSE;
#line 1527 "expose-manager.c"
	}
#line 485 "expose-manager.vala"
	if (_tmp0_) {
#line 1531 "expose-manager.c"
		ClutterActor* _tmp2_;
		UnityExposeClone* clone;
		gboolean _tmp3_ = FALSE;
		guint _tmp5_;
#line 487 "expose-manager.vala"
		while (TRUE) {
#line 1538 "expose-manager.c"
			gboolean _tmp1_ = FALSE;
#line 487 "expose-manager.vala"
			if (clutter_actor_get_parent (actor) != NULL) {
#line 487 "expose-manager.vala"
				_tmp1_ = !UNITY_IS_EXPOSE_CLONE (actor);
#line 1544 "expose-manager.c"
			} else {
#line 487 "expose-manager.vala"
				_tmp1_ = FALSE;
#line 1548 "expose-manager.c"
			}
#line 487 "expose-manager.vala"
			if (!_tmp1_) {
#line 487 "expose-manager.vala"
				break;
#line 1554 "expose-manager.c"
			}
#line 488 "expose-manager.vala"
			actor = clutter_actor_get_parent (actor);
#line 1558 "expose-manager.c"
		}
#line 490 "expose-manager.vala"
		clone = _g_object_ref0 ((_tmp2_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp2_) ? ((UnityExposeClone*) _tmp2_) : NULL));
#line 491 "expose-manager.vala"
		if (clone != NULL) {
#line 491 "expose-manager.vala"
			_tmp3_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (clone));
#line 1566 "expose-manager.c"
		} else {
#line 491 "expose-manager.vala"
			_tmp3_ = FALSE;
#line 1570 "expose-manager.c"
		}
#line 491 "expose-manager.vala"
		if (_tmp3_) {
#line 1574 "expose-manager.c"
			MutterWindow* _tmp4_;
			MetaWindow* meta;
#line 493 "expose-manager.vala"
			clutter_actor_raise_top ((ClutterActor*) clone);
#line 494 "expose-manager.vala"
			meta = mutter_window_get_meta_window ((_tmp4_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp4_) ? ((MutterWindow*) _tmp4_) : NULL));
#line 495 "expose-manager.vala"
			meta_workspace_activate (meta_window_get_workspace (meta), clutter_event_get_time (event));
#line 496 "expose-manager.vala"
			meta_window_activate (meta, clutter_event_get_time (event));
#line 1585 "expose-manager.c"
		}
#line 498 "expose-manager.vala"
		g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp5_, NULL, FALSE);
#line 498 "expose-manager.vala"
		g_signal_handlers_disconnect_matched ((ClutterActor*) self->priv->stage, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self);
#line 499 "expose-manager.vala"
		unity_expose_manager_end_expose (self);
#line 1593 "expose-manager.c"
		_g_object_unref0 (clone);
	}
}


#line 503 "expose-manager.vala"
static void unity_expose_manager_pick_window (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor) {
#line 1601 "expose-manager.c"
	ClutterActor* _tmp1_;
	UnityExposeClone* clone;
	gboolean _tmp2_ = FALSE;
#line 503 "expose-manager.vala"
	g_return_if_fail (self != NULL);
#line 503 "expose-manager.vala"
	g_return_if_fail (actor != NULL);
#line 505 "expose-manager.vala"
	while (TRUE) {
#line 1611 "expose-manager.c"
		gboolean _tmp0_ = FALSE;
#line 505 "expose-manager.vala"
		if (clutter_actor_get_parent (actor) != NULL) {
#line 505 "expose-manager.vala"
			_tmp0_ = !UNITY_IS_EXPOSE_CLONE (actor);
#line 1617 "expose-manager.c"
		} else {
#line 505 "expose-manager.vala"
			_tmp0_ = FALSE;
#line 1621 "expose-manager.c"
		}
#line 505 "expose-manager.vala"
		if (!_tmp0_) {
#line 505 "expose-manager.vala"
			break;
#line 1627 "expose-manager.c"
		}
#line 506 "expose-manager.vala"
		actor = clutter_actor_get_parent (actor);
#line 1631 "expose-manager.c"
	}
#line 508 "expose-manager.vala"
	clone = _g_object_ref0 ((_tmp1_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp1_) ? ((UnityExposeClone*) _tmp1_) : NULL));
#line 509 "expose-manager.vala"
	if (clone != NULL) {
#line 509 "expose-manager.vala"
		_tmp2_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (clone));
#line 1639 "expose-manager.c"
	} else {
#line 509 "expose-manager.vala"
		_tmp2_ = FALSE;
#line 1643 "expose-manager.c"
	}
#line 509 "expose-manager.vala"
	if (_tmp2_) {
#line 1647 "expose-manager.c"
		UnityExposeClone* _tmp3_;
#line 511 "expose-manager.vala"
		self->priv->last_selected_clone = (_tmp3_ = _g_object_ref0 (clone), _g_object_unref0 (self->priv->last_selected_clone), _tmp3_);
#line 1651 "expose-manager.c"
	} else {
		UnityExposeClone* _tmp4_;
#line 515 "expose-manager.vala"
		self->priv->last_selected_clone = (_tmp4_ = NULL, _g_object_unref0 (self->priv->last_selected_clone), _tmp4_);
#line 1656 "expose-manager.c"
	}
	_g_object_unref0 (clone);
}


#line 519 "expose-manager.vala"
static gboolean unity_expose_manager_on_stage_captured_event (UnityExposeManager* self, ClutterEvent* event) {
#line 1664 "expose-manager.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean event_over_menu;
	float x = 0.0F;
	float y = 0.0F;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ClutterActor* actor;
	ClutterActor* menu;
	gboolean _tmp6_ = FALSE;
#line 519 "expose-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 521 "expose-manager.vala"
	if ((*event).type == CLUTTER_ENTER) {
#line 521 "expose-manager.vala"
		_tmp0_ = TRUE;
#line 1681 "expose-manager.c"
	} else {
#line 521 "expose-manager.vala"
		_tmp0_ = (*event).type == CLUTTER_LEAVE;
#line 1685 "expose-manager.c"
	}
#line 521 "expose-manager.vala"
	if (_tmp0_) {
#line 1689 "expose-manager.c"
		result = FALSE;
#line 522 "expose-manager.vala"
		return result;
#line 1693 "expose-manager.c"
	}
#line 524 "expose-manager.vala"
	event_over_menu = FALSE;
#line 527 "expose-manager.vala"
	clutter_event_get_coords (event, &x, &y);
#line 529 "expose-manager.vala"
	if ((*event).type == CLUTTER_BUTTON_PRESS) {
#line 529 "expose-manager.vala"
		_tmp2_ = TRUE;
#line 1703 "expose-manager.c"
	} else {
#line 529 "expose-manager.vala"
		_tmp2_ = (*event).type == CLUTTER_BUTTON_RELEASE;
#line 1707 "expose-manager.c"
	}
#line 529 "expose-manager.vala"
	if (_tmp2_) {
#line 529 "expose-manager.vala"
		_tmp1_ = y < 24;
#line 1713 "expose-manager.c"
	} else {
#line 529 "expose-manager.vala"
		_tmp1_ = FALSE;
#line 1717 "expose-manager.c"
	}
#line 529 "expose-manager.vala"
	if (_tmp1_) {
#line 531 "expose-manager.vala"
		unity_expose_manager_end_expose (self);
#line 1723 "expose-manager.c"
		result = FALSE;
#line 532 "expose-manager.vala"
		return result;
#line 1727 "expose-manager.c"
	}
#line 535 "expose-manager.vala"
	actor = clutter_stage_get_actor_at_pos (self->priv->stage, CLUTTER_PICK_REACTIVE, (gint) x, (gint) y);
#line 537 "expose-manager.vala"
	menu = NULL;
#line 538 "expose-manager.vala"
	if (unity_quicklauncher_quicklist_controller_menu_is_open (unity_quicklauncher_quicklist_controller_get_default ())) {
#line 539 "expose-manager.vala"
		menu = (ClutterActor*) unity_quicklauncher_quicklist_controller_get_default ()->menu;
#line 1737 "expose-manager.c"
	}
#line 540 "expose-manager.vala"
	if (menu != NULL) {
#line 1741 "expose-manager.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 542 "expose-manager.vala"
		if (x > clutter_actor_get_x (menu)) {
#line 542 "expose-manager.vala"
			_tmp5_ = x < (clutter_actor_get_x (menu) + clutter_actor_get_width (menu));
#line 1749 "expose-manager.c"
		} else {
#line 542 "expose-manager.vala"
			_tmp5_ = FALSE;
#line 1753 "expose-manager.c"
		}
#line 542 "expose-manager.vala"
		if (_tmp5_) {
#line 542 "expose-manager.vala"
			_tmp4_ = y > clutter_actor_get_y (menu);
#line 1759 "expose-manager.c"
		} else {
#line 542 "expose-manager.vala"
			_tmp4_ = FALSE;
#line 1763 "expose-manager.c"
		}
#line 542 "expose-manager.vala"
		if (_tmp4_) {
#line 542 "expose-manager.vala"
			_tmp3_ = y < (clutter_actor_get_y (menu) + clutter_actor_get_height (menu));
#line 1769 "expose-manager.c"
		} else {
#line 542 "expose-manager.vala"
			_tmp3_ = FALSE;
#line 1773 "expose-manager.c"
		}
#line 542 "expose-manager.vala"
		if (_tmp3_) {
#line 543 "expose-manager.vala"
			event_over_menu = TRUE;
#line 1779 "expose-manager.c"
		}
	}
#line 546 "expose-manager.vala"
	if ((*event).type == CLUTTER_BUTTON_PRESS) {
#line 546 "expose-manager.vala"
		_tmp6_ = !event_over_menu;
#line 1786 "expose-manager.c"
	} else {
#line 546 "expose-manager.vala"
		_tmp6_ = FALSE;
#line 1790 "expose-manager.c"
	}
#line 546 "expose-manager.vala"
	if (_tmp6_) {
#line 547 "expose-manager.vala"
		unity_expose_manager_pick_window (self, event, actor);
#line 1796 "expose-manager.c"
	} else {
		UnityExposeClone* _tmp7_;
#line 549 "expose-manager.vala"
		self->priv->last_selected_clone = (_tmp7_ = NULL, _g_object_unref0 (self->priv->last_selected_clone), _tmp7_);
#line 1801 "expose-manager.c"
	}
#line 551 "expose-manager.vala"
	if (self->priv->_coverflow) {
#line 552 "expose-manager.vala"
		unity_expose_manager_handle_event_coverflow (self, event);
#line 1807 "expose-manager.c"
	} else {
#line 554 "expose-manager.vala"
		unity_expose_manager_handle_event_expose (self, event, actor);
#line 1811 "expose-manager.c"
	}
	result = !event_over_menu;
#line 556 "expose-manager.vala"
	return result;
#line 1816 "expose-manager.c"
}


gboolean unity_expose_manager_get_expose_showing (UnityExposeManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expose_showing;
#line 100 "expose-manager.vala"
	return result;
#line 1826 "expose-manager.c"
}


static void unity_expose_manager_set_expose_showing (UnityExposeManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expose_showing = value;
	g_object_notify ((GObject *) self, "expose-showing");
}


gboolean unity_expose_manager_get_coverflow (UnityExposeManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coverflow;
#line 101 "expose-manager.vala"
	return result;
#line 1843 "expose-manager.c"
}


void unity_expose_manager_set_coverflow (UnityExposeManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_coverflow = value;
	g_object_notify ((GObject *) self, "coverflow");
}


gint unity_expose_manager_get_left_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_left_buffer;
#line 103 "expose-manager.vala"
	return result;
#line 1860 "expose-manager.c"
}


void unity_expose_manager_set_left_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_left_buffer = value;
	g_object_notify ((GObject *) self, "left-buffer");
}


gint unity_expose_manager_get_right_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_right_buffer;
#line 104 "expose-manager.vala"
	return result;
#line 1877 "expose-manager.c"
}


void unity_expose_manager_set_right_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_right_buffer = value;
	g_object_notify ((GObject *) self, "right-buffer");
}


gint unity_expose_manager_get_top_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_top_buffer;
#line 105 "expose-manager.vala"
	return result;
#line 1894 "expose-manager.c"
}


void unity_expose_manager_set_top_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_top_buffer = value;
	g_object_notify ((GObject *) self, "top-buffer");
}


gint unity_expose_manager_get_bottom_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bottom_buffer;
#line 106 "expose-manager.vala"
	return result;
#line 1911 "expose-manager.c"
}


void unity_expose_manager_set_bottom_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_bottom_buffer = value;
	g_object_notify ((GObject *) self, "bottom-buffer");
}


guint8 unity_expose_manager_get_hovered_opacity (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_hovered_opacity;
#line 108 "expose-manager.vala"
	return result;
#line 1928 "expose-manager.c"
}


void unity_expose_manager_set_hovered_opacity (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_hovered_opacity = value;
	g_object_notify ((GObject *) self, "hovered-opacity");
}


guint8 unity_expose_manager_get_unhovered_opacity (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_unhovered_opacity;
#line 109 "expose-manager.vala"
	return result;
#line 1945 "expose-manager.c"
}


void unity_expose_manager_set_unhovered_opacity (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_unhovered_opacity = value;
	g_object_notify ((GObject *) self, "unhovered-opacity");
}


guint8 unity_expose_manager_get_darken (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_darken;
#line 111 "expose-manager.vala"
	return result;
#line 1962 "expose-manager.c"
}


void unity_expose_manager_set_darken (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_darken = value;
	g_object_notify ((GObject *) self, "darken");
}


static GObject * unity_expose_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityExposeManager * self;
	parent_class = G_OBJECT_CLASS (unity_expose_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_EXPOSE_MANAGER (obj);
	{
	}
	return obj;
}


static void unity_expose_manager_class_init (UnityExposeManagerClass * klass) {
	unity_expose_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityExposeManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_expose_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_expose_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_expose_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_expose_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING, g_param_spec_boolean ("expose-showing", "expose-showing", "expose-showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_COVERFLOW, g_param_spec_boolean ("coverflow", "coverflow", "coverflow", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_LEFT_BUFFER, g_param_spec_int ("left-buffer", "left-buffer", "left-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_RIGHT_BUFFER, g_param_spec_int ("right-buffer", "right-buffer", "right-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_TOP_BUFFER, g_param_spec_int ("top-buffer", "top-buffer", "top-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER, g_param_spec_int ("bottom-buffer", "bottom-buffer", "bottom-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_HOVERED_OPACITY, g_param_spec_uchar ("hovered-opacity", "hovered-opacity", "hovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY, g_param_spec_uchar ("unhovered-opacity", "unhovered-opacity", "unhovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_DARKEN, g_param_spec_uchar ("darken", "darken", "darken", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_expose_manager_instance_init (UnityExposeManager * self) {
	self->priv = UNITY_EXPOSE_MANAGER_GET_PRIVATE (self);
	self->priv->last_selected_clone = NULL;
	self->priv->menu_in_hover_close_state = FALSE;
}


static void unity_expose_manager_finalize (GObject* obj) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (obj);
	__g_list_free_g_object_unref0 (self->priv->exposed_windows);
	_g_object_unref0 (self->priv->expose_group);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->quicklauncher);
	_g_object_unref0 (self->priv->last_selected_clone);
	G_OBJECT_CLASS (unity_expose_manager_parent_class)->finalize (obj);
}


GType unity_expose_manager_get_type (void) {
	static volatile gsize unity_expose_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_expose_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityExposeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_expose_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityExposeManager), 0, (GInstanceInitFunc) unity_expose_manager_instance_init, NULL };
		GType unity_expose_manager_type_id;
		unity_expose_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityExposeManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_expose_manager_type_id__volatile, unity_expose_manager_type_id);
	}
	return unity_expose_manager_type_id__volatile;
}


static void unity_expose_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (object);
	switch (property_id) {
		case UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING:
		g_value_set_boolean (value, unity_expose_manager_get_expose_showing (self));
		break;
		case UNITY_EXPOSE_MANAGER_COVERFLOW:
		g_value_set_boolean (value, unity_expose_manager_get_coverflow (self));
		break;
		case UNITY_EXPOSE_MANAGER_LEFT_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_left_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_RIGHT_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_right_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_TOP_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_top_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_bottom_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_HOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_manager_get_hovered_opacity (self));
		break;
		case UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_manager_get_unhovered_opacity (self));
		break;
		case UNITY_EXPOSE_MANAGER_DARKEN:
		g_value_set_uchar (value, unity_expose_manager_get_darken (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_expose_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (object);
	switch (property_id) {
		case UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING:
		unity_expose_manager_set_expose_showing (self, g_value_get_boolean (value));
		break;
		case UNITY_EXPOSE_MANAGER_COVERFLOW:
		unity_expose_manager_set_coverflow (self, g_value_get_boolean (value));
		break;
		case UNITY_EXPOSE_MANAGER_LEFT_BUFFER:
		unity_expose_manager_set_left_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_RIGHT_BUFFER:
		unity_expose_manager_set_right_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_TOP_BUFFER:
		unity_expose_manager_set_top_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER:
		unity_expose_manager_set_bottom_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_HOVERED_OPACITY:
		unity_expose_manager_set_hovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY:
		unity_expose_manager_set_unhovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_MANAGER_DARKEN:
		unity_expose_manager_set_darken (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




