/* mutter-2.28.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Mutter", lower_case_cprefix = "mutter_")]
namespace Mutter {
	[Compact]
	[CCode (free_function = "meta_alpha_gradient_spec_free", cheader_filename = "mutter-plugins.h")]
	public class MetaAlphaGradientSpec {
		public uint alphas;
		public int n_alphas;
		public Mutter.MetaGradientType type;
		[CCode (cname = "meta_alpha_gradient_spec_new", type = "MetaAlphaGradientSpec*", has_construct_function = false)]
		public MetaAlphaGradientSpec (Mutter.MetaGradientType type, int n_alphas);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaButtonLayout {
		[CCode (array_length = false)]
		public weak Mutter.MetaButtonFunction[] left_buttons;
		[CCode (array_length = false)]
		public weak bool[] left_buttons_has_spacer;
		[CCode (array_length = false)]
		public weak Mutter.MetaButtonFunction[] right_buttons;
		[CCode (array_length = false)]
		public weak bool[] right_buttons_has_spacer;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaButtonSpace {
		public Gdk.Rectangle clickable;
		public Gdk.Rectangle visible;
	}
	[Compact]
	[CCode (free_function = "meta_color_spec_free", cheader_filename = "mutter-plugins.h")]
	public class MetaColorSpec {
		public void* data;
		public Mutter.MetaColorSpecType type;
		[CCode (cname = "meta_color_spec_new", type = "MetaColorSpec*", has_construct_function = false)]
		public MetaColorSpec (Mutter.MetaColorSpecType type);
		[CCode (cname = "meta_color_spec_new_from_string", type = "MetaColorSpec*", has_construct_function = false)]
		public MetaColorSpec.from_string (string str) throws GLib.Error;
		[CCode (cname = "meta_color_spec_new_gtk", type = "MetaColorSpec*", has_construct_function = false)]
		public MetaColorSpec.gtk (Mutter.MetaGtkColorComponent component, Gtk.StateType state);
		[CCode (cname = "meta_color_spec_render")]
		public static void render (Mutter.MetaColorSpec spec, Gtk.Widget widget, Gdk.Color color);
	}
	[Compact]
	[CCode (free_function = "meta_compositor_destroy", cheader_filename = "mutter-plugins.h")]
	public class MetaCompositor {
		[CCode (cname = "meta_compositor_new", type = "MetaCompositor*", has_construct_function = false)]
		public MetaCompositor (Mutter.MetaDisplay display);
		[CCode (cname = "meta_compositor_add_window")]
		public static void add_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window);
		[CCode (cname = "meta_compositor_hide_window")]
		public static void hide_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window, Mutter.MetaCompEffect effect);
		[CCode (cname = "meta_compositor_manage_screen")]
		public static void manage_screen (Mutter.MetaCompositor compositor, Mutter.MetaScreen screen);
		[CCode (cname = "meta_compositor_maximize_window")]
		public static void maximize_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window, Mutter.MetaRectangle old_rect, Mutter.MetaRectangle new_rect);
		[CCode (cname = "meta_compositor_process_event")]
		public static bool process_event (Mutter.MetaCompositor compositor, X.Event event, Mutter.MetaWindow window);
		[CCode (cname = "meta_compositor_remove_window")]
		public static void remove_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window);
		[CCode (cname = "meta_compositor_set_updates")]
		public static void set_updates (Mutter.MetaCompositor compositor, Mutter.MetaWindow window, bool updates);
		[CCode (cname = "meta_compositor_show_window")]
		public static void show_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window, Mutter.MetaCompEffect effect);
		[CCode (cname = "meta_compositor_switch_workspace")]
		public static void switch_workspace (Mutter.MetaCompositor compositor, Mutter.MetaScreen screen, Mutter.MetaWorkspace from, Mutter.MetaWorkspace to, Mutter.MetaMotionDirection direction);
		[CCode (cname = "meta_compositor_sync_screen_size")]
		public static void sync_screen_size (Mutter.MetaCompositor compositor, Mutter.MetaScreen screen, uint width, uint height);
		[CCode (cname = "meta_compositor_sync_stack")]
		public static void sync_stack (Mutter.MetaCompositor compositor, Mutter.MetaScreen screen, GLib.List stack);
		[CCode (cname = "meta_compositor_sync_window_geometry")]
		public static void sync_window_geometry (Mutter.MetaCompositor compositor, Mutter.MetaWindow window);
		[CCode (cname = "meta_compositor_unmanage_screen")]
		public static void unmanage_screen (Mutter.MetaCompositor compositor, Mutter.MetaScreen screen);
		[CCode (cname = "meta_compositor_unmaximize_window")]
		public static void unmaximize_window (Mutter.MetaCompositor compositor, Mutter.MetaWindow window, Mutter.MetaRectangle old_rect, Mutter.MetaRectangle new_rect);
		[CCode (cname = "meta_compositor_update_workspace_geometry")]
		public static void update_workspace_geometry (Mutter.MetaCompositor compositor, Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_compositor_window_mapped")]
		public static void window_mapped (Mutter.MetaCompositor compositor, Mutter.MetaWindow window);
		[CCode (cname = "meta_compositor_window_unmapped")]
		public static void window_unmapped (Mutter.MetaCompositor compositor, Mutter.MetaWindow window);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h", cname = "MetaDisplay")]
	public class MetaDisplay {
		[CCode (cname = "meta_display_begin_grab_op")]
		public static bool begin_grab_op (Mutter.MetaDisplay display, Mutter.MetaScreen screen, Mutter.MetaWindow window, Mutter.MetaGrabOp op, bool pointer_already_grabbed, bool frame_action, int button, ulong modmask, uint32 timestamp, int root_x, int root_y);
		[CCode (cname = "meta_display_end_grab_op")]
		public static void end_grab_op (Mutter.MetaDisplay display, uint32 timestamp);
		[CCode (cname = "meta_display_focus_the_no_focus_window")]
		public static void focus_the_no_focus_window (Mutter.MetaDisplay display, Mutter.MetaScreen screen, uint32 timestamp);
		[CCode (cname = "meta_display_get_atom")]
		public static X.Atom get_atom (Mutter.MetaDisplay display, Mutter.MetaAtom meta_atom);
		[CCode (cname = "meta_display_get_compositor")]
		public static unowned Mutter.MetaCompositor get_compositor (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_compositor_version")]
		public static void get_compositor_version (Mutter.MetaDisplay display, int major, int minor);
		[CCode (cname = "meta_display_get_current_time")]
		public static uint32 get_current_time (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_current_time_roundtrip")]
		public static uint32 get_current_time_roundtrip (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_damage_event_base")]
		public static int get_damage_event_base (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_focus_window")]
		public static unowned Mutter.MetaWindow get_focus_window (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_grab_op")]
		public static Mutter.MetaGrabOp get_grab_op (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_screens")]
		public static unowned GLib.SList get_screens (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_shape_event_base")]
		public static int get_shape_event_base (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_get_tab_current")]
		public static unowned Mutter.MetaWindow get_tab_current (Mutter.MetaDisplay display, Mutter.MetaTabList type, Mutter.MetaScreen screen, Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_display_get_tab_list")]
		public static unowned GLib.List get_tab_list (Mutter.MetaDisplay display, Mutter.MetaTabList type, Mutter.MetaScreen screen, Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_display_get_tab_next")]
		public static unowned Mutter.MetaWindow get_tab_next (Mutter.MetaDisplay display, Mutter.MetaTabList type, Mutter.MetaScreen screen, Mutter.MetaWorkspace workspace, Mutter.MetaWindow window, bool backward);
		[CCode (cname = "meta_display_get_xdisplay")]
		public static unowned X.Display get_xdisplay (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_has_shape")]
		public static bool has_shape (Mutter.MetaDisplay display);
		[CCode (cname = "meta_display_lookup_group")]
		public static unowned Mutter.MetaGroup lookup_group (Mutter.MetaDisplay display, X.Window group_leader);
		[CCode (cname = "meta_display_screen_for_root")]
		public static unowned Mutter.MetaScreen screen_for_root (Mutter.MetaDisplay display, X.Window xroot);
		[CCode (cname = "meta_display_set_input_focus_window")]
		public static void set_input_focus_window (Mutter.MetaDisplay display, Mutter.MetaWindow window, bool focus_frame, uint32 timestamp);
		[CCode (cname = "meta_display_xwindow_is_a_no_focus_window")]
		public static bool xwindow_is_a_no_focus_window (Mutter.MetaDisplay display, X.Window xwindow);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaDisplayClass {
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaDrawInfo {
		public weak Mutter.MetaFrameGeometry fgeom;
		public weak Gdk.Pixbuf icon;
		public weak Gdk.Pixbuf mini_icon;
		public weak Pango.Layout title_layout;
		public int title_layout_height;
		public int title_layout_width;
	}
	[Compact]
	[CCode (free_function = "meta_draw_op_free", cheader_filename = "mutter-plugins.h")]
	public class MetaDrawOp {
		public void* data;
		public Mutter.MetaDrawType type;
		[CCode (cname = "meta_draw_op_new", type = "MetaDrawOp*", has_construct_function = false)]
		public MetaDrawOp (Mutter.MetaDrawType type);
		[CCode (cname = "meta_draw_op_draw")]
		public static void draw (Mutter.MetaDrawOp op, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, Mutter.MetaDrawInfo info, Mutter.MetaRectangle logical_region);
		[CCode (cname = "meta_draw_op_draw_with_style")]
		public static void draw_with_style (Mutter.MetaDrawOp op, Gtk.Style style_gtk, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, Mutter.MetaDrawInfo info, Mutter.MetaRectangle logical_region);
	}
	[Compact]
	[CCode (ref_function = "meta_draw_op_list_ref", ref_function_void = true, unref_function = "meta_draw_op_list_unref", cheader_filename = "mutter-plugins.h")]
	public class MetaDrawOpList {
		public int n_allocated;
		public int n_ops;
		public weak Mutter.MetaDrawOp ops;
		public int refcount;
		[CCode (cname = "meta_draw_op_list_new", type = "MetaDrawOpList*", has_construct_function = false)]
		public MetaDrawOpList (int n_preallocs);
		[CCode (cname = "meta_draw_op_list_append")]
		public static void append (Mutter.MetaDrawOpList op_list, Mutter.MetaDrawOp op);
		[CCode (cname = "meta_draw_op_list_contains")]
		public static bool contains (Mutter.MetaDrawOpList op_list, Mutter.MetaDrawOpList child);
		[CCode (cname = "meta_draw_op_list_draw")]
		public static void draw (Mutter.MetaDrawOpList op_list, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, Mutter.MetaDrawInfo info, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_draw_op_list_draw_with_style")]
		public static void draw_with_style (Mutter.MetaDrawOpList op_list, Gtk.Style style_gtk, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, Mutter.MetaDrawInfo info, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_draw_op_list_validate")]
		public static bool validate (Mutter.MetaDrawOpList op_list) throws GLib.Error;
	}
	[Compact]
	[CCode (free_function = "meta_draw_spec_free", cheader_filename = "mutter-plugins.h")]
	public class MetaDrawSpec {
		public bool constant;
		public int n_tokens;
		public weak Mutter.PosToken tokens;
		public int value;
		[CCode (cname = "meta_draw_spec_new", type = "MetaDrawSpec*", has_construct_function = false)]
		public MetaDrawSpec (Mutter.MetaTheme theme, string expr) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaEdge {
		public Mutter.MetaEdgeType edge_type;
		public weak Mutter.MetaRectangle rect;
		public Mutter.MetaSide side_type;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaFrame {
		[CCode (cname = "meta_frame_focus_from_string")]
		public static Mutter.MetaFrameFocus focus_from_string (string str);
		[CCode (cname = "meta_frame_focus_to_string")]
		public static unowned string focus_to_string (Mutter.MetaFrameFocus focus);
		[CCode (cname = "meta_frame_piece_from_string")]
		public static Mutter.MetaFramePiece piece_from_string (string str);
		[CCode (cname = "meta_frame_piece_to_string")]
		public static unowned string piece_to_string (Mutter.MetaFramePiece piece);
		[CCode (cname = "meta_frame_resize_from_string")]
		public static Mutter.MetaFrameResize resize_from_string (string str);
		[CCode (cname = "meta_frame_resize_to_string")]
		public static unowned string resize_to_string (Mutter.MetaFrameResize resize);
		[CCode (cname = "meta_frame_state_from_string")]
		public static Mutter.MetaFrameState state_from_string (string str);
		[CCode (cname = "meta_frame_state_to_string")]
		public static unowned string state_to_string (Mutter.MetaFrameState state);
		[CCode (cname = "meta_frame_type_from_string")]
		public static Mutter.MetaFrameType type_from_string (string str);
		[CCode (cname = "meta_frame_type_to_string")]
		public static unowned string type_to_string (Mutter.MetaFrameType type);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaFrameGeometry {
		public weak Mutter.MetaButtonSpace above_rect;
		public int bottom_height;
		public uint bottom_left_corner_rounded_radius;
		public uint bottom_right_corner_rounded_radius;
		public int bottom_titlebar_edge;
		public weak Mutter.MetaButtonSpace close_rect;
		public int height;
		public Gdk.Rectangle left_left_background;
		[CCode (array_length = false)]
		public weak Gdk.Rectangle[] left_middle_backgrounds;
		public Gdk.Rectangle left_right_background;
		public int left_titlebar_edge;
		public int left_width;
		public weak Mutter.MetaButtonSpace max_rect;
		public weak Mutter.MetaButtonSpace menu_rect;
		public weak Mutter.MetaButtonSpace min_rect;
		public Gdk.Rectangle right_left_background;
		[CCode (array_length = false)]
		public weak Gdk.Rectangle[] right_middle_backgrounds;
		public Gdk.Rectangle right_right_background;
		public int right_titlebar_edge;
		public int right_width;
		public weak Mutter.MetaButtonSpace shade_rect;
		public weak Mutter.MetaButtonSpace stick_rect;
		public Gdk.Rectangle title_rect;
		public int top_height;
		public uint top_left_corner_rounded_radius;
		public uint top_right_corner_rounded_radius;
		public int top_titlebar_edge;
		public weak Mutter.MetaButtonSpace unabove_rect;
		public weak Mutter.MetaButtonSpace unshade_rect;
		public weak Mutter.MetaButtonSpace unstick_rect;
		public int width;
	}
	[Compact]
	[CCode (ref_function = "meta_frame_layout_ref", ref_function_void = true, unref_function = "meta_frame_layout_unref", cheader_filename = "mutter-plugins.h")]
	public class MetaFrameLayout {
		public int bottom_height;
		public uint bottom_left_corner_rounded_radius;
		public uint bottom_right_corner_rounded_radius;
		public double button_aspect;
		public Gtk.Border button_border;
		public int button_height;
		public Mutter.MetaButtonSizing button_sizing;
		public int button_width;
		public uint has_title;
		public uint hide_buttons;
		public int left_titlebar_edge;
		public int left_width;
		public int refcount;
		public int right_titlebar_edge;
		public int right_width;
		public Gtk.Border title_border;
		public double title_scale;
		public int title_vertical_pad;
		public uint top_left_corner_rounded_radius;
		public uint top_right_corner_rounded_radius;
		[CCode (cname = "meta_frame_layout_new", type = "MetaFrameLayout*", has_construct_function = false)]
		public MetaFrameLayout ();
		[CCode (cname = "meta_frame_layout_calc_geometry")]
		public static void calc_geometry (Mutter.MetaFrameLayout layout, int text_height, Mutter.MetaFrameFlags flags, int client_width, int client_height, Mutter.MetaButtonLayout button_layout, Mutter.MetaFrameGeometry fgeom, Mutter.MetaTheme theme);
		[CCode (cname = "meta_frame_layout_copy")]
		public static unowned Mutter.MetaFrameLayout copy (Mutter.MetaFrameLayout src);
		[CCode (cname = "meta_frame_layout_get_borders")]
		public static void get_borders (Mutter.MetaFrameLayout layout, int text_height, Mutter.MetaFrameFlags flags, int top_height, int bottom_height, int left_width, int right_width);
		[CCode (cname = "meta_frame_layout_validate")]
		public static bool validate (Mutter.MetaFrameLayout layout) throws GLib.Error;
	}
	[Compact]
	[CCode (ref_function = "meta_frame_style_ref", ref_function_void = true, unref_function = "meta_frame_style_unref", cheader_filename = "mutter-plugins.h")]
	public class MetaFrameStyle {
		[CCode (array_length = false)]
		public weak Mutter.MetaDrawOpList[] buttons;
		public weak Mutter.MetaFrameLayout layout;
		public weak Mutter.MetaFrameStyle parent;
		[CCode (array_length = false)]
		public weak Mutter.MetaDrawOpList[] pieces;
		public int refcount;
		public uchar window_background_alpha;
		public weak Mutter.MetaColorSpec window_background_color;
		[CCode (cname = "meta_frame_style_new", type = "MetaFrameStyle*", has_construct_function = false)]
		public MetaFrameStyle (Mutter.MetaFrameStyle parent);
		[CCode (cname = "meta_frame_style_draw")]
		public static void draw (Mutter.MetaFrameStyle style, Gtk.Widget widget, Gdk.Drawable drawable, int x_offset, int y_offset, Gdk.Rectangle clip, Mutter.MetaFrameGeometry fgeom, int client_width, int client_height, Pango.Layout title_layout, int text_height, Mutter.MetaButtonState[] button_states, Gdk.Pixbuf mini_icon, Gdk.Pixbuf icon);
		[CCode (cname = "meta_frame_style_draw_with_style")]
		public static void draw_with_style (Mutter.MetaFrameStyle style, Gtk.Style style_gtk, Gtk.Widget widget, Gdk.Drawable drawable, int x_offset, int y_offset, Gdk.Rectangle clip, Mutter.MetaFrameGeometry fgeom, int client_width, int client_height, Pango.Layout title_layout, int text_height, Mutter.MetaButtonState[] button_states, Gdk.Pixbuf mini_icon, Gdk.Pixbuf icon);
		[CCode (cname = "meta_frame_style_validate")]
		public static bool validate (Mutter.MetaFrameStyle style, uint current_theme_version) throws GLib.Error;
	}
	[Compact]
	[CCode (ref_function = "meta_frame_style_set_ref", ref_function_void = true, unref_function = "meta_frame_style_set_unref", cheader_filename = "mutter-plugins.h")]
	public class MetaFrameStyleSet {
		[CCode (array_length = false)]
		public weak Mutter.MetaFrameStyle[] maximized_and_shaded_styles;
		[CCode (array_length = false)]
		public weak Mutter.MetaFrameStyle[] maximized_styles;
		[CCode (array_length = false)]
		public weak Mutter.MetaFrameStyle[] normal_styles;
		public weak Mutter.MetaFrameStyleSet parent;
		public int refcount;
		[CCode (array_length = false)]
		public weak Mutter.MetaFrameStyle[] shaded_styles;
		[CCode (cname = "meta_frame_style_set_new", type = "MetaFrameStyleSet*", has_construct_function = false)]
		public MetaFrameStyleSet (Mutter.MetaFrameStyleSet parent);
		[CCode (cname = "meta_frame_style_set_validate")]
		public static bool validate (Mutter.MetaFrameStyleSet style_set) throws GLib.Error;
	}
	[Compact]
	[CCode (free_function = "meta_gradient_spec_free", cheader_filename = "mutter-plugins.h")]
	public class MetaGradientSpec {
		public weak GLib.SList color_specs;
		public Mutter.MetaGradientType type;
		[CCode (cname = "meta_gradient_spec_new", type = "MetaGradientSpec*", has_construct_function = false)]
		public MetaGradientSpec (Mutter.MetaGradientType type);
		[CCode (cname = "meta_gradient_spec_render")]
		public static unowned Gdk.Pixbuf render (Mutter.MetaGradientSpec desc, Gtk.Widget widget, int width, int height);
		[CCode (cname = "meta_gradient_spec_validate")]
		public static bool validate (Mutter.MetaGradientSpec spec) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaGroup {
		[CCode (cname = "meta_group_get_size")]
		public static int get_size (Mutter.MetaGroup group);
		[CCode (cname = "meta_group_get_startup_id")]
		public static unowned string get_startup_id (Mutter.MetaGroup group);
		[CCode (cname = "meta_group_list_windows")]
		public static unowned GLib.SList list_windows (Mutter.MetaGroup group);
		[CCode (cname = "meta_group_property_notify")]
		public static bool property_notify (Mutter.MetaGroup group, X.Event event);
		[CCode (cname = "meta_group_update_layers")]
		public static void update_layers (Mutter.MetaGroup group);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaKeyBinding {
		public weak Mutter.MetaKeyHandler handler;
		public uint keycode;
		public uint keysym;
		public uint mask;
		public Mutter.MetaVirtualModifier modifiers;
		public weak string name;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaKeyCombo {
		public uint keycode;
		public uint keysym;
		public Mutter.MetaVirtualModifier modifiers;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaKeyHandler {
		public int data;
		public weak Mutter.MetaKeyHandlerFunc default_func;
		public int flags;
		public weak Mutter.MetaKeyHandlerFunc func;
		public weak string name;
		public void* user_data;
		public weak GLib.DestroyNotify user_data_free_func;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaKeyPref {
		public bool add_shift;
		public weak GLib.SList bindings;
		public weak string default_keybinding;
		public weak string name;
		public bool per_window;
	}
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaNexus : GLib.Object {
		[CCode (cname = "meta_nexus_new", type = "MetaNexus*", has_construct_function = false)]
		public MetaNexus ();
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaPositionExprEnv {
		public int bottom_height;
		public int icon_height;
		public int icon_width;
		public int left_width;
		public int mini_icon_height;
		public int mini_icon_width;
		public int object_height;
		public int object_width;
		public weak Mutter.MetaRectangle rect;
		public int right_width;
		public weak Mutter.MetaTheme theme;
		public int title_height;
		public int title_width;
		public int top_height;
	}
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaPreview : Gtk.Bin, Gtk.Buildable, Atk.Implementor {
		public int bottom_height;
		public weak Mutter.MetaButtonLayout button_layout;
		public Mutter.MetaFrameFlags flags;
		public weak Pango.Layout layout;
		public int left_width;
		public int right_width;
		public int text_height;
		public weak Mutter.MetaTheme theme;
		public weak string title;
		public int top_height;
		public Mutter.MetaFrameType type;
		[CCode (cname = "meta_preview_new", type = "GtkWidget*", has_construct_function = false)]
		public MetaPreview ();
		[CCode (cname = "meta_preview_get_clip_region")]
		public static unowned Gdk.Region get_clip_region (Mutter.MetaPreview preview, int new_window_width, int new_window_height);
		[CCode (cname = "meta_preview_get_icon")]
		public static unowned Gdk.Pixbuf get_icon ();
		[CCode (cname = "meta_preview_get_mini_icon")]
		public static unowned Gdk.Pixbuf get_mini_icon ();
		[CCode (cname = "meta_preview_set_button_layout")]
		public static void set_button_layout (Mutter.MetaPreview preview, Mutter.MetaButtonLayout button_layout);
		[CCode (cname = "meta_preview_set_frame_flags")]
		public static void set_frame_flags (Mutter.MetaPreview preview, Mutter.MetaFrameFlags flags);
		[CCode (cname = "meta_preview_set_frame_type")]
		public static void set_frame_type (Mutter.MetaPreview preview, Mutter.MetaFrameType type);
		[CCode (cname = "meta_preview_set_theme")]
		public static void set_theme (Mutter.MetaPreview preview, Mutter.MetaTheme theme);
		[CCode (cname = "meta_preview_set_title")]
		public static void set_title (Mutter.MetaPreview preview, string title);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h", cname = "MetaRectangle")]
	public struct MetaRectangle {
		public int height;
		public int width;
		public int x;
		public int y;
		[CCode (cname = "meta_rectangle_area")]
		public static int area (Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_clamp_to_fit_into_region")]
		public static void clamp_to_fit_into_region (GLib.List spanning_rects, Mutter.FixedDirections fixed_directions, Mutter.MetaRectangle rect, Mutter.MetaRectangle min_size);
		[CCode (cname = "meta_rectangle_clip_to_region")]
		public static void clip_to_region (GLib.List spanning_rects, Mutter.FixedDirections fixed_directions, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_contained_in_region")]
		public static bool contained_in_region (GLib.List spanning_rects, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_contains_rect")]
		public static bool contains_rect (Mutter.MetaRectangle outer_rect, Mutter.MetaRectangle inner_rect);
		[CCode (cname = "meta_rectangle_could_fit_in_region")]
		public static bool could_fit_in_region (GLib.List spanning_rects, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_could_fit_rect")]
		public static bool could_fit_rect (Mutter.MetaRectangle outer_rect, Mutter.MetaRectangle inner_rect);
		[CCode (cname = "meta_rectangle_edge_aligns")]
		public static bool edge_aligns (Mutter.MetaRectangle rect, Mutter.MetaEdge edge);
		[CCode (cname = "meta_rectangle_edge_cmp")]
		public static int edge_cmp (void* a, void* b);
		[CCode (cname = "meta_rectangle_edge_cmp_ignore_type")]
		public static int edge_cmp_ignore_type (void* a, void* b);
		[CCode (cname = "meta_rectangle_edge_list_to_string")]
		public static unowned string edge_list_to_string (GLib.List edge_list, string separator_string, string output);
		[CCode (cname = "meta_rectangle_edge_to_string")]
		public static unowned string edge_to_string (Mutter.MetaEdge edge, string output);
		[CCode (cname = "meta_rectangle_equal")]
		public static bool equal (Mutter.MetaRectangle src1, Mutter.MetaRectangle src2);
		[CCode (cname = "meta_rectangle_expand_region")]
		public static unowned GLib.List expand_region (GLib.List region, int left_expand, int right_expand, int top_expand, int bottom_expand);
		[CCode (cname = "meta_rectangle_expand_region_conditionally")]
		public static unowned GLib.List expand_region_conditionally (GLib.List region, int left_expand, int right_expand, int top_expand, int bottom_expand, int min_x, int min_y);
		[CCode (cname = "meta_rectangle_expand_to_avoiding_struts")]
		public static void expand_to_avoiding_struts (Mutter.MetaRectangle rect, Mutter.MetaRectangle expand_to, Mutter.MetaDirection direction, GLib.SList all_struts);
		[CCode (cname = "meta_rectangle_find_linepoint_closest_to_point")]
		public static void find_linepoint_closest_to_point (double x1, double y1, double x2, double y2, double px, double py, double valx, double valy);
		[CCode (cname = "meta_rectangle_find_nonintersected_monitor_edges")]
		public static unowned GLib.List find_nonintersected_monitor_edges (GLib.List monitor_rects, GLib.SList all_struts);
		[CCode (cname = "meta_rectangle_find_onscreen_edges")]
		public static unowned GLib.List find_onscreen_edges (Mutter.MetaRectangle basic_rect, GLib.SList all_struts);
		[CCode (cname = "meta_rectangle_free_list_and_elements")]
		public static void free_list_and_elements (GLib.List filled_list);
		[CCode (cname = "meta_rectangle_get_minimal_spanning_set_for_region")]
		public static unowned GLib.List get_minimal_spanning_set_for_region (Mutter.MetaRectangle basic_rect, GLib.SList all_struts);
		[CCode (cname = "meta_rectangle_horiz_overlap")]
		public static bool horiz_overlap (Mutter.MetaRectangle rect1, Mutter.MetaRectangle rect2);
		[CCode (cname = "meta_rectangle_intersect")]
		public static bool intersect (Mutter.MetaRectangle src1, Mutter.MetaRectangle src2, Mutter.MetaRectangle dest);
		[CCode (cname = "meta_rectangle_overlap")]
		public static bool overlap (Mutter.MetaRectangle rect1, Mutter.MetaRectangle rect2);
		[CCode (cname = "meta_rectangle_overlaps_with_region")]
		public static bool overlaps_with_region (GLib.List spanning_rects, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_region_to_string")]
		public static unowned string region_to_string (GLib.List region, string separator_string, string output);
		[CCode (cname = "meta_rectangle_remove_intersections_with_boxes_from_edges")]
		public static unowned GLib.List remove_intersections_with_boxes_from_edges (GLib.List edges, GLib.SList rectangles);
		[CCode (cname = "meta_rectangle_resize_with_gravity")]
		public static void resize_with_gravity (Mutter.MetaRectangle old_rect, Mutter.MetaRectangle rect, int gravity, int new_width, int new_height);
		[CCode (cname = "meta_rectangle_shove_into_region")]
		public static void shove_into_region (GLib.List spanning_rects, Mutter.FixedDirections fixed_directions, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_rectangle_to_string")]
		public static unowned string to_string (Mutter.MetaRectangle rect, string output);
		[CCode (cname = "meta_rectangle_union")]
		public static void union (Mutter.MetaRectangle rect1, Mutter.MetaRectangle rect2, Mutter.MetaRectangle dest);
		[CCode (cname = "meta_rectangle_vert_overlap")]
		public static bool vert_overlap (Mutter.MetaRectangle rect1, Mutter.MetaRectangle rect2);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaResizePopup {
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaScreen {
		[CCode (cname = "meta_screen_append_new_workspace")]
		public static unowned Mutter.MetaWorkspace append_new_workspace (Mutter.MetaScreen screen, bool activate, uint32 timestamp);
		[CCode (cname = "meta_screen_for_x_screen")]
		public static unowned Mutter.MetaScreen for_x_screen (X.Screen xscreen);
		[CCode (cname = "meta_screen_get_active_workspace")]
		public static unowned Mutter.MetaWorkspace get_active_workspace (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_active_workspace_index")]
		public static int get_active_workspace_index (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_compositor_data")]
		public static void* get_compositor_data (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_display")]
		public static unowned Mutter.MetaDisplay get_display (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_monitor_geometry")]
		public static void get_monitor_geometry (Mutter.MetaScreen screen, int monitor, Mutter.MetaRectangle geometry);
		[CCode (cname = "meta_screen_get_n_monitors")]
		public static int get_n_monitors (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_n_workspaces")]
		public static int get_n_workspaces (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_screen_number")]
		public static int get_screen_number (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_size")]
		public static void get_size (Mutter.MetaScreen screen, int width, int height);
		[CCode (cname = "meta_screen_get_startup_sequences")]
		public static unowned GLib.SList get_startup_sequences (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_workspace_by_index")]
		public static unowned Mutter.MetaWorkspace get_workspace_by_index (Mutter.MetaScreen screen, int index);
		[CCode (cname = "meta_screen_get_workspaces")]
		public static unowned GLib.List get_workspaces (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_get_xroot")]
		public static X.Window get_xroot (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_grab_all_keys")]
		public static bool grab_all_keys (Mutter.MetaScreen screen, uint32 timestamp);
		[CCode (cname = "meta_screen_remove_workspace")]
		public static void remove_workspace (Mutter.MetaScreen screen, Mutter.MetaWorkspace workspace, uint32 timestamp);
		[CCode (cname = "meta_screen_set_cm_selection")]
		public static void set_cm_selection (Mutter.MetaScreen screen);
		[CCode (cname = "meta_screen_set_compositor_data")]
		public static void set_compositor_data (Mutter.MetaScreen screen, void* info);
		[CCode (cname = "meta_screen_ungrab_all_keys")]
		public static void ungrab_all_keys (Mutter.MetaScreen screen, uint32 timestamp);
		[CCode (cname = "meta_screen_unset_cm_selection")]
		public static void unset_cm_selection (Mutter.MetaScreen screen);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaScreenClass {
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaStrut {
		public weak Mutter.MetaRectangle rect;
		public Mutter.MetaSide side;
	}
	[Compact]
	[CCode (free_function = "meta_theme_free", cheader_filename = "mutter-plugins.h")]
	public class MetaTheme {
		public weak string author;
		public weak GLib.HashTable color_constants;
		public weak string copyright;
		public weak string date;
		public weak string description;
		public weak string dirname;
		public weak GLib.HashTable draw_op_lists_by_name;
		public weak string filename;
		public weak GLib.HashTable float_constants;
		public uint format_version;
		public weak GLib.HashTable images_by_filename;
		public weak GLib.HashTable integer_constants;
		public weak GLib.HashTable layouts_by_name;
		public weak string name;
		public GLib.Quark quark_bottom_height;
		public GLib.Quark quark_height;
		public GLib.Quark quark_icon_height;
		public GLib.Quark quark_icon_width;
		public GLib.Quark quark_left_width;
		public GLib.Quark quark_mini_icon_height;
		public GLib.Quark quark_mini_icon_width;
		public GLib.Quark quark_object_height;
		public GLib.Quark quark_object_width;
		public GLib.Quark quark_right_width;
		public GLib.Quark quark_title_height;
		public GLib.Quark quark_title_width;
		public GLib.Quark quark_top_height;
		public GLib.Quark quark_width;
		public weak string readable_name;
		public weak GLib.HashTable style_sets_by_name;
		[CCode (array_length = false)]
		public weak Mutter.MetaFrameStyleSet[] style_sets_by_type;
		public weak GLib.HashTable styles_by_name;
		[CCode (cname = "meta_theme_new", type = "MetaTheme*", has_construct_function = false)]
		public MetaTheme ();
		[CCode (cname = "meta_theme_calc_geometry")]
		public static void calc_geometry (Mutter.MetaTheme theme, Mutter.MetaFrameType type, int text_height, Mutter.MetaFrameFlags flags, int client_width, int client_height, Mutter.MetaButtonLayout button_layout, Mutter.MetaFrameGeometry fgeom);
		[CCode (cname = "meta_theme_define_color_constant")]
		public static bool define_color_constant (Mutter.MetaTheme theme, string name, string value) throws GLib.Error;
		[CCode (cname = "meta_theme_define_float_constant")]
		public static bool define_float_constant (Mutter.MetaTheme theme, string name, double value) throws GLib.Error;
		[CCode (cname = "meta_theme_define_int_constant")]
		public static bool define_int_constant (Mutter.MetaTheme theme, string name, int value) throws GLib.Error;
		[CCode (cname = "meta_theme_draw_frame")]
		public static void draw_frame (Mutter.MetaTheme theme, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, int x_offset, int y_offset, Mutter.MetaFrameType type, Mutter.MetaFrameFlags flags, int client_width, int client_height, Pango.Layout title_layout, int text_height, Mutter.MetaButtonLayout button_layout, Mutter.MetaButtonState[] button_states, Gdk.Pixbuf mini_icon, Gdk.Pixbuf icon);
		[CCode (cname = "meta_theme_draw_frame_by_name")]
		public static void draw_frame_by_name (Mutter.MetaTheme theme, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, int x_offset, int y_offset, string style_name, Mutter.MetaFrameFlags flags, int client_width, int client_height, Pango.Layout title_layout, int text_height, Mutter.MetaButtonLayout button_layout, Mutter.MetaButtonState[] button_states, Gdk.Pixbuf mini_icon, Gdk.Pixbuf icon);
		[CCode (cname = "meta_theme_draw_frame_with_style")]
		public static void draw_frame_with_style (Mutter.MetaTheme theme, Gtk.Style style_gtk, Gtk.Widget widget, Gdk.Drawable drawable, Gdk.Rectangle clip, int x_offset, int y_offset, Mutter.MetaFrameType type, Mutter.MetaFrameFlags flags, int client_width, int client_height, Pango.Layout title_layout, int text_height, Mutter.MetaButtonLayout button_layout, Mutter.MetaButtonState[] button_states, Gdk.Pixbuf mini_icon, Gdk.Pixbuf icon);
		[CCode (cname = "meta_theme_earliest_version_with_button")]
		public static uint earliest_version_with_button (Mutter.MetaButtonType type);
		[CCode (cname = "meta_theme_get_current")]
		public static unowned Mutter.MetaTheme get_current ();
		[CCode (cname = "meta_theme_get_frame_borders")]
		public static void get_frame_borders (Mutter.MetaTheme theme, Mutter.MetaFrameType type, int text_height, Mutter.MetaFrameFlags flags, int top_height, int bottom_height, int left_width, int right_width);
		[CCode (cname = "meta_theme_get_frame_style")]
		public static unowned Mutter.MetaFrameStyle get_frame_style (Mutter.MetaTheme theme, Mutter.MetaFrameType type, Mutter.MetaFrameFlags flags);
		[CCode (cname = "meta_theme_get_title_scale")]
		public static double get_title_scale (Mutter.MetaTheme theme, Mutter.MetaFrameType type, Mutter.MetaFrameFlags flags);
		[CCode (cname = "meta_theme_insert_draw_op_list")]
		public static void insert_draw_op_list (Mutter.MetaTheme theme, string name, Mutter.MetaDrawOpList op_list);
		[CCode (cname = "meta_theme_insert_layout")]
		public static void insert_layout (Mutter.MetaTheme theme, string name, Mutter.MetaFrameLayout layout);
		[CCode (cname = "meta_theme_insert_style")]
		public static void insert_style (Mutter.MetaTheme theme, string name, Mutter.MetaFrameStyle style);
		[CCode (cname = "meta_theme_insert_style_set")]
		public static void insert_style_set (Mutter.MetaTheme theme, string name, Mutter.MetaFrameStyleSet style_set);
		[CCode (cname = "meta_theme_load")]
		public static unowned Mutter.MetaTheme load (string theme_name) throws GLib.Error;
		[CCode (cname = "meta_theme_load_image")]
		public static unowned Gdk.Pixbuf load_image (Mutter.MetaTheme theme, string filename, uint size_of_theme_icons) throws GLib.Error;
		[CCode (cname = "meta_theme_lookup_color_constant")]
		public static bool lookup_color_constant (Mutter.MetaTheme theme, string name, out unowned string value);
		[CCode (cname = "meta_theme_lookup_draw_op_list")]
		public static unowned Mutter.MetaDrawOpList lookup_draw_op_list (Mutter.MetaTheme theme, string name);
		[CCode (cname = "meta_theme_lookup_float_constant")]
		public static bool lookup_float_constant (Mutter.MetaTheme theme, string name, double value);
		[CCode (cname = "meta_theme_lookup_int_constant")]
		public static bool lookup_int_constant (Mutter.MetaTheme theme, string name, int value);
		[CCode (cname = "meta_theme_lookup_layout")]
		public static unowned Mutter.MetaFrameLayout lookup_layout (Mutter.MetaTheme theme, string name);
		[CCode (cname = "meta_theme_lookup_style")]
		public static unowned Mutter.MetaFrameStyle lookup_style (Mutter.MetaTheme theme, string name);
		[CCode (cname = "meta_theme_lookup_style_set")]
		public static unowned Mutter.MetaFrameStyleSet lookup_style_set (Mutter.MetaTheme theme, string name);
		[CCode (cname = "meta_theme_replace_constants")]
		public static bool replace_constants (Mutter.MetaTheme theme, Mutter.PosToken[] tokens) throws GLib.Error;
		[CCode (cname = "meta_theme_set_current")]
		public static void set_current (string name, bool force_reload);
		[CCode (cname = "meta_theme_validate")]
		public static bool validate (Mutter.MetaTheme theme) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h", cname = "MetaWindow")]
	public class MetaWindow {
		[CCode (cname = "meta_window_activate")]
		public static void activate (Mutter.MetaWindow window, uint32 current_time);
		[CCode (cname = "meta_window_activate_with_workspace")]
		public static void activate_with_workspace (Mutter.MetaWindow window, uint32 current_time, Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_window_change_workspace_by_index")]
		public static void change_workspace_by_index (Mutter.MetaWindow window, int space_index, bool append, uint32 timestamp);
		[CCode (cname = "meta_window_compute_group")]
		public static void compute_group (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_configure_notify")]
		public static void configure_notify (Mutter.MetaWindow window, X.ConfigureEvent event);
		[CCode (cname = "meta_window_delete")]
		public static void @delete (Mutter.MetaWindow window, uint32 timestamp);
		[CCode (cname = "meta_window_find_root_ancestor")]
		public static unowned Mutter.MetaWindow find_root_ancestor (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_client_machine")]
		public static unowned string get_client_machine (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_compositor_private")]
		public static unowned GLib.Object get_compositor_private (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_description")]
		public static unowned string get_description (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_display")]
		public static unowned Mutter.MetaDisplay get_display (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_frame")]
		public static unowned Mutter.MetaFrame get_frame (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_group")]
		public static unowned Mutter.MetaGroup get_group (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_icon_geometry")]
		public static bool get_icon_geometry (Mutter.MetaWindow window, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_window_get_layer")]
		public static Mutter.MetaStackLayer get_layer (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_outer_rect")]
		public static void get_outer_rect (Mutter.MetaWindow window, Mutter.MetaRectangle rect);
		[CCode (cname = "meta_window_get_pid")]
		public static int get_pid (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_rect")]
		public static unowned Mutter.MetaRectangle get_rect (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_role")]
		public static unowned string get_role (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_screen")]
		public static unowned Mutter.MetaScreen get_screen (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_stable_sequence")]
		public static uint get_stable_sequence (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_startup_id")]
		public static unowned string get_startup_id (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_title")]
		public static unowned string get_title (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_transient_for")]
		public static unowned Mutter.MetaWindow get_transient_for (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_transient_for_as_xid")]
		public static X.Window get_transient_for_as_xid (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_user_time")]
		public static uint32 get_user_time (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_window_type")]
		public static Mutter.MetaWindowType get_window_type (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_window_type_atom")]
		public static X.Atom get_window_type_atom (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_wm_class")]
		public static unowned string get_wm_class (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_workspace")]
		public static unowned Mutter.MetaWorkspace get_workspace (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_get_xwindow")]
		public static X.Window get_xwindow (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_group_leader_changed")]
		public static void group_leader_changed (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_has_focus")]
		public static bool has_focus (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_ancestor_of_transient")]
		public static bool is_ancestor_of_transient (Mutter.MetaWindow window, Mutter.MetaWindow transient);
		[CCode (cname = "meta_window_is_hidden")]
		public static bool is_hidden (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_mapped")]
		public static bool is_mapped (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_maximized")]
		public static bool is_maximized (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_maximized_horizontally")]
		public static bool is_maximized_horizontally (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_maximized_vertically")]
		public static bool is_maximized_vertically (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_minimized")]
		public static bool is_minimized (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_allows_resize")]
		public static bool allows_resize (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_modal")]
		public static bool is_modal (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_on_all_workspaces")]
		public static bool is_on_all_workspaces (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_override_redirect")]
		public static bool is_override_redirect (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_shaded")]
		public static bool is_shaded (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_is_skip_taskbar")]
		public static bool is_skip_taskbar (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_maximize")]
		public static void maximize (Mutter.MetaWindow window, Mutter.MetaMaximizeFlags directions);
		[CCode (cname = "meta_window_minimize")]
		public static void minimize (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_set_compositor_private")]
		public static void set_compositor_private (Mutter.MetaWindow window, GLib.Object priv);
		[CCode (cname = "meta_window_showing_on_its_workspace")]
		public static bool showing_on_its_workspace (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_shutdown_group")]
		public static void shutdown_group (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_toplevel_is_mapped")]
		public static bool toplevel_is_mapped (Mutter.MetaWindow window);
		[CCode (cname = "meta_window_unmaximize")]
		public static void unmaximize (Mutter.MetaWindow window, Mutter.MetaMaximizeFlags directions);
		[CCode (cname = "meta_window_unminimize")]
		public static void unminimize (Mutter.MetaWindow window);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaWindowClass {
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaWindowMenu {
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaWorkspace {
		[CCode (cname = "meta_workspace_activate")]
		public static void activate (Mutter.MetaWorkspace workspace, uint32 timestamp);
		[CCode (cname = "meta_workspace_activate_with_focus")]
		public static void activate_with_focus (Mutter.MetaWorkspace workspace, Mutter.MetaWindow focus_this, uint32 timestamp);
		[CCode (cname = "meta_workspace_get_screen")]
		public static unowned Mutter.MetaScreen get_screen (Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_workspace_get_work_area_all_monitors")]
		public static void get_work_area_all_monitors (Mutter.MetaWorkspace workspace, Mutter.MetaRectangle area);
		[CCode (cname = "meta_workspace_index")]
		public static int index (Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_workspace_list_windows")]
		public static unowned GLib.List list_windows (Mutter.MetaWorkspace workspace);
		[CCode (cname = "meta_workspace_set_builtin_struts")]
		public static void set_builtin_struts (Mutter.MetaWorkspace workspace, GLib.SList struts);
		[CCode (cname = "meta_workspace_update_window_hints")]
		public static void update_window_hints (Mutter.MetaWorkspace workspace);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class MetaWorkspaceClass {
	}
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class Plugin : GLib.Object {
		public weak GLib.Object parent;
		public bool begin_modal (X.Window grab_window, uint cursor, Mutter.MetaModalOptions options, uint32 timestamp);
		public bool debug_mode ();
		public bool disabled ();
		public void effect_completed (Mutter.Window actor, uint event);
		public void end_modal (uint32 timestamp);
		public ulong features ();
		public unowned Clutter.Actor get_above_window_group ();
		public unowned Clutter.Actor get_below_window_group ();
		public unowned Mutter.PluginInfo get_info ();
		public unowned Clutter.Actor get_normal_window_group ();
		public unowned Clutter.Actor get_overlay_group ();
		public unowned Mutter.MetaScreen get_screen ();
		public unowned Clutter.Actor get_stage ();
		public unowned Clutter.Actor get_window_group ();
		public unowned GLib.List get_windows ();
		public unowned X.Display get_xdisplay ();
		public void query_screen_size (int width, int height);
		public bool running ();
		public void set_stage_input_area (int x, int y, int width, int height);
		public void set_stage_input_region (uint region);
		public void set_stage_reactive (bool reactive);
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class PluginClass {
		public weak GLib.Callback destroy;
		public weak GLib.Callback kill_effect;
		public weak GLib.Callback map;
		public weak GLib.Callback maximize;
		public weak GLib.Callback minimize;
		public weak GLib.ObjectClass parent_class;
		public weak GLib.Callback plugin_info;
		public weak GLib.Callback switch_workspace;
		public weak GLib.Callback unmaximize;
		public weak GLib.Callback xevent_filter;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class PluginInfo {
		public weak string author;
		public weak string description;
		public weak string license;
		public weak string name;
		public weak string version;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class PluginVersion {
		public uint version_api;
		public uint version_major;
		public uint version_micro;
		public uint version_minor;
	}
	[Compact]
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class PosToken {
		public void* d;
		public Mutter.PosTokenType type;
	}
	[CCode (cheader_filename = "mutter-plugins.h")]
	public class Window : Clutter.Group {
		public weak Clutter.Group parent;
		public unowned string get_description ();
		public unowned Mutter.MetaWindow get_meta_window ();
		public unowned Clutter.Actor get_texture ();
		public Mutter.MetaCompWindowType get_window_type ();
		public int get_workspace ();
		public X.Window get_x_window ();
		public bool is_hidden ();
		public bool is_override_redirect ();
		public bool showing_on_its_workspace ();
	}
	[CCode (cprefix = "FIXED_DIRECTION_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum FixedDirections {
		NONE,
		X,
		Y
	}
	[CCode (cprefix = "META_ACTION_TITLEBAR_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaActionTitlebar {
		TOGGLE_SHADE,
		TOGGLE_MAXIMIZE,
		TOGGLE_MAXIMIZE_HORIZONTALLY,
		TOGGLE_MAXIMIZE_VERTICALLY,
		MINIMIZE,
		NONE,
		LOWER,
		MENU,
		LAST
	}
	[CCode (cprefix = "META_ATOM_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaAtom {
		FIRST,
		WM_PROTOCOLS,
		WM_TAKE_FOCUS,
		WM_DELETE_WINDOW,
		WM_STATE,
		_MOTIF_WM_HINTS,
		WM_CHANGE_STATE,
		SM_CLIENT_ID,
		WM_CLIENT_LEADER,
		WM_WINDOW_ROLE,
		UTF8_STRING,
		WM_ICON_SIZE,
		_KWM_WIN_ICON,
		_MUTTER_RESTART_MESSAGE,
		_MUTTER_RELOAD_THEME_MESSAGE,
		_MUTTER_SET_KEYBINDINGS_MESSAGE,
		_MUTTER_TOGGLE_VERBOSE,
		_GNOME_WM_KEYBINDINGS,
		_GNOME_PANEL_ACTION,
		_GNOME_PANEL_ACTION_MAIN_MENU,
		_GNOME_PANEL_ACTION_RUN_DIALOG,
		_MUTTER_SENTINEL,
		_MUTTER_VERSION,
		WM_CLIENT_MACHINE,
		MANAGER,
		TARGETS,
		MULTIPLE,
		TIMESTAMP,
		VERSION,
		ATOM_PAIR,
		_NET_WM_SYNC_REQUEST,
		_NET_WM_SYNC_REQUEST_COUNTER,
		_NET_WM_VISIBLE_NAME,
		_NET_WM_VISIBLE_ICON_NAME,
		_NET_SUPPORTING_WM_CHECK,
		_NET_SUPPORTED,
		_NET_WM_NAME,
		_NET_CLOSE_WINDOW,
		_NET_WM_STATE,
		_NET_WM_STATE_SHADED,
		_NET_WM_STATE_MAXIMIZED_HORZ,
		_NET_WM_STATE_MAXIMIZED_VERT,
		_NET_WM_DESKTOP,
		_NET_NUMBER_OF_DESKTOPS,
		_NET_CURRENT_DESKTOP,
		_NET_WM_WINDOW_TYPE,
		_NET_WM_WINDOW_TYPE_DESKTOP,
		_NET_WM_WINDOW_TYPE_DOCK,
		_NET_WM_WINDOW_TYPE_TOOLBAR,
		_NET_WM_WINDOW_TYPE_MENU,
		_NET_WM_WINDOW_TYPE_UTILITY,
		_NET_WM_WINDOW_TYPE_SPLASH,
		_NET_WM_WINDOW_TYPE_DIALOG,
		_NET_WM_WINDOW_TYPE_DROPDOWN_MENU,
		_NET_WM_WINDOW_TYPE_POPUP_MENU,
		_NET_WM_WINDOW_TYPE_TOOLTIP,
		_NET_WM_WINDOW_TYPE_NOTIFICATION,
		_NET_WM_WINDOW_TYPE_COMBO,
		_NET_WM_WINDOW_TYPE_DND,
		_NET_WM_WINDOW_TYPE_NORMAL,
		_NET_WM_STATE_MODAL,
		_NET_CLIENT_LIST,
		_NET_CLIENT_LIST_STACKING,
		_NET_WM_STATE_SKIP_TASKBAR,
		_NET_WM_STATE_SKIP_PAGER,
		_NET_WM_ICON_NAME,
		_NET_WM_ICON,
		_NET_WM_ICON_GEOMETRY,
		_NET_WM_MOVERESIZE,
		_NET_ACTIVE_WINDOW,
		_NET_WM_STRUT,
		_NET_WM_STATE_HIDDEN,
		_NET_WM_STATE_FULLSCREEN,
		_NET_WM_PING,
		_NET_WM_PID,
		_NET_WORKAREA,
		_NET_SHOWING_DESKTOP,
		_NET_DESKTOP_LAYOUT,
		_NET_DESKTOP_NAMES,
		_NET_WM_ALLOWED_ACTIONS,
		_NET_WM_ACTION_MOVE,
		_NET_WM_ACTION_RESIZE,
		_NET_WM_ACTION_SHADE,
		_NET_WM_ACTION_STICK,
		_NET_WM_ACTION_MAXIMIZE_HORZ,
		_NET_WM_ACTION_MAXIMIZE_VERT,
		_NET_WM_ACTION_CHANGE_DESKTOP,
		_NET_WM_ACTION_CLOSE,
		_NET_WM_STATE_ABOVE,
		_NET_WM_STATE_BELOW,
		_NET_STARTUP_ID,
		_NET_WM_STRUT_PARTIAL,
		_NET_WM_ACTION_FULLSCREEN,
		_NET_WM_ACTION_MINIMIZE,
		_NET_FRAME_EXTENTS,
		_NET_REQUEST_FRAME_EXTENTS,
		_NET_WM_USER_TIME,
		_NET_WM_STATE_DEMANDS_ATTENTION,
		_NET_MOVERESIZE_WINDOW,
		_NET_DESKTOP_GEOMETRY,
		_NET_DESKTOP_VIEWPORT,
		_NET_WM_USER_TIME_WINDOW,
		_NET_WM_ACTION_ABOVE,
		_NET_WM_ACTION_BELOW,
		_NET_WM_STATE_STICKY,
		_NET_WM_FULLSCREEN_MONITORS
	}
	[CCode (cprefix = "META_BUTTON_FUNCTION_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaButtonFunction {
		MENU,
		MINIMIZE,
		MAXIMIZE,
		CLOSE,
		SHADE,
		ABOVE,
		STICK,
		UNSHADE,
		UNABOVE,
		UNSTICK,
		LAST
	}
	[CCode (cprefix = "META_BUTTON_SIZING_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaButtonSizing {
		ASPECT,
		FIXED,
		LAST
	}
	[CCode (cprefix = "META_BUTTON_STATE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaButtonState {
		NORMAL,
		PRESSED,
		PRELIGHT,
		LAST
	}
	[CCode (cprefix = "META_BUTTON_TYPE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaButtonType {
		LEFT_LEFT_BACKGROUND,
		LEFT_MIDDLE_BACKGROUND,
		LEFT_RIGHT_BACKGROUND,
		RIGHT_LEFT_BACKGROUND,
		RIGHT_MIDDLE_BACKGROUND,
		RIGHT_RIGHT_BACKGROUND,
		CLOSE,
		MAXIMIZE,
		MINIMIZE,
		MENU,
		SHADE,
		ABOVE,
		STICK,
		UNSHADE,
		UNABOVE,
		UNSTICK,
		LAST
	}
	[CCode (cprefix = "META_COLOR_SPEC_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaColorSpecType {
		BASIC,
		GTK,
		BLEND,
		SHADE
	}
	[CCode (cprefix = "META_COMP_EFFECT_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaCompEffect {
		CREATE,
		UNMINIMIZE,
		DESTROY,
		MINIMIZE,
		NONE
	}
	[CCode (cprefix = "META_COMP_WINDOW_", has_type_id = "0", cheader_filename = "mutter-plugins.h", cname="MetaCompWindowType")]
	public enum MetaCompWindowType {
		NORMAL,
		DESKTOP,
		DOCK,
		DIALOG,
		MODAL_DIALOG,
		TOOLBAR,
		MENU,
		UTILITY,
		SPLASHSCREEN,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND,
		OVERRIDE_OTHER
	}
	[CCode (cprefix = "META_CURSOR_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaCursor {
		DEFAULT,
		NORTH_RESIZE,
		SOUTH_RESIZE,
		WEST_RESIZE,
		EAST_RESIZE,
		SE_RESIZE,
		SW_RESIZE,
		NE_RESIZE,
		NW_RESIZE,
		MOVE_OR_RESIZE_WINDOW,
		BUSY
	}
	[CCode (cprefix = "META_DEBUG_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaDebugTopic {
		FOCUS,
		WORKAREA,
		STACK,
		THEMES,
		SM,
		EVENTS,
		WINDOW_STATE,
		WINDOW_OPS,
		GEOMETRY,
		PLACEMENT,
		PING,
		XINERAMA,
		KEYBINDINGS,
		SYNC,
		ERRORS,
		STARTUP,
		PREFS,
		GROUPS,
		RESIZING,
		SHAPES,
		COMPOSITOR,
		EDGE_RESISTANCE
	}
	[CCode (cprefix = "META_DIRECTION_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaDirection {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM,
		UP,
		DOWN,
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cprefix = "META_DRAW_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaDrawType {
		LINE,
		RECTANGLE,
		ARC,
		CLIP,
		TINT,
		GRADIENT,
		IMAGE,
		GTK_ARROW,
		GTK_BOX,
		GTK_VLINE,
		ICON,
		TITLE,
		OP_LIST,
		TILE
	}
	[CCode (cprefix = "META_EDGE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaEdgeType {
		WINDOW,
		MONITOR,
		SCREEN
	}
	[CCode (cprefix = "META_EXIT_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaExitCode {
		SUCCESS,
		ERROR
	}
	[CCode (cprefix = "META_FOCUS_MODE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFocusMode {
		CLICK,
		SLOPPY,
		MOUSE
	}
	[CCode (cprefix = "META_FOCUS_NEW_WINDOWS_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFocusNewWindows {
		SMART,
		STRICT
	}
	[CCode (cprefix = "META_FRAME_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFrameFlags {
		ALLOWS_DELETE,
		ALLOWS_MENU,
		ALLOWS_MINIMIZE,
		ALLOWS_MAXIMIZE,
		ALLOWS_VERTICAL_RESIZE,
		ALLOWS_HORIZONTAL_RESIZE,
		HAS_FOCUS,
		SHADED,
		STUCK,
		MAXIMIZED,
		ALLOWS_SHADE,
		ALLOWS_MOVE,
		FULLSCREEN,
		IS_FLASHING,
		ABOVE
	}
	[CCode (cprefix = "META_FRAME_FOCUS_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFrameFocus {
		NO,
		YES,
		LAST
	}
	[CCode (cprefix = "META_FRAME_PIECE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFramePiece {
		ENTIRE_BACKGROUND,
		TITLEBAR,
		TITLEBAR_MIDDLE,
		LEFT_TITLEBAR_EDGE,
		RIGHT_TITLEBAR_EDGE,
		TOP_TITLEBAR_EDGE,
		BOTTOM_TITLEBAR_EDGE,
		TITLE,
		LEFT_EDGE,
		RIGHT_EDGE,
		BOTTOM_EDGE,
		OVERLAY,
		LAST
	}
	[CCode (cprefix = "META_FRAME_RESIZE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFrameResize {
		NONE,
		VERTICAL,
		HORIZONTAL,
		BOTH,
		LAST
	}
	[CCode (cprefix = "META_FRAME_STATE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFrameState {
		NORMAL,
		MAXIMIZED,
		SHADED,
		MAXIMIZED_AND_SHADED,
		LAST
	}
	[CCode (cprefix = "META_FRAME_TYPE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaFrameType {
		NORMAL,
		DIALOG,
		MODAL_DIALOG,
		UTILITY,
		MENU,
		BORDER,
		LAST
	}
	[CCode (cprefix = "META_GRAB_OP_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaGrabOp {
		NONE,
		MOVING,
		RESIZING_SE,
		RESIZING_S,
		RESIZING_SW,
		RESIZING_N,
		RESIZING_NE,
		RESIZING_NW,
		RESIZING_W,
		RESIZING_E,
		KEYBOARD_MOVING,
		KEYBOARD_RESIZING_UNKNOWN,
		KEYBOARD_RESIZING_S,
		KEYBOARD_RESIZING_N,
		KEYBOARD_RESIZING_W,
		KEYBOARD_RESIZING_E,
		KEYBOARD_RESIZING_SE,
		KEYBOARD_RESIZING_NE,
		KEYBOARD_RESIZING_SW,
		KEYBOARD_RESIZING_NW,
		KEYBOARD_TABBING_NORMAL,
		KEYBOARD_TABBING_DOCK,
		KEYBOARD_ESCAPING_NORMAL,
		KEYBOARD_ESCAPING_DOCK,
		KEYBOARD_ESCAPING_GROUP,
		KEYBOARD_TABBING_GROUP,
		KEYBOARD_WORKSPACE_SWITCHING,
		CLICKING_MINIMIZE,
		CLICKING_MAXIMIZE,
		CLICKING_UNMAXIMIZE,
		CLICKING_DELETE,
		CLICKING_MENU,
		CLICKING_SHADE,
		CLICKING_UNSHADE,
		CLICKING_ABOVE,
		CLICKING_UNABOVE,
		CLICKING_STICK,
		CLICKING_UNSTICK,
		COMPOSITOR
	}
	[CCode (cprefix = "META_GRADIENT_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaGradientType {
		VERTICAL,
		HORIZONTAL,
		DIAGONAL,
		LAST
	}
	[CCode (cprefix = "META_GTK_COLOR_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaGtkColorComponent {
		FG,
		BG,
		LIGHT,
		DARK,
		MID,
		TEXT,
		BASE,
		TEXT_AA,
		LAST
	}
	[CCode (cprefix = "META_IMAGE_FILL_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaImageFillType {
		SCALE,
		TILE
	}
	[CCode (cprefix = "META_KEYBINDING_ACTION_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaKeyBindingAction {
		NONE,
		WORKSPACE_1,
		WORKSPACE_2,
		WORKSPACE_3,
		WORKSPACE_4,
		WORKSPACE_5,
		WORKSPACE_6,
		WORKSPACE_7,
		WORKSPACE_8,
		WORKSPACE_9,
		WORKSPACE_10,
		WORKSPACE_11,
		WORKSPACE_12,
		WORKSPACE_LEFT,
		WORKSPACE_RIGHT,
		WORKSPACE_UP,
		WORKSPACE_DOWN,
		SWITCH_GROUP,
		SWITCH_GROUP_BACKWARD,
		SWITCH_WINDOWS,
		SWITCH_WINDOWS_BACKWARD,
		SWITCH_PANELS,
		SWITCH_PANELS_BACKWARD,
		CYCLE_GROUP,
		CYCLE_GROUP_BACKWARD,
		CYCLE_WINDOWS,
		CYCLE_WINDOWS_BACKWARD,
		CYCLE_PANELS,
		CYCLE_PANELS_BACKWARD,
		SHOW_DESKTOP,
		PANEL_MAIN_MENU,
		PANEL_RUN_DIALOG,
		COMMAND_1,
		COMMAND_2,
		COMMAND_3,
		COMMAND_4,
		COMMAND_5,
		COMMAND_6,
		COMMAND_7,
		COMMAND_8,
		COMMAND_9,
		COMMAND_10,
		COMMAND_11,
		COMMAND_12
	}
	[CCode (cprefix = "META_LATER_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaLaterType {
		RESIZE,
		BEFORE_REDRAW,
		IDLE
	}
	[CCode (cprefix = "META_MAXIMIZE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaMaximizeFlags {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cprefix = "META_MENU_ICON_TYPE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaMenuIconType {
		CLOSE,
		MAXIMIZE,
		UNMAXIMIZE,
		MINIMIZE,
		LAST
	}
	[CCode (cprefix = "META_MENU_OP_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaMenuOp {
		DELETE,
		MINIMIZE,
		UNMAXIMIZE,
		MAXIMIZE,
		UNSHADE,
		SHADE,
		UNSTICK,
		STICK,
		WORKSPACES,
		MOVE,
		RESIZE,
		ABOVE,
		UNABOVE,
		MOVE_LEFT,
		MOVE_RIGHT,
		MOVE_UP,
		MOVE_DOWN,
		RECOVER
	}
	[CCode (cprefix = "META_MODAL_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaModalOptions {
		POINTER_ALREADY_GRABBED,
		KEYBOARD_ALREADY_GRABBED
	}
	[CCode (cprefix = "META_MOTION_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaMotionDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT,
		UP_LEFT,
		UP_RIGHT,
		DOWN_LEFT,
		DOWN_RIGHT
	}
	[CCode (cprefix = "META_PREF_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaPreference {
		MOUSE_BUTTON_MODS,
		FOCUS_MODE,
		FOCUS_NEW_WINDOWS,
		RAISE_ON_CLICK,
		ACTION_DOUBLE_CLICK_TITLEBAR,
		ACTION_MIDDLE_CLICK_TITLEBAR,
		ACTION_RIGHT_CLICK_TITLEBAR,
		AUTO_RAISE,
		AUTO_RAISE_DELAY,
		THEME,
		TITLEBAR_FONT,
		NUM_WORKSPACES,
		APPLICATION_BASED,
		KEYBINDINGS,
		DISABLE_WORKAROUNDS,
		COMMANDS,
		TERMINAL_COMMAND,
		BUTTON_LAYOUT,
		WORKSPACE_NAMES,
		VISUAL_BELL,
		AUDIBLE_BELL,
		VISUAL_BELL_TYPE,
		GNOME_ACCESSIBILITY,
		GNOME_ANIMATIONS,
		CURSOR_THEME,
		CURSOR_SIZE,
		COMPOSITING_MANAGER,
		RESIZE_WITH_RIGHT_BUTTON,
		CLUTTER_PLUGINS,
		LIVE_HIDDEN_WINDOWS,
		NO_TAB_POPUP
	}
	[CCode (cprefix = "META_SIDE_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaSide {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM
	}
	[CCode (cprefix = "META_LAYER_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaStackLayer {
		DESKTOP,
		BOTTOM,
		NORMAL,
		TOP,
		DOCK,
		FULLSCREEN,
		FOCUSED_WINDOW,
		OVERRIDE_REDIRECT,
		LAST
	}
	[CCode (cprefix = "META_TAB_LIST_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaTabList {
		NORMAL,
		DOCKS,
		GROUP
	}
	[CCode (cprefix = "META_TAB_SHOW_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaTabShowType {
		ICON,
		INSTANTLY
	}
	[CCode (cprefix = "META_THEME_ERROR_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaThemeError {
		FRAME_GEOMETRY,
		BAD_CHARACTER,
		BAD_PARENS,
		UNKNOWN_VARIABLE,
		DIVIDE_BY_ZERO,
		MOD_ON_FLOAT,
		FAILED
	}
	[CCode (cprefix = "META_VIRTUAL_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaVirtualModifier {
		SHIFT_MASK,
		CONTROL_MASK,
		ALT_MASK,
		META_MASK,
		SUPER_MASK,
		HYPER_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK
	}
	[CCode (cprefix = "META_VISUAL_BELL_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaVisualBellType {
		INVALID,
		FULLSCREEN_FLASH,
		FRAME_FLASH
	}
	[CCode (cprefix = "META_WINDOW_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum MetaWindowType {
		NORMAL,
		DESKTOP,
		DOCK,
		DIALOG,
		MODAL_DIALOG,
		TOOLBAR,
		MENU,
		UTILITY,
		SPLASHSCREEN,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND,
		OVERRIDE_OTHER
	}
	[CCode (cprefix = "POS_OP_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum PosOperatorType {
		NONE,
		ADD,
		SUBTRACT,
		MULTIPLY,
		DIVIDE,
		MOD,
		MAX,
		MIN
	}
	[CCode (cprefix = "POS_TOKEN_", has_type_id = "0", cheader_filename = "mutter-plugins.h")]
	public enum PosTokenType {
		INT,
		DOUBLE,
		OPERATOR,
		VARIABLE,
		OPEN_PAREN,
		CLOSE_PAREN
	}
	[CCode (cheader_filename = "mutter-plugins.h")]
	public delegate void MetaKeyHandlerFunc (Mutter.MetaDisplay display, Mutter.MetaScreen screen, Mutter.MetaWindow window, X.Event event, Mutter.MetaKeyBinding binding);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public delegate void MetaPrefsChangedFunc (Mutter.MetaPreference pref);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public delegate void MetaWindowMenuFunc (Mutter.MetaWindowMenu menu, X.Display xdisplay, X.Window client_xwindow, uint32 timestamp, Mutter.MetaMenuOp op, int workspace);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int EDGE_LENGTH;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int LENGTH_OF_BUTTON_RECTS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int MAX_MIDDLE_BACKGROUNDS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const string META_DEFAULT_ICON_NAME;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_ICON_HEIGHT;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_ICON_WIDTH;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_MINI_ICON_HEIGHT;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_MINI_ICON_WIDTH;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_PRIORITY_BEFORE_REDRAW;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_PRIORITY_PREFS_NOTIFY;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_PRIORITY_REDRAW;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_PRIORITY_RESIZE;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_COLOR_CONSTANTS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_DEGREES_IN_ARCS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_FRAME_BACKGROUNDS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_HIDDEN_BUTTONS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_IMAGES_FROM_ICON_THEMES;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_SHADE_STICK_ABOVE_BUTTONS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_UBIQUITOUS_CONSTANTS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_UNRESIZABLE_SHADED_STYLES;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int META_THEME_VARIED_ROUND_CORNERS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int N_GTK_STATES;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_ALL_EFFECTS;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_DESTROY;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_MAP;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_MAXIMIZE;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_MINIMIZE;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_SWITCH_WORKSPACE;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int PLUGIN_UNMAXIMIZE;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public const int RECT_LENGTH;
	[CCode (cheader_filename = "mutter-plugins.h")]
	public static unowned Clutter.Actor get_overlay_group_for_screen (Mutter.MetaScreen screen);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public static X.Window get_overlay_window (Mutter.MetaScreen screen);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public static unowned Clutter.Actor get_stage_for_screen (Mutter.MetaScreen screen);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public static unowned Clutter.Actor get_window_group_for_screen (Mutter.MetaScreen screen);
	[CCode (cheader_filename = "mutter-plugins.h")]
	public static unowned GLib.List get_windows (Mutter.MetaScreen screen);
	[CCode (cname = "meta_bug", cheader_filename = "mutter-plugins.h")]
	public static void meta_bug (string format);
	[CCode (cname = "meta_button_state_from_string", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaButtonState meta_button_state_from_string (string str);
	[CCode (cname = "meta_button_state_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_button_state_to_string (Mutter.MetaButtonState state);
	[CCode (cname = "meta_button_type_from_string", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaButtonType meta_button_type_from_string (string str, Mutter.MetaTheme theme);
	[CCode (cname = "meta_button_type_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_button_type_to_string (Mutter.MetaButtonType type);
	[CCode (cname = "meta_color_component_from_string", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaGtkColorComponent meta_color_component_from_string (string str);
	[CCode (cname = "meta_color_component_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_color_component_to_string (Mutter.MetaGtkColorComponent component);
	[CCode (cname = "meta_debug_spew_real", cheader_filename = "mutter-plugins.h")]
	public static void meta_debug_spew_real (string format);
	[CCode (cname = "meta_error_trap_pop", cheader_filename = "mutter-plugins.h")]
	public static void meta_error_trap_pop (Mutter.MetaDisplay display, bool last_request_was_roundtrip);
	[CCode (cname = "meta_error_trap_pop_with_return", cheader_filename = "mutter-plugins.h")]
	public static int meta_error_trap_pop_with_return (Mutter.MetaDisplay display, bool last_request_was_roundtrip);
	[CCode (cname = "meta_error_trap_push", cheader_filename = "mutter-plugins.h")]
	public static void meta_error_trap_push (Mutter.MetaDisplay display);
	[CCode (cname = "meta_error_trap_push_with_return", cheader_filename = "mutter-plugins.h")]
	public static void meta_error_trap_push_with_return (Mutter.MetaDisplay display);
	[CCode (cname = "meta_errors_init", cheader_filename = "mutter-plugins.h")]
	public static void meta_errors_init ();
	[CCode (cname = "meta_exit", cheader_filename = "mutter-plugins.h")]
	public static void meta_exit (Mutter.MetaExitCode code);
	[CCode (cname = "meta_fatal", cheader_filename = "mutter-plugins.h")]
	public static void meta_fatal (string format);
	[CCode (cname = "meta_free_gslist_and_elements", cheader_filename = "mutter-plugins.h")]
	public static void meta_free_gslist_and_elements (GLib.SList list_to_deep_free);
	[CCode (cname = "meta_g_utf8_strndup", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_g_utf8_strndup (string src, size_t n);
	[CCode (cname = "meta_get_replace_current_wm", cheader_filename = "mutter-plugins.h")]
	public static bool meta_get_replace_current_wm ();
	[CCode (cname = "meta_gradient_add_alpha", cheader_filename = "mutter-plugins.h")]
	public static void meta_gradient_add_alpha (Gdk.Pixbuf pixbuf, uchar[] alphas, Mutter.MetaGradientType type);
	[CCode (cname = "meta_gradient_create_interwoven", cheader_filename = "mutter-plugins.h")]
	public static unowned Gdk.Pixbuf meta_gradient_create_interwoven (int width, int height, Gdk.Color[] colors1, int thickness1, Gdk.Color[] colors2, int thickness2);
	[CCode (cname = "meta_gradient_create_multi", cheader_filename = "mutter-plugins.h")]
	public static unowned Gdk.Pixbuf meta_gradient_create_multi (int width, int height, Gdk.Color[] colors, Mutter.MetaGradientType style);
	[CCode (cname = "meta_gradient_create_simple", cheader_filename = "mutter-plugins.h")]
	public static unowned Gdk.Pixbuf meta_gradient_create_simple (int width, int height, Gdk.Color from, Gdk.Color to, Mutter.MetaGradientType style);
	[CCode (cname = "meta_gradient_type_from_string", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaGradientType meta_gradient_type_from_string (string str);
	[CCode (cname = "meta_gradient_type_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_gradient_type_to_string (Mutter.MetaGradientType type);
	[CCode (cname = "meta_gravity_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_gravity_to_string (int gravity);
	[CCode (cname = "meta_gtk_arrow_from_string", cheader_filename = "mutter-plugins.h")]
	public static Gtk.ArrowType meta_gtk_arrow_from_string (string str);
	[CCode (cname = "meta_gtk_arrow_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_gtk_arrow_to_string (Gtk.ArrowType arrow);
	[CCode (cname = "meta_gtk_shadow_from_string", cheader_filename = "mutter-plugins.h")]
	public static Gtk.ShadowType meta_gtk_shadow_from_string (string str);
	[CCode (cname = "meta_gtk_shadow_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_gtk_shadow_to_string (Gtk.ShadowType shadow);
	[CCode (cname = "meta_gtk_state_from_string", cheader_filename = "mutter-plugins.h")]
	public static Gtk.StateType meta_gtk_state_from_string (string str);
	[CCode (cname = "meta_gtk_state_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_gtk_state_to_string (Gtk.StateType state);
	[CCode (cname = "meta_gtk_widget_get_font_desc", cheader_filename = "mutter-plugins.h")]
	public static unowned Pango.FontDescription meta_gtk_widget_get_font_desc (Gtk.Widget widget, double scale, Pango.FontDescription @override);
	[CCode (cname = "meta_image_fill_type_from_string", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaImageFillType meta_image_fill_type_from_string (string str);
	[CCode (cname = "meta_image_fill_type_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_image_fill_type_to_string (Mutter.MetaImageFillType fill_type);
	[CCode (cname = "meta_is_debugging", cheader_filename = "mutter-plugins.h")]
	public static bool meta_is_debugging ();
	[CCode (cname = "meta_is_syncing", cheader_filename = "mutter-plugins.h")]
	public static bool meta_is_syncing ();
	[CCode (cname = "meta_is_verbose", cheader_filename = "mutter-plugins.h")]
	public static bool meta_is_verbose ();
	[CCode (cname = "meta_keybindings_set_custom_handler", cheader_filename = "mutter-plugins.h")]
	public static bool meta_keybindings_set_custom_handler (string name, Mutter.MetaKeyHandlerFunc handler, GLib.DestroyNotify free_data);
	[CCode (cname = "meta_keybindings_switch_window", cheader_filename = "mutter-plugins.h")]
	public static void meta_keybindings_switch_window (Mutter.MetaDisplay display, Mutter.MetaScreen screen, Mutter.MetaWindow event_window, X.Event event, Mutter.MetaKeyBinding binding);
	[CCode (cname = "meta_later_add", cheader_filename = "mutter-plugins.h")]
	public static uint meta_later_add (Mutter.MetaLaterType when, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cname = "meta_later_remove", cheader_filename = "mutter-plugins.h")]
	public static void meta_later_remove (uint later_id);
	[CCode (cname = "meta_pango_font_desc_get_text_height", cheader_filename = "mutter-plugins.h")]
	public static int meta_pango_font_desc_get_text_height (Pango.FontDescription font_desc, Pango.Context context);
	[CCode (cname = "meta_parse_position_expression", cheader_filename = "mutter-plugins.h")]
	public static bool meta_parse_position_expression (Mutter.MetaDrawSpec spec, Mutter.MetaPositionExprEnv env, int x_return, int y_return) throws GLib.Error;
	[CCode (cname = "meta_parse_size_expression", cheader_filename = "mutter-plugins.h")]
	public static bool meta_parse_size_expression (Mutter.MetaDrawSpec spec, Mutter.MetaPositionExprEnv env, int val_return) throws GLib.Error;
	[CCode (cname = "meta_pop_no_msg_prefix", cheader_filename = "mutter-plugins.h")]
	public static void meta_pop_no_msg_prefix ();
	[CCode (cname = "meta_preference_to_string", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_preference_to_string (Mutter.MetaPreference pref);
	[CCode (cname = "meta_prefs_add_listener", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_add_listener (Mutter.MetaPrefsChangedFunc func, void* data);
	[CCode (cname = "meta_prefs_bell_is_audible", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_bell_is_audible ();
	[CCode (cname = "meta_prefs_change_workspace_name", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_change_workspace_name (int i, string name);
	[CCode (cname = "meta_prefs_get_action_double_click_titlebar", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaActionTitlebar meta_prefs_get_action_double_click_titlebar ();
	[CCode (cname = "meta_prefs_get_action_middle_click_titlebar", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaActionTitlebar meta_prefs_get_action_middle_click_titlebar ();
	[CCode (cname = "meta_prefs_get_action_right_click_titlebar", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaActionTitlebar meta_prefs_get_action_right_click_titlebar ();
	[CCode (cname = "meta_prefs_get_application_based", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_application_based ();
	[CCode (cname = "meta_prefs_get_auto_raise", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_auto_raise ();
	[CCode (cname = "meta_prefs_get_auto_raise_delay", cheader_filename = "mutter-plugins.h")]
	public static int meta_prefs_get_auto_raise_delay ();
	[CCode (cname = "meta_prefs_get_button_layout", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_get_button_layout (Mutter.MetaButtonLayout button_layout);
	[CCode (cname = "meta_prefs_get_clutter_plugins", cheader_filename = "mutter-plugins.h")]
	public static unowned GLib.SList meta_prefs_get_clutter_plugins ();
	[CCode (cname = "meta_prefs_get_command", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_command (int i);
	[CCode (cname = "meta_prefs_get_compositing_manager", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_compositing_manager ();
	[CCode (cname = "meta_prefs_get_cursor_size", cheader_filename = "mutter-plugins.h")]
	public static int meta_prefs_get_cursor_size ();
	[CCode (cname = "meta_prefs_get_cursor_theme", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_cursor_theme ();
	[CCode (cname = "meta_prefs_get_disable_workarounds", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_disable_workarounds ();
	[CCode (cname = "meta_prefs_get_focus_mode", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaFocusMode meta_prefs_get_focus_mode ();
	[CCode (cname = "meta_prefs_get_focus_new_windows", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaFocusNewWindows meta_prefs_get_focus_new_windows ();
	[CCode (cname = "meta_prefs_get_gconf_key_for_command", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_gconf_key_for_command (int i);
	[CCode (cname = "meta_prefs_get_gconf_key_for_terminal_command", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_gconf_key_for_terminal_command ();
	[CCode (cname = "meta_prefs_get_gnome_accessibility", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_gnome_accessibility ();
	[CCode (cname = "meta_prefs_get_gnome_animations", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_gnome_animations ();
	[CCode (cname = "meta_prefs_get_key_bindings", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_get_key_bindings (Mutter.MetaKeyPref[] bindings);
	[CCode (cname = "meta_prefs_get_keybinding_action", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaKeyBindingAction meta_prefs_get_keybinding_action (string name);
	[CCode (cname = "meta_prefs_get_live_hidden_windows", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_live_hidden_windows ();
	[CCode (cname = "meta_prefs_get_mouse_button_menu", cheader_filename = "mutter-plugins.h")]
	public static uint meta_prefs_get_mouse_button_menu ();
	[CCode (cname = "meta_prefs_get_mouse_button_mods", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaVirtualModifier meta_prefs_get_mouse_button_mods ();
	[CCode (cname = "meta_prefs_get_mouse_button_resize", cheader_filename = "mutter-plugins.h")]
	public static uint meta_prefs_get_mouse_button_resize ();
	[CCode (cname = "meta_prefs_get_no_tab_popup", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_no_tab_popup ();
	[CCode (cname = "meta_prefs_get_num_workspaces", cheader_filename = "mutter-plugins.h")]
	public static int meta_prefs_get_num_workspaces ();
	[CCode (cname = "meta_prefs_get_overlay_binding", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_get_overlay_binding (Mutter.MetaKeyCombo combo);
	[CCode (cname = "meta_prefs_get_raise_on_click", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_raise_on_click ();
	[CCode (cname = "meta_prefs_get_terminal_command", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_terminal_command ();
	[CCode (cname = "meta_prefs_get_theme", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_theme ();
	[CCode (cname = "meta_prefs_get_titlebar_font", cheader_filename = "mutter-plugins.h")]
	public static unowned Pango.FontDescription meta_prefs_get_titlebar_font ();
	[CCode (cname = "meta_prefs_get_visual_bell", cheader_filename = "mutter-plugins.h")]
	public static bool meta_prefs_get_visual_bell ();
	[CCode (cname = "meta_prefs_get_visual_bell_type", cheader_filename = "mutter-plugins.h")]
	public static Mutter.MetaVisualBellType meta_prefs_get_visual_bell_type ();
	[CCode (cname = "meta_prefs_get_window_binding", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_get_window_binding (string name, uint keysym, Mutter.MetaVirtualModifier modifiers);
	[CCode (cname = "meta_prefs_get_workspace_name", cheader_filename = "mutter-plugins.h")]
	public static unowned string meta_prefs_get_workspace_name (int i);
	[CCode (cname = "meta_prefs_init", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_init ();
	[CCode (cname = "meta_prefs_override_clutter_plugins", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_override_clutter_plugins (GLib.SList list);
	[CCode (cname = "meta_prefs_override_no_tab_popup", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_override_no_tab_popup (bool whether);
	[CCode (cname = "meta_prefs_remove_listener", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_remove_listener (Mutter.MetaPrefsChangedFunc func, void* data);
	[CCode (cname = "meta_prefs_set_clutter_plugins", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_set_clutter_plugins (GLib.SList list);
	[CCode (cname = "meta_prefs_set_compositing_manager", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_set_compositing_manager (bool whether);
	[CCode (cname = "meta_prefs_set_live_hidden_windows", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_set_live_hidden_windows (bool whether);
	[CCode (cname = "meta_prefs_set_no_tab_popup", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_set_no_tab_popup (bool whether);
	[CCode (cname = "meta_prefs_set_num_workspaces", cheader_filename = "mutter-plugins.h")]
	public static void meta_prefs_set_num_workspaces (int n_workspaces);
	[CCode (cname = "meta_print_backtrace", cheader_filename = "mutter-plugins.h")]
	public static void meta_print_backtrace ();
	[CCode (cname = "meta_push_no_msg_prefix", cheader_filename = "mutter-plugins.h")]
	public static void meta_push_no_msg_prefix ();
	[CCode (cname = "meta_quit", cheader_filename = "mutter-plugins.h")]
	public static void meta_quit (Mutter.MetaExitCode code);
	[CCode (cname = "meta_rect", cheader_filename = "mutter-plugins.h")]
	public static unowned Mutter.MetaRectangle meta_rect (int x, int y, int width, int height);
	[CCode (cname = "meta_restart", cheader_filename = "mutter-plugins.h")]
	public static void meta_restart ();
	[CCode (cname = "meta_set_debugging", cheader_filename = "mutter-plugins.h")]
	public static void meta_set_debugging (bool setting);
	[CCode (cname = "meta_set_replace_current_wm", cheader_filename = "mutter-plugins.h")]
	public static void meta_set_replace_current_wm (bool setting);
	[CCode (cname = "meta_set_syncing", cheader_filename = "mutter-plugins.h")]
	public static void meta_set_syncing (bool setting);
	[CCode (cname = "meta_set_verbose", cheader_filename = "mutter-plugins.h")]
	public static void meta_set_verbose (bool setting);
	[CCode (cname = "meta_show_dialog", cheader_filename = "mutter-plugins.h")]
	public static GLib.Pid meta_show_dialog (string type, string title, string message, int timeout, string ok_text, string cancel_text, int transient_for, GLib.SList columns, GLib.SList entries);
	[CCode (cname = "meta_topic_real", cheader_filename = "mutter-plugins.h")]
	public static void meta_topic_real (Mutter.MetaDebugTopic topic, string format);
	[CCode (cname = "meta_unsigned_long_equal", cheader_filename = "mutter-plugins.h")]
	public static int meta_unsigned_long_equal (void* v1, void* v2);
	[CCode (cname = "meta_unsigned_long_hash", cheader_filename = "mutter-plugins.h")]
	public static uint meta_unsigned_long_hash (void* v);
	[CCode (cname = "meta_verbose_real", cheader_filename = "mutter-plugins.h")]
	public static void meta_verbose_real (string format);
	[CCode (cname = "meta_warning", cheader_filename = "mutter-plugins.h")]
	public static void meta_warning (string format);
}
