/* test-window.c generated by valac 0.10.0, the Vala compiler
 * generated from test-window.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 *             Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <unity.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <libwnck/libwnck.h>
#include <clutk/clutk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <unity-utils.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TESTING_TYPE_WINDOW (unity_testing_window_get_type ())
#define UNITY_TESTING_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_WINDOW, UnityTestingWindow))
#define UNITY_TESTING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_WINDOW, UnityTestingWindowClass))
#define UNITY_TESTING_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_WINDOW))
#define UNITY_TESTING_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_WINDOW))
#define UNITY_TESTING_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_WINDOW, UnityTestingWindowClass))

typedef struct _UnityTestingWindow UnityTestingWindow;
typedef struct _UnityTestingWindowClass UnityTestingWindowClass;
typedef struct _UnityTestingWindowPrivate UnityTestingWindowPrivate;

#define UNITY_TESTING_TYPE_WORKAREA (unity_testing_workarea_get_type ())
#define UNITY_TESTING_WORKAREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_WORKAREA, UnityTestingWorkarea))
#define UNITY_TESTING_WORKAREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_WORKAREA, UnityTestingWorkareaClass))
#define UNITY_TESTING_IS_WORKAREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_WORKAREA))
#define UNITY_TESTING_IS_WORKAREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_WORKAREA))
#define UNITY_TESTING_WORKAREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_WORKAREA, UnityTestingWorkareaClass))

typedef struct _UnityTestingWorkarea UnityTestingWorkarea;
typedef struct _UnityTestingWorkareaClass UnityTestingWorkareaClass;

#define UNITY_TESTING_TYPE_BACKGROUND (unity_testing_background_get_type ())
#define UNITY_TESTING_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_BACKGROUND, UnityTestingBackground))
#define UNITY_TESTING_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_BACKGROUND, UnityTestingBackgroundClass))
#define UNITY_TESTING_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_BACKGROUND))
#define UNITY_TESTING_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_BACKGROUND))
#define UNITY_TESTING_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_BACKGROUND, UnityTestingBackgroundClass))

typedef struct _UnityTestingBackground UnityTestingBackground;
typedef struct _UnityTestingBackgroundClass UnityTestingBackgroundClass;

#define UNITY_LAUNCHER_TYPE_LAUNCHER (unity_launcher_launcher_get_type ())
#define UNITY_LAUNCHER_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_LAUNCHER, UnityLauncherLauncher))
#define UNITY_LAUNCHER_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_LAUNCHER, UnityLauncherLauncherClass))
#define UNITY_LAUNCHER_IS_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_LAUNCHER))
#define UNITY_LAUNCHER_IS_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_LAUNCHER))
#define UNITY_LAUNCHER_LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_LAUNCHER, UnityLauncherLauncherClass))

typedef struct _UnityLauncherLauncher UnityLauncherLauncher;
typedef struct _UnityLauncherLauncherClass UnityLauncherLauncherClass;

#define UNITY_PANEL_TYPE_VIEW (unity_panel_view_get_type ())
#define UNITY_PANEL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PANEL_TYPE_VIEW, UnityPanelView))
#define UNITY_PANEL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PANEL_TYPE_VIEW, UnityPanelViewClass))
#define UNITY_PANEL_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PANEL_TYPE_VIEW))
#define UNITY_PANEL_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PANEL_TYPE_VIEW))
#define UNITY_PANEL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PANEL_TYPE_VIEW, UnityPanelViewClass))

typedef struct _UnityPanelView UnityPanelView;
typedef struct _UnityPanelViewClass UnityPanelViewClass;

#define UNITY_PLACES_TYPE_CONTROLLER (unity_places_controller_get_type ())
#define UNITY_PLACES_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_CONTROLLER, UnityPlacesController))
#define UNITY_PLACES_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_CONTROLLER, UnityPlacesControllerClass))
#define UNITY_PLACES_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_CONTROLLER))
#define UNITY_PLACES_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_CONTROLLER))
#define UNITY_PLACES_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_CONTROLLER, UnityPlacesControllerClass))

typedef struct _UnityPlacesController UnityPlacesController;
typedef struct _UnityPlacesControllerClass UnityPlacesControllerClass;

#define UNITY_PLACES_TYPE_VIEW (unity_places_view_get_type ())
#define UNITY_PLACES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_VIEW, UnityPlacesView))
#define UNITY_PLACES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_VIEW, UnityPlacesViewClass))
#define UNITY_PLACES_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_VIEW))
#define UNITY_PLACES_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_VIEW))
#define UNITY_PLACES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_VIEW, UnityPlacesViewClass))

typedef struct _UnityPlacesView UnityPlacesView;
typedef struct _UnityPlacesViewClass UnityPlacesViewClass;

#define UNITY_GESTURE_TYPE_DISPATCHER (unity_gesture_dispatcher_get_type ())
#define UNITY_GESTURE_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_DISPATCHER, UnityGestureDispatcher))
#define UNITY_GESTURE_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_DISPATCHER, UnityGestureDispatcherClass))
#define UNITY_GESTURE_IS_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_DISPATCHER))
#define UNITY_GESTURE_IS_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_DISPATCHER))
#define UNITY_GESTURE_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_DISPATCHER, UnityGestureDispatcherClass))

typedef struct _UnityGestureDispatcher UnityGestureDispatcher;
typedef struct _UnityGestureDispatcherClass UnityGestureDispatcherClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_testing_workarea_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_workarea_unref (var), NULL)))

#define UNITY_GESTURE_TYPE_XCB_DISPATCHER (unity_gesture_xcb_dispatcher_get_type ())
#define UNITY_GESTURE_XCB_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_XCB_DISPATCHER, UnityGestureXCBDispatcher))
#define UNITY_GESTURE_XCB_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_XCB_DISPATCHER, UnityGestureXCBDispatcherClass))
#define UNITY_GESTURE_IS_XCB_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_XCB_DISPATCHER))
#define UNITY_GESTURE_IS_XCB_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_XCB_DISPATCHER))
#define UNITY_GESTURE_XCB_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_XCB_DISPATCHER, UnityGestureXCBDispatcherClass))

typedef struct _UnityGestureXCBDispatcher UnityGestureXCBDispatcher;
typedef struct _UnityGestureXCBDispatcherClass UnityGestureXCBDispatcherClass;
typedef struct _UnityTestingWorkareaPrivate UnityTestingWorkareaPrivate;
typedef struct _UnityTestingParamSpecWorkarea UnityTestingParamSpecWorkarea;

struct _UnityTestingWindow {
	GtkWindow parent_instance;
	UnityTestingWindowPrivate * priv;
	GtkClutterEmbed* gtk_clutter;
	ClutterStage* stage;
};

struct _UnityTestingWindowClass {
	GtkWindowClass parent_class;
};

struct _UnityTestingWindowPrivate {
	gboolean _super_key_active;
	gboolean _is_starting;
	gboolean _is_popup;
	gint _popup_width;
	gint _popup_height;
	WnckScreen* wnck_screen;
	UnityTestingWorkarea* workarea_size;
	gboolean is_showing;
	UnityTestingBackground* background;
	UnityLauncherLauncher* launcher;
	UnityPanelView* panel;
	UnityPlacesController* controller;
	UnityPlacesView* places;
	UnityGestureDispatcher* gesture_dispatcher;
	gboolean showing_places;
};

struct _UnityTestingWorkarea {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityTestingWorkareaPrivate * priv;
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _UnityTestingWorkareaClass {
	GTypeClass parent_class;
	void (*finalize) (UnityTestingWorkarea *self);
};

struct _UnityTestingParamSpecWorkarea {
	GParamSpec parent_instance;
};


static gpointer unity_testing_window_parent_class = NULL;
static UnityShellIface* unity_testing_window_unity_shell_parent_iface = NULL;
static gpointer unity_testing_workarea_parent_class = NULL;

GType unity_testing_window_get_type (void) G_GNUC_CONST;
gpointer unity_testing_workarea_ref (gpointer instance);
void unity_testing_workarea_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_workarea (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_workarea (GValue* value, gpointer v_object);
void unity_testing_value_take_workarea (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_workarea (const GValue* value);
GType unity_testing_workarea_get_type (void) G_GNUC_CONST;
GType unity_testing_background_get_type (void) G_GNUC_CONST;
GType unity_launcher_launcher_get_type (void) G_GNUC_CONST;
GType unity_panel_view_get_type (void) G_GNUC_CONST;
GType unity_places_controller_get_type (void) G_GNUC_CONST;
GType unity_places_view_get_type (void) G_GNUC_CONST;
GType unity_gesture_dispatcher_get_type (void) G_GNUC_CONST;
#define UNITY_TESTING_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TESTING_TYPE_WINDOW, UnityTestingWindowPrivate))
enum  {
	UNITY_TESTING_WINDOW_DUMMY_PROPERTY,
	UNITY_TESTING_WINDOW_MENUS_SWALLOW_EVENTS,
	UNITY_TESTING_WINDOW_SUPER_KEY_ACTIVE,
	UNITY_TESTING_WINDOW_IS_STARTING,
	UNITY_TESTING_WINDOW_IS_POPUP,
	UNITY_TESTING_WINDOW_POPUP_WIDTH,
	UNITY_TESTING_WINDOW_POPUP_HEIGHT
};
UnityTestingWindow* unity_testing_window_new (gboolean popup, gint width, gint height);
UnityTestingWindow* unity_testing_window_construct (GType object_type, gboolean popup, gint width, gint height);
static guint32 unity_testing_window_real_get_current_time (UnityShell* base);
void unity_testing_window_init_test_mode (UnityTestingWindow* self);
static void unity_testing_window_relayout (UnityTestingWindow* self);
gboolean unity_testing_window_get_is_popup (UnityTestingWindow* self);
gint unity_testing_window_get_popup_width (UnityTestingWindow* self);
gint unity_testing_window_get_popup_height (UnityTestingWindow* self);
void utils_set_strut (GtkWindow* window, guint32 strut_size, guint32 strut_start, guint32 strut_end, guint32 top_size, guint32 top_start, guint32 top_end);
ClutterActor* unity_launcher_launcher_get_container (UnityLauncherLauncher* self);
#define UNITY_PANEL_PANEL_HEIGHT 24
static void unity_testing_window_real_show (GtkWidget* base);
static void unity_testing_window_on_active_window_changed (UnityTestingWindow* self, WnckWindow* previous_window);
gboolean unity_testing_window_on_stage_button_press (UnityTestingWindow* self, ClutterEvent* src);
static void unity_testing_window_real_get_window_details (UnityShell* base, guint32 xid, gboolean* allows_resize, gboolean* is_maximised);
static void unity_testing_window_real_do_window_action (UnityShell* base, guint32 xid, UnityWindowAction action);
void unity_testing_window_show_window_picker (UnityTestingWindow* self);
static void unity_testing_window_real_grab_keyboard (UnityShell* base, gboolean grab, guint32 timestamp);
static ClutterStage* unity_testing_window_real_get_stage (UnityShell* base);
static UnityShellMode unity_testing_window_real_get_mode (UnityShell* base);
static void unity_testing_window_real_show_unity (UnityShell* base);
void unity_panel_view_set_indicator_mode (UnityPanelView* self, gboolean mode);
void unity_places_view_hidden (UnityPlacesView* self);
void unity_places_view_shown (UnityPlacesView* self);
static void unity_testing_window_real_hide_unity (UnityShell* base);
static void unity_testing_window_real_about_to_show_places (UnityShell* base);
void unity_places_view_about_to_show (UnityPlacesView* self);
static gint unity_testing_window_real_get_indicators_width (UnityShell* base);
gint unity_panel_view_get_indicators_width (UnityPanelView* self);
static gint unity_testing_window_real_get_launcher_width_foobar (UnityShell* base);
float unity_launcher_launcher_get_width (UnityLauncherLauncher* self);
static gint unity_testing_window_real_get_panel_height_foobar (UnityShell* base);
gint unity_panel_view_get_panel_height (UnityPanelView* self);
static void unity_testing_window_real_add_fullscreen_request (UnityShell* base, GObject* o);
static gboolean unity_testing_window_real_remove_fullscreen_request (UnityShell* base, GObject* o);
static void unity_testing_window_real_ensure_input_region (UnityShell* base);
static void unity_testing_window_real_close_xids (UnityShell* base, GArray* xids);
static void unity_testing_window_real_expose_xids (UnityShell* base, GArray* xids);
static void unity_testing_window_real_stop_expose (UnityShell* base);
static void unity_testing_window_real_show_window (UnityShell* base, guint32 xid);
static void unity_testing_window_set_is_popup (UnityTestingWindow* self, gboolean value);
static void unity_testing_window_set_popup_width (UnityTestingWindow* self, gint value);
static void unity_testing_window_set_popup_height (UnityTestingWindow* self, gint value);
UnityTestingWorkarea* unity_testing_workarea_new (void);
UnityTestingWorkarea* unity_testing_workarea_construct (GType object_type);
void unity_testing_workarea_update_net_workarea (UnityTestingWorkarea* self);
static gboolean _lambda102_ (UnityTestingWindow* self);
static gboolean __lambda102__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean _lambda103_ (UnityTestingWindow* self);
static gboolean __lambda103__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _lambda104_ (GdkScreen* s, UnityTestingWindow* self);
static void __lambda104__gdk_screen_size_changed (GdkScreen* _sender, gpointer self);
static void _lambda105_ (GdkScreen* s, UnityTestingWindow* self);
static void __lambda105__gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
static gboolean _unity_testing_window_on_stage_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
UnityTestingBackground* unity_testing_background_new (void);
UnityTestingBackground* unity_testing_background_construct (GType object_type);
UnityLauncherLauncher* unity_launcher_launcher_new (UnityShell* shell);
UnityLauncherLauncher* unity_launcher_launcher_construct (GType object_type, UnityShell* shell);
ClutterActor* unity_launcher_launcher_get_view (UnityLauncherLauncher* self);
UnityPlacesController* unity_places_controller_new (UnityShell* shell);
UnityPlacesController* unity_places_controller_construct (GType object_type, UnityShell* shell);
UnityPlacesView* unity_places_controller_get_view (UnityPlacesController* self);
UnityPanelView* unity_panel_view_new (UnityShell* shell);
UnityPanelView* unity_panel_view_construct (GType object_type, UnityShell* shell);
static void _unity_testing_window_on_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self);
UnityGestureXCBDispatcher* unity_gesture_xcb_dispatcher_new (void);
UnityGestureXCBDispatcher* unity_gesture_xcb_dispatcher_construct (GType object_type);
GType unity_gesture_xcb_dispatcher_get_type (void) G_GNUC_CONST;
static gboolean _lambda106_ (UnityTestingWindow* self);
static gboolean __lambda106__gsource_func (gpointer self);
static GObject * unity_testing_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_testing_window_finalize (GObject* obj);
static void unity_testing_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_testing_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	UNITY_TESTING_WORKAREA_DUMMY_PROPERTY
};
static void unity_testing_workarea_finalize (UnityTestingWorkarea* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



UnityTestingWindow* unity_testing_window_construct (GType object_type, gboolean popup, gint width, gint height) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) g_object_new (object_type, "is-popup", popup, "popup-width", width, "popup-height", height, NULL);
	return self;
}


UnityTestingWindow* unity_testing_window_new (gboolean popup, gint width, gint height) {
	return unity_testing_window_construct (UNITY_TESTING_TYPE_WINDOW, popup, width, height);
}


static guint32 unity_testing_window_real_get_current_time (UnityShell* base) {
	UnityTestingWindow * self;
	guint32 result = 0U;
	self = (UnityTestingWindow*) base;
	result = clutter_get_current_event_time ();
	return result;
}


void unity_testing_window_init_test_mode (UnityTestingWindow* self) {
	ClutterColor _tmp0_ = {0};
	ClutterColor _tmp1_;
	GtkSettings* settings;
	g_return_if_fail (self != NULL);
	clutter_stage_set_color (self->stage, (_tmp1_ = (_tmp0_.red = (guint8) 148, _tmp0_.green = (guint8) 86, _tmp0_.blue = (guint8) 99, _tmp0_.alpha = (guint8) 255, _tmp0_), &_tmp1_));
	clutter_actor_set_opacity ((ClutterActor*) self->priv->background, (guint8) 0);
	settings = gtk_settings_get_default ();
	g_object_set (settings, "gtk-xft-dpi", 96 * 1024, NULL);
	g_object_set (settings, "gtk-font-name", "Sans 10", NULL);
	g_object_set (settings, "gtk-icon-theme-name", "ubuntu-mono-dark", NULL);
	g_object_set (settings, "gtk-theme-name", "Ambiance", NULL);
}


static void unity_testing_window_relayout (UnityTestingWindow* self) {
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	float ql_width = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->_is_popup) {
		x = 0;
		y = 0;
		width = self->priv->_popup_width;
		height = self->priv->_popup_height;
	} else {
		GdkRectangle size = {0};
		gdk_screen_get_monitor_geometry (gtk_window_get_screen ((GtkWindow*) self), 0, &size);
		x = size.x;
		y = size.y;
		width = size.width;
		height = size.height;
	}
	ql_width = (float) 58;
	gtk_window_resize ((GtkWindow*) self, width, height);
	clutter_actor_set_size ((ClutterActor*) self->stage, (float) width, (float) height);
	if (!self->priv->_is_popup) {
		utils_set_strut (GTK_WINDOW (self), (guint32) ((guint) ql_width), (guint32) 0, (guint32) height, (guint32) 24, (guint32) 0, (guint32) width);
	}
	clutter_actor_set_position ((ClutterActor*) self->priv->background, (float) 0, (float) 0);
	clutter_actor_set_size ((ClutterActor*) self->priv->background, (float) width, (float) height);
	clutter_actor_set_size (_tmp0_ = unity_launcher_launcher_get_container (self->priv->launcher), ql_width, (float) (height - UNITY_PANEL_PANEL_HEIGHT));
	_g_object_unref0 (_tmp0_);
	clutter_actor_set_position (_tmp1_ = unity_launcher_launcher_get_container (self->priv->launcher), (float) 0, (float) UNITY_PANEL_PANEL_HEIGHT);
	_g_object_unref0 (_tmp1_);
	clutter_actor_set_clip (_tmp2_ = unity_launcher_launcher_get_container (self->priv->launcher), (float) 0, (float) 0, ql_width, (float) height);
	_g_object_unref0 (_tmp2_);
	clutter_actor_set_size ((ClutterActor*) self->priv->places, width - ql_width, (float) height);
	clutter_actor_set_position ((ClutterActor*) self->priv->places, ql_width, (float) 0);
	clutter_actor_set_size ((ClutterActor*) self->priv->panel, (float) width, (float) UNITY_PANEL_PANEL_HEIGHT);
	clutter_actor_set_position ((ClutterActor*) self->priv->panel, (float) 0, (float) 0);
}


static void unity_testing_window_real_show (GtkWidget* base) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	GTK_WIDGET_CLASS (unity_testing_window_parent_class)->show ((GtkWidget*) GTK_WINDOW (self));
	gtk_widget_show ((GtkWidget*) self->gtk_clutter);
	clutter_actor_show_all ((ClutterActor*) self->stage);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_testing_window_on_active_window_changed (UnityTestingWindow* self, WnckWindow* previous_window) {
	WnckWindow* new_window;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	new_window = _g_object_ref0 (wnck_screen_get_active_window (self->priv->wnck_screen));
	if (new_window == NULL) {
		_g_object_unref0 (new_window);
		return;
	}
	if (WNCK_IS_WINDOW (new_window)) {
		_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) new_window) != WNCK_WINDOW_DESKTOP;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = _vala_strcmp0 (wnck_window_get_name (new_window), "Unity") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->is_showing = TRUE;
	} else {
		self->priv->is_showing = FALSE;
	}
	_g_object_unref0 (new_window);
}


gboolean unity_testing_window_on_stage_button_press (UnityTestingWindow* self, ClutterEvent* src) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_is_popup) {
		result = FALSE;
		return result;
	}
	if (self->priv->is_showing) {
		;
	} else {
	}
	result = FALSE;
	return result;
}


static void unity_testing_window_real_get_window_details (UnityShell* base, guint32 xid, gboolean* allows_resize, gboolean* is_maximised) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	*allows_resize = TRUE;
	g_debug ("test-window.vala:295: This target does not support getting window deta" \
"ils");
}


static void unity_testing_window_real_do_window_action (UnityShell* base, guint32 xid, UnityWindowAction action) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	g_debug ("test-window.vala:300: This target does not support window actions");
}


void unity_testing_window_show_window_picker (UnityTestingWindow* self) {
	g_return_if_fail (self != NULL);
	unity_shell_show_unity ((UnityShell*) self);
}


static void unity_testing_window_real_grab_keyboard (UnityShell* base, gboolean grab, guint32 timestamp) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
}


static ClutterStage* unity_testing_window_real_get_stage (UnityShell* base) {
	UnityTestingWindow * self;
	ClutterStage* result = NULL;
	self = (UnityTestingWindow*) base;
	result = _g_object_ref0 (self->stage);
	return result;
}


static UnityShellMode unity_testing_window_real_get_mode (UnityShell* base) {
	UnityTestingWindow * self;
	UnityShellMode result = 0;
	UnityShellMode _tmp0_ = 0;
	self = (UnityTestingWindow*) base;
	if (self->priv->showing_places) {
		_tmp0_ = UNITY_SHELL_MODE_DASH;
	} else {
		_tmp0_ = UNITY_SHELL_MODE_MINIMIZED;
	}
	result = _tmp0_;
	return result;
}


static void unity_testing_window_real_show_unity (UnityShell* base) {
	UnityTestingWindow * self;
	UnityShellMode _tmp0_ = 0;
	self = (UnityTestingWindow*) base;
	if (self->priv->showing_places) {
		self->priv->showing_places = FALSE;
		unity_panel_view_set_indicator_mode (self->priv->panel, FALSE);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->background, (guint8) 255);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->places, (guint8) 0);
		unity_places_view_hidden (self->priv->places);
	} else {
		self->priv->showing_places = TRUE;
		unity_panel_view_set_indicator_mode (self->priv->panel, TRUE);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->background, (guint8) 160);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->places, (guint8) 255);
		unity_places_view_shown (self->priv->places);
	}
	if (self->priv->showing_places) {
		_tmp0_ = UNITY_SHELL_MODE_DASH;
	} else {
		_tmp0_ = UNITY_SHELL_MODE_MINIMIZED;
	}
	g_signal_emit_by_name ((UnityShell*) self, "mode-changed", _tmp0_);
	clutter_actor_queue_redraw ((ClutterActor*) self->priv->places);
}


static void unity_testing_window_real_hide_unity (UnityShell* base) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	if (self->priv->showing_places == TRUE) {
		self->priv->showing_places = FALSE;
		unity_panel_view_set_indicator_mode (self->priv->panel, FALSE);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->background, (guint8) 255);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->places, (guint8) 0);
		unity_places_view_hidden (self->priv->places);
		g_signal_emit_by_name ((UnityShell*) self, "mode-changed", UNITY_SHELL_MODE_MINIMIZED);
	}
}


static void unity_testing_window_real_about_to_show_places (UnityShell* base) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	unity_places_view_about_to_show (self->priv->places);
}


static gint unity_testing_window_real_get_indicators_width (UnityShell* base) {
	UnityTestingWindow * self;
	gint result = 0;
	self = (UnityTestingWindow*) base;
	result = unity_panel_view_get_indicators_width (self->priv->panel);
	return result;
}


static gint unity_testing_window_real_get_launcher_width_foobar (UnityShell* base) {
	UnityTestingWindow * self;
	gint result = 0;
	self = (UnityTestingWindow*) base;
	result = (gint) unity_launcher_launcher_get_width (self->priv->launcher);
	return result;
}


static gint unity_testing_window_real_get_panel_height_foobar (UnityShell* base) {
	UnityTestingWindow * self;
	gint result = 0;
	self = (UnityTestingWindow*) base;
	result = (gint) unity_panel_view_get_panel_height (self->priv->panel);
	return result;
}


static void unity_testing_window_real_add_fullscreen_request (UnityShell* base, GObject* o) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	g_return_if_fail (o != NULL);
	return;
}


static gboolean unity_testing_window_real_remove_fullscreen_request (UnityShell* base, GObject* o) {
	UnityTestingWindow * self;
	gboolean result = FALSE;
	self = (UnityTestingWindow*) base;
	g_return_val_if_fail (o != NULL, FALSE);
	result = FALSE;
	return result;
}


static void unity_testing_window_real_ensure_input_region (UnityShell* base) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	return;
}


static void unity_testing_window_real_close_xids (UnityShell* base, GArray* xids) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	g_return_if_fail (xids != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint32 xid;
				WnckWindow* window;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < xids->len)) {
					break;
				}
				xid = g_array_index (xids, guint32, (guint) i);
				window = _g_object_ref0 (wnck_window_get ((gulong) xid));
				if (WNCK_IS_WINDOW (window)) {
					wnck_window_close (window, clutter_get_current_event_time ());
				}
				_g_object_unref0 (window);
			}
		}
	}
}


static void unity_testing_window_real_expose_xids (UnityShell* base, GArray* xids) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
	g_return_if_fail (xids != NULL);
}


static void unity_testing_window_real_stop_expose (UnityShell* base) {
	UnityTestingWindow * self;
	self = (UnityTestingWindow*) base;
}


static void unity_testing_window_real_show_window (UnityShell* base, guint32 xid) {
	UnityTestingWindow * self;
	WnckWindow* window;
	self = (UnityTestingWindow*) base;
	window = _g_object_ref0 (wnck_window_get ((gulong) xid));
	if (WNCK_IS_WINDOW (window)) {
		wnck_window_activate (window, clutter_get_current_event_time ());
	}
	_g_object_unref0 (window);
}


static gboolean unity_testing_window_real_get_menus_swallow_events (UnityShell* base) {
	gboolean result;
	UnityTestingWindow* self;
	self = (UnityTestingWindow*) base;
	result = TRUE;
	return result;
}


static gboolean unity_testing_window_real_get_super_key_active (UnityShell* base) {
	gboolean result;
	UnityTestingWindow* self;
	self = (UnityTestingWindow*) base;
	result = self->priv->_super_key_active;
	return result;
}


static void unity_testing_window_real_set_super_key_active (UnityShell* base, gboolean value) {
	UnityTestingWindow* self;
	self = (UnityTestingWindow*) base;
	self->priv->_super_key_active = value;
	g_object_notify ((GObject *) self, "super-key-active");
}


static gboolean unity_testing_window_real_get_is_starting (UnityShell* base) {
	gboolean result;
	UnityTestingWindow* self;
	self = (UnityTestingWindow*) base;
	result = self->priv->_is_starting;
	return result;
}


static void unity_testing_window_real_set_is_starting (UnityShell* base, gboolean value) {
	UnityTestingWindow* self;
	self = (UnityTestingWindow*) base;
	self->priv->_is_starting = value;
	g_object_notify ((GObject *) self, "is-starting");
}


gboolean unity_testing_window_get_is_popup (UnityTestingWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_popup;
	return result;
}


static void unity_testing_window_set_is_popup (UnityTestingWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_popup = value;
	g_object_notify ((GObject *) self, "is-popup");
}


gint unity_testing_window_get_popup_width (UnityTestingWindow* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_popup_width;
	return result;
}


static void unity_testing_window_set_popup_width (UnityTestingWindow* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_popup_width = value;
	g_object_notify ((GObject *) self, "popup-width");
}


gint unity_testing_window_get_popup_height (UnityTestingWindow* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_popup_height;
	return result;
}


static void unity_testing_window_set_popup_height (UnityTestingWindow* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_popup_height = value;
	g_object_notify ((GObject *) self, "popup-height");
}


static gboolean _lambda102_ (UnityTestingWindow* self) {
	gboolean result = FALSE;
	gtk_main_quit ();
	result = FALSE;
	return result;
}


static gboolean __lambda102__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda102_ (self);
	return result;
}


static gboolean _lambda103_ (UnityTestingWindow* self) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean __lambda103__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda103_ (self);
	return result;
}


static void _lambda104_ (GdkScreen* s, UnityTestingWindow* self) {
	g_return_if_fail (s != NULL);
	unity_testing_window_relayout (self);
}


static void __lambda104__gdk_screen_size_changed (GdkScreen* _sender, gpointer self) {
	_lambda104_ (_sender, self);
}


static void _lambda105_ (GdkScreen* s, UnityTestingWindow* self) {
	g_return_if_fail (s != NULL);
	unity_testing_window_relayout (self);
}


static void __lambda105__gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	_lambda105_ (_sender, self);
}


static gboolean _unity_testing_window_on_stage_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_testing_window_on_stage_button_press (self, event);
	return result;
}


static void _unity_testing_window_on_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self) {
	unity_testing_window_on_active_window_changed (self, previous_window);
}


static gboolean _lambda106_ (UnityTestingWindow* self) {
	gboolean result = FALSE;
	unity_shell_set_is_starting ((UnityShell*) self, FALSE);
	result = FALSE;
	return result;
}


static gboolean __lambda106__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda106_ (self);
	return result;
}


static GObject * unity_testing_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityTestingWindow * self;
	parent_class = G_OBJECT_CLASS (unity_testing_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_TESTING_WINDOW (obj);
	{
		UnityShell* _tmp0_;
		UnityTestingWorkarea* _tmp1_;
		GtkClutterEmbed* _tmp2_;
		gint target_list_length1;
		gint _target_list_size_;
		GtkTargetEntry* _tmp10_;
		GtkTargetEntry _tmp3_ = {0};
		GtkTargetEntry _tmp4_ = {0};
		GtkTargetEntry _tmp5_ = {0};
		GtkTargetEntry _tmp6_ = {0};
		GtkTargetEntry _tmp7_ = {0};
		GtkTargetEntry _tmp8_ = {0};
		GtkTargetEntry* _tmp9_ = NULL;
		GtkTargetEntry* target_list;
		ClutterStage* _tmp11_;
		ClutterColor _tmp12_ = {0};
		ClutterColor stage_bg;
		UnityTestingBackground* _tmp13_;
		UnityLauncherLauncher* _tmp14_;
		ClutterActor* _tmp15_;
		ClutterActor* _tmp16_;
		CtkBin* _tmp17_;
		ClutterActor* _tmp18_;
		ClutterActor* _tmp19_;
		UnityPlacesController* _tmp20_;
		UnityPlacesView* _tmp21_;
		UnityPanelView* _tmp22_;
		WnckScreen* _tmp23_;
		UnityGestureDispatcher* _tmp24_;
		unity_shell_set_is_starting ((UnityShell*) self, TRUE);
		START_FUNCTION ();
		unity_global_shell = (_tmp0_ = _g_object_ref0 ((UnityShell*) self), _g_object_unref0 (unity_global_shell), _tmp0_);
		self->priv->workarea_size = (_tmp1_ = unity_testing_workarea_new (), _unity_testing_workarea_unref0 (self->priv->workarea_size), _tmp1_);
		unity_testing_workarea_update_net_workarea (self->priv->workarea_size);
		if (self->priv->_is_popup) {
			gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_NORMAL);
			gtk_window_set_decorated ((GtkWindow*) self, TRUE);
			gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, FALSE);
			gtk_window_set_skip_pager_hint ((GtkWindow*) self, FALSE);
			g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda102__gtk_widget_delete_event, self, 0);
		} else {
			gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DESKTOP);
			gtk_window_set_keep_below ((GtkWindow*) self, TRUE);
			gtk_window_set_decorated ((GtkWindow*) self, FALSE);
			gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
			gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
			gtk_window_set_accept_focus ((GtkWindow*) self, FALSE);
			g_object_set ((GtkWidget*) self, "can-focus", FALSE, NULL);
			g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda103__gtk_widget_delete_event, self, 0);
			g_signal_connect_object (gtk_window_get_screen ((GtkWindow*) self), "size-changed", (GCallback) __lambda104__gdk_screen_size_changed, self, 0);
			g_signal_connect_object (gtk_window_get_screen ((GtkWindow*) self), "monitors-changed", (GCallback) __lambda105__gdk_screen_monitors_changed, self, 0);
		}
		gtk_window_set_title ((GtkWindow*) self, "Unity");
		gtk_window_set_icon_name ((GtkWindow*) self, "distributor-logo");
		self->priv->is_showing = FALSE;
		LOGGER_START_PROCESS ("unity_underlay_window_realize");
		gtk_widget_realize ((GtkWidget*) self);
		LOGGER_END_PROCESS ("unity_underlay_window_realize");
		self->gtk_clutter = (_tmp2_ = g_object_ref_sink ((GtkClutterEmbed*) gtk_clutter_embed_new ()), _g_object_unref0 (self->gtk_clutter), _tmp2_);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->gtk_clutter);
		LOGGER_START_PROCESS ("gtk_clutter_realize");
		gtk_widget_realize ((GtkWidget*) self->gtk_clutter);
		LOGGER_END_PROCESS ("gtk_clutter_realize");
		target_list = (_tmp10_ = (_tmp9_ = g_new0 (GtkTargetEntry, 6), _tmp9_[0] = (memset (&_tmp3_, 0, sizeof (GtkTargetEntry)), _tmp3_.target = "STRING", _tmp3_.flags = (guint) 0, _tmp3_.info = (guint) UNITY_DND_TARGETS_TARGET_STRING, _tmp3_), _tmp9_[1] = (memset (&_tmp4_, 0, sizeof (GtkTargetEntry)), _tmp4_.target = "text/plain", _tmp4_.flags = (guint) 0, _tmp4_.info = (guint) UNITY_DND_TARGETS_TARGET_STRING, _tmp4_), _tmp9_[2] = (memset (&_tmp5_, 0, sizeof (GtkTargetEntry)), _tmp5_.target = "text/uri-list", _tmp5_.flags = (guint) 0, _tmp5_.info = (guint) UNITY_DND_TARGETS_TARGET_URL, _tmp5_), _tmp9_[3] = (memset (&_tmp6_, 0, sizeof (GtkTargetEntry)), _tmp6_.target = "x-url/http", _tmp6_.flags = (guint) 0, _tmp6_.info = (guint) UNITY_DND_TARGETS_TARGET_URL, _tmp6_), _tmp9_[4] = (memset (&_tmp7_, 0, sizeof (GtkTargetEntry)), _tmp7_.target = "x-url/ftp", _tmp7_.flags = (guint) 0, _tmp7_.info = (guint) UNITY_DND_TARGETS_TARGET_URL, _tmp7_), _tmp9_[5] = (memset (&_tmp8_, 0, sizeof (GtkTargetEntry)), _tmp8_.target = "_NETSCAPE_URL", _tmp8_.flags = (guint) 0, _tmp8_.info = (guint) UNITY_DND_TARGETS_TARGET_URL, _tmp8_), _tmp9_), target_list_length1 = 6, _target_list_size_ = target_list_length1, _tmp10_);
		LOGGER_START_PROCESS ("ctk_dnd_init");
		ctk_dnd_init ((GtkWidget*) self->gtk_clutter, target_list, target_list_length1);
		LOGGER_END_PROCESS ("ctk_dnd_init");
		self->stage = (_tmp11_ = _g_object_ref0 (CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->gtk_clutter))), _g_object_unref0 (self->stage), _tmp11_);
		stage_bg = (memset (&_tmp12_, 0, sizeof (ClutterColor)), _tmp12_.red = (guint8) 0x00, _tmp12_.green = (guint8) 0x00, _tmp12_.blue = (guint8) 0x00, _tmp12_.alpha = (guint8) 0xff, _tmp12_);
		clutter_stage_set_color (self->stage, &stage_bg);
		g_signal_connect_object ((ClutterActor*) self->stage, "button-press-event", (GCallback) _unity_testing_window_on_stage_button_press_clutter_actor_button_press_event, self, 0);
		self->priv->background = (_tmp13_ = g_object_ref_sink (unity_testing_background_new ()), _g_object_unref0 (self->priv->background), _tmp13_);
		clutter_container_add_actor ((ClutterContainer*) self->stage, (ClutterActor*) self->priv->background);
		clutter_actor_show ((ClutterActor*) self->priv->background);
		self->priv->launcher = (_tmp14_ = unity_launcher_launcher_new ((UnityShell*) self), _g_object_unref0 (self->priv->launcher), _tmp14_);
		clutter_container_add_actor ((ClutterContainer*) self->stage, _tmp15_ = unity_launcher_launcher_get_container (self->priv->launcher));
		_g_object_unref0 (_tmp15_);
		clutter_container_add_actor ((ClutterContainer*) (_tmp17_ = (_tmp16_ = unity_launcher_launcher_get_container (self->priv->launcher), CTK_IS_BIN (_tmp16_) ? ((CtkBin*) _tmp16_) : NULL)), _tmp18_ = unity_launcher_launcher_get_view (self->priv->launcher));
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp17_);
		clutter_actor_show (_tmp19_ = unity_launcher_launcher_get_container (self->priv->launcher));
		_g_object_unref0 (_tmp19_);
		self->priv->controller = (_tmp20_ = unity_places_controller_new ((UnityShell*) self), _g_object_unref0 (self->priv->controller), _tmp20_);
		self->priv->places = (_tmp21_ = unity_places_controller_get_view (self->priv->controller), _g_object_unref0 (self->priv->places), _tmp21_);
		clutter_container_add_actor ((ClutterContainer*) self->stage, (ClutterActor*) self->priv->places);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->places, (guint8) 0);
		self->priv->showing_places = FALSE;
		self->priv->panel = (_tmp22_ = g_object_ref_sink (unity_panel_view_new ((UnityShell*) self)), _g_object_unref0 (self->priv->panel), _tmp22_);
		clutter_container_add_actor ((ClutterContainer*) self->stage, (ClutterActor*) self->priv->panel);
		clutter_actor_show ((ClutterActor*) self->priv->panel);
		gtk_window_move ((GtkWindow*) self, 0, 0);
		unity_testing_window_relayout (self);
		self->priv->wnck_screen = (_tmp23_ = _g_object_ref0 (wnck_screen_get_default ()), _g_object_unref0 (self->priv->wnck_screen), _tmp23_);
		if (!self->priv->_is_popup) {
			g_signal_connect_object (self->priv->wnck_screen, "active-window-changed", (GCallback) _unity_testing_window_on_active_window_changed_wnck_screen_active_window_changed, self, 0);
		}
		self->priv->gesture_dispatcher = (_tmp24_ = (UnityGestureDispatcher*) unity_gesture_xcb_dispatcher_new (), _g_object_unref0 (self->priv->gesture_dispatcher), _tmp24_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda106__gsource_func, g_object_ref (self), g_object_unref);
		END_FUNCTION ();
		target_list = (g_free (target_list), NULL);
	}
	return obj;
}


static void unity_testing_window_class_init (UnityTestingWindowClass * klass) {
	unity_testing_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityTestingWindowPrivate));
	GTK_WIDGET_CLASS (klass)->show = unity_testing_window_real_show;
	G_OBJECT_CLASS (klass)->get_property = unity_testing_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_testing_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_testing_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_testing_window_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_MENUS_SWALLOW_EVENTS, "menus-swallow-events");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_SUPER_KEY_ACTIVE, "super-key-active");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_IS_STARTING, "is-starting");
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_IS_POPUP, g_param_spec_boolean ("is-popup", "is-popup", "is-popup", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_POPUP_WIDTH, g_param_spec_int ("popup-width", "popup-width", "popup-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TESTING_WINDOW_POPUP_HEIGHT, g_param_spec_int ("popup-height", "popup-height", "popup-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void unity_testing_window_unity_shell_interface_init (UnityShellIface * iface) {
	unity_testing_window_unity_shell_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_current_time = unity_testing_window_real_get_current_time;
	iface->get_window_details = unity_testing_window_real_get_window_details;
	iface->do_window_action = unity_testing_window_real_do_window_action;
	iface->grab_keyboard = unity_testing_window_real_grab_keyboard;
	iface->get_stage = unity_testing_window_real_get_stage;
	iface->get_mode = unity_testing_window_real_get_mode;
	iface->show_unity = unity_testing_window_real_show_unity;
	iface->hide_unity = unity_testing_window_real_hide_unity;
	iface->about_to_show_places = unity_testing_window_real_about_to_show_places;
	iface->get_indicators_width = unity_testing_window_real_get_indicators_width;
	iface->get_launcher_width_foobar = unity_testing_window_real_get_launcher_width_foobar;
	iface->get_panel_height_foobar = unity_testing_window_real_get_panel_height_foobar;
	iface->add_fullscreen_request = unity_testing_window_real_add_fullscreen_request;
	iface->remove_fullscreen_request = unity_testing_window_real_remove_fullscreen_request;
	iface->ensure_input_region = unity_testing_window_real_ensure_input_region;
	iface->close_xids = unity_testing_window_real_close_xids;
	iface->expose_xids = unity_testing_window_real_expose_xids;
	iface->stop_expose = unity_testing_window_real_stop_expose;
	iface->show_window = unity_testing_window_real_show_window;
	iface->get_menus_swallow_events = unity_testing_window_real_get_menus_swallow_events;
	iface->get_super_key_active = unity_testing_window_real_get_super_key_active;
	iface->set_super_key_active = unity_testing_window_real_set_super_key_active;
	iface->get_is_starting = unity_testing_window_real_get_is_starting;
	iface->set_is_starting = unity_testing_window_real_set_is_starting;
}


static void unity_testing_window_instance_init (UnityTestingWindow * self) {
	self->priv = UNITY_TESTING_WINDOW_GET_PRIVATE (self);
}


static void unity_testing_window_finalize (GObject* obj) {
	UnityTestingWindow * self;
	self = UNITY_TESTING_WINDOW (obj);
	_g_object_unref0 (self->priv->wnck_screen);
	_unity_testing_workarea_unref0 (self->priv->workarea_size);
	_g_object_unref0 (self->gtk_clutter);
	_g_object_unref0 (self->stage);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->launcher);
	_g_object_unref0 (self->priv->panel);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->places);
	_g_object_unref0 (self->priv->gesture_dispatcher);
	G_OBJECT_CLASS (unity_testing_window_parent_class)->finalize (obj);
}


GType unity_testing_window_get_type (void) {
	static volatile gsize unity_testing_window_type_id__volatile = 0;
	if (g_once_init_enter (&unity_testing_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityTestingWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_testing_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityTestingWindow), 0, (GInstanceInitFunc) unity_testing_window_instance_init, NULL };
		static const GInterfaceInfo unity_shell_info = { (GInterfaceInitFunc) unity_testing_window_unity_shell_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_testing_window_type_id;
		unity_testing_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "UnityTestingWindow", &g_define_type_info, 0);
		g_type_add_interface_static (unity_testing_window_type_id, UNITY_TYPE_SHELL, &unity_shell_info);
		g_once_init_leave (&unity_testing_window_type_id__volatile, unity_testing_window_type_id);
	}
	return unity_testing_window_type_id__volatile;
}


static void unity_testing_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityTestingWindow * self;
	self = UNITY_TESTING_WINDOW (object);
	switch (property_id) {
		case UNITY_TESTING_WINDOW_MENUS_SWALLOW_EVENTS:
		g_value_set_boolean (value, unity_shell_get_menus_swallow_events ((UnityShell*) self));
		break;
		case UNITY_TESTING_WINDOW_SUPER_KEY_ACTIVE:
		g_value_set_boolean (value, unity_shell_get_super_key_active ((UnityShell*) self));
		break;
		case UNITY_TESTING_WINDOW_IS_STARTING:
		g_value_set_boolean (value, unity_shell_get_is_starting ((UnityShell*) self));
		break;
		case UNITY_TESTING_WINDOW_IS_POPUP:
		g_value_set_boolean (value, unity_testing_window_get_is_popup (self));
		break;
		case UNITY_TESTING_WINDOW_POPUP_WIDTH:
		g_value_set_int (value, unity_testing_window_get_popup_width (self));
		break;
		case UNITY_TESTING_WINDOW_POPUP_HEIGHT:
		g_value_set_int (value, unity_testing_window_get_popup_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_testing_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityTestingWindow * self;
	self = UNITY_TESTING_WINDOW (object);
	switch (property_id) {
		case UNITY_TESTING_WINDOW_SUPER_KEY_ACTIVE:
		unity_shell_set_super_key_active ((UnityShell*) self, g_value_get_boolean (value));
		break;
		case UNITY_TESTING_WINDOW_IS_STARTING:
		unity_shell_set_is_starting ((UnityShell*) self, g_value_get_boolean (value));
		break;
		case UNITY_TESTING_WINDOW_IS_POPUP:
		unity_testing_window_set_is_popup (self, g_value_get_boolean (value));
		break;
		case UNITY_TESTING_WINDOW_POPUP_WIDTH:
		unity_testing_window_set_popup_width (self, g_value_get_int (value));
		break;
		case UNITY_TESTING_WINDOW_POPUP_HEIGHT:
		unity_testing_window_set_popup_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityTestingWorkarea* unity_testing_workarea_construct (GType object_type) {
	UnityTestingWorkarea* self;
	self = (UnityTestingWorkarea*) g_type_create_instance (object_type);
	self->left = 0;
	self->right = 0;
	self->top = 0;
	self->bottom = 0;
	unity_testing_workarea_update_net_workarea (self);
	return self;
}


UnityTestingWorkarea* unity_testing_workarea_new (void) {
	return unity_testing_workarea_construct (UNITY_TESTING_TYPE_WORKAREA);
}


void unity_testing_workarea_update_net_workarea (UnityTestingWorkarea* self) {
	g_return_if_fail (self != NULL);
	self->left = 0;
	self->right = 0;
	self->top = 24;
	self->bottom = 0;
}


static void unity_testing_value_workarea_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_testing_value_workarea_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_testing_workarea_unref (value->data[0].v_pointer);
	}
}


static void unity_testing_value_workarea_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_testing_workarea_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_testing_value_workarea_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_testing_value_workarea_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityTestingWorkarea* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_testing_workarea_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_testing_value_workarea_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityTestingWorkarea** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_testing_workarea_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_testing_param_spec_workarea (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityTestingParamSpecWorkarea* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TESTING_TYPE_WORKAREA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_testing_value_get_workarea (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TESTING_TYPE_WORKAREA), NULL);
	return value->data[0].v_pointer;
}


void unity_testing_value_set_workarea (GValue* value, gpointer v_object) {
	UnityTestingWorkarea* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TESTING_TYPE_WORKAREA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TESTING_TYPE_WORKAREA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_testing_workarea_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_testing_workarea_unref (old);
	}
}


void unity_testing_value_take_workarea (GValue* value, gpointer v_object) {
	UnityTestingWorkarea* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TESTING_TYPE_WORKAREA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TESTING_TYPE_WORKAREA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_testing_workarea_unref (old);
	}
}


static void unity_testing_workarea_class_init (UnityTestingWorkareaClass * klass) {
	unity_testing_workarea_parent_class = g_type_class_peek_parent (klass);
	UNITY_TESTING_WORKAREA_CLASS (klass)->finalize = unity_testing_workarea_finalize;
	g_signal_new ("workarea_changed", UNITY_TESTING_TYPE_WORKAREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_testing_workarea_instance_init (UnityTestingWorkarea * self) {
	self->ref_count = 1;
}


static void unity_testing_workarea_finalize (UnityTestingWorkarea* obj) {
	UnityTestingWorkarea * self;
	self = UNITY_TESTING_WORKAREA (obj);
}


GType unity_testing_workarea_get_type (void) {
	static volatile gsize unity_testing_workarea_type_id__volatile = 0;
	if (g_once_init_enter (&unity_testing_workarea_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_testing_value_workarea_init, unity_testing_value_workarea_free_value, unity_testing_value_workarea_copy_value, unity_testing_value_workarea_peek_pointer, "p", unity_testing_value_workarea_collect_value, "p", unity_testing_value_workarea_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityTestingWorkareaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_testing_workarea_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityTestingWorkarea), 0, (GInstanceInitFunc) unity_testing_workarea_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_testing_workarea_type_id;
		unity_testing_workarea_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityTestingWorkarea", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_testing_workarea_type_id__volatile, unity_testing_workarea_type_id);
	}
	return unity_testing_workarea_type_id__volatile;
}


gpointer unity_testing_workarea_ref (gpointer instance) {
	UnityTestingWorkarea* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_testing_workarea_unref (gpointer instance) {
	UnityTestingWorkarea* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_TESTING_WORKAREA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




