/* unity-pixbuf-cache.c generated by valac 0.10.0, the Vala compiler
 * generated from unity-pixbuf-cache.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
  <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <clutk/clutk.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TYPE_PIXBUF_CACHE_TASK (unity_pixbuf_cache_task_get_type ())
#define UNITY_PIXBUF_CACHE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PIXBUF_CACHE_TASK, UnityPixbufCacheTask))
#define UNITY_PIXBUF_CACHE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PIXBUF_CACHE_TASK, UnityPixbufCacheTaskClass))
#define UNITY_IS_PIXBUF_CACHE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PIXBUF_CACHE_TASK))
#define UNITY_IS_PIXBUF_CACHE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PIXBUF_CACHE_TASK))
#define UNITY_PIXBUF_CACHE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PIXBUF_CACHE_TASK, UnityPixbufCacheTaskClass))

typedef struct _UnityPixbufCacheTask UnityPixbufCacheTask;
typedef struct _UnityPixbufCacheTaskClass UnityPixbufCacheTaskClass;
typedef struct _UnityPixbufCacheTaskPrivate UnityPixbufCacheTaskPrivate;

#define UNITY_TYPE_PIXBUF_REQUEST_TYPE (unity_pixbuf_request_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityParamSpecPixbufCacheTask UnityParamSpecPixbufCacheTask;

#define UNITY_TYPE_PIXBUF_CACHE (unity_pixbuf_cache_get_type ())
#define UNITY_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PIXBUF_CACHE, UnityPixbufCache))
#define UNITY_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PIXBUF_CACHE, UnityPixbufCacheClass))
#define UNITY_IS_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PIXBUF_CACHE))
#define UNITY_IS_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PIXBUF_CACHE))
#define UNITY_PIXBUF_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PIXBUF_CACHE, UnityPixbufCacheClass))

typedef struct _UnityPixbufCache UnityPixbufCache;
typedef struct _UnityPixbufCacheClass UnityPixbufCacheClass;
typedef struct _UnityPixbufCachePrivate UnityPixbufCachePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TYPE_SHELL (unity_shell_get_type ())
#define UNITY_SHELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SHELL, UnityShell))
#define UNITY_IS_SHELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SHELL))
#define UNITY_SHELL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SHELL, UnityShellIface))

typedef struct _UnityShell UnityShell;
typedef struct _UnityShellIface UnityShellIface;

#define UNITY_TYPE_SHELL_MODE (unity_shell_mode_get_type ())

#define UNITY_TYPE_WINDOW_ACTION (unity_window_action_get_type ())
#define _unity_pixbuf_cache_task_unref0(var) ((var == NULL) ? NULL : (var = (unity_pixbuf_cache_task_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _UnityPixbufCacheProcessIconQueueAsyncData UnityPixbufCacheProcessIconQueueAsyncData;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityPixbufCacheSetImageFromIconNameRealData UnityPixbufCacheSetImageFromIconNameRealData;
typedef struct _UnityPixbufCacheSetImageFromGiconStringRealData UnityPixbufCacheSetImageFromGiconStringRealData;
typedef struct _UnityPixbufCacheSetImageFromGiconData UnityPixbufCacheSetImageFromGiconData;
typedef struct _UnityPixbufCacheLoadFromFilepathData UnityPixbufCacheLoadFromFilepathData;

typedef enum  {
	UNITY_PIXBUF_REQUEST_TYPE_ICON_NAME,
	UNITY_PIXBUF_REQUEST_TYPE_GICON_STRING
} UnityPixbufRequestType;

struct _UnityPixbufCacheTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityPixbufCacheTaskPrivate * priv;
	char* data;
	CtkImage* image;
	gint size;
	char* key;
	UnityPixbufRequestType type;
};

struct _UnityPixbufCacheTaskClass {
	GTypeClass parent_class;
	void (*finalize) (UnityPixbufCacheTask *self);
};

struct _UnityParamSpecPixbufCacheTask {
	GParamSpec parent_instance;
};

struct _UnityPixbufCache {
	GObject parent_instance;
	UnityPixbufCachePrivate * priv;
};

struct _UnityPixbufCacheClass {
	GObjectClass parent_class;
};

struct _UnityPixbufCachePrivate {
	GtkIconTheme* theme;
	GeeHashMap* cache;
	gboolean autodispose;
	GeeQueue* queue;
	guint queue_source;
};

typedef enum  {
	UNITY_SHELL_MODE_MINIMIZED,
	UNITY_SHELL_MODE_DASH,
	UNITY_SHELL_MODE_EXPOSE
} UnityShellMode;

typedef enum  {
	UNITY_WINDOW_ACTION_CLOSE,
	UNITY_WINDOW_ACTION_MINIMIZE,
	UNITY_WINDOW_ACTION_MAXIMIZE,
	UNITY_WINDOW_ACTION_UNMAXIMIZE
} UnityWindowAction;

struct _UnityShellIface {
	GTypeInterface parent_iface;
	guint32 (*get_current_time) (UnityShell* self);
	UnityShellMode (*get_mode) (UnityShell* self);
	ClutterStage* (*get_stage) (UnityShell* self);
	void (*show_unity) (UnityShell* self);
	void (*hide_unity) (UnityShell* self);
	gint (*get_indicators_width) (UnityShell* self);
	gint (*get_launcher_width_foobar) (UnityShell* self);
	gint (*get_panel_height_foobar) (UnityShell* self);
	void (*ensure_input_region) (UnityShell* self);
	void (*add_fullscreen_request) (UnityShell* self, GObject* o);
	gboolean (*remove_fullscreen_request) (UnityShell* self, GObject* o);
	void (*grab_keyboard) (UnityShell* self, gboolean grab, guint32 timestamp);
	void (*about_to_show_places) (UnityShell* self);
	void (*close_xids) (UnityShell* self, GArray* xids);
	void (*show_window) (UnityShell* self, guint32 xid);
	void (*expose_xids) (UnityShell* self, GArray* xids);
	void (*stop_expose) (UnityShell* self);
	void (*get_window_details) (UnityShell* self, guint32 xid, gboolean* allows_resize, gboolean* is_maximised);
	void (*do_window_action) (UnityShell* self, guint32 xid, UnityWindowAction action);
	gboolean (*get_menus_swallow_events) (UnityShell* self);
	gboolean (*get_super_key_active) (UnityShell* self);
	void (*set_super_key_active) (UnityShell* self, gboolean value);
	gboolean (*get_is_starting) (UnityShell* self);
	void (*set_is_starting) (UnityShell* self, gboolean value);
};

struct _UnityPixbufCacheProcessIconQueueAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPixbufCache* self;
	guchar* buf;
	gint buf_length1;
	gint _buf_size_;
	guchar* _tmp0_;
	gint count;
	GTimer* timer;
	UnityPixbufCacheTask* task;
	UnityPixbufCacheTask* _tmp1_;
};

struct _UnityPixbufCacheSetImageFromIconNameRealData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPixbufCache* self;
	UnityPixbufCacheTask* task;
	void* buf;
	gsize buf_length;
	GdkPixbuf* ret;
	GtkIconInfo* info;
	char* filename;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * e;
	GError * _inner_error_;
};

struct _UnityPixbufCacheSetImageFromGiconStringRealData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPixbufCache* self;
	UnityPixbufCacheTask* task;
	void* buf;
	gsize buf_length;
	GdkPixbuf* ret;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	char* _tmp2_;
	GError * err;
	GIcon* icon;
	GtkIconInfo* info;
	char* filename;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	char* real_name;
	GtkIconInfo* _tmp8_;
	char* fname;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	char* _tmp11_;
	GError * e;
	GError * _inner_error_;
};

struct _UnityPixbufCacheSetImageFromGiconData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPixbufCache* self;
	CtkImage* image;
	GIcon* icon;
	gint size;
	char* _tmp0_;
};

struct _UnityPixbufCacheLoadFromFilepathData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPixbufCache* self;
	char* filename;
	gint size;
	void* buf;
	gsize buf_length;
	GdkPixbuf* result;
	GFile* datafile;
	GFileInfo* info;
	char* mimetype;
	GFileInputStream* stream;
	void* data;
	gsize data_size;
	GdkPixbufLoader* loader;
	GError * ee;
	GError * _inner_error_;
};


static gpointer unity_pixbuf_cache_task_parent_class = NULL;
extern UnityPixbufCache* unity__pixbuf_cache;
UnityPixbufCache* unity__pixbuf_cache = NULL;
extern UnityShell* unity_global_shell;
static gpointer unity_pixbuf_cache_parent_class = NULL;

gpointer unity_pixbuf_cache_task_ref (gpointer instance);
void unity_pixbuf_cache_task_unref (gpointer instance);
GParamSpec* unity_param_spec_pixbuf_cache_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_value_set_pixbuf_cache_task (GValue* value, gpointer v_object);
void unity_value_take_pixbuf_cache_task (GValue* value, gpointer v_object);
gpointer unity_value_get_pixbuf_cache_task (const GValue* value);
GType unity_pixbuf_cache_task_get_type (void) G_GNUC_CONST;
GType unity_pixbuf_request_type_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_PIXBUF_CACHE_TASK_DUMMY_PROPERTY
};
UnityPixbufCacheTask* unity_pixbuf_cache_task_new (void);
UnityPixbufCacheTask* unity_pixbuf_cache_task_construct (GType object_type);
static void unity_pixbuf_cache_task_finalize (UnityPixbufCacheTask* obj);
#define UNITY_hash_template "%s%d"
GType unity_pixbuf_cache_get_type (void) G_GNUC_CONST;
#define UNITY_PIXBUF_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PIXBUF_CACHE, UnityPixbufCachePrivate))
enum  {
	UNITY_PIXBUF_CACHE_DUMMY_PROPERTY,
	UNITY_PIXBUF_CACHE_SIZE
};
UnityPixbufCache* unity_pixbuf_cache_new (gboolean _autodispose);
UnityPixbufCache* unity_pixbuf_cache_construct (GType object_type, gboolean _autodispose);
GType unity_shell_mode_get_type (void) G_GNUC_CONST;
GType unity_window_action_get_type (void) G_GNUC_CONST;
GType unity_shell_get_type (void) G_GNUC_CONST;
static void unity_pixbuf_cache_on_shell_destroyed (UnityPixbufCache* self);
static void _unity_pixbuf_cache_on_shell_destroyed_gweak_notify (gpointer self, GObject* object);
UnityPixbufCache* unity_pixbuf_cache_get_default (void);
void unity_pixbuf_cache_set (UnityPixbufCache* self, const char* icon_id, GdkPixbuf* pixbuf, gint size);
GdkPixbuf* unity_pixbuf_cache_get (UnityPixbufCache* self, const char* icon_id, gint size);
void unity_pixbuf_cache_clear (UnityPixbufCache* self);
static void unity_pixbuf_cache_process_icon_queue_async_data_free (gpointer _data);
static void unity_pixbuf_cache_process_icon_queue_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_pixbuf_cache_process_icon_queue_async (UnityPixbufCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_pixbuf_cache_process_icon_queue_finish (UnityPixbufCache* self, GAsyncResult* _res_);
static gboolean unity_pixbuf_cache_process_icon_queue_async_co (UnityPixbufCacheProcessIconQueueAsyncData* data);
static void unity_pixbuf_cache_set_image_from_icon_name_real (UnityPixbufCache* self, UnityPixbufCacheTask* task, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_pixbuf_cache_set_image_from_icon_name_real_finish (UnityPixbufCache* self, GAsyncResult* _res_);
static void unity_pixbuf_cache_set_image_from_gicon_string_real (UnityPixbufCache* self, UnityPixbufCacheTask* task, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_pixbuf_cache_set_image_from_gicon_string_real_finish (UnityPixbufCache* self, GAsyncResult* _res_);
static void unity_pixbuf_cache_process_icon_queue (UnityPixbufCache* self);
static gboolean unity_pixbuf_cache_dispatch_process_icon_queue_async (UnityPixbufCache* self);
static gboolean _unity_pixbuf_cache_dispatch_process_icon_queue_async_gsource_func (gpointer self);
void unity_pixbuf_cache_set_image_from_icon_name (UnityPixbufCache* self, CtkImage* image, const char* icon_name, gint size);
static void unity_pixbuf_cache_set_image_from_icon_name_real_data_free (gpointer _data);
static void unity_pixbuf_cache_set_image_from_icon_name_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_pixbuf_cache_set_image_from_icon_name_real_co (UnityPixbufCacheSetImageFromIconNameRealData* data);
static void unity_pixbuf_cache_load_from_filepath (UnityPixbufCache* self, const char* filename, gint size, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GdkPixbuf* unity_pixbuf_cache_load_from_filepath_finish (UnityPixbufCache* self, GAsyncResult* _res_, GError** error);
void unity_pixbuf_cache_set_image_from_gicon_string (UnityPixbufCache* self, CtkImage* image, const char* gicon_as_string, gint size);
static void unity_pixbuf_cache_set_image_from_gicon_string_real_data_free (gpointer _data);
static void unity_pixbuf_cache_set_image_from_gicon_string_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_pixbuf_cache_set_image_from_gicon_string_real_co (UnityPixbufCacheSetImageFromGiconStringRealData* data);
static void unity_pixbuf_cache_set_image_from_gicon_data_free (gpointer _data);
static void unity_pixbuf_cache_set_image_from_gicon_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_pixbuf_cache_set_image_from_gicon (UnityPixbufCache* self, CtkImage* image, GIcon* icon, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_pixbuf_cache_set_image_from_gicon_finish (UnityPixbufCache* self, GAsyncResult* _res_);
static gboolean unity_pixbuf_cache_set_image_from_gicon_co (UnityPixbufCacheSetImageFromGiconData* data);
static void unity_pixbuf_cache_load_from_filepath_data_free (gpointer _data);
static void unity_pixbuf_cache_load_from_filepath_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_pixbuf_cache_load_from_filepath_co (UnityPixbufCacheLoadFromFilepathData* data);
void unity_io_read_stream_async (GInputStream* input, void* buffer, gsize buffer_lenght, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_io_read_stream_finish (GAsyncResult* _res_, void** data, gsize* size, GError** error);
guint unity_pixbuf_cache_get_size (UnityPixbufCache* self);
static GObject * unity_pixbuf_cache_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_pixbuf_cache_finalize (GObject* obj);
static void unity_pixbuf_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



UnityPixbufCacheTask* unity_pixbuf_cache_task_construct (GType object_type) {
	UnityPixbufCacheTask* self;
	self = (UnityPixbufCacheTask*) g_type_create_instance (object_type);
	return self;
}


UnityPixbufCacheTask* unity_pixbuf_cache_task_new (void) {
	return unity_pixbuf_cache_task_construct (UNITY_TYPE_PIXBUF_CACHE_TASK);
}


static void unity_value_pixbuf_cache_task_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_value_pixbuf_cache_task_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_pixbuf_cache_task_unref (value->data[0].v_pointer);
	}
}


static void unity_value_pixbuf_cache_task_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_pixbuf_cache_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_value_pixbuf_cache_task_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_value_pixbuf_cache_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityPixbufCacheTask* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_pixbuf_cache_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_value_pixbuf_cache_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityPixbufCacheTask** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_pixbuf_cache_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_param_spec_pixbuf_cache_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityParamSpecPixbufCacheTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TYPE_PIXBUF_CACHE_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_value_get_pixbuf_cache_task (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_PIXBUF_CACHE_TASK), NULL);
	return value->data[0].v_pointer;
}


void unity_value_set_pixbuf_cache_task (GValue* value, gpointer v_object) {
	UnityPixbufCacheTask* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_PIXBUF_CACHE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_PIXBUF_CACHE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_pixbuf_cache_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_pixbuf_cache_task_unref (old);
	}
}


void unity_value_take_pixbuf_cache_task (GValue* value, gpointer v_object) {
	UnityPixbufCacheTask* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_PIXBUF_CACHE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_PIXBUF_CACHE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_pixbuf_cache_task_unref (old);
	}
}


static void unity_pixbuf_cache_task_class_init (UnityPixbufCacheTaskClass * klass) {
	unity_pixbuf_cache_task_parent_class = g_type_class_peek_parent (klass);
	UNITY_PIXBUF_CACHE_TASK_CLASS (klass)->finalize = unity_pixbuf_cache_task_finalize;
}


static void unity_pixbuf_cache_task_instance_init (UnityPixbufCacheTask * self) {
	self->ref_count = 1;
}


static void unity_pixbuf_cache_task_finalize (UnityPixbufCacheTask* obj) {
	UnityPixbufCacheTask * self;
	self = UNITY_PIXBUF_CACHE_TASK (obj);
	_g_free0 (self->data);
	_g_free0 (self->key);
}


GType unity_pixbuf_cache_task_get_type (void) {
	static volatile gsize unity_pixbuf_cache_task_type_id__volatile = 0;
	if (g_once_init_enter (&unity_pixbuf_cache_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_value_pixbuf_cache_task_init, unity_value_pixbuf_cache_task_free_value, unity_value_pixbuf_cache_task_copy_value, unity_value_pixbuf_cache_task_peek_pointer, "p", unity_value_pixbuf_cache_task_collect_value, "p", unity_value_pixbuf_cache_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityPixbufCacheTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_pixbuf_cache_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPixbufCacheTask), 0, (GInstanceInitFunc) unity_pixbuf_cache_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_pixbuf_cache_task_type_id;
		unity_pixbuf_cache_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityPixbufCacheTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_pixbuf_cache_task_type_id__volatile, unity_pixbuf_cache_task_type_id);
	}
	return unity_pixbuf_cache_task_type_id__volatile;
}


gpointer unity_pixbuf_cache_task_ref (gpointer instance) {
	UnityPixbufCacheTask* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_pixbuf_cache_task_unref (gpointer instance) {
	UnityPixbufCacheTask* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_PIXBUF_CACHE_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType unity_pixbuf_request_type_get_type (void) {
	static volatile gsize unity_pixbuf_request_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_pixbuf_request_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_PIXBUF_REQUEST_TYPE_ICON_NAME, "UNITY_PIXBUF_REQUEST_TYPE_ICON_NAME", "icon-name"}, {UNITY_PIXBUF_REQUEST_TYPE_GICON_STRING, "UNITY_PIXBUF_REQUEST_TYPE_GICON_STRING", "gicon-string"}, {0, NULL, NULL}};
		GType unity_pixbuf_request_type_type_id;
		unity_pixbuf_request_type_type_id = g_enum_register_static ("UnityPixbufRequestType", values);
		g_once_init_leave (&unity_pixbuf_request_type_type_id__volatile, unity_pixbuf_request_type_type_id);
	}
	return unity_pixbuf_request_type_type_id__volatile;
}


static void _unity_pixbuf_cache_on_shell_destroyed_gweak_notify (gpointer self, GObject* object) {
	unity_pixbuf_cache_on_shell_destroyed (self);
}


UnityPixbufCache* unity_pixbuf_cache_construct (GType object_type, gboolean _autodispose) {
	UnityPixbufCache * self;
	self = (UnityPixbufCache*) g_object_new (object_type, NULL);
	self->priv->autodispose = _autodispose;
	if (self->priv->autodispose) {
		if (UNITY_IS_SHELL (unity_global_shell)) {
			g_object_weak_ref ((GObject*) unity_global_shell, _unity_pixbuf_cache_on_shell_destroyed_gweak_notify, self);
		}
	}
	return self;
}


UnityPixbufCache* unity_pixbuf_cache_new (gboolean _autodispose) {
	return unity_pixbuf_cache_construct (UNITY_TYPE_PIXBUF_CACHE, _autodispose);
}


static void unity_pixbuf_cache_on_shell_destroyed (UnityPixbufCache* self) {
	g_return_if_fail (self != NULL);
	if (unity__pixbuf_cache == self) {
		UnityPixbufCache* _tmp0_;
		unity__pixbuf_cache = (_tmp0_ = NULL, _g_object_unref0 (unity__pixbuf_cache), _tmp0_);
	} else {
		g_object_unref ((GObject*) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityPixbufCache* unity_pixbuf_cache_get_default (void) {
	UnityPixbufCache* result = NULL;
	if (unity__pixbuf_cache == NULL) {
		UnityPixbufCache* _tmp0_;
		unity__pixbuf_cache = (_tmp0_ = unity_pixbuf_cache_new (TRUE), _g_object_unref0 (unity__pixbuf_cache), _tmp0_);
	}
	result = _g_object_ref0 (unity__pixbuf_cache);
	return result;
}


void unity_pixbuf_cache_set (UnityPixbufCache* self, const char* icon_id, GdkPixbuf* pixbuf, gint size) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (pixbuf != NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->cache, _tmp0_ = g_strdup_printf (UNITY_hash_template, icon_id, size), pixbuf);
	_g_free0 (_tmp0_);
}


GdkPixbuf* unity_pixbuf_cache_get (UnityPixbufCache* self, const char* icon_id, gint size) {
	GdkPixbuf* result = NULL;
	char* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_id != NULL, NULL);
	result = (_tmp1_ = (GdkPixbuf*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->cache, _tmp0_ = g_strdup_printf (UNITY_hash_template, icon_id, size)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


void unity_pixbuf_cache_clear (UnityPixbufCache* self) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->cache);
}


static void unity_pixbuf_cache_process_icon_queue_async_data_free (gpointer _data) {
	UnityPixbufCacheProcessIconQueueAsyncData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (UnityPixbufCacheProcessIconQueueAsyncData, data);
}


static void unity_pixbuf_cache_process_icon_queue_async (UnityPixbufCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPixbufCacheProcessIconQueueAsyncData* _data_;
	_data_ = g_slice_new0 (UnityPixbufCacheProcessIconQueueAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_pixbuf_cache_process_icon_queue_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_pixbuf_cache_process_icon_queue_async_data_free);
	_data_->self = g_object_ref (self);
	unity_pixbuf_cache_process_icon_queue_async_co (_data_);
}


static void unity_pixbuf_cache_process_icon_queue_finish (UnityPixbufCache* self, GAsyncResult* _res_) {
	UnityPixbufCacheProcessIconQueueAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_pixbuf_cache_process_icon_queue_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPixbufCacheProcessIconQueueAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_pixbuf_cache_process_icon_queue_async_co (data);
}


static gboolean unity_pixbuf_cache_process_icon_queue_async_co (UnityPixbufCacheProcessIconQueueAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
	}
	_state_0:
	data->buf = (data->_tmp0_ = g_new0 (guchar, 4096), data->buf_length1 = 4096, data->_buf_size_ = data->buf_length1, data->_tmp0_);
	data->count = 0;
	data->timer = g_timer_new ();
	while (TRUE) {
		if (!((data->task = (data->_tmp1_ = (UnityPixbufCacheTask*) gee_queue_poll (data->self->priv->queue), _unity_pixbuf_cache_task_unref0 (data->task), data->_tmp1_)) != NULL)) {
			break;
		}
		if (CTK_IS_IMAGE (data->task->image)) {
			switch (data->task->type) {
				case UNITY_PIXBUF_REQUEST_TYPE_ICON_NAME:
				{
					data->_state_ = 10;
					unity_pixbuf_cache_set_image_from_icon_name_real (data->self, data->task, data->buf, (gsize) data->buf_length1, unity_pixbuf_cache_process_icon_queue_async_ready, data);
					return FALSE;
					_state_10:
					unity_pixbuf_cache_set_image_from_icon_name_real_finish (data->self, data->_res_);
					break;
				}
				case UNITY_PIXBUF_REQUEST_TYPE_GICON_STRING:
				{
					data->_state_ = 11;
					unity_pixbuf_cache_set_image_from_gicon_string_real (data->self, data->task, data->buf, (gsize) data->buf_length1, unity_pixbuf_cache_process_icon_queue_async_ready, data);
					return FALSE;
					_state_11:
					unity_pixbuf_cache_set_image_from_gicon_string_real_finish (data->self, data->_res_);
					break;
				}
				default:
				{
					g_critical ("unity-pixbuf-cache.vala:151: Internal error. Unknown PixbufRequestType" \
": %u", (guint) data->task->type);
					break;
				}
			}
		}
		data->count++;
	}
	g_timer_stop (data->timer);
	g_debug ("unity-pixbuf-cache.vala:160: Loaded %i icons in %fms", data->count, g_timer_elapsed (data->timer, NULL) * 1000);
	data->self->priv->queue_source = (guint) 0;
	_unity_pixbuf_cache_task_unref0 (data->task);
	_g_timer_destroy0 (data->timer);
	data->buf = (g_free (data->buf), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gboolean _unity_pixbuf_cache_dispatch_process_icon_queue_async_gsource_func (gpointer self) {
	gboolean result;
	result = unity_pixbuf_cache_dispatch_process_icon_queue_async (self);
	return result;
}


static void unity_pixbuf_cache_process_icon_queue (UnityPixbufCache* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->queue_source == 0) {
		self->priv->queue_source = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_pixbuf_cache_dispatch_process_icon_queue_async_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean unity_pixbuf_cache_dispatch_process_icon_queue_async (UnityPixbufCache* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_pixbuf_cache_process_icon_queue_async (self, NULL, NULL);
	unity_pixbuf_cache_process_icon_queue_async (self, NULL, NULL);
	unity_pixbuf_cache_process_icon_queue_async (self, NULL, NULL);
	result = FALSE;
	return result;
}


/**
     * If the icon is already cached then set it immediately on @image. Otherwise
     * does async IO to load and cache the icon, then setting it on @image.
     *
     * Note that this means that you should treat this method as an async
     * operation for all intents and purposes. You can not count on
     * image.pixbuf != null when this method call returns. That may just as well
     * happen in a subsequent idle call.
     */
void unity_pixbuf_cache_set_image_from_icon_name (UnityPixbufCache* self, CtkImage* image, const char* icon_name, gint size) {
	char* key;
	GdkPixbuf* ret;
	UnityPixbufCacheTask* task;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (icon_name != NULL);
	key = g_strdup_printf (UNITY_hash_template, icon_name, size);
	ret = (GdkPixbuf*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->cache, key);
	if (GDK_IS_PIXBUF (ret)) {
		ctk_image_set_from_pixbuf (image, ret);
		_g_object_unref0 (ret);
		_g_free0 (key);
		return;
	}
	task = unity_pixbuf_cache_task_new ();
	task->key = (_tmp0_ = g_strdup (key), _g_free0 (task->key), _tmp0_);
	task->data = (_tmp1_ = g_strdup (icon_name), _g_free0 (task->data), _tmp1_);
	task->image = image;
	task->size = size;
	task->type = UNITY_PIXBUF_REQUEST_TYPE_ICON_NAME;
	gee_queue_offer (self->priv->queue, task);
	unity_pixbuf_cache_process_icon_queue (self);
	_unity_pixbuf_cache_task_unref0 (task);
	_g_object_unref0 (ret);
	_g_free0 (key);
}


static void unity_pixbuf_cache_set_image_from_icon_name_real_data_free (gpointer _data) {
	UnityPixbufCacheSetImageFromIconNameRealData* data;
	data = _data;
	_unity_pixbuf_cache_task_unref0 (data->task);
	g_object_unref (data->self);
	g_slice_free (UnityPixbufCacheSetImageFromIconNameRealData, data);
}


static gpointer _unity_pixbuf_cache_task_ref0 (gpointer self) {
	return self ? unity_pixbuf_cache_task_ref (self) : NULL;
}


static void unity_pixbuf_cache_set_image_from_icon_name_real (UnityPixbufCache* self, UnityPixbufCacheTask* task, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromIconNameRealData* _data_;
	_data_ = g_slice_new0 (UnityPixbufCacheSetImageFromIconNameRealData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_pixbuf_cache_set_image_from_icon_name_real);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_pixbuf_cache_set_image_from_icon_name_real_data_free);
	_data_->self = g_object_ref (self);
	_data_->task = _unity_pixbuf_cache_task_ref0 (task);
	_data_->buf = buf;
	_data_->buf_length = buf_length;
	unity_pixbuf_cache_set_image_from_icon_name_real_co (_data_);
}


static void unity_pixbuf_cache_set_image_from_icon_name_real_finish (UnityPixbufCache* self, GAsyncResult* _res_) {
	UnityPixbufCacheSetImageFromIconNameRealData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_pixbuf_cache_set_image_from_icon_name_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromIconNameRealData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_pixbuf_cache_set_image_from_icon_name_real_co (data);
}


static gboolean unity_pixbuf_cache_set_image_from_icon_name_real_co (UnityPixbufCacheSetImageFromIconNameRealData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 12:
		goto _state_12;
	}
	_state_0:
	data->ret = (GdkPixbuf*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->cache, data->task->key);
	if (GDK_IS_PIXBUF (data->ret)) {
		ctk_image_set_from_pixbuf (data->task->image, data->ret);
		_g_object_unref0 (data->ret);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->info = gtk_icon_theme_lookup_icon (data->self->priv->theme, data->task->data, data->task->size, 0);
		if (data->info != NULL) {
			data->filename = g_strdup (gtk_icon_info_get_filename (data->info));
			data->_state_ = 12;
			unity_pixbuf_cache_load_from_filepath (data->self, data->filename, data->task->size, data->buf, data->buf_length, unity_pixbuf_cache_set_image_from_icon_name_real_ready, data);
			return FALSE;
			_state_12:
			data->_tmp0_ = unity_pixbuf_cache_load_from_filepath_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->filename);
				_gtk_icon_info_free0 (data->info);
				goto __catch34_g_error;
			}
			data->ret = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->ret), data->_tmp1_);
			_g_free0 (data->filename);
		}
		if (GDK_IS_PIXBUF (data->ret)) {
			gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->cache, data->task->key, data->ret);
		}
		_gtk_icon_info_free0 (data->info);
	}
	goto __finally34;
	__catch34_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("unity-pixbuf-cache.vala:255: Unable to load icon_name: %s", data->e->message);
			_g_error_free0 (data->e);
		}
	}
	__finally34:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->ret);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (GDK_IS_PIXBUF (data->ret)) {
		ctk_image_set_from_pixbuf (data->task->image, data->ret);
	}
	_g_object_unref0 (data->ret);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
     * If the icon is already cached then set it immediately on @image. Otherwise
     * does async IO to load and cache the icon, then setting it on @image.
     *
     * Note that this means that you should treat this method as an async
     * operation for all intents and purposes. You can not count on
     * image.pixbuf != null when this method call returns. That may just as well
     * happen in a subsequent idle call.
     */
void unity_pixbuf_cache_set_image_from_gicon_string (UnityPixbufCache* self, CtkImage* image, const char* gicon_as_string, gint size) {
	char* key;
	GdkPixbuf* ret;
	UnityPixbufCacheTask* task;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (gicon_as_string != NULL);
	key = g_strdup_printf (UNITY_hash_template, gicon_as_string, size);
	ret = (GdkPixbuf*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->cache, key);
	if (GDK_IS_PIXBUF (ret)) {
		ctk_image_set_from_pixbuf (image, ret);
		_g_object_unref0 (ret);
		_g_free0 (key);
		return;
	}
	task = unity_pixbuf_cache_task_new ();
	task->key = (_tmp0_ = g_strdup (key), _g_free0 (task->key), _tmp0_);
	task->image = image;
	task->data = (_tmp1_ = g_strdup (gicon_as_string), _g_free0 (task->data), _tmp1_);
	task->size = size;
	task->type = UNITY_PIXBUF_REQUEST_TYPE_GICON_STRING;
	gee_queue_offer (self->priv->queue, task);
	unity_pixbuf_cache_process_icon_queue (self);
	_unity_pixbuf_cache_task_unref0 (task);
	_g_object_unref0 (ret);
	_g_free0 (key);
}


static void unity_pixbuf_cache_set_image_from_gicon_string_real_data_free (gpointer _data) {
	UnityPixbufCacheSetImageFromGiconStringRealData* data;
	data = _data;
	_unity_pixbuf_cache_task_unref0 (data->task);
	g_object_unref (data->self);
	g_slice_free (UnityPixbufCacheSetImageFromGiconStringRealData, data);
}


static void unity_pixbuf_cache_set_image_from_gicon_string_real (UnityPixbufCache* self, UnityPixbufCacheTask* task, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromGiconStringRealData* _data_;
	_data_ = g_slice_new0 (UnityPixbufCacheSetImageFromGiconStringRealData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_pixbuf_cache_set_image_from_gicon_string_real);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_pixbuf_cache_set_image_from_gicon_string_real_data_free);
	_data_->self = g_object_ref (self);
	_data_->task = _unity_pixbuf_cache_task_ref0 (task);
	_data_->buf = buf;
	_data_->buf_length = buf_length;
	unity_pixbuf_cache_set_image_from_gicon_string_real_co (_data_);
}


static void unity_pixbuf_cache_set_image_from_gicon_string_real_finish (UnityPixbufCache* self, GAsyncResult* _res_) {
	UnityPixbufCacheSetImageFromGiconStringRealData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_pixbuf_cache_set_image_from_gicon_string_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromGiconStringRealData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_pixbuf_cache_set_image_from_gicon_string_real_co (data);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static gboolean unity_pixbuf_cache_set_image_from_gicon_string_real_co (UnityPixbufCacheSetImageFromGiconStringRealData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
	}
	_state_0:
	data->ret = (GdkPixbuf*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->cache, data->task->key);
	if (GDK_IS_PIXBUF (data->ret)) {
		ctk_image_set_from_pixbuf (data->task->image, data->ret);
		_g_object_unref0 (data->ret);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (g_utf8_get_char (g_utf8_offset_to_pointer (data->task->data, 0)) == '/') {
		{
			data->_state_ = 13;
			unity_pixbuf_cache_load_from_filepath (data->self, data->task->data, data->task->size, data->buf, data->buf_length, unity_pixbuf_cache_set_image_from_gicon_string_real_ready, data);
			return FALSE;
			_state_13:
			data->_tmp0_ = unity_pixbuf_cache_load_from_filepath_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch35_g_error;
			}
			data->ret = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->ret), data->_tmp1_);
		}
		goto __finally35;
		__catch35_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_message (data->_tmp2_ = g_strconcat ("Unable to load ", string_to_string (data->task->data), " as file: %s", NULL), data->err->message);
				_g_free0 (data->_tmp2_);
				_g_error_free0 (data->err);
			}
		}
		__finally35:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->ret == NULL) {
		{
			data->icon = g_icon_new_for_string (data->task->data, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch36_g_error;
			}
			data->info = gtk_icon_theme_lookup_by_gicon (data->self->priv->theme, data->icon, data->task->size, 0);
			if (data->info != NULL) {
				data->filename = g_strdup (gtk_icon_info_get_filename (data->info));
				data->_state_ = 14;
				unity_pixbuf_cache_load_from_filepath (data->self, data->filename, data->task->size, data->buf, data->buf_length, unity_pixbuf_cache_set_image_from_gicon_string_real_ready, data);
				return FALSE;
				_state_14:
				data->_tmp3_ = unity_pixbuf_cache_load_from_filepath_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->filename);
					_gtk_icon_info_free0 (data->info);
					goto __catch36_g_error;
				}
				data->ret = (data->_tmp4_ = data->_tmp3_, _g_object_unref0 (data->ret), data->_tmp4_);
				_g_free0 (data->filename);
			}
			if (data->ret == NULL) {
				if (g_str_has_suffix (data->task->data, ".png")) {
					data->_tmp7_ = TRUE;
				} else {
					data->_tmp7_ = g_str_has_suffix (data->task->data, ".xpm");
				}
				if (data->_tmp7_) {
					data->_tmp6_ = TRUE;
				} else {
					data->_tmp6_ = g_str_has_suffix (data->task->data, ".gif");
				}
				if (data->_tmp6_) {
					data->_tmp5_ = TRUE;
				} else {
					data->_tmp5_ = g_str_has_suffix (data->task->data, ".jpg");
				}
				if (data->_tmp5_) {
					data->real_name = string_slice (data->task->data, (glong) 0, string_get_length (data->task->data) - 4);
					data->info = (data->_tmp8_ = gtk_icon_theme_lookup_icon (data->self->priv->theme, data->real_name, data->task->size, 0), _gtk_icon_info_free0 (data->info), data->_tmp8_);
					if (data->info != NULL) {
						data->fname = g_strdup (gtk_icon_info_get_filename (data->info));
						data->_state_ = 15;
						unity_pixbuf_cache_load_from_filepath (data->self, data->fname, data->task->size, data->buf, data->buf_length, unity_pixbuf_cache_set_image_from_gicon_string_real_ready, data);
						return FALSE;
						_state_15:
						data->_tmp9_ = unity_pixbuf_cache_load_from_filepath_finish (data->self, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							_g_free0 (data->fname);
							_g_free0 (data->real_name);
							_gtk_icon_info_free0 (data->info);
							goto __catch36_g_error;
						}
						data->ret = (data->_tmp10_ = data->_tmp9_, _g_object_unref0 (data->ret), data->_tmp10_);
						_g_free0 (data->fname);
					}
					_g_free0 (data->real_name);
				}
			}
			_gtk_icon_info_free0 (data->info);
		}
		goto __finally36;
		__catch36_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning (data->_tmp11_ = g_strconcat ("Unable to load icon ", string_to_string (data->task->data), ": '%s'", NULL), data->e->message);
				_g_free0 (data->_tmp11_);
				_g_error_free0 (data->e);
			}
		}
		__finally36:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (GDK_IS_PIXBUF (data->ret)) {
		gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->cache, data->task->key, data->ret);
		ctk_image_set_from_pixbuf (data->task->image, data->ret);
	}
	_g_object_unref0 (data->ret);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_pixbuf_cache_set_image_from_gicon_data_free (gpointer _data) {
	UnityPixbufCacheSetImageFromGiconData* data;
	data = _data;
	_g_object_unref0 (data->image);
	_g_object_unref0 (data->icon);
	g_object_unref (data->self);
	g_slice_free (UnityPixbufCacheSetImageFromGiconData, data);
}


void unity_pixbuf_cache_set_image_from_gicon (UnityPixbufCache* self, CtkImage* image, GIcon* icon, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromGiconData* _data_;
	_data_ = g_slice_new0 (UnityPixbufCacheSetImageFromGiconData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_pixbuf_cache_set_image_from_gicon);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_pixbuf_cache_set_image_from_gicon_data_free);
	_data_->self = g_object_ref (self);
	_data_->image = _g_object_ref0 (image);
	_data_->icon = _g_object_ref0 (icon);
	_data_->size = size;
	unity_pixbuf_cache_set_image_from_gicon_co (_data_);
}


void unity_pixbuf_cache_set_image_from_gicon_finish (UnityPixbufCache* self, GAsyncResult* _res_) {
	UnityPixbufCacheSetImageFromGiconData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_pixbuf_cache_set_image_from_gicon_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPixbufCacheSetImageFromGiconData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_pixbuf_cache_set_image_from_gicon_co (data);
}


/**
     * If @icon is already cached then set it immediately on @image. Otherwise
     * does async IO to load and cache the icon, then setting it on @image.
     *
     * Note that this means that you should treat this method as an async
     * operation for all intents and purposes. You can not count on
     * image.pixbuf != null when this method call returns. That may just as well
     * happen in a subsequent idle call.
     */
static gboolean unity_pixbuf_cache_set_image_from_gicon_co (UnityPixbufCacheSetImageFromGiconData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_pixbuf_cache_set_image_from_gicon_string (data->self, data->image, data->_tmp0_ = g_icon_to_string (data->icon), data->size);
	_g_free0 (data->_tmp0_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_pixbuf_cache_load_from_filepath_data_free (gpointer _data) {
	UnityPixbufCacheLoadFromFilepathData* data;
	data = _data;
	_g_free0 (data->filename);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (UnityPixbufCacheLoadFromFilepathData, data);
}


static void unity_pixbuf_cache_load_from_filepath (UnityPixbufCache* self, const char* filename, gint size, void* buf, gsize buf_length, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPixbufCacheLoadFromFilepathData* _data_;
	_data_ = g_slice_new0 (UnityPixbufCacheLoadFromFilepathData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_pixbuf_cache_load_from_filepath);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_pixbuf_cache_load_from_filepath_data_free);
	_data_->self = g_object_ref (self);
	_data_->filename = g_strdup (filename);
	_data_->size = size;
	_data_->buf = buf;
	_data_->buf_length = buf_length;
	unity_pixbuf_cache_load_from_filepath_co (_data_);
}


static GdkPixbuf* unity_pixbuf_cache_load_from_filepath_finish (UnityPixbufCache* self, GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	UnityPixbufCacheLoadFromFilepathData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_pixbuf_cache_load_from_filepath_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPixbufCacheLoadFromFilepathData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_pixbuf_cache_load_from_filepath_co (data);
}


static gboolean unity_pixbuf_cache_load_from_filepath_co (UnityPixbufCacheLoadFromFilepathData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 16:
		goto _state_16;
		case 17:
		goto _state_17;
		case 18:
		goto _state_18;
	}
	_state_0:
	if (data->filename != NULL) {
		data->datafile = g_file_new_for_path (data->filename);
		data->_state_ = 16;
		g_file_query_info_async (data->datafile, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, unity_pixbuf_cache_load_from_filepath_ready, data);
		return FALSE;
		_state_16:
		data->info = g_file_query_info_finish (data->datafile, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->datafile);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->mimetype = g_strdup (g_file_info_get_content_type (data->info));
		{
			data->_state_ = 17;
			g_file_read_async (data->datafile, G_PRIORITY_DEFAULT, NULL, unity_pixbuf_cache_load_from_filepath_ready, data);
			return FALSE;
			_state_17:
			data->stream = g_file_read_finish (data->datafile, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
			if (G_IS_FILE_INPUT_STREAM (data->stream)) {
				data->_state_ = 18;
				unity_io_read_stream_async ((GInputStream*) data->stream, data->buf, data->buf_length, G_PRIORITY_DEFAULT, NULL, unity_pixbuf_cache_load_from_filepath_ready, data);
				return FALSE;
				_state_18:
				unity_io_read_stream_finish (data->_res_, &data->data, &data->data_size, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->stream);
					goto __catch37_g_error;
				}
				data->loader = gdk_pixbuf_loader_new_with_mime_type (data->mimetype, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->stream);
					goto __catch37_g_error;
				}
				gdk_pixbuf_loader_write (data->loader, (guchar*) data->data, data->data_size, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->loader);
					_g_object_unref0 (data->stream);
					goto __catch37_g_error;
				}
				gdk_pixbuf_loader_close (data->loader, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->loader);
					_g_object_unref0 (data->stream);
					goto __catch37_g_error;
				}
				g_free (data->data);
				data->result = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (data->loader));
				_g_object_unref0 (data->loader);
				_g_object_unref0 (data->stream);
				_g_free0 (data->mimetype);
				_g_object_unref0 (data->info);
				_g_object_unref0 (data->datafile);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->loader);
			}
			_g_object_unref0 (data->stream);
		}
		goto __finally37;
		__catch37_g_error:
		{
			data->ee = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("unity-pixbuf-cache.vala:422: Unable to load image file '%s': %s", data->filename, data->ee->message);
				_g_error_free0 (data->ee);
			}
		}
		__finally37:
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->mimetype);
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->datafile);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_free0 (data->mimetype);
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->datafile);
	}
	data->result = NULL;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


guint unity_pixbuf_cache_get_size (UnityPixbufCache* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) gee_map_get_size ((GeeMap*) self->priv->cache);
	return result;
}


static GObject * unity_pixbuf_cache_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPixbufCache * self;
	parent_class = G_OBJECT_CLASS (unity_pixbuf_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PIXBUF_CACHE (obj);
	{
		GeeQueue* _tmp0_;
		GeeHashMap* _tmp1_;
		self->priv->queue = (_tmp0_ = (GeeQueue*) gee_linked_list_new (UNITY_TYPE_PIXBUF_CACHE_TASK, (GBoxedCopyFunc) unity_pixbuf_cache_task_ref, unity_pixbuf_cache_task_unref, NULL), _g_object_unref0 (self->priv->queue), _tmp0_);
		self->priv->theme = gtk_icon_theme_get_default ();
		self->priv->cache = (_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDK_TYPE_PIXBUF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->cache), _tmp1_);
	}
	return obj;
}


static void unity_pixbuf_cache_class_init (UnityPixbufCacheClass * klass) {
	unity_pixbuf_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPixbufCachePrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_pixbuf_cache_get_property;
	G_OBJECT_CLASS (klass)->constructor = unity_pixbuf_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_pixbuf_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PIXBUF_CACHE_SIZE, g_param_spec_uint ("size", "size", "size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_pixbuf_cache_instance_init (UnityPixbufCache * self) {
	self->priv = UNITY_PIXBUF_CACHE_GET_PRIVATE (self);
	self->priv->autodispose = FALSE;
	self->priv->queue_source = (guint) 0;
}


static void unity_pixbuf_cache_finalize (GObject* obj) {
	UnityPixbufCache * self;
	self = UNITY_PIXBUF_CACHE (obj);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->queue);
	G_OBJECT_CLASS (unity_pixbuf_cache_parent_class)->finalize (obj);
}


GType unity_pixbuf_cache_get_type (void) {
	static volatile gsize unity_pixbuf_cache_type_id__volatile = 0;
	if (g_once_init_enter (&unity_pixbuf_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPixbufCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_pixbuf_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPixbufCache), 0, (GInstanceInitFunc) unity_pixbuf_cache_instance_init, NULL };
		GType unity_pixbuf_cache_type_id;
		unity_pixbuf_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPixbufCache", &g_define_type_info, 0);
		g_once_init_leave (&unity_pixbuf_cache_type_id__volatile, unity_pixbuf_cache_type_id);
	}
	return unity_pixbuf_cache_type_id__volatile;
}


static void unity_pixbuf_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPixbufCache * self;
	self = UNITY_PIXBUF_CACHE (object);
	switch (property_id) {
		case UNITY_PIXBUF_CACHE_SIZE:
		g_value_set_uint (value, unity_pixbuf_cache_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




