#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <glade/glade.h>
#include <libnotify/notify.h>

#include "update-notifier.h"
#include "update.h"
#include "gdm-logout-action.h"

static GladeXML *xml;

static gboolean
show_notification (TrayApplet *ta)
{
	NotifyNotification *n;

	GdkRectangle area;
	gtk_status_icon_get_geometry(ta->tray_icon, NULL, &area, NULL);

	// no usefull coordiante yet, do another timeout
	if(area.x <= 0 || area.y <= 0 || area.width <= 0 || area.height <= 0)
	   return TRUE;

	// only show once the icon is realy availabe
	if(!gtk_status_icon_get_visible(ta->tray_icon))
	   return TRUE;

	/* Create and show the notification */
	n = notify_notification_new_with_status_icon(
				     _("System restart required"),
				     _("To complete the update of your system, "
				       "please restart it.\n\n"
				       "Click on the notification icon for "
				       "details."),
				     GTK_STOCK_DIALOG_WARNING,
				     ta->tray_icon);
	notify_notification_set_timeout (n, 60000);
	notify_notification_show (n, NULL);
	g_object_set_data (G_OBJECT(ta->tray_icon), "notification", n);

	return FALSE;
}

static void
request_reboot (void)
{
	GnomeClient *client;

	client = gnome_master_client ();
	g_return_if_fail (client != NULL);

	/* set gdm logout action */
	gdm_set_logout_action(GDM_LOGOUT_ACTION_REBOOT);

	/* Tell gnome-session to save and exit the session without asking
	 * the user. */
	gnome_client_request_save (client,
				   GNOME_SAVE_GLOBAL,
				   TRUE,
				   GNOME_INTERACT_ANY,
				   TRUE,
				   TRUE);
}


static void
ask_reboot_required(TrayApplet *ta, gboolean focus_on_map)
{
   GtkWidget *dia;
   
   dia = glade_xml_get_widget (xml, "dialog_reboot");
   gtk_window_set_focus_on_map(GTK_WINDOW(dia), focus_on_map);
   if (gtk_dialog_run (GTK_DIALOG(dia)) == GTK_RESPONSE_OK)
      request_reboot ();
   gtk_widget_hide (dia);
}

gboolean
reboot_check (TrayApplet *ta)
{
        static gboolean already_asked_for_reboot = FALSE;
	struct stat statbuf;

	/* If the file doesn't exist, we don't need to reboot */
	if (stat (REBOOT_FILE, &statbuf)) {
		NotifyNotification *n;

		gtk_status_icon_set_visible (ta->tray_icon, FALSE);
		/* Hide any notification popup */
		n = g_object_get_data (G_OBJECT(ta->tray_icon), "notification");
		if (n)
			notify_notification_close (n, NULL);
		g_object_set_data (G_OBJECT(ta->tray_icon), "notification", NULL);

		return TRUE;
	}

	// check if we are in auto-launch dialog/apps mode
	if(gconf_client_get_bool((GConfClient*) ta->user_data,
				 GCONF_KEY_AUTO_LAUNCH, NULL)) {
	   if (!already_asked_for_reboot)
	      ask_reboot_required(ta, FALSE);
	   already_asked_for_reboot = TRUE;
	   return TRUE;
	}

	/* Skip the rest if the icon is already visible */
	if (gtk_status_icon_get_visible (ta->tray_icon))
	   return TRUE;

	gtk_status_icon_set_tooltip (ta->tray_icon,  
				     _("System restart required"));
	gtk_status_icon_set_visible (ta->tray_icon, TRUE);

	/* Check whether the user doesn't like notifications */
	if (gconf_client_get_bool ((GConfClient*) ta->user_data,
				   GCONF_KEY_NO_UPDATE_NOTIFICATIONS, NULL))
		return TRUE;

	/* Show the notification, after a delay so it doesn't look ugly
	 * if we've just logged in */
	g_timeout_add(5000, (GSourceFunc)(show_notification), ta);

	return TRUE;
}

static gboolean
button_release_cb (GtkWidget *widget,
		   TrayApplet *ta)
{
   ask_reboot_required(ta, TRUE);

   return TRUE;
}


void
reboot_tray_icon_init (TrayApplet *ta)
{
	GtkWidget *widget;

	xml = glade_xml_new (GLADEDIR"reboot-dialog.glade", NULL, NULL);

	widget = glade_xml_get_widget (xml, "image");
	GtkIconTheme* icon_theme = gtk_icon_theme_get_default();
	GdkPixbuf *pixbuf = gtk_icon_theme_load_icon (icon_theme, "un-reboot",
						      48, 0,NULL);
	gtk_status_icon_set_from_pixbuf (ta->tray_icon, pixbuf);
	ta->user_data = gconf_client_get_default();

        g_signal_connect (G_OBJECT(ta->tray_icon),
			  "activate",
			  G_CALLBACK (button_release_cb),
			  ta);

	gtk_image_set_from_pixbuf(GTK_IMAGE(widget), pixbuf);

	/* Check for updates for the first time */
	reboot_check (ta);
}
