/**
 * geis_xcb.h
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_XCB_H_
#define GEIS_XCB_H_

#include "geis_config.h"
#include <geis/geis.h>

typedef struct _GeisXcb *GeisXcb;

GeisXcb geis_xcb_new(GeisXcbWinInfo *win_info);

GeisInstance geis_xcb_create_instance(GeisXcb xcb, uint32_t window_id);

GeisStatus geis_xcb_input_devices(GeisXcb         xcb,
                                  GeisInputFuncs *funcs,
                                  void           *cookie);

GeisStatus geis_xcb_subscribe(GeisXcb      xcb,
                              GeisInstance instance,
                              uint16_t     device_id,
                              const char **gesture_list);

int geis_xcb_fd(GeisXcb xcb);

void geis_xcb_dispatch(GeisXcb xcb);

void geis_xcb_free(GeisXcb xcb);

#endif /* GEIS_XCB_H_ */
