#
# @file geisview/deviceview.py
# @brief Device viewer for geisview.
#
# Copyright (C) 2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import pygtk
pygtk.require('2.0')
import gtk

class DeviceView(gtk.Window):

    def __init__(self, devices):
        gtk.Window.__init__(self)
        self.set_title("GEIS Devices")
        self.set_size_request(200, 200)

        self._devices = devices
        self._tree_store = gtk.TreeStore(str)
        for device in devices:
            it = self._tree_store.append(None, ["%s" % device])
        self._tree_view = gtk.TreeView(self._tree_store)
#        self._tree_view.set_mode(gtk.SELECTION_SINGLE)
        cell = gtk.CellRendererText()
        col = gtk.TreeViewColumn('Label')
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 0)
        self._tree_view.append_column(col)

        self.add(self._tree_view)
        self.show_all()

