/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) a 2009 <a@a>
 * 
 * callbacks.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * callbacks.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "common.h"

extern gboolean update_gconf (gchar*);
extern void select_gconf_wp (GtkIconView *icon_view);


void
on_iconview1_selection_changed (GtkIconView *icon_view,
								gpointer data)
{
	GList *selection;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *name;
	
	g_print ("callback iconview1_selection_changed_cb()\n");

	selection = gtk_icon_view_get_selected_items(icon_view);

	if (selection)
	{
		model = gtk_icon_view_get_model (GTK_ICON_VIEW (icon_view));
		gtk_tree_model_get_iter (model, &iter, selection->data);
		gtk_tree_model_get (model, &iter, COL_NAME, &name, -1);

		g_print ("iconview1_item_activated_cb() name[%s]\n",name);
		update_gconf (name);
		
		g_free (name);
		g_list_foreach (selection, (GFunc) gtk_tree_path_free, NULL);
		g_list_free (selection);
	}
	else
	{
		g_print ("I choose the range outside.\n");
		select_gconf_wp(icon_view);
	}
}

void
on_button1_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_button1_clicked\n");
	gtk_widget_destroy (dialog);
}

void
destroy (GtkWidget *widget, gpointer data)
{
	g_print ("callback destroy\n");
	gtk_main_quit ();
}
