#!/bin/bash
# set -x #for debugging
source yourpath/file_paths.sh

check_values()
{
    grep ^User $TP
    grep ^Group $TP
    grep ^Port $TP
}

if [ $# -ne 3 ]
then
	echo "============="
        echo "usage :"
        echo "set values : `basename $0` USER GROUP PORT"
        echo "check values : `basename $0`"
	echo "============="
	check_values
	exit 0
fi

USER=$1
GROUP=$2
PORT=$3

sed -i "s/^User.*/User $USER/" $TP >/dev/null
sed -i "s/^Group.*/Group $GROUP/" $TP >/dev/null
sed -i "s/^Port.*/Port $PORT/" $TP >/dev/null

check_values
