# -.- coding: utf-8 -.-

# Zeitgeist
#
# By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>, 2010
#
# This script is free software. It comes without any warranty, to
# the extent permitted by applicable law. You can redistribute it
# and/or modify it under the following terms:
#   0. You just DO WHAT THE FUCK YOU WANT TO.

import sys

from zeitgeist.datamodel import TimeRange, StorageState, ResultType, Event
from zeitgeist.client import ZeitgeistDBusInterface

iface = ZeitgeistDBusInterface().get_extension("Log", "geolocation")

if len(sys.argv) != 2 or sys.argv[1] not in ("1", "2"):
    print "Usage: %s [operation]" % sys.argv[0]
    print "Possible values for operation:"
    print " - 1: Test FindEventsForLocations"
    print " - 2: Test FindLocationsForEvents"

elif sys.argv[1] == "1":

    position = (0, 0, 90)  # longitude, latitude, radius
    event_templates = []   # no restrictions
    num_events = 0         # 0 = no limit

    results = iface.FindEventsForLocations(position, TimeRange.always(),
        event_templates, StorageState.Any, num_events,
        ResultType.MostRecentSubjects)

    for result in results:
        event = Event.new_for_struct(result[:3])
        geoposition = [float(p) for p in result[3]]
        print "Event %d (1st subject: \"%s\") at position: (%f-%f,%f-%f)" % \
            tuple([int(event.id), event.get_subjects()[0].uri] + geoposition)

elif sys.argv[1] == "2":
    print iface.FindLocationsForEvents((1, 2, 47109))
