/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class Compile {
    private TransformerFactoryImpl factory = new TransformerFactoryImpl();
    private boolean showTime = false;
    private boolean debug = false;

    public static void main(String[] stringArray) throws Exception {
        new Compile().doMain(stringArray);
    }

    protected void doMain(String[] stringArray) {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            Source source;
            int n = 0;
            while (true) {
                String string;
                if (n >= stringArray.length) {
                    this.badUsage("No stylesheet file name");
                }
                if (stringArray[n].charAt(0) != '-') break;
                if (stringArray[n].equals("-u")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-t")) {
                    System.err.println(this.factory.getConfiguration().getProductTitle());
                    System.err.println(Configuration.getPlatform().getPlatformVersion());
                    this.factory.setAttribute("http://saxon.sf.net/feature/timing", Boolean.TRUE);
                    this.showTime = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-y")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage("No style parser class");
                    }
                    string = stringArray[n++];
                    this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", string);
                    continue;
                }
                if (stringArray[n].equals("-r")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage("No URIResolver class");
                    }
                    string = stringArray[n++];
                    this.factory.setURIResolver(this.factory.getConfiguration().makeURIResolver(string));
                    continue;
                }
                if (stringArray[n].equals("-debug")) {
                    ++n;
                    this.debug = true;
                    continue;
                }
                if (stringArray[n].equals("-1.1")) {
                    ++n;
                    this.factory.setAttribute("http://saxon.sf.bet/feature/xml-version", "1.1");
                    continue;
                }
                this.badUsage("Unknown option " + stringArray[n]);
            }
            if (stringArray.length < n + 1) {
                this.badUsage("No stylesheet file name");
            }
            String string = stringArray[n++];
            if (stringArray.length < n + 1) {
                this.badUsage("No output file name");
            }
            String string2 = stringArray[n++];
            long l = new Date().getTime();
            if (bl || string.startsWith("http:") || string.startsWith("file:")) {
                source = this.factory.getURIResolver().resolve(string, null);
                if (source == null) {
                    source = this.factory.getConfiguration().getSystemURIResolver().resolve(string, null);
                }
            } else {
                object2 = new File(string);
                if (!((File)object2).exists()) {
                    Compile.quit("Stylesheet file " + object2 + " does not exist", 2);
                }
                object = new InputSource(((File)object2).toURL().toString());
                source = new SAXSource(this.factory.getConfiguration().getStyleParser(), (InputSource)object);
            }
            if (source == null) {
                Compile.quit("URIResolver for stylesheet file must return a Source", 2);
            }
            object2 = this.factory.newTemplates(source);
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Stylesheet compilation time: " + (l2 - l) + " milliseconds");
            }
            try {
                object = ((PreparedStylesheet)object2).getExecutable().getReasonUnableToCompile();
                if (object != null) {
                    System.err.println((String)object);
                    Compile.quit("Unable to compile stylesheet", 2);
                }
                System.err.println("Serializing compiled stylesheet");
                ((PreparedStylesheet)object2).setTargetNamePool(((PreparedStylesheet)object2).getConfiguration().getNamePool());
                OutputStream outputStream = new FileOutputStream(string2);
                if (this.debug) {
                    outputStream = new TracingObjectOutputStream(outputStream);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object2);
                objectOutputStream.close();
                System.err.println("Finished serializing stylesheet");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (TerminationException terminationException) {
            Compile.quit(terminationException.getMessage(), 1);
        }
        catch (XPathException xPathException) {
            Compile.quit("Stylesheet compilation failed: " + xPathException.getMessage(), 2);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Compile.quit("Stylesheet compilation failed: " + transformerConfigurationException.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            Compile.quit("Stylesheet compilation failed: " + transformerFactoryConfigurationError.getMessage(), 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    protected void badUsage(String string) {
        System.err.println(string);
        System.err.println(this.factory.getConfiguration().getProductTitle());
        System.err.println("Usage: java net.sf.saxon.Compile [options] stylesheet-file output-file");
        System.err.println("Options: ");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet");
        System.err.println("  -debug          Produce trace output to diagnose failures");
        System.err.println("  -1.1            Allow XML 1.1 documents");
        System.err.println("  -?              Display this message ");
        System.exit(2);
    }

    private static class TracingObjectOutputStream
    extends FilterOutputStream {
        OutputStream oos;

        public TracingObjectOutputStream(OutputStream outputStream) {
            super(outputStream);
            this.oos = outputStream;
        }

        public void write(byte[] byArray) throws IOException {
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            String string = new String(cArray);
            if (string.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + string);
            }
            super.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)byArray[i + n];
            }
            String string = new String(cArray);
            if (string.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + string);
            }
            super.write(byArray, n, n2);
        }
    }
}

