/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class XPathExpression {
    private XPathEvaluator evaluator;
    private Expression expression;
    private SlotManager stackFrameMap;
    private int numberOfExternalVariables;

    protected XPathExpression(XPathEvaluator xPathEvaluator, Expression expression) {
        this.expression = expression;
        this.evaluator = xPathEvaluator;
    }

    protected void setStackFrameMap(SlotManager slotManager, int n) {
        this.stackFrameMap = slotManager;
        this.numberOfExternalVariables = n;
    }

    public XPathDynamicContext createDynamicContext(Item item) {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(item, this.evaluator.getExecutable());
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        return new XPathDynamicContext(xPathContextMajor);
    }

    public SequenceIterator iterate(XPathDynamicContext xPathDynamicContext) throws XPathException {
        xPathDynamicContext.checkExternalVariables(this.stackFrameMap, this.numberOfExternalVariables);
        return this.expression.iterate(xPathDynamicContext.getXPathContextObject());
    }

    public List evaluate(XPathDynamicContext xPathDynamicContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.expression.iterate(xPathDynamicContext.getXPathContextObject());
        ArrayList<Item> arrayList = new ArrayList<Item>(20);
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(item);
        }
        return arrayList;
    }

    public Item evaluateSingle(XPathDynamicContext xPathDynamicContext) throws XPathException {
        return this.expression.evaluateItem(xPathDynamicContext.getXPathContextObject());
    }

    public List evaluate(Source source) throws XPathException {
        NodeInfo nodeInfo = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext xPathDynamicContext = this.createDynamicContext(nodeInfo);
        SequenceIterator sequenceIterator = this.iterate(xPathDynamicContext);
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        List list = (List)sequenceExtent.convertToJava(List.class, xPathDynamicContext.getXPathContextObject());
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public Object evaluateSingle(Source source) throws XPathException {
        SequenceIterator sequenceIterator = this.rawIterator(source);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert(item);
    }

    public SequenceIterator rawIterator(Source source) throws XPathException {
        NodeInfo nodeInfo = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext xPathDynamicContext = this.createDynamicContext(nodeInfo);
        return this.iterate(xPathDynamicContext);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

