#!/bin/bash

KERNELVER=$1
KERNELVER_BASE=${KERNELVER%%-*}

version_lt () {
    newest=$((echo "$1"; echo "$2") | sort -V | tail -n1)
    [ "$1" != "$newest" ]
}

version_ge () {
    newest=$((echo "$1"; echo "$2") | sort -V | tail -n1)
    [ "$1" = "$newest" ]
}

version_gt () {
    oldest=$((echo "$1"; echo "$2") | sort -V | head -n1)
    [ "$1" != "$oldest" ]
}

version_le () {
    oldest=$((echo "$1"; echo "$2") | sort -V | head -n1)
    [ "$1" = "$oldest" ]
}

source amd/backport/symbols

echo '// auto generated by DKMS pre-build.sh' > amd/backport/symbols.c
for sym in $SYMS; do
    addr=$(grep $sym /boot/System.map-$KERNELVER | awk -F' ' '{print $1}')
    echo "void *$sym = (void *)0x$addr;" >> amd/backport/symbols.c
done
