#!/bin/sh
#
# Regenerate the indexes in a pool
#
# Author: Steve Magoun <steve.magoun@canonical.com>

set -e

if [ "x$1" = "x" ]; then
    BASEDIR=/media/OEM_BUILD
else
    BASEDIR="$1"
fi

if [ ! -d "${BASEDIR}" ]; then
    echo "BASEDIR ${BASEDIR} not found!"
    exit 1
fi

DEBFILE="config-deb"
UDEBFILE="config-udeb"
RELFILE="config-rel"
INDICIES="indicies"
SUITE="jaunty"
ARCH="i386"

write_config_deb() {
    FILE="${DEBFILE}"
    if [ -f "${FILE}" ]; then
	mv "${FILE}" "${FILE}.bak"
    fi
    cat > "${FILE}" <<EOF
Dir {
    ArchiveDir "${BASEDIR}";
    OverrideDir "${INDICIES}";
    CacheDir "${INDICIES}";
 };
            
 TreeDefault {
    Directory "pool/";
 };
                    
 BinDirectory "pool/main" {
    Packages "dists/${SUITE}/main/binary-${ARCH}/Packages";
 };
                                   
 Default {
    Packages {
        Extensions ".deb";
    };
 };

EOF
}

write_config_udeb() {
    FILE="${UDEBFILE}"
    if [ -f "${FILE}" ]; then
	mv "${FILE}" "${FILE}.bak"
    fi
    cat > "${FILE}" <<EOF
 Dir {
    ArchiveDir "${BASEDIR}";
    OverrideDir "${INDICIES}";
    CacheDir "${INDICIES}";
 };
            
 TreeDefault {
    Directory "pool/";
 };
                    
 BinDirectory "pool/main" {
    Packages "dists/${SUITE}/main/debian-installer/binary-${ARCH}/Packages";
 };
                                   
 Default {
    Packages {
        Extensions ".udeb";
    };
 };

EOF
}

write_config_rel() {
    FILE="${RELFILE}"
    if [ -f "${FILE}" ]; then
	mv "${FILE}" "${FILE}.bak"
    fi
    cat > "${FILE}" <<EOF
APT::FTPArchive::Release::Codename "${SUITE}";
APT::FTPArchive::Release::Origin "Debian";
APT::FTPArchive::Release::Components "main";
APT::FTPArchive::Release::Label "Debian";
APT::FTPArchive::Release::Architectures "${ARCH}";
APT::FTPArchive::Release::Suite "${SUITE}";
EOF
}

TMPDIR=`mktemp -d` || exit 1
cd "${TMPDIR}"
mkdir -p "${INDICIES}"
write_config_deb
write_config_udeb
write_config_rel
apt-ftparchive generate "${UDEBFILE}"
apt-ftparchive generate "${DEBFILE}"
apt-ftparchive -c "${RELFILE}" release ${BASEDIR}/dists/${SUITE} > ${BASEDIR}/dists/${SUITE}/Release
cd -
rm -rf "${TMPDIR}"
sync
