#! /bin/sh
#
# Reorder grub entries on existing systems
# so that the edubuntu recovery option is last,
# and separated from the OS options.
#
# Optional argument is path to grub's menu.lst

set -e

MENU=/boot/grub/menu.lst
if [ "$1" != "" ]; then
    MENU="$1"
fi

# Some tools may not be available in the installer;
# assume they're on disk
AWK=/usr/bin/awk
if [ ! -x "$AWK" ]; then
    # awk uses /etc/alternatives
    AWK=/target/usr/bin/mawk
fi
SED=/bin/sed
if [ ! -x "$SED" ]; then
    SED=/target/bin/sed
fi
GREP=/bin/grep
if [ ! -x "$GREP" ]; then
    GREP=/target/bin/grep
fi


if [ -f "$MENU" ]; then
    EDU_RECOVERY="$(cat $MENU | ${AWK} '/^title[ \t]*Recover Edubuntu/,/^$/')"
    WIN_RECOVERY="$(cat $MENU | ${AWK} '/^title[ \t]*\@Windows/,/^$/')"
    DUMMY_GREP="^title -$"
    DUMMY_BLOCK="title -
root"

    COUNT=$(${GREP} -c "$DUMMY_GREP" "$MENU" || true)
    if [ "$COUNT" = 0 ]; then
        if [ "$EDU_RECOVERY" != "" -a "$WIN_RECOVERY" != "" ]; then
	    cp "$MENU" "${MENU}.athens-config.bak"
	    # Clobber the existing recovery options, replace /w
	    # our reordered versions
            # These sed expressions should match the awk regexps above
            ${SED} -i '/^title[ \t]*Recover Edubuntu/,/^$/d' "$MENU"
            ${SED} -i '/^title[ \t]*\@Windows/,/^$/d' "$MENU"
            cat >> "$MENU" << EOF
$DUMMY_BLOCK

$EDU_RECOVERY

$WIN_RECOVERY
EOF
        fi
    fi
fi

