// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2005 Novell, Inc. (http://www.novell.com)
//
// Authors:
//	Peter Bartok	(pbartok@novell.com)
//
//

// COMPLETE

namespace System.Windows.Forms.RTF {
	internal class KeysInit {
		public static KeyStruct[] Init() {
			return new KeyStruct[] {
					new KeyStruct(Major.SpecialChar, Minor.IIntVersion, "vern"),
					new KeyStruct(Major.SpecialChar, Minor.ICreateTime, "creatim"),
					new KeyStruct(Major.SpecialChar, Minor.IRevisionTime, "revtim"),
					new KeyStruct(Major.SpecialChar, Minor.IPrintTime, "printim"),
					new KeyStruct(Major.SpecialChar, Minor.IBackupTime, "buptim"),
					new KeyStruct(Major.SpecialChar, Minor.IEditTime, "edmins"),
					new KeyStruct(Major.SpecialChar, Minor.IYear, "yr"),
					new KeyStruct(Major.SpecialChar, Minor.IMonth, "mo"),
					new KeyStruct(Major.SpecialChar, Minor.IDay, "dy"),
					new KeyStruct(Major.SpecialChar, Minor.IHour, "hr"),
					new KeyStruct(Major.SpecialChar, Minor.IMinute, "min"),
					new KeyStruct(Major.SpecialChar, Minor.ISecond, "sec"),
					new KeyStruct(Major.SpecialChar, Minor.INPages, "nofpages"),
					new KeyStruct(Major.SpecialChar, Minor.INWords, "nofwords"),
					new KeyStruct(Major.SpecialChar, Minor.INChars, "nofchars"),
					new KeyStruct(Major.SpecialChar, Minor.IIntID, "id"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadDate, "chdate"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadDateLong, "chdpl"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadDateAbbrev, "chdpa"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadTime, "chtime"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadPage, "chpgn"),
					new KeyStruct(Major.SpecialChar, Minor.SectNum, "sectnum"),
					new KeyStruct(Major.SpecialChar, Minor.CurFNote, "chftn"),
					new KeyStruct(Major.SpecialChar, Minor.CurAnnotRef, "chatn"),
					new KeyStruct(Major.SpecialChar, Minor.FNoteSep, "chftnsep"),
					new KeyStruct(Major.SpecialChar, Minor.FNoteCont, "chftnsepc"),
					new KeyStruct(Major.SpecialChar, Minor.Cell, "cell"),
					new KeyStruct(Major.SpecialChar, Minor.Row, "row"),
					new KeyStruct(Major.SpecialChar, Minor.Par, "par"),
					new KeyStruct(Major.SpecialChar, Minor.Par, "\n"),
					new KeyStruct(Major.SpecialChar, Minor.Par, "\r"),
					new KeyStruct(Major.SpecialChar, Minor.Sect, "sect"),
					new KeyStruct(Major.SpecialChar, Minor.Page, "page"),
					new KeyStruct(Major.SpecialChar, Minor.Column, "column"),
					new KeyStruct(Major.SpecialChar, Minor.Line, "line"),
					new KeyStruct(Major.SpecialChar, Minor.SoftPage, "softpage"),
					new KeyStruct(Major.SpecialChar, Minor.SoftColumn, "softcol"),
					new KeyStruct(Major.SpecialChar, Minor.SoftLine, "softline"),
					new KeyStruct(Major.SpecialChar, Minor.SoftLineHt, "softlheight"),
					new KeyStruct(Major.SpecialChar, Minor.Tab, "tab"),
					new KeyStruct(Major.SpecialChar, Minor.EmDash, "emdash"),
					new KeyStruct(Major.SpecialChar, Minor.EnDash, "endash"),
					new KeyStruct(Major.SpecialChar, Minor.EmSpace, "emspace"),
					new KeyStruct(Major.SpecialChar, Minor.EnSpace, "enspace"),
					new KeyStruct(Major.SpecialChar, Minor.Bullet, "bullet"),
					new KeyStruct(Major.SpecialChar, Minor.LQuote, "lquote"),
					new KeyStruct(Major.SpecialChar, Minor.RQuote, "rquote"),
					new KeyStruct(Major.SpecialChar, Minor.LDblQuote, "ldblquote"),
					new KeyStruct(Major.SpecialChar, Minor.RDblQuote, "rdblquote"),
					new KeyStruct(Major.SpecialChar, Minor.Formula, "|"),
					new KeyStruct(Major.SpecialChar, Minor.NoBrkSpace, "~"),
					new KeyStruct(Major.SpecialChar, Minor.NoReqHyphen, "-"),
					new KeyStruct(Major.SpecialChar, Minor.NoBrkHyphen, "_"),
					new KeyStruct(Major.SpecialChar, Minor.LTRMark, "ltrmark"),
					new KeyStruct(Major.SpecialChar, Minor.RTLMark, "rtlmark"),
					new KeyStruct(Major.SpecialChar, Minor.NoWidthJoiner, "zwj"),
					new KeyStruct(Major.SpecialChar, Minor.NoWidthNonJoiner, "zwnj"),
					new KeyStruct(Major.SpecialChar, Minor.CurHeadPict, "chpict"),
					new KeyStruct(Major.CharAttr, Minor.Plain, "plain"),
					new KeyStruct(Major.CharAttr, Minor.Bold, "b"),
					new KeyStruct(Major.CharAttr, Minor.AllCaps, "caps"),
					new KeyStruct(Major.CharAttr, Minor.Deleted, "deleted"),
					new KeyStruct(Major.CharAttr, Minor.SubScript, "dn"),
					new KeyStruct(Major.CharAttr, Minor.SubScrShrink, "sub"),
					new KeyStruct(Major.CharAttr, Minor.NoSuperSub, "nosupersub"),
					new KeyStruct(Major.CharAttr, Minor.Expand, "expnd"),
					new KeyStruct(Major.CharAttr, Minor.ExpandTwips, "expndtw"),
					new KeyStruct(Major.CharAttr, Minor.Kerning, "kerning"),
					new KeyStruct(Major.CharAttr, Minor.FontNum, "f"),
					new KeyStruct(Major.CharAttr, Minor.FontSize, "fs"),
					new KeyStruct(Major.CharAttr, Minor.Italic, "i"),
					new KeyStruct(Major.CharAttr, Minor.Outline, "outl"),
					new KeyStruct(Major.CharAttr, Minor.Revised, "revised"),
					new KeyStruct(Major.CharAttr, Minor.RevAuthor, "revauth"),
					new KeyStruct(Major.CharAttr, Minor.RevDTTM, "revdttm"),
					new KeyStruct(Major.CharAttr, Minor.SmallCaps, "scaps"),
					new KeyStruct(Major.CharAttr, Minor.Shadow, "shad"),
					new KeyStruct(Major.CharAttr, Minor.StrikeThru, "strike"),
					new KeyStruct(Major.CharAttr, Minor.Underline, "ul"),
					new KeyStruct(Major.CharAttr, Minor.DotUnderline, "uld"),
					new KeyStruct(Major.CharAttr, Minor.DbUnderline, "uldb"),
					new KeyStruct(Major.CharAttr, Minor.NoUnderline, "ulnone"),
					new KeyStruct(Major.CharAttr, Minor.WordUnderline, "ulw"),
					new KeyStruct(Major.CharAttr, Minor.SuperScript, "up"),
					new KeyStruct(Major.CharAttr, Minor.SuperScrShrink, "super"),
					new KeyStruct(Major.CharAttr, Minor.Invisible, "v"),
					new KeyStruct(Major.CharAttr, Minor.ForeColor, "cf"),
					new KeyStruct(Major.CharAttr, Minor.BackColor, "cb"),
					new KeyStruct(Major.CharAttr, Minor.RTLChar, "rtlch"),
					new KeyStruct(Major.CharAttr, Minor.LTRChar, "ltrch"),
					new KeyStruct(Major.CharAttr, Minor.CharStyleNum, "cs"),
					new KeyStruct(Major.CharAttr, Minor.CharCharSet, "cchs"),
					new KeyStruct(Major.CharAttr, Minor.Language, "lang"),
					new KeyStruct(Major.CharAttr, Minor.Gray, "gray"),
					new KeyStruct(Major.ParAttr, Minor.ParDef, "pard"),
					new KeyStruct(Major.ParAttr, Minor.StyleNum, "s"),
					new KeyStruct(Major.ParAttr, Minor.Hyphenate, "hyphpar"),
					new KeyStruct(Major.ParAttr, Minor.InTable, "intbl"),
					new KeyStruct(Major.ParAttr, Minor.Keep, "keep"),
					new KeyStruct(Major.ParAttr, Minor.NoWidowControl, "nowidctlpar"),
					new KeyStruct(Major.ParAttr, Minor.KeepNext, "keepn"),
					new KeyStruct(Major.ParAttr, Minor.OutlineLevel, "level"),
					new KeyStruct(Major.ParAttr, Minor.NoLineNum, "noline"),
					new KeyStruct(Major.ParAttr, Minor.PBBefore, "pagebb"),
					new KeyStruct(Major.ParAttr, Minor.SideBySide, "sbys"),
					new KeyStruct(Major.ParAttr, Minor.QuadLeft, "ql"),
					new KeyStruct(Major.ParAttr, Minor.QuadRight, "qr"),
					new KeyStruct(Major.ParAttr, Minor.QuadJust, "qj"),
					new KeyStruct(Major.ParAttr, Minor.QuadCenter, "qc"),
					new KeyStruct(Major.ParAttr, Minor.FirstIndent, "fi"),
					new KeyStruct(Major.ParAttr, Minor.LeftIndent, "li"),
					new KeyStruct(Major.ParAttr, Minor.RightIndent, "ri"),
					new KeyStruct(Major.ParAttr, Minor.SpaceBefore, "sb"),
					new KeyStruct(Major.ParAttr, Minor.SpaceAfter, "sa"),
					new KeyStruct(Major.ParAttr, Minor.SpaceBetween, "sl"),
					new KeyStruct(Major.ParAttr, Minor.SpaceMultiply, "slmult"),
					new KeyStruct(Major.ParAttr, Minor.SubDocument, "subdocument"),
					new KeyStruct(Major.ParAttr, Minor.RTLPar, "rtlpar"),
					new KeyStruct(Major.ParAttr, Minor.LTRPar, "ltrpar"),
					new KeyStruct(Major.ParAttr, Minor.TabPos, "tx"),
					new KeyStruct(Major.ParAttr, Minor.TabLeft, "tql"),
					new KeyStruct(Major.ParAttr, Minor.TabRight, "tqr"),
					new KeyStruct(Major.ParAttr, Minor.TabCenter, "tqc"),
					new KeyStruct(Major.ParAttr, Minor.TabDecimal, "tqdec"),
					new KeyStruct(Major.ParAttr, Minor.TabBar, "tb"),
					new KeyStruct(Major.ParAttr, Minor.LeaderDot, "tldot"),
					new KeyStruct(Major.ParAttr, Minor.LeaderHyphen, "tlhyph"),
					new KeyStruct(Major.ParAttr, Minor.LeaderUnder, "tlul"),
					new KeyStruct(Major.ParAttr, Minor.LeaderThick, "tlth"),
					new KeyStruct(Major.ParAttr, Minor.LeaderEqual, "tleq"),
					new KeyStruct(Major.ParAttr, Minor.ParLevel, "pnlvl"),
					new KeyStruct(Major.ParAttr, Minor.ParBullet, "pnlvlblt"),
					new KeyStruct(Major.ParAttr, Minor.ParSimple, "pnlvlbody"),
					new KeyStruct(Major.ParAttr, Minor.ParNumCont, "pnlvlcont"),
					new KeyStruct(Major.ParAttr, Minor.ParNumOnce, "pnnumonce"),
					new KeyStruct(Major.ParAttr, Minor.ParNumAcross, "pnacross"),
					new KeyStruct(Major.ParAttr, Minor.ParHangIndent, "pnhang"),
					new KeyStruct(Major.ParAttr, Minor.ParNumRestart, "pnrestart"),
					new KeyStruct(Major.ParAttr, Minor.ParNumCardinal, "pncard"),
					new KeyStruct(Major.ParAttr, Minor.ParNumDecimal, "pndec"),
					new KeyStruct(Major.ParAttr, Minor.ParNumULetter, "pnucltr"),
					new KeyStruct(Major.ParAttr, Minor.ParNumURoman, "pnucrm"),
					new KeyStruct(Major.ParAttr, Minor.ParNumLLetter, "pnlcltr"),
					new KeyStruct(Major.ParAttr, Minor.ParNumLRoman, "pnlcrm"),
					new KeyStruct(Major.ParAttr, Minor.ParNumOrdinal, "pnord"),
					new KeyStruct(Major.ParAttr, Minor.ParNumOrdinalText, "pnordt"),
					new KeyStruct(Major.ParAttr, Minor.ParNumBold, "pnb"),
					new KeyStruct(Major.ParAttr, Minor.ParNumItalic, "pni"),
					new KeyStruct(Major.ParAttr, Minor.ParNumAllCaps, "pncaps"),
					new KeyStruct(Major.ParAttr, Minor.ParNumSmallCaps, "pnscaps"),
					new KeyStruct(Major.ParAttr, Minor.ParNumUnder, "pnul"),
					new KeyStruct(Major.ParAttr, Minor.ParNumDotUnder, "pnuld"),
					new KeyStruct(Major.ParAttr, Minor.ParNumDbUnder, "pnuldb"),
					new KeyStruct(Major.ParAttr, Minor.ParNumNoUnder, "pnulnone"),
					new KeyStruct(Major.ParAttr, Minor.ParNumWordUnder, "pnulw"),
					new KeyStruct(Major.ParAttr, Minor.ParNumStrikethru, "pnstrike"),
					new KeyStruct(Major.ParAttr, Minor.ParNumForeColor, "pncf"),
					new KeyStruct(Major.ParAttr, Minor.ParNumFont, "pnf"),
					new KeyStruct(Major.ParAttr, Minor.ParNumFontSize, "pnfs"),
					new KeyStruct(Major.ParAttr, Minor.ParNumIndent, "pnindent"),
					new KeyStruct(Major.ParAttr, Minor.ParNumSpacing, "pnsp"),
					new KeyStruct(Major.ParAttr, Minor.ParNumInclPrev, "pnprev"),
					new KeyStruct(Major.ParAttr, Minor.ParNumCenter, "pnqc"),
					new KeyStruct(Major.ParAttr, Minor.ParNumLeft, "pnql"),
					new KeyStruct(Major.ParAttr, Minor.ParNumRight, "pnqr"),
					new KeyStruct(Major.ParAttr, Minor.ParNumStartAt, "pnstart"),
					new KeyStruct(Major.ParAttr, Minor.BorderTop, "brdrt"),
					new KeyStruct(Major.ParAttr, Minor.BorderBottom, "brdrb"),
					new KeyStruct(Major.ParAttr, Minor.BorderLeft, "brdrl"),
					new KeyStruct(Major.ParAttr, Minor.BorderRight, "brdrr"),
					new KeyStruct(Major.ParAttr, Minor.BorderBetween, "brdrbtw"),
					new KeyStruct(Major.ParAttr, Minor.BorderBar, "brdrbar"),
					new KeyStruct(Major.ParAttr, Minor.BorderBox, "box"),
					new KeyStruct(Major.ParAttr, Minor.BorderSingle, "brdrs"),
					new KeyStruct(Major.ParAttr, Minor.BorderThick, "brdrth"),
					new KeyStruct(Major.ParAttr, Minor.BorderShadow, "brdrsh"),
					new KeyStruct(Major.ParAttr, Minor.BorderDouble, "brdrdb"),
					new KeyStruct(Major.ParAttr, Minor.BorderDot, "brdrdot"),
					new KeyStruct(Major.ParAttr, Minor.BorderDot, "brdrdash"),
					new KeyStruct(Major.ParAttr, Minor.BorderHair, "brdrhair"),
					new KeyStruct(Major.ParAttr, Minor.BorderWidth, "brdrw"),
					new KeyStruct(Major.ParAttr, Minor.BorderColor, "brdrcf"),
					new KeyStruct(Major.ParAttr, Minor.BorderSpace, "brsp"),
					new KeyStruct(Major.ParAttr, Minor.Shading, "shading"),
					new KeyStruct(Major.ParAttr, Minor.BgPatH, "bghoriz"),
					new KeyStruct(Major.ParAttr, Minor.BgPatV, "bgvert"),
					new KeyStruct(Major.ParAttr, Minor.FwdDiagBgPat, "bgfdiag"),
					new KeyStruct(Major.ParAttr, Minor.BwdDiagBgPat, "bgbdiag"),
					new KeyStruct(Major.ParAttr, Minor.HatchBgPat, "bgcross"),
					new KeyStruct(Major.ParAttr, Minor.DiagHatchBgPat, "bgdcross"),
					new KeyStruct(Major.ParAttr, Minor.DarkBgPatH, "bgdkhoriz"),
					new KeyStruct(Major.ParAttr, Minor.DarkBgPatV, "bgdkvert"),
					new KeyStruct(Major.ParAttr, Minor.FwdDarkBgPat, "bgdkfdiag"),
					new KeyStruct(Major.ParAttr, Minor.BwdDarkBgPat, "bgdkbdiag"),
					new KeyStruct(Major.ParAttr, Minor.DarkHatchBgPat, "bgdkcross"),
					new KeyStruct(Major.ParAttr, Minor.DarkDiagHatchBgPat, "bgdkdcross"),
					new KeyStruct(Major.ParAttr, Minor.BgPatLineColor, "cfpat"),
					new KeyStruct(Major.ParAttr, Minor.BgPatColor, "cbpat"),
					new KeyStruct(Major.SectAttr, Minor.SectDef, "sectd"),
					new KeyStruct(Major.SectAttr, Minor.ENoteHere, "endnhere"),
					new KeyStruct(Major.SectAttr, Minor.PrtBinFirst, "binfsxn"),
					new KeyStruct(Major.SectAttr, Minor.PrtBin, "binsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectStyleNum, "ds"),
					new KeyStruct(Major.SectAttr, Minor.NoBreak, "sbknone"),
					new KeyStruct(Major.SectAttr, Minor.ColBreak, "sbkcol"),
					new KeyStruct(Major.SectAttr, Minor.PageBreak, "sbkpage"),
					new KeyStruct(Major.SectAttr, Minor.EvenBreak, "sbkeven"),
					new KeyStruct(Major.SectAttr, Minor.OddBreak, "sbkodd"),
					new KeyStruct(Major.SectAttr, Minor.Columns, "cols"),
					new KeyStruct(Major.SectAttr, Minor.ColumnSpace, "colsx"),
					new KeyStruct(Major.SectAttr, Minor.ColumnNumber, "colno"),
					new KeyStruct(Major.SectAttr, Minor.ColumnSpRight, "colsr"),
					new KeyStruct(Major.SectAttr, Minor.ColumnWidth, "colw"),
					new KeyStruct(Major.SectAttr, Minor.ColumnLine, "linebetcol"),
					new KeyStruct(Major.SectAttr, Minor.LineModulus, "linemod"),
					new KeyStruct(Major.SectAttr, Minor.LineDist, "linex"),
					new KeyStruct(Major.SectAttr, Minor.LineStarts, "linestarts"),
					new KeyStruct(Major.SectAttr, Minor.LineRestart, "linerestart"),
					new KeyStruct(Major.SectAttr, Minor.LineRestartPg, "lineppage"),
					new KeyStruct(Major.SectAttr, Minor.LineCont, "linecont"),
					new KeyStruct(Major.SectAttr, Minor.SectPageWid, "pgwsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectPageHt, "pghsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectMarginLeft, "marglsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectMarginRight, "margrsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectMarginTop, "margtsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectMarginBottom, "margbsxn"),
					new KeyStruct(Major.SectAttr, Minor.SectMarginGutter, "guttersxn"),
					new KeyStruct(Major.SectAttr, Minor.SectLandscape, "lndscpsxn"),
					new KeyStruct(Major.SectAttr, Minor.TitleSpecial, "titlepg"),
					new KeyStruct(Major.SectAttr, Minor.HeaderY, "headery"),
					new KeyStruct(Major.SectAttr, Minor.FooterY, "footery"),
					new KeyStruct(Major.SectAttr, Minor.PageStarts, "pgnstarts"),
					new KeyStruct(Major.SectAttr, Minor.PageCont, "pgncont"),
					new KeyStruct(Major.SectAttr, Minor.PageRestart, "pgnrestart"),
					new KeyStruct(Major.SectAttr, Minor.PageNumRight, "pgnx"),
					new KeyStruct(Major.SectAttr, Minor.PageNumTop, "pgny"),
					new KeyStruct(Major.SectAttr, Minor.PageDecimal, "pgndec"),
					new KeyStruct(Major.SectAttr, Minor.PageURoman, "pgnucrm"),
					new KeyStruct(Major.SectAttr, Minor.PageLRoman, "pgnlcrm"),
					new KeyStruct(Major.SectAttr, Minor.PageULetter, "pgnucltr"),
					new KeyStruct(Major.SectAttr, Minor.PageLLetter, "pgnlcltr"),
					new KeyStruct(Major.SectAttr, Minor.PageNumHyphSep, "pgnhnsh"),
					new KeyStruct(Major.SectAttr, Minor.PageNumSpaceSep, "pgnhnsp"),
					new KeyStruct(Major.SectAttr, Minor.PageNumColonSep, "pgnhnsc"),
					new KeyStruct(Major.SectAttr, Minor.PageNumEmdashSep, "pgnhnsm"),
					new KeyStruct(Major.SectAttr, Minor.PageNumEndashSep, "pgnhnsn"),
					new KeyStruct(Major.SectAttr, Minor.TopVAlign, "vertalt"),
					new KeyStruct(Major.SectAttr, Minor.BottomVAlign, "vertalb"),
					new KeyStruct(Major.SectAttr, Minor.CenterVAlign, "vertalc"),
					new KeyStruct(Major.SectAttr, Minor.JustVAlign, "vertalj"),
					new KeyStruct(Major.SectAttr, Minor.RTLSect, "rtlsect"),
					new KeyStruct(Major.SectAttr, Minor.LTRSect, "ltrsect"),
					new KeyStruct(Major.DocAttr, Minor.DefTab, "deftab"),
					new KeyStruct(Major.DocAttr, Minor.HyphHotZone, "hyphhotz"),
					new KeyStruct(Major.DocAttr, Minor.HyphConsecLines, "hyphconsec"),
					new KeyStruct(Major.DocAttr, Minor.HyphCaps, "hyphcaps"),
					new KeyStruct(Major.DocAttr, Minor.HyphAuto, "hyphauto"),
					new KeyStruct(Major.DocAttr, Minor.LineStart, "linestart"),
					new KeyStruct(Major.DocAttr, Minor.FracWidth, "fracwidth"),
					new KeyStruct(Major.DocAttr, Minor.MakeBackup, "makeback"),
					new KeyStruct(Major.DocAttr, Minor.MakeBackup, "makebackup"),
					new KeyStruct(Major.DocAttr, Minor.RTFDefault, "defformat"),
					new KeyStruct(Major.DocAttr, Minor.PSOverlay, "psover"),
					new KeyStruct(Major.DocAttr, Minor.DocTemplate, "doctemp"),
					new KeyStruct(Major.DocAttr, Minor.DefLanguage, "deflang"),
					new KeyStruct(Major.DocAttr, Minor.FENoteType, "fet"),
					new KeyStruct(Major.DocAttr, Minor.FNoteEndSect, "endnotes"),
					new KeyStruct(Major.DocAttr, Minor.FNoteEndDoc, "enddoc"),
					new KeyStruct(Major.DocAttr, Minor.FNoteText, "ftntj"),
					new KeyStruct(Major.DocAttr, Minor.FNoteBottom, "ftnbj"),
					new KeyStruct(Major.DocAttr, Minor.ENoteEndSect, "aendnotes"),
					new KeyStruct(Major.DocAttr, Minor.ENoteEndDoc, "aenddoc"),
					new KeyStruct(Major.DocAttr, Minor.ENoteText, "aftntj"),
					new KeyStruct(Major.DocAttr, Minor.ENoteBottom, "aftnbj"),
					new KeyStruct(Major.DocAttr, Minor.FNoteStart, "ftnstart"),
					new KeyStruct(Major.DocAttr, Minor.ENoteStart, "aftnstart"),
					new KeyStruct(Major.DocAttr, Minor.FNoteRestartPage, "ftnrstpg"),
					new KeyStruct(Major.DocAttr, Minor.FNoteRestart, "ftnrestart"),
					new KeyStruct(Major.DocAttr, Minor.FNoteRestartCont, "ftnrstcont"),
					new KeyStruct(Major.DocAttr, Minor.ENoteRestart, "aftnrestart"),
					new KeyStruct(Major.DocAttr, Minor.ENoteRestartCont, "aftnrstcont"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumArabic, "ftnnar"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumLLetter, "ftnnalc"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumULetter, "ftnnauc"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumLRoman, "ftnnrlc"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumURoman, "ftnnruc"),
					new KeyStruct(Major.DocAttr, Minor.FNoteNumChicago, "ftnnchi"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumArabic, "aftnnar"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumLLetter, "aftnnalc"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumULetter, "aftnnauc"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumLRoman, "aftnnrlc"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumURoman, "aftnnruc"),
					new KeyStruct(Major.DocAttr, Minor.ENoteNumChicago, "aftnnchi"),
					new KeyStruct(Major.DocAttr, Minor.PaperWidth, "paperw"),
					new KeyStruct(Major.DocAttr, Minor.PaperHeight, "paperh"),
					new KeyStruct(Major.DocAttr, Minor.PaperSize, "psz"),
					new KeyStruct(Major.DocAttr, Minor.LeftMargin, "margl"),
					new KeyStruct(Major.DocAttr, Minor.RightMargin, "margr"),
					new KeyStruct(Major.DocAttr, Minor.TopMargin, "margt"),
					new KeyStruct(Major.DocAttr, Minor.BottomMargin, "margb"),
					new KeyStruct(Major.DocAttr, Minor.FacingPage, "facingp"),
					new KeyStruct(Major.DocAttr, Minor.GutterWid, "gutter"),
					new KeyStruct(Major.DocAttr, Minor.MirrorMargin, "margmirror"),
					new KeyStruct(Major.DocAttr, Minor.Landscape, "landscape"),
					new KeyStruct(Major.DocAttr, Minor.PageStart, "pgnstart"),
					new KeyStruct(Major.DocAttr, Minor.WidowCtrl, "widowctrl"),
					new KeyStruct(Major.DocAttr, Minor.LinkStyles, "linkstyles"),
					new KeyStruct(Major.DocAttr, Minor.NoAutoTabIndent, "notabind"),
					new KeyStruct(Major.DocAttr, Minor.WrapSpaces, "wraptrsp"),
					new KeyStruct(Major.DocAttr, Minor.PrintColorsBlack, "prcolbl"),
					new KeyStruct(Major.DocAttr, Minor.NoExtraSpaceRL, "noextrasprl"),
					new KeyStruct(Major.DocAttr, Minor.NoColumnBalance, "nocolbal"),
					new KeyStruct(Major.DocAttr, Minor.CvtMailMergeQuote, "cvmme"),
					new KeyStruct(Major.DocAttr, Minor.SuppressTopSpace, "sprstsp"),
					new KeyStruct(Major.DocAttr, Minor.SuppressPreParSpace, "sprsspbf"),
					new KeyStruct(Major.DocAttr, Minor.CombineTblBorders, "otblrul"),
					new KeyStruct(Major.DocAttr, Minor.TranspMetafiles, "transmf"),
					new KeyStruct(Major.DocAttr, Minor.SwapBorders, "swpbdr"),
					new KeyStruct(Major.DocAttr, Minor.ShowHardBreaks, "brkfrm"),
					new KeyStruct(Major.DocAttr, Minor.FormProtected, "formprot"),
					new KeyStruct(Major.DocAttr, Minor.AllProtected, "allprot"),
					new KeyStruct(Major.DocAttr, Minor.FormShading, "formshade"),
					new KeyStruct(Major.DocAttr, Minor.FormDisplay, "formdisp"),
					new KeyStruct(Major.DocAttr, Minor.PrintData, "printdata"),
					new KeyStruct(Major.DocAttr, Minor.RevProtected, "revprot"),
					new KeyStruct(Major.DocAttr, Minor.Revisions, "revisions"),
					new KeyStruct(Major.DocAttr, Minor.RevDisplay, "revprop"),
					new KeyStruct(Major.DocAttr, Minor.RevBar, "revbar"),
					new KeyStruct(Major.DocAttr, Minor.AnnotProtected, "annotprot"),
					new KeyStruct(Major.DocAttr, Minor.RTLDoc, "rtldoc"),
					new KeyStruct(Major.DocAttr, Minor.LTRDoc, "ltrdoc"),
					new KeyStruct(Major.StyleAttr, Minor.Additive, "additive"),
					new KeyStruct(Major.StyleAttr, Minor.BasedOn, "sbasedon"),
					new KeyStruct(Major.StyleAttr, Minor.Next, "snext"),
					new KeyStruct(Major.PictAttr, Minor.MacQD, "macpict"),
					new KeyStruct(Major.PictAttr, Minor.PMMetafile, "pmmetafile"),
					new KeyStruct(Major.PictAttr, Minor.WinMetafile, "wmetafile"),
					new KeyStruct(Major.PictAttr, Minor.DevIndBitmap, "dibitmap"),
					new KeyStruct(Major.PictAttr, Minor.WinBitmap, "wbitmap"),
					new KeyStruct(Major.PictAttr, Minor.PixelBits, "wbmbitspixel"),
					new KeyStruct(Major.PictAttr, Minor.BitmapPlanes, "wbmplanes"),
					new KeyStruct(Major.PictAttr, Minor.BitmapWid, "wbmwidthbytes"),
					new KeyStruct(Major.PictAttr, Minor.PicWid, "picw"),
					new KeyStruct(Major.PictAttr, Minor.PicHt, "pich"),
					new KeyStruct(Major.PictAttr, Minor.PicGoalWid, "picwgoal"),
					new KeyStruct(Major.PictAttr, Minor.PicGoalHt, "pichgoal"),
					new KeyStruct(Major.PictAttr, Minor.PicGoalWid, "picwGoal"),
					new KeyStruct(Major.PictAttr, Minor.PicGoalHt, "pichGoal"),
					new KeyStruct(Major.PictAttr, Minor.PicScaleX, "picscalex"),
					new KeyStruct(Major.PictAttr, Minor.PicScaleY, "picscaley"),
					new KeyStruct(Major.PictAttr, Minor.PicScaled, "picscaled"),
					new KeyStruct(Major.PictAttr, Minor.PicCropTop, "piccropt"),
					new KeyStruct(Major.PictAttr, Minor.PicCropBottom, "piccropb"),
					new KeyStruct(Major.PictAttr, Minor.PicCropLeft, "piccropl"),
					new KeyStruct(Major.PictAttr, Minor.PicCropRight, "piccropr"),
					new KeyStruct(Major.PictAttr, Minor.PicMFHasBitmap, "picbmp"),
					new KeyStruct(Major.PictAttr, Minor.PicMFBitsPerPixel, "picbpp"),
					new KeyStruct(Major.PictAttr, Minor.PicBinary, "bin"),
					new KeyStruct(Major.NeXTGrAttr, Minor.NeXTGWidth, "width"),
					new KeyStruct(Major.NeXTGrAttr, Minor.NeXTGHeight, "height"),
					new KeyStruct(Major.Destination, Minor.OptDest, "*"),
					new KeyStruct(Major.Destination, Minor.FontTbl, "fonttbl"),
					new KeyStruct(Major.Destination, Minor.FontAltName, "falt"),
					new KeyStruct(Major.Destination, Minor.EmbeddedFont, "fonteb"),
					new KeyStruct(Major.Destination, Minor.FontFile, "fontfile"),
					new KeyStruct(Major.Destination, Minor.FileTbl, "filetbl"),
					new KeyStruct(Major.Destination, Minor.FileInfo, "file"),
					new KeyStruct(Major.Destination, Minor.ColorTbl, "colortbl"),
					new KeyStruct(Major.Destination, Minor.StyleSheet, "stylesheet"),
					new KeyStruct(Major.Destination, Minor.KeyCode, "keycode"),
					new KeyStruct(Major.Destination, Minor.RevisionTbl, "revtbl"),
					new KeyStruct(Major.Destination, Minor.Info, "info"),
					new KeyStruct(Major.Destination, Minor.ITitle, "title"),
					new KeyStruct(Major.Destination, Minor.ISubject, "subject"),
					new KeyStruct(Major.Destination, Minor.IAuthor, "author"),
					new KeyStruct(Major.Destination, Minor.IOperator, "operator"),
					new KeyStruct(Major.Destination, Minor.IKeywords, "keywords"),
					new KeyStruct(Major.Destination, Minor.IComment, "comment"),
					new KeyStruct(Major.Destination, Minor.IVersion, "version"),
					new KeyStruct(Major.Destination, Minor.IDoccomm, "doccomm"),
					new KeyStruct(Major.Destination, Minor.IVerscomm, "verscomm"),
					new KeyStruct(Major.Destination, Minor.NextFile, "nextfile"),
					new KeyStruct(Major.Destination, Minor.Template, "template"),
					new KeyStruct(Major.Destination, Minor.FNSep, "ftnsep"),
					new KeyStruct(Major.Destination, Minor.FNContSep, "ftnsepc"),
					new KeyStruct(Major.Destination, Minor.FNContNotice, "ftncn"),
					new KeyStruct(Major.Destination, Minor.ENSep, "aftnsep"),
					new KeyStruct(Major.Destination, Minor.ENContSep, "aftnsepc"),
					new KeyStruct(Major.Destination, Minor.ENContNotice, "aftncn"),
					new KeyStruct(Major.Destination, Minor.PageNumLevel, "pgnhn"),
					new KeyStruct(Major.Destination, Minor.ParNumLevelStyle, "pnseclvl"),
					new KeyStruct(Major.Destination, Minor.Header, "header"),
					new KeyStruct(Major.Destination, Minor.Footer, "footer"),
					new KeyStruct(Major.Destination, Minor.HeaderLeft, "headerl"),
					new KeyStruct(Major.Destination, Minor.HeaderRight, "headerr"),
					new KeyStruct(Major.Destination, Minor.HeaderFirst, "headerf"),
					new KeyStruct(Major.Destination, Minor.FooterLeft, "footerl"),
					new KeyStruct(Major.Destination, Minor.FooterRight, "footerr"),
					new KeyStruct(Major.Destination, Minor.FooterFirst, "footerf"),
					new KeyStruct(Major.Destination, Minor.ParNumText, "pntext"),
					new KeyStruct(Major.Destination, Minor.ParNumbering, "pn"),
					new KeyStruct(Major.Destination, Minor.ParNumTextAfter, "pntexta"),
					new KeyStruct(Major.Destination, Minor.ParNumTextBefore, "pntextb"),
					new KeyStruct(Major.Destination, Minor.BookmarkStart, "bkmkstart"),
					new KeyStruct(Major.Destination, Minor.BookmarkEnd, "bkmkend"),
					new KeyStruct(Major.Destination, Minor.Pict, "pict"),
					new KeyStruct(Major.Destination, Minor.Object, "object"),
					new KeyStruct(Major.Destination, Minor.ObjClass, "objclass"),
					new KeyStruct(Major.Destination, Minor.ObjName, "objname"),
					new KeyStruct(Major.ObjAttr, Minor.ObjTime, "objtime"),
					new KeyStruct(Major.Destination, Minor.ObjData, "objdata"),
					new KeyStruct(Major.Destination, Minor.ObjAlias, "objalias"),
					new KeyStruct(Major.Destination, Minor.ObjSection, "objsect"),
					new KeyStruct(Major.Destination, Minor.ObjItem, "objitem"),
					new KeyStruct(Major.Destination, Minor.ObjTopic, "objtopic"),
					new KeyStruct(Major.Destination, Minor.ObjResult, "result"),
					new KeyStruct(Major.Destination, Minor.DrawObject, "do"),
					new KeyStruct(Major.Destination, Minor.Footnote, "footnote"),
					new KeyStruct(Major.Destination, Minor.AnnotRefStart, "atrfstart"),
					new KeyStruct(Major.Destination, Minor.AnnotRefEnd, "atrfend"),
					new KeyStruct(Major.Destination, Minor.AnnotID, "atnid"),
					new KeyStruct(Major.Destination, Minor.AnnotAuthor, "atnauthor"),
					new KeyStruct(Major.Destination, Minor.Annotation, "annotation"),
					new KeyStruct(Major.Destination, Minor.AnnotRef, "atnref"),
					new KeyStruct(Major.Destination, Minor.AnnotTime, "atntime"),
					new KeyStruct(Major.Destination, Minor.AnnotIcon, "atnicn"),
					new KeyStruct(Major.Destination, Minor.Field, "field"),
					new KeyStruct(Major.Destination, Minor.FieldInst, "fldinst"),
					new KeyStruct(Major.Destination, Minor.FieldResult, "fldrslt"),
					new KeyStruct(Major.Destination, Minor.DataField, "datafield"),
					new KeyStruct(Major.Destination, Minor.Index, "xe"),
					new KeyStruct(Major.Destination, Minor.IndexText, "txe"),
					new KeyStruct(Major.Destination, Minor.IndexRange, "rxe"),
					new KeyStruct(Major.Destination, Minor.TOC, "tc"),
					new KeyStruct(Major.Destination, Minor.NeXTGraphic, "NeXTGraphic"),
					new KeyStruct(Major.FontFamily, Minor.FFNil, "fnil"),
					new KeyStruct(Major.FontFamily, Minor.FFRoman, "froman"),
					new KeyStruct(Major.FontFamily, Minor.FFSwiss, "fswiss"),
					new KeyStruct(Major.FontFamily, Minor.FFModern, "fmodern"),
					new KeyStruct(Major.FontFamily, Minor.FFScript, "fscript"),
					new KeyStruct(Major.FontFamily, Minor.FFDecor, "fdecor"),
					new KeyStruct(Major.FontFamily, Minor.FFTech, "ftech"),
					new KeyStruct(Major.FontFamily, Minor.FFBidirectional, "fbidi"),
					new KeyStruct(Major.FontAttr, Minor.FontCharSet, "fcharset"),
					new KeyStruct(Major.FontAttr, Minor.FontPitch, "fprq"),
					new KeyStruct(Major.FontAttr, Minor.FontCodePage, "cpg"),
					new KeyStruct(Major.FontAttr, Minor.FTypeNil, "ftnil"),
					new KeyStruct(Major.FontAttr, Minor.FTypeTrueType, "fttruetype"),
					new KeyStruct(Major.FileAttr, Minor.FileNum, "fid"),
					new KeyStruct(Major.FileAttr, Minor.FileRelPath, "frelative"),
					new KeyStruct(Major.FileAttr, Minor.FileOSNum, "fosnum"),
					new KeyStruct(Major.FileSource, Minor.SrcMacintosh, "fvalidmac"),
					new KeyStruct(Major.FileSource, Minor.SrcDOS, "fvaliddos"),
					new KeyStruct(Major.FileSource, Minor.SrcNTFS, "fvalidntfs"),
					new KeyStruct(Major.FileSource, Minor.SrcHPFS, "fvalidhpfs"),
					new KeyStruct(Major.FileSource, Minor.SrcNetwork, "fnetwork"),
					new KeyStruct(Major.ColorName, Minor.Red, "red"),
					new KeyStruct(Major.ColorName, Minor.Green, "green"),
					new KeyStruct(Major.ColorName, Minor.Blue, "blue"),
					new KeyStruct(Major.CharSet, Minor.MacCharSet, "mac"),
					new KeyStruct(Major.CharSet, Minor.AnsiCharSet, "ansi"),
					new KeyStruct(Major.CharSet, Minor.PcCharSet, "pc"),
					new KeyStruct(Major.CharSet, Minor.PcaCharSet, "pca"),
					new KeyStruct(Major.TblAttr, Minor.RowDef, "trowd"),
					new KeyStruct(Major.TblAttr, Minor.RowGapH, "trgaph"),
					new KeyStruct(Major.TblAttr, Minor.CellPos, "cellx"),
					new KeyStruct(Major.TblAttr, Minor.MergeRngFirst, "clmgf"),
					new KeyStruct(Major.TblAttr, Minor.MergePrevious, "clmrg"),
					new KeyStruct(Major.TblAttr, Minor.RowLeft, "trql"),
					new KeyStruct(Major.TblAttr, Minor.RowRight, "trqr"),
					new KeyStruct(Major.TblAttr, Minor.RowCenter, "trqc"),
					new KeyStruct(Major.TblAttr, Minor.RowLeftEdge, "trleft"),
					new KeyStruct(Major.TblAttr, Minor.RowHt, "trrh"),
					new KeyStruct(Major.TblAttr, Minor.RowHeader, "trhdr"),
					new KeyStruct(Major.TblAttr, Minor.RowKeep, "trkeep"),
					new KeyStruct(Major.TblAttr, Minor.RTLRow, "rtlrow"),
					new KeyStruct(Major.TblAttr, Minor.LTRRow, "ltrrow"),
					new KeyStruct(Major.TblAttr, Minor.RowBordTop, "trbrdrt"),
					new KeyStruct(Major.TblAttr, Minor.RowBordLeft, "trbrdrl"),
					new KeyStruct(Major.TblAttr, Minor.RowBordBottom, "trbrdrb"),
					new KeyStruct(Major.TblAttr, Minor.RowBordRight, "trbrdrr"),
					new KeyStruct(Major.TblAttr, Minor.RowBordHoriz, "trbrdrh"),
					new KeyStruct(Major.TblAttr, Minor.RowBordVert, "trbrdrv"),
					new KeyStruct(Major.TblAttr, Minor.CellBordBottom, "clbrdrb"),
					new KeyStruct(Major.TblAttr, Minor.CellBordTop, "clbrdrt"),
					new KeyStruct(Major.TblAttr, Minor.CellBordLeft, "clbrdrl"),
					new KeyStruct(Major.TblAttr, Minor.CellBordRight, "clbrdrr"),
					new KeyStruct(Major.TblAttr, Minor.CellShading, "clshdng"),
					new KeyStruct(Major.TblAttr, Minor.CellBgPatH, "clbghoriz"),
					new KeyStruct(Major.TblAttr, Minor.CellBgPatV, "clbgvert"),
					new KeyStruct(Major.TblAttr, Minor.CellFwdDiagBgPat, "clbgfdiag"),
					new KeyStruct(Major.TblAttr, Minor.CellBwdDiagBgPat, "clbgbdiag"),
					new KeyStruct(Major.TblAttr, Minor.CellHatchBgPat, "clbgcross"),
					new KeyStruct(Major.TblAttr, Minor.CellDiagHatchBgPat, "clbgdcross"),
					new KeyStruct(Major.TblAttr, Minor.CellDarkBgPatH, "clbgdkhoriz"),
					new KeyStruct(Major.TblAttr, Minor.CellDarkBgPatH, "clbgdkhor"),
					new KeyStruct(Major.TblAttr, Minor.CellDarkBgPatV, "clbgdkvert"),
					new KeyStruct(Major.TblAttr, Minor.CellFwdDarkBgPat, "clbgdkfdiag"),
					new KeyStruct(Major.TblAttr, Minor.CellBwdDarkBgPat, "clbgdkbdiag"),
					new KeyStruct(Major.TblAttr, Minor.CellDarkHatchBgPat, "clbgdkcross"),
					new KeyStruct(Major.TblAttr, Minor.CellDarkDiagHatchBgPat, "clbgdkdcross"),
					new KeyStruct(Major.TblAttr, Minor.CellBgPatLineColor, "clcfpat"),
					new KeyStruct(Major.TblAttr, Minor.CellBgPatColor, "clcbpat"),
					new KeyStruct(Major.FieldAttr, Minor.FieldDirty, "flddirty"),
					new KeyStruct(Major.FieldAttr, Minor.FieldEdited, "fldedit"),
					new KeyStruct(Major.FieldAttr, Minor.FieldLocked, "fldlock"),
					new KeyStruct(Major.FieldAttr, Minor.FieldPrivate, "fldpriv"),
					new KeyStruct(Major.FieldAttr, Minor.FieldAlt, "fldalt"),
					new KeyStruct(Major.PosAttr, Minor.AbsWid, "absw"),
					new KeyStruct(Major.PosAttr, Minor.AbsHt, "absh"),
					new KeyStruct(Major.PosAttr, Minor.RPosMargH, "phmrg"),
					new KeyStruct(Major.PosAttr, Minor.RPosPageH, "phpg"),
					new KeyStruct(Major.PosAttr, Minor.RPosColH, "phcol"),
					new KeyStruct(Major.PosAttr, Minor.PosX, "posx"),
					new KeyStruct(Major.PosAttr, Minor.PosNegX, "posnegx"),
					new KeyStruct(Major.PosAttr, Minor.PosXCenter, "posxc"),
					new KeyStruct(Major.PosAttr, Minor.PosXInside, "posxi"),
					new KeyStruct(Major.PosAttr, Minor.PosXOutSide, "posxo"),
					new KeyStruct(Major.PosAttr, Minor.PosXRight, "posxr"),
					new KeyStruct(Major.PosAttr, Minor.PosXLeft, "posxl"),
					new KeyStruct(Major.PosAttr, Minor.RPosMargV, "pvmrg"),
					new KeyStruct(Major.PosAttr, Minor.RPosPageV, "pvpg"),
					new KeyStruct(Major.PosAttr, Minor.RPosParaV, "pvpara"),
					new KeyStruct(Major.PosAttr, Minor.PosY, "posy"),
					new KeyStruct(Major.PosAttr, Minor.PosNegY, "posnegy"),
					new KeyStruct(Major.PosAttr, Minor.PosYInline, "posyil"),
					new KeyStruct(Major.PosAttr, Minor.PosYTop, "posyt"),
					new KeyStruct(Major.PosAttr, Minor.PosYCenter, "posyc"),
					new KeyStruct(Major.PosAttr, Minor.PosYBottom, "posyb"),
					new KeyStruct(Major.PosAttr, Minor.NoWrap, "nowrap"),
					new KeyStruct(Major.PosAttr, Minor.DistFromTextAll, "dxfrtext"),
					new KeyStruct(Major.PosAttr, Minor.DistFromTextX, "dfrmtxtx"),
					new KeyStruct(Major.PosAttr, Minor.DistFromTextY, "dfrmtxty"),
					new KeyStruct(Major.PosAttr, Minor.TextDistY, "dyfrtext"),
					new KeyStruct(Major.PosAttr, Minor.DropCapLines, "dropcapli"),
					new KeyStruct(Major.PosAttr, Minor.DropCapType, "dropcapt"),
					new KeyStruct(Major.ObjAttr, Minor.ObjEmb, "objemb"),
					new KeyStruct(Major.ObjAttr, Minor.ObjLink, "objlink"),
					new KeyStruct(Major.ObjAttr, Minor.ObjAutoLink, "objautlink"),
					new KeyStruct(Major.ObjAttr, Minor.ObjSubscriber, "objsub"),
					new KeyStruct(Major.ObjAttr, Minor.ObjPublisher, "objpub"),
					new KeyStruct(Major.ObjAttr, Minor.ObjICEmb, "objicemb"),
					new KeyStruct(Major.ObjAttr, Minor.ObjLinkSelf, "linkself"),
					new KeyStruct(Major.ObjAttr, Minor.ObjLock, "objupdate"),
					new KeyStruct(Major.ObjAttr, Minor.ObjUpdate, "objlock"),
					new KeyStruct(Major.ObjAttr, Minor.ObjHt, "objh"),
					new KeyStruct(Major.ObjAttr, Minor.ObjWid, "objw"),
					new KeyStruct(Major.ObjAttr, Minor.ObjSetSize, "objsetsize"),
					new KeyStruct(Major.ObjAttr, Minor.ObjAlign, "objalign"),
					new KeyStruct(Major.ObjAttr, Minor.ObjTransposeY, "objtransy"),
					new KeyStruct(Major.ObjAttr, Minor.ObjCropTop, "objcropt"),
					new KeyStruct(Major.ObjAttr, Minor.ObjCropBottom, "objcropb"),
					new KeyStruct(Major.ObjAttr, Minor.ObjCropLeft, "objcropl"),
					new KeyStruct(Major.ObjAttr, Minor.ObjCropRight, "objcropr"),
					new KeyStruct(Major.ObjAttr, Minor.ObjScaleX, "objscalex"),
					new KeyStruct(Major.ObjAttr, Minor.ObjScaleY, "objscaley"),
					new KeyStruct(Major.ObjAttr, Minor.ObjResRTF, "rsltrtf"),
					new KeyStruct(Major.ObjAttr, Minor.ObjResPict, "rsltpict"),
					new KeyStruct(Major.ObjAttr, Minor.ObjResBitmap, "rsltbmp"),
					new KeyStruct(Major.ObjAttr, Minor.ObjResText, "rslttxt"),
					new KeyStruct(Major.ObjAttr, Minor.ObjResMerge, "rsltmerge"),
					new KeyStruct(Major.ObjAttr, Minor.ObjBookmarkPubObj, "bkmkpub"),
					new KeyStruct(Major.ObjAttr, Minor.ObjPubAutoUpdate, "pubauto"),
					new KeyStruct(Major.ACharAttr, Minor.ACBold, "ab"),
					new KeyStruct(Major.ACharAttr, Minor.ACAllCaps, "caps"),
					new KeyStruct(Major.ACharAttr, Minor.ACForeColor, "acf"),
					new KeyStruct(Major.ACharAttr, Minor.ACSubScript, "adn"),
					new KeyStruct(Major.ACharAttr, Minor.ACExpand, "aexpnd"),
					new KeyStruct(Major.ACharAttr, Minor.ACFontNum, "af"),
					new KeyStruct(Major.ACharAttr, Minor.ACFontSize, "afs"),
					new KeyStruct(Major.ACharAttr, Minor.ACItalic, "ai"),
					new KeyStruct(Major.ACharAttr, Minor.ACLanguage, "alang"),
					new KeyStruct(Major.ACharAttr, Minor.ACOutline, "aoutl"),
					new KeyStruct(Major.ACharAttr, Minor.ACSmallCaps, "ascaps"),
					new KeyStruct(Major.ACharAttr, Minor.ACShadow, "ashad"),
					new KeyStruct(Major.ACharAttr, Minor.ACStrikeThru, "astrike"),
					new KeyStruct(Major.ACharAttr, Minor.ACUnderline, "aul"),
					new KeyStruct(Major.ACharAttr, Minor.ACDotUnderline, "auld"),
					new KeyStruct(Major.ACharAttr, Minor.ACDbUnderline, "auldb"),
					new KeyStruct(Major.ACharAttr, Minor.ACNoUnderline, "aulnone"),
					new KeyStruct(Major.ACharAttr, Minor.ACWordUnderline, "aulw"),
					new KeyStruct(Major.ACharAttr, Minor.ACSuperScript, "aup"),
					new KeyStruct(Major.FNoteAttr, Minor.FNAlt, "ftnalt"),
					new KeyStruct(Major.KeyCodeAttr, Minor.AltKey, "alt"),
					new KeyStruct(Major.KeyCodeAttr, Minor.ShiftKey, "shift"),
					new KeyStruct(Major.KeyCodeAttr, Minor.ControlKey, "ctrl"),
					new KeyStruct(Major.KeyCodeAttr, Minor.FunctionKey, "fn"),
					new KeyStruct(Major.BookmarkAttr, Minor.BookmarkFirstCol, "bkmkcolf"),
					new KeyStruct(Major.BookmarkAttr, Minor.BookmarkLastCol, "bkmkcoll"),
					new KeyStruct(Major.IndexAttr, Minor.IndexNumber, "xef"),
					new KeyStruct(Major.IndexAttr, Minor.IndexBold, "bxe"),
					new KeyStruct(Major.IndexAttr, Minor.IndexItalic, "ixe"),
					new KeyStruct(Major.TOCAttr, Minor.TOCType, "tcf"),
					new KeyStruct(Major.TOCAttr, Minor.TOCLevel, "tcl"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLock, "dolock"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPageRelX, "doxpage"),
					new KeyStruct(Major.DrawAttr, Minor.DrawColumnRelX, "dobxcolumn"),
					new KeyStruct(Major.DrawAttr, Minor.DrawMarginRelX, "dobxmargin"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPageRelY, "dobypage"),
					new KeyStruct(Major.DrawAttr, Minor.DrawColumnRelY, "dobycolumn"),
					new KeyStruct(Major.DrawAttr, Minor.DrawMarginRelY, "dobymargin"),
					new KeyStruct(Major.DrawAttr, Minor.DrawHeight, "dobhgt"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBeginGroup, "dpgroup"),
					new KeyStruct(Major.DrawAttr, Minor.DrawGroupCount, "dpcount"),
					new KeyStruct(Major.DrawAttr, Minor.DrawEndGroup, "dpendgroup"),
					new KeyStruct(Major.DrawAttr, Minor.DrawArc, "dparc"),
					new KeyStruct(Major.DrawAttr, Minor.DrawCallout, "dpcallout"),
					new KeyStruct(Major.DrawAttr, Minor.DrawEllipse, "dpellipse"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLine, "dpline"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPolygon, "dppolygon"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPolyLine, "dppolyline"),
					new KeyStruct(Major.DrawAttr, Minor.DrawRect, "dprect"),
					new KeyStruct(Major.DrawAttr, Minor.DrawTextBox, "dptxbx"),
					new KeyStruct(Major.DrawAttr, Minor.DrawOffsetX, "dpx"),
					new KeyStruct(Major.DrawAttr, Minor.DrawSizeX, "dpxsize"),
					new KeyStruct(Major.DrawAttr, Minor.DrawOffsetY, "dpy"),
					new KeyStruct(Major.DrawAttr, Minor.DrawSizeY, "dpysize"),
					new KeyStruct(Major.DrawAttr, Minor.COAngle, "dpcoa"),
					new KeyStruct(Major.DrawAttr, Minor.COAccentBar, "dpcoaccent"),
					new KeyStruct(Major.DrawAttr, Minor.COBestFit, "dpcobestfit"),
					new KeyStruct(Major.DrawAttr, Minor.COBorder, "dpcoborder"),
					new KeyStruct(Major.DrawAttr, Minor.COAttachAbsDist, "dpcodabs"),
					new KeyStruct(Major.DrawAttr, Minor.COAttachBottom, "dpcodbottom"),
					new KeyStruct(Major.DrawAttr, Minor.COAttachCenter, "dpcodcenter"),
					new KeyStruct(Major.DrawAttr, Minor.COAttachTop, "dpcodtop"),
					new KeyStruct(Major.DrawAttr, Minor.COLength, "dpcolength"),
					new KeyStruct(Major.DrawAttr, Minor.CONegXQuadrant, "dpcominusx"),
					new KeyStruct(Major.DrawAttr, Minor.CONegYQuadrant, "dpcominusy"),
					new KeyStruct(Major.DrawAttr, Minor.COOffset, "dpcooffset"),
					new KeyStruct(Major.DrawAttr, Minor.COAttachSmart, "dpcosmarta"),
					new KeyStruct(Major.DrawAttr, Minor.CODoubleLine, "dpcotdouble"),
					new KeyStruct(Major.DrawAttr, Minor.CORightAngle, "dpcotright"),
					new KeyStruct(Major.DrawAttr, Minor.COSingleLine, "dpcotsingle"),
					new KeyStruct(Major.DrawAttr, Minor.COTripleLine, "dpcottriple"),
					new KeyStruct(Major.DrawAttr, Minor.DrawTextBoxMargin, "dptxbxmar"),
					new KeyStruct(Major.DrawAttr, Minor.DrawTextBoxText, "dptxbxtext"),
					new KeyStruct(Major.DrawAttr, Minor.DrawRoundRect, "dproundr"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPointX, "dpptx"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPointY, "dppty"),
					new KeyStruct(Major.DrawAttr, Minor.DrawPolyCount, "dppolycount"),
					new KeyStruct(Major.DrawAttr, Minor.DrawArcFlipX, "dparcflipx"),
					new KeyStruct(Major.DrawAttr, Minor.DrawArcFlipY, "dparcflipy"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineBlue, "dplinecob"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineGreen, "dplinecog"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineRed, "dplinecor"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLinePalette, "dplinepal"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineDashDot, "dplinedado"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineDashDotDot, "dplinedadodo"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineDash, "dplinedash"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineDot, "dplinedot"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineGray, "dplinegray"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineHollow, "dplinehollow"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineSolid, "dplinesolid"),
					new KeyStruct(Major.DrawAttr, Minor.DrawLineWidth, "dplinew"),
					new KeyStruct(Major.DrawAttr, Minor.DrawHollowEndArrow, "dpaendhol"),
					new KeyStruct(Major.DrawAttr, Minor.DrawEndArrowLength, "dpaendl"),
					new KeyStruct(Major.DrawAttr, Minor.DrawSolidEndArrow, "dpaendsol"),
					new KeyStruct(Major.DrawAttr, Minor.DrawEndArrowWidth, "dpaendw"),
					new KeyStruct(Major.DrawAttr, Minor.DrawHollowStartArrow,"dpastarthol"),
					new KeyStruct(Major.DrawAttr, Minor.DrawStartArrowLength,"dpastartl"),
					new KeyStruct(Major.DrawAttr, Minor.DrawSolidStartArrow, "dpastartsol"),
					new KeyStruct(Major.DrawAttr, Minor.DrawStartArrowWidth, "dpastartw"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBgFillBlue, "dpfillbgcb"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBgFillGreen, "dpfillbgcg"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBgFillRed, "dpfillbgcr"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBgFillPalette, "dpfillbgpal"),
					new KeyStruct(Major.DrawAttr, Minor.DrawBgFillGray, "dpfillbggray"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFgFillBlue, "dpfillfgcb"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFgFillGreen, "dpfillfgcg"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFgFillRed, "dpfillfgcr"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFgFillPalette, "dpfillfgpal"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFgFillGray, "dpfillfggray"),
					new KeyStruct(Major.DrawAttr, Minor.DrawFillPatIndex, "dpfillpat"),
					new KeyStruct(Major.DrawAttr, Minor.DrawShadow, "dpshadow"),
					new KeyStruct(Major.DrawAttr, Minor.DrawShadowXOffset, "dpshadx"),
					new KeyStruct(Major.DrawAttr, Minor.DrawShadowYOffset, "dpshady"),
					new KeyStruct(Major.Version, Minor.Undefined, "rtf"),
					new KeyStruct(Major.DefFont, Minor.Undefined, "deff"),
					new KeyStruct(Major.Unicode, Minor.UnicodeCharBytes, "uc"),
					new KeyStruct(Major.Unicode, Minor.UnicodeChar, "u"),
					new KeyStruct(Major.Unicode, Minor.UnicodeDestination, "ud"),
					new KeyStruct(Major.Unicode, Minor.UnicodeDualDestination, "upr"),
					new KeyStruct(Major.Unicode, Minor.UnicodeAnsiCodepage, "ansicpg"),
			};
		}
	}
}
