#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Huan Komrade T <huantnh at gmail.com>'
'''
vnexpress.net
'''

from calibre.web.feeds.news import BasicNewsRecipe

class BBCVietnamese(BasicNewsRecipe):
    title          = u'VnExpress'
    __author__     = 'Huan Komrade T'
    description    = 'Vietnam news and current affairs from the Food Production Technology Corporation'
    no_stylesheets = True
    language = 'vi'

    encoding = 'utf-8'
    recursions = 0

    remove_tags    = [dict(name='div', attrs={'class':'footer'})]
    extra_css      = '.headline {font-size: x-large;} \n .fact { padding-top: 10pt  }' 

    feeds          = [
                      ('Index', 'http://vnexpress.net/rss/gl/trang-chu.rss'), 
                      ('Vietnam', 'http://vnexpress.net/rss/gl/xa-hoi.rss'),
                      ('World News', 'http://vnexpress.net/rss/gl/the-gioi.rss'),
                      ('Business', 'http://vnexpress.net/rss/gl/kinh-doanh.rss'),
                      ('Culture', 'http://vnexpress.net/rss/gl/van-hoa.rss'),
                      ('Sports', 'http://vnexpress.net/rss/gl/the-thao.rss'),
                      ('Lifestyle', 'http://vnexpress.net/rss/gl/doi-song.rss'),
                      ('From The Readers', 'http://vnexpress.net/rss/gl/ban-doc-viet.rss'),
                      ('From The Readers - Sharing', 'http://vnexpress.net/rss/gl/ban-doc-viet-tam-su.rss'),
                    ]

    def print_version(self, url):
        return url + '?q=1'
