#!/system/bin/sh

CMD=$1

smount / rprivate >/dev/null 2>&1

if grep ' /data ' /proc/mounts | grep -q nodev; then
    mount -o remount,dev /data
fi

# Prepare all the bind-mounts
if ! grep -q " $UFA_DIR/root " /proc/mounts; then
    mount -o bind $UFA_DIR/root $UFA_DIR/root
fi

if [ "$CMD" = "lxc-start" ]; then
    # If the user hit the "Clear data" button then /home will be wiped.
    # Recopy it.
    if [ ! -d $UFA_DATA_DIR/home ]; then
        cp -a $UFA_DIR/home $UFA_DATA_DIR/
    fi
    # note the "missing" /, without it you get two /s and grep fails
    if ! grep -q " $UFA_DIR/root/data/data/com.canonical.ubuntu/home " /proc/mounts; then
        mkdir -p $UFA_DIR/root/data/data/com.canonical.ubuntu/home
        mount -o bind $UFA_DATA_DIR/home $UFA_DIR/root/data/data/com.canonical.ubuntu/home
    fi
fi

for path in acct dev dev/cpuctl dev/pts proc sys system mnt/sdcard; do
    if [ ! -d /$path ]; then
        continue
    fi

    if grep -q " $UFA_DIR/root/$path " /proc/mounts; then
        continue
    fi
    mkdir -p $UFA_DIR/root/$path
    mount -o bind /$path $UFA_DIR/root/$path
done

# bind mount /var for lxc to log debug messages
if [ ! -d $UFA_DIR/root/var ]; then
    mkdir -p $UFA_DIR/root/var
fi
if ! grep -q " $UFA_DIR/root/var " /proc/mounts; then
    mount -o bind $UFA_DIR/var $UFA_DIR/root/var
fi

if [ "$CMD" = "lxc-start" ]; then
    # Bind mount custom paths into standard paths
    for path in containers lxc var; do
        if [ ! -d $UFA_DIR/$path ]; then
            continue
        fi

        if grep -q " $UFA_DIR/root/data/ubuntu/$path " /proc/mounts; then
            continue
        fi
        mkdir -p $UFA_DIR/root/data/ubuntu/$path
        mount -o bind $UFA_DIR/$path $UFA_DIR/root/data/ubuntu/$path
    done

    if [ -f $UFA_DIR/filesystem.ext4 ]; then
        mkdir -p $UFA_DIR/root/data/ubuntu/containers/ufa/rootfs
        if ! grep -q " $UFA_DIR/root/data/ubuntu/containers/ufa/rootfs " /proc/mounts; then
            if [ ! -b /dev/block/loopUFA ]; then
                # Android gets confused when we user up one of the lower
                # loopback devices, so we use a large number to get out of
                # the way. Since device minor is 20 bits, we use 2^20-1, the
                # largest value we can use. According to the code in vold in
                # loop.h, the maximum number of loopback devices for Paid apps,
                # is 4096 but that may change and we don't want to set an
                # artificial limit too low.
                $UFA_DIR/bin/mknod -m0600 /dev/block/loopUFA b 7 1048575
            fi
            if ! $UFA_DIR/bin/losetup /dev/block/loopUFA > /dev/null 2>&1; then
                $UFA_DIR/bin/losetup /dev/block/loopUFA $UFA_DIR/filesystem.ext4
            fi
            mount -o rw -t ext4 /dev/block/loopUFA $UFA_DIR/root/data/ubuntu/containers/ufa/rootfs
        fi
    fi

    # Drop the UID for the UfA user into /var for consumption by the ufa
    # upstart job. The job will chown ~ if necessary so that the ownership
    # matches what Android expects.
    echo $UFA_UID > $UFA_DIR/var/tmp/ufa_uid
    # Drop DNS info into /var for consumption by Ubuntu
    getprop net.dns1 > $UFA_DIR/var/tmp/ufa_nameservers
fi

# Prepare the cgroup filesystems
[ ! -d $UFA_DIR/root/cgroup ] && mkdir -p $UFA_DIR/root/cgroup
cgroups=""
while read line; do
    set -- $line
    # Blacklist
    [ "$1" = "#subsys_name" ] && continue
    [ "$1" = "cpuacct" ] && [ -d /acct ] && continue
    [ "$1" = "cpu" ] && [ -d /dev/cpuctl ] && continue

    # Mount the rest
    if [ -z "$cgroups" ]; then
        cgroups="$1"
    else
        cgroups="$cgroups,$1"
    fi
done < /proc/cgroups

if ! grep -q " $UFA_DIR/root/cgroup " /proc/mounts; then
    mount -t cgroup -o $cgroups none $UFA_DIR/root/cgroup
fi

if [ "$CMD" = "lxc-start" ]; then
    # Symlinks
    rm -f $UFA_DIR/lxc/var/lib/lxc/*
    for container in $UFA_DIR/containers/*; do
        ln -s $container $UFA_DIR/lxc/var/lib/lxc/${container##*/}
    done
fi
