from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestBT(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestBT, self).setUp()
        self.dbus_interface = "com.canonical.android.contacts.Contacts"
        self.s_contactsChanged = "contactsChanged"
        self.s_contactsRemoved = "contactsRemoved"
        self.m_createContact = "createContact"
        self.m_deleteContacts = "deleteContacts"
        self.m_getAvatar = "getAvatar"
        self.m_getContact = "getContact"
        self.m_getContactForNumber = "getContactForNumber"
        self.m_getContactKeyForNumber = "getContactKeyForNumber"
        self.m_listContactsChangesAsync = "listContactsChangesAsync"
        self.m_listContactsChangesAsyncGetPage = "listContactsChanges" \
            "AsyncGetPage"
        self.m_signalProcessed = "signalProcessed"
        self.m_startContactObserver = "startContactObserver"
        self.m_stopContactObserver = "stopContactObserver"
        self.m_updateContact = "updateContact"

    def tearDown(self):
        super(TestBT, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_con.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_bt_adapter_s_contactsChanged(self):
        item = self.s_contactsChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_adapter_s_contactsRemoved(self):
        item = self.s_contactsRemoved
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_adapter_m_createContact(self):
        item = self.m_createContact
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_deleteContacts(self):
        item = self.m_deleteContacts
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_getAvatar(self):
        item = self.m_getAvatar
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_getContact(self):
        item = self.m_getContact
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_getContactForNumber(self):
        item = self.m_getContactForNumber
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_getContactKeyForNumber(self):
        item = self.m_getContactKeyForNumber
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_listContactsChangesAsync(self):
        item = self.m_listContactsChangesAsync
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_listContactsChangesAsyncGetPage(self):
        item = self.m_listContactsChangesAsyncGetPage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_signalProcessed(self):
        item = self.m_signalProcessed
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_startContactObserver(self):
        item = self.m_startContactObserver
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_stopContactObserver(self):
        item = self.m_stopContactObserver
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_updateContact(self):
        item = self.m_updateContact
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
