from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestAccount(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestAccount, self).setUp()
        self.dbus_interface = "com.canonical.android.accounts.Accounts"
        self.s_AccountsUpdated = "AccountsUpdated"
        self.s_EmailAccountsAdded = "EmailAccountsAdded"
        self.s_EmailAccountsDeleted = "EmailAccountsDeleted"
        self.s_EmailAccountUpdated = "EmailAccountUpdated"
        self.s_SyncSettingsUpdated = "SyncSettingsUpdated"
        self.m_disableEmailAccountsChangeNotifications = "disableEmail" \
            "AccountsChangeNotifications"
        self.m_enableEmailAccountsChangeNotifications = "enableEmail" \
            "AccountsChangeNotifications"
        self.m_getAccounts = "getAccounts"
        self.m_getAllAccounts = "getAllAccounts"
        self.m_getAllEmailAccounts = "getAllEmailAccounts"
        self.m_getAllSyncAdapters = "getAllSyncAdapters"
        self.m_getAuthenticatorTypes = "getAuthenticatorTypes"
        self.m_getAutoEnabledSyncAdapters = "getAutoEnabledSyncAdapters"
        self.m_getEmailAccount = "getEmailAccount"
        self.m_getUserData = "getUserData"
        self.m_removeAccount = "removeAccount"
        self.m_setUserData = "setUserData"
        self.m_updateEmailAccountSettings = "updateEmailAccountSettings"

    def tearDown(self):
        super(TestAccount, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_acc.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_account_s_AccountsUpdated(self):
        item = self.s_AccountsUpdated
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_account_s_EmailAccountsAdded(self):
        item = self.s_EmailAccountsAdded
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_account_s_EmailAccountsDeleted(self):
        item = self.s_EmailAccountsDeleted
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_account_s_EmailAccountUpdated(self):
        item = self.s_EmailAccountUpdated
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_account_s_SyncSettingsUpdated(self):
        item = self.s_SyncSettingsUpdated
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_account_m_disableEmailAccountsChangeNotifications(self):
        item = self.m_disableEmailAccountsChangeNotifications
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_enableEmailAccountsChangeNotifications(self):
        item = self.m_enableEmailAccountsChangeNotifications
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAccounts(self):
        item = self.m_getAccounts
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAllAccounts(self):
        item = self.m_getAllAccounts
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAllEmailAccounts(self):
        item = self.m_getAllEmailAccounts
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAllSyncAdapters(self):
        item = self.m_getAllSyncAdapters
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAuthenticatorTypes(self):
        item = self.m_getAuthenticatorTypes
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getAutoEnabledSyncAdapters(self):
        item = self.m_getAutoEnabledSyncAdapters
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getEmailAccount(self):
        item = self.m_getEmailAccount
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_getUserData(self):
        item = self.m_getUserData
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_removeAccount(self):
        item = self.m_removeAccount
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_setUserData(self):
        item = self.m_setUserData
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_account_m_updateEmailAccountSettings(self):
        item = self.m_updateEmailAccountSettings
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
