#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import logging

from terra.core.model import Model
from terra.core.manager import Manager

log = logging.getLogger("plugins.canola-core.settings")

mger = Manager()
ModelFolderOrdered = mger.get_class("Model/Folder/Ordered")
DefaultIcon = mger.get_class("Icon")


class ModelSettingsFolder(ModelFolderOrdered):
    terra_type = "Model/Settings/Folder"
    title = "" # XXX

    def __init__(self, parent):
        ModelFolderOrdered.__init__(self, self.title, parent)


class OptionsModelFolder(ModelFolderOrdered):
    terra_type = "Model/Options/Folder"
    title = "" # XXX

    def __init__(self, parent, screen_controller=None):
        ModelFolderOrdered.__init__(self, self.title, parent)
        self.screen_controller = screen_controller or parent.screen_controller


class SettingsModel(ModelSettingsFolder):
    terra_type = "Model/Folder/Settings"
    icon = "settings"
    title = "Settings"
    children_order = ["/MediaLibrary", "/ChooseTheme", "/InternetMedia"]
    children_prefixes = ["Model/Settings/Folder/Root"]


class ActionModel(Model):
    terra_type = "Model/Action"
    name = ""

    def __init__(self, parent=None):
        Model.__init__(self, self.name, parent)

    def execute(self):
        raise NotImplementedError("actions must implement execute")


class SettingsActionModel(ActionModel):
    terra_type = "Model/Settings/Action"


class OptionsActionModel(ActionModel):
    terra_type = "Model/Options/Action"

    def __init__(self, parent=None):
        ActionModel.__init__(self, parent)
        self.screen_controller = self.parent.screen_controller

class SettingsIcon(DefaultIcon):
    terra_type = "Icon/Folder/Settings"
    icon = "icon/main_item/settings"
