#!/usr/bin/python
#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import sys
import os
import re
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-d", "--directory", help="Directory to scan for .edc",
                  default="data/themes/default")
parser.add_option("-o", "--outfile", help="Output to file",
                  default="-")

regexp_regular = ('^\s*(?:text_class\s*:\s*"(?P<text_class>[^"]+)")\s*;\s*$'
                  '\s*(?:font\s*:\s*"(?P<font>[^"]+)")\s*;\s*$'
                  '\s*(?:size\s*:\s*(?P<size>\d+))\s*;\s*$')
r_regular = re.compile(regexp_regular, re.M)

regexp_style = ('^.*text_class=(?P<text_class>\S+).*$'
                '\s*font=(?P<font>.*)\s+font_size=(?P<size>\d+).*$')
r_style = re.compile(regexp_style, re.M)

class TextClassRegister(dict):
    def __setitem__(self, key, value):
        old = self.get(key)
        if old is not None and old != value:
            msg = "ERROR: text_class=%r was registered differently: %r, %r\n"
            sys.stderr.write(msg % (text_class, old, value))
            return
        dict.__setitem__(self, key, value)

options, args = parser.parse_args()

text_class_register = TextClassRegister()
pisfile = os.path.isfile
pjoin = os.path.join
directory = options.directory
for f in os.listdir(directory):
    p = pjoin(directory, f)
    if not os.path.isfile(p) or not f.endswith(".edc"):
        continue

    fd = open(p)
    contents = fd.read()
    fd.close()

    for (text_class, font, size) in r_regular.findall(contents):
        text_class_register[text_class] = (font, int(size))

    for (text_class, font, size) in r_style.findall(contents):
        font = font.replace(r'\\ ', ' ')
        text_class_register[text_class] = (font, int(size))

if options.outfile == "-":
    outfile = sys.stdout
else:
    outfile = open(options.outfile, "wb")

for text_class, (font, size) in text_class_register.iteritems():
    outfile.write("""\
[%s]
font=%s
size=%d

""" % (text_class, font, size))
