#
# 	Librairie des objets d'interface Cecilia
# 	(c) 1995-7 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#
 
proc ctoggle {nom args} {
    global  type value path color cfont kill loading realArr realtim tcl_platform
    catch {array set arp $args} ref
    if {$ref != ""} {bell;errFile2 "error in toggle definition:\n$args";return}
    foreach ar [array names arp] {
	switch -glob -- [string trim $ar "-"] {
	    i*		{set init $arp($ar)}
	    la*		{set nam $arp($ar)}
	    default 	{bell;bell;errFile2 "error in toggle definition";return} 
	}
    }
 	if ![info exists init] {set init 0}
 	if ![info exists nam] {set nam $nom}
    append  realArr(list) "$nom "
    set realtim 1

    if ![winfo exists $path(bas).sw] {
	pack [frame $path(bas).sw ] -side left
    }   

    if ![winfo exists $path(togli)] {doPackIrate toggle}   
     doCsoundPrep $nom $init
    checkbutton $path(toggleval).$nom -text $nam -offvalue 0 \
	    -onvalue 1  -variable realArr($nom) \
	    -command "passCheck $nom"
    eval optMenu $path(toggleopt).$nom realArr(${nom}rec) {{}} [list $cfont(small)] ${color} \
	    7 1 {k-rate record playback load save}

    set realArr($nom) $init
   
    # no realtime on MacOS  
    if {$tcl_platform(platform) != "macintosh"} {
	pack $path(toggleopt).$nom -padx 1  -side top -anchor e -pady 2
    }
    
    pack $path(toggleval).$nom -side top -anchor w -padx 2 -pady 2  -fill y
    set type($nom) cec_toggle
    set kill($nom) "destroy $path(togli); unset value($nom) type($nom)"
    trace variable realArr(${nom}rec) w dataFilesReal
}


proc passCheck {nom} {
    global realArr
    putIt $realArr(${nom}ch) $realArr($nom)
}


    
proc cfilein {nom args} {
    global type value path color soundInInfo kill loading  tcl_platform _db prefs soundNamer
    global midiinfo

    catch {array set arp $args} ref
	if {$ref != ""} {bell;errFile2 "error in filein definition:\n$args";return}
	
	foreach ar [array names arp] {
		switch -glob -- [string trim $ar "-"] {
			la*		{set nam $arp($ar)}
			type*   {set mytype $arp($ar)}
			default 	{bell;bell;errFile2 "error in filein definition";return} 
		}
	}
 	if ![info exists nam] {set nam $nom}
 	if ![info exists mytype] {set mytype "audio"}
	set _db(type,$nom) $mytype

    grid $path(winIn) -row 3 -column 0 -sticky news -pady 5 -padx 5

    pack $path(winIn).l  -side top -fill x
    pack $path(winIn).f -side top -fill x
    pack [frame $path(winIn).f.$nom  \
		-relief groove -bd 1] -side top -fill x -expand y -padx 1 -pady 1

    grid columnconfigure $path(winIn).f.$nom 1 -weight 10

	grid [label $path(winIn).f.$nom.l   -text "$nam: " \
	  -justify left] -row 0 -column 0 -sticky news -padx 2 -pady 2

	switch -- $mytype  {
		"audio" {
			grid [button $path(winIn).f.$nom.b  \
			  -text toLoad -command "chooseSoundPath $nom"] \
			  -row 0 -column 1 -sticky news  -padx 2 -pady 2

			grid [button $path(winIn).f.$nom.play -state disabled -image play \
			  -text joue] \
			  -row 0 -column 2 -sticky news -padx 2 -pady 2
			
			grid [button $path(winIn).f.$nom.edit -image edi -state disabled  \
			  -text edit] \
			  -row 0 -column 3 -sticky news -padx 2 -pady 2
			
			grid [label $path(winIn).f.$nom.label  -text "(no info)"]  \
			  -row 1 -column 0 -columnspan 4 -sticky news 
			
			bindHelp $path(winIn).f.$nom.b bWinInSelect
			bindHelp $path(winIn).f.$nom.label LWinInInfo 
			bindHelp $path(winIn).f.$nom.edit bWinEdit 
			bindHelp $path(winIn).f.$nom.play bWinPlay
			
			if {$tcl_platform(platform) != "windows"} {
				
				grid [label $path(winIn).f.$nom.k  \
				  -text "offset:" -justify left] \
				  -row 2 -column 0 -sticky news -pady 2 -padx 2 
				
				grid [scale $path(winIn).f.$nom.scale -from 0 -to 10 -bigincrement 1 \
				  -resolution .01 -variable value(off$nom) -command "" \
				  -orient h -showvalue 0 -length 150 -width 5 \
				  -state disabled]  -row 2 -column 1  -sticky news -pady 2 -padx 2
				
				grid [label $path(winIn).f.$nom.s  \
				  -textvariable value(off$nom) -justify left]  \
				  -row 2 -column 2 -sticky news -pady 2 -padx 2
				
				grid [label $path(winIn).f.$nom.st \
				  -text "s"  -justify left]  \
				  -row 2 -column 3 -sticky news -pady 2 -padx 2
			}
			if ![info exists loading] {
				if [llength $_db(sound,previous)] {
					if ![rememberSound $nom] {
						set soundInInfo($nom) ""
						set soundNamer($nom) $nam
						set value($nom) "toLoad" 
					}
				} {
					set soundInInfo($nom) ""
					set soundNamer($nom) $nam
					set value($nom) "toLoad" 
				}
				
			}
			set type(off$nom) islider
			set type($nom) cec_filein
			set kill($nom) "destroy $path(winIn).f.$nom; unset value($nom) value(off$nom) type($nom) type(off$nom) soundInInfo($nom)"
		}
		"MIDI" {
		    if [info exists midiinfo] {
			puts "error ($nom): only one midi file per module allowed!"
			return
		    }
			grid [button $path(winIn).f.$nom.b  \
			  -text toLoad -command "chooseMIDIPath $nom"] \
			  -row 0 -column 1 -sticky news  -padx 2 -pady 2

			grid [button $path(winIn).f.$nom.edit -image edi -state disabled  \
			  -text edit] \
			  -row 0 -column 3 -sticky news -padx 2 -pady 2

			bindHelp $path(winIn).f.$nom.edit bWinEdit 
			set type($nom) cec_midiin
			set midiinfo $nom 
			set kill($nom) "destroy $path(winIn).f.$nom; unset value($nom) type($nom)"
			set value($nom) "toLoad"
		}	
	}
	
	
	wm deiconify . 
}

proc cpopup {nom args} {
    global cfont  type value path color kill loading realArr realtim tcl_platform
    catch {array set arp $args} ref
    if {$ref != ""} {bell;errFile2 "error in toggle definition:\n$args";return}
    foreach ar [array names arp] {
	switch -glob -- [string trim $ar "-"] {
	    v*		{set val $arp($ar)}
	    la*		{set nam $arp($ar)}
	    i*		{set init $arp($ar)}
	    default 	{bell;bell;errFile2 "error in popup definition";return} 
	}
    }
    if ![info exists init] {set init [lindex $val 0]}

    if ![info exists nam] {set nam $nom}

    append  realArr(list) "$nom "
    set realtim 1
    set maxl 0
    foreach ar $val {
	if {[string length $ar] > $maxl} {
	    set maxl  [string length $ar] 
	} 
    }
    if ![winfo exists $path(bas).sw] {
	pack [frame $path(bas).sw ] -side left
    }   

    if ![winfo exists $path(opti)] {doPackIrate option}   
    doCsoundPrep $nom $init
    eval optMenu $path(optionopt).$nom realArr(${nom}rec) {{}} [list $cfont(small)] ${color} \
	    7 1 {k-rate record playback load save}
    eval optMenu $path(optionval).${nom}op realArr(${nom}op) {{}} [list $cfont(small)] \
	    ${color} $maxl 1  $val
    label $path(optionnam).$nom -text $nam -anchor w

    # not on MacOS
    if {$tcl_platform(platform) != "macintosh"} {
	pack $path(optionopt).$nom -padx 1  -side top -anchor e -pady 2
    }

    pack $path(optionnam).$nom -side top -anchor e -padx 1 -pady 2
    pack $path(optionval).${nom}op -side top -anchor w -padx 1 -pady 2 -fill y
    set in [$path(optionval).${nom}op.menu index ${init}]
    $path(optionval).${nom}op.menu invoke $in    
    set type($nom) cec_option 
    set kill($nom) "destroy $path(opti); unset value($nom) type($nom)"
    trace variable realArr(${nom}op) w optionpoof
    trace variable realArr(${nom}rec) w dataFilesReal
   $path(optionval).${nom}op.menu activate $in
    optionpoof realArr ${nom}op w
 }

proc optionpoof {args} {
    global realArr path
    set nom [string trimright [lindex $args 1] op]
    set result [$path(optionval).[lindex $args 1].menu index active ] 
    set realArr($nom) $result
    putIt $realArr(${nom}ch) $result
}



proc resetPath {} {
global path grFlag

if $grFlag {set pa .vslide} {set pa $path(bas)}
#    set path(vsli)      .vslide.vsli
    set path(hsli)      $pa.hsli
    set path(opti)      $pa.sw.opti
    set path(togli)     $pa.sw.togli
    set path(toggleopt) $path(togli).opt
    set path(toggleval) $path(togli).val
    set path(optionnam) $path(opti).nam
    set path(optionopt) $path(opti).opt
    set path(optionval) $path(opti).val
    set path(hsliopt)   $path(hsli).opt
    set path(hslinam)   $path(hsli).nam
    set path(hslisca)   $path(hsli).sca
    set path(hslival)   $path(hsli).val
    set path(hsliuni)   $path(hsli).uni
}

proc doPackIrate {what} {
    global path realtime color tcl_platform color grFlag
    # no realtime on MacOS  
    if {$tcl_platform(platform) != "macintosh"} {
	set realtim 1
    }
	
	
#    wm deiconify .pre
    pack .pre.grap   
#     -fill both -expand 1
    switch $what {
    	hslider {
	    if $grFlag {
		if  ![winfo exists .vslide] {
		    makeVslide
		} else {
		    wm deiconify .vslide
		}
		pack [frame $path(hsli)  -relief groove -bd 2] \
			-side top  -fill x -padx 1 -pady 1
		foreach f {opt nam sca val uni} {
		    pack [frame $path(hsli$f) ] -side left -fill x
		}
		pack configure $path(hslisca) -expand 1
	    } else {
		pack [frame $path(hsli)  -relief groove -bd 2] \
			-side left  -fill both -padx 3 -pady 1 -expand 1
		foreach f {opt nam sca val uni} {
		    pack [frame $path(hsli$f)] -side left -fill x
		}
		pack configure $path(hslisca) -expand 1
	    }
	    }
	    
	vslider {
	    if ![winfo exists .vslide] {
		makeVslide
	    } else {
		wm deiconify .vslide
	    }
	    pack [frame $path(vsli) -relief groove -bd 2] -side top -fill both -expand 1  
	    }


	option {
	    if $grFlag {
		if ![winfo exists .vslide] {
		    makeVslide
		} else {
		    wm deiconify .vslide
		}
		if ![winfo exists .vslide.sw] {
			    pack [frame .vslide.sw] \
			    -side top -padx 3 -pady 1 -anchor c
		}
		pack [frame $path(opti) -relief groove -bd 2] \
			 -side top  -anchor c -padx 3 -pady 1 
	    } else {
		    pack [frame $path(opti) -relief groove -bd 2] \
			    -anchor e -side top  -padx 3 -pady 1 -fill x -expand 1	
	    }
		pack [frame $path(optionopt)] -side left  -padx 3 -pady 1 
		pack [frame $path(optionnam)] -side left  -padx 3 -pady 1  
		
		# WEIRD
		if ![winfo exists $path(optionval)] {
		    frame $path(optionval)
		}
	    pack $path(optionval) -side left  -padx 3 -pady 1 
	}
	
	toggle {

	    if $grFlag {
		if ![winfo exists .vslide] {
		    makeVslide
		} else {
		    wm deiconify .vslide
		}
		if ![winfo exists .vslide.sw] {
			    pack [frame .vslide.sw] \
			    -side top -padx 3 -pady 1 -anchor c
		} else {
		wm deiconify .vslide
		}
		pack [frame $path(togli) -relief groove -bd 2] \
			-side top  -padx 3 -pady 1 -anchor c
	    } else {
		pack [frame $path(togli) -relief groove -bd 2] \
			-side top  -padx 3 -pady 1 -anchor e -fill x  -expand 1
	    }
	    pack [frame $path(toggleopt)] -side left  -padx 3 -pady 1
	    pack [frame $path(toggleval)] -side left  -padx 3 -pady 1
	}
	
	midi {
	    if [winfo exists $path(option)] {
		pack [frame $path(midi) -relief groove -bd 2] \
			-side left -before $path(opti) -padx 3 -pady 1
	    } else {
		pack [frame $path(midi) -relief groove -bd 2] \
			-side top  -padx 3 -pady 1
	    }
	    pack [frame $path(midinam)] -side left  -padx 3 -pady 1
	    pack [frame $path(midival)] -side left  -padx 3 -pady 1
	}
    }      
}



proc makeVslide {} {
        global path realtime color tcl_platform color grFlag
  		toplevel .vslide
		wm iconname .vslide "Vertical Sliders"
		wm title .vslide "Sliders"
		bindvslide
		set i [menu .vslide.intermenubar]
		if {$tcl_platform(platform) == "macintosh"} {
		    $i add cascade -menu $i.apple -label Apple
		    menu $i.apple -tearoff 0
		    $i.apple add command  -label "About Cecilia..."  -command getAbout
		}
		
		$i add cascade -label File -menu .menubar.file
		$i add cascade -menu .menubar.option -label Csound
		$i add cascade -label Windows -menu .menubar.wind
		.vslide config -menu $i -bg ${color}3
		.vslide.intermenubar config -bg ${color}3
		bind .menubar <Enter> windowsMenu
}

proc VSetWrap {instr ctrl val} {
    puts "Wrap: AXCSSetVData $instr $ctrl  [expr int($val * 100)] (will be $val in the orc)"
    AXCSSetVData $instr $ctrl  [expr int($val * 100)]
}

proc VSetAutoWrap {idx val} {
    puts "55: AXCSSetVData 55 $idx  [expr int($val * 100)] (will be $val in the orc)"
    AXCSSetVData 55 $idx  [expr int($val * 100)]
}


proc krateSlider {nom kind unite oriente rel res min max col init wid lab nam} {
    global cfont type value path color  kill loading prefs realtim realArr  tcl_platform grFlag
    set realtim 1
    set prefs(wind) 0
    append  realArr(list) "$nom "
    

    if {$lab == "auto"} {
		set maxl [expr [string length $max] + [string length [string trimleft $res .]] + 1]
    } else {set maxl $lab}
    
    if {$rel == "log"} {
     	set init [linInt_to_log10Float $init $min $max]
    }

     doCsoundPrep $nom $init
    if ![winfo exists $path(${oriente}sli)] {doPackIrate ${oriente}slider}
     switch -glob -- $oriente {
	h*  {
	    if {[string match li* $rel]} {
			scale $path(hslisca).$nom -from $min -to $max -bigincrement 1 \
			  -resolution $res -variable realArr($nom)\
			  -command "putIt $realArr(${nom}ch)" \
			  -orient h -showvalue 0  -troughcolor $col -length 150 -width $wid	
	    } else {    
			scale $path(hslisca).$nom -from 0 -to 1 -bigincrement 1 \
			  -resolution $res \
			  -command "slidLog $min $max [expr $max - $min] $nom" \
			  -orient h -showvalue 0  -troughcolor $col -length 150 -width $wid	
	    }	     
	    label $path(hslinam).$nom -text $nam  
	    label $path(hslival).$nom -padx 0 -width 8 -justify right \
		    -anchor e -textvariable  realArr($nom)
	    label $path(hsliuni).$nom -padx 0 -text $unite 
	    eval optMenu $path(hsliopt).$nom realArr(${nom}rec) {{}} [list $cfont(small)] \
		    ${color} 7 1 {k-rate record playback load save}
	    if {$tcl_platform(platform) == "unix" } {
		pack $path(hsliopt).$nom -padx 2  -side top -anchor e -pady 1 -fill x
	    }
	    pack $path(hslinam).$nom -padx 2  -side top -anchor e -pady 1   
	    pack $path(hslisca).$nom -padx 2  -side top -anchor e -pady 1  -fill x -expand 1
	    pack $path(hslival).$nom -padx 2  -side top -anchor e -pady 1  
	    pack $path(hsliuni).$nom -padx 2  -side top -anchor e -pady 1      	   
	    $path(${oriente}slisca).$nom set $init
    }
	
	v*  {
	    pack [frame $path(vsli).$nom -relief groove -bd 2] -side left -expand 1 -fill y
	    if {[string match li* $rel]} {
		scale $path(vsli).$nom.sca -from $max -to $min -bigincrement 1 \
		    -resolution $res -variable realArr($nom)\
		    -command "putIt $realArr(${nom}ch)" \
		    -orient v -showvalue 0  -troughcolor $col -length 150 -width $wid	
	    } else {    
		scale $path(vsli).$nom.sca -from 1 -to 0 -bigincrement 1 \
		    -resolution $res \
		    -command "slidLog $min $max [expr $max - $min] $nom" \
		    -orient v -showvalue 0  -troughcolor $col -length 150 -width $wid	
	    }	     
	    label $path(vsli).$nom.nam -text $nam 
	    label $path(vsli).$nom.val -padx 0 -width $maxl -justify center  -textvariable  realArr($nom)
	    label $path(vsli).$nom.uni -padx 0 -text $unite 
	    eval optMenu $path(vsli).$nom.opt realArr(${nom}rec) {{}} [list $cfont(small)] \
		    ${color} 7 1 {k-rate record playback load save}
	    pack $path(vsli).$nom.nam -padx 2  -side top -anchor c -pady 1
	    pack $path(vsli).$nom.sca -padx 2  -side top -anchor c -pady 1 -fill y -expand 1
	    pack $path(vsli).$nom.val -padx 2  -side top -anchor c -pady 1
	    pack $path(vsli).$nom.uni -padx 2  -side top -anchor c -pady 1 	    
	    if {$tcl_platform(platform) == "unix" } {
		pack $path(vsli).$nom.opt -padx 1  -side top -anchor e -pady 2 -fill x
	    }

	    
	    $path(vsli).$nom.sca set $init
	}
    }
    set type($nom) kslider
    set kill($nom) "destroy $path(hslinam).$nom; 
    destroy $path(hslisca).$nom; 
    destroy $path(hslival).$nom; 
    destroy $path(vsli).$nom; 
    destroy $path(hsliuni).$nom; 
    unset realArr($nom) type($nom)"
    
    trace variable realArr(${nom}rec) w dataFilesReal
    bug ...done with $nom
}


proc linInt_to_log10Float {int min max} {
	expr log10($int/$min) / log10(($min+$max)/$min)
}

proc slidLog {min max ran nom val} {
    global realArr
    set realArr($nom) [cleanFormat [format %.4f [expr 1.0*pow($max/$min,$val)*$min]]]
    putIt $realArr(${nom}ch) $realArr($nom)
}

proc slidLogI {min max ran nom val} {
    global value 
    set value($nom) [cleanFormat [format %.2f [expr 1.0*pow($max/$min,$val)*$min]]]
}

proc irateSlider {nom kind unite oriente rel res min max colo init wid lab nam} {
    global  type typeList value path color  kill loading prefs cfont realtim realArr  tcl_platform    
    set prefs(wind) 0

	set maxl [expr [string length $max] + [string length [string trimleft $res .]] + 1]
    lappend typeList(cec_irateSlider) $nom
    if {$lab == "auto"} {
		set maxl [expr [string length $max] + [string length [string trimleft $res .]] + 1]
    } else {set maxl $lab}
	if {$rel == "log"} {
		set init [linInt_to_log10Float $init $min $max]
    }
    if ![winfo exists $path(${oriente}sli)] {doPackIrate ${oriente}slider}
	switch -glob -- $oriente {
	h* {
		bug slider looks horizontal to me
	    if {[string match li* $rel]} {
		scale $path(${oriente}slisca).$nom  -bigincrement 1 -variable value($nom) -from $min -to $max \
		    -resolution $res  -troughcolor $colo -orient $oriente -showvalue 0 -length 250 -width $wid		
		$path(${oriente}slisca).$nom set $init
	    } {
		scale $path(${oriente}slisca).$nom  -bigincrement 1 -resolution $res -from 0 -to 1 \
		    -command "slidLogI $min $max [expr $max-$min] $nom" -troughcolor $colo -orient $oriente -showvalue 0 -length 250 -width $wid	
	    }
	    label $path(${oriente}slinam).$nom -text $nam 
	    label $path(${oriente}slival).$nom -padx 0 -width $maxl -justify right  -anchor e -textvariable  value($nom)
	    label $path(${oriente}sliuni).$nom -padx 0 -text $unite 
	    eval optMenu $path(${oriente}sliopt).$nom dummy {{}} [list $cfont(small)] ${color} 7 1 {i-rate}		    
	    if {$tcl_platform(platform) == "unix" } {
		pack $path(${oriente}sliopt).$nom -padx 2  -side top -anchor e -pady 1 -fill both 
	    }
	    pack $path(${oriente}slinam).$nom -padx 2  -side top -anchor e -pady 1   
	    pack $path(${oriente}slisca).$nom -padx 2  -side top -anchor e -pady 1 -fill x -expand 1 
	    pack $path(${oriente}slival).$nom -padx 2  -side top -anchor e -pady 1 
	    pack $path(${oriente}sliuni).$nom -padx 2  -side top -anchor w -pady 1     
	    $path(${oriente}slisca).$nom set $init
	    if {$nom == "duree_totale" || $nom == "total_time"} { 
		bind $path(${oriente}slisca).$nom <ButtonRelease> "updateSoundOutDuree" 
	    }
	}

	v* {
	    pack [frame $path(vsli).$nom -relief groove -bd 2] -side left -fill y -expand 1
	    if {[string match li* $rel]} {
		scale $path(vsli).$nom.sca  -bigincrement 1 -variable value($nom) -from $max -to $min \
		    -resolution $res  -troughcolor $colo -orient $oriente -showvalue 0 -length 250 -width $wid		
		$path(vsli).$nom.sca set $init
	    } {
		scale $path(vsli).$nom.sca  -bigincrement 1 -resolution $res -from 1 -to 0 \
		    -command "slidLogI $min $max [expr $max-$min] $nom" -troughcolor $colo -orient $oriente\
		    -showvalue 0 -length 250 -width $wid		
	    }
	    label $path(vsli).$nom.nam -text $nam  
	    label $path(vsli).$nom.val -padx 0 -width $maxl -justify center  -textvariable  value($nom)
	    label $path(vsli).$nom.uni -padx 0 -text $unite 
	    eval optMenu $path(vsli).$nom.opt dummy {{}} [list $cfont(small)] ${color} 7 1 {i-rate}		    
	    pack $path(vsli).$nom.nam -padx 2  -side top -anchor c -pady 1
	    pack $path(vsli).$nom.sca -padx 2  -side top -anchor c -pady 1 -fill y -expand 1
	    pack $path(vsli).$nom.val -padx 2  -side top -anchor c -pady 1
	    pack $path(vsli).$nom.uni -padx 2  -side top -anchor c -pady 1 	    
	    if {$tcl_platform(platform) == "unix" } {
		pack $path(vsli).$nom.opt -padx 2  -side top -anchor c -pady 1 
	    }
	    
	    $path(vsli).$nom.sca set $init
	    if {$nom == "duree_totale" || $nom == "total_time"} { 
		bind $path(vsli).$nom.sca <ButtonRelease> "updateSoundOutDuree" 
	    }

	}
    }    
    set type($nom) islider
    set kill($nom) "destroy $path(${oriente}slinam).$nom; \
    destroy $path(${oriente}slisca).$nom; destroy $path(${oriente}slival).$nom; \
    destroy $path(${oriente}sli).$nom; destroy $path(${oriente}sliuni).$nom; \
    unset value($nom) type($nom)"
}


proc doCsoundPrep {nom init} {
	
	bug doing csoundPrep for $nom at $init
	
    global realArr
    set chan	[expr 100 + [llength $realArr(list)]]
    set chanrec [expr 150 + [llength $realArr(list)]]
    append realArr(chan) "$chanrec "
    set realArr(${nom}ch) $chan
    set realArr(${nom}or) ""
    set realArr(${nom}sc) ""
    set realArr(${nom}hd) ""
    set realArr(${nom}pb) ""
    set realArr(${nom}ch) $chan
    
    append realArr(${nom}or) "
             instr $chan
    gkpp$nom init p4
             endin
    
             instr $chanrec
    gk$nom   = gkpp${nom}
;            kdump gk$nom, \"filezzz\", 6, 4/kr
             endin
"
	
   append realArr(${nom}pb)  "
            instr $chanrec
   gk${nom} oscil1i	0, 1, p3/(gi${chanrec}sz/ftlen($chanrec)),$chanrec
;  gk$nom   port k${nom}zz, portezzz,  $init
	    endin
"
	        
    append realArr(${nom}sc) "i $chanrec 0 "

}

proc dataFilesReal {args} {
    global currentdir realArr env user
    switch $realArr([lindex $args 1]) {
	load {
	    set types { {{All files} * } }
	    set thing [chooseOpen "Choose a file for control info" $currentdir $types]
	    regsub "rec" [lindex $args 1] "" boo
	    set realArr(file$boo) $thing
	    set realArr([lindex $args 1]) playback
	}
	save { 
	    set thing [chooseSave "Name for control data file:" $currentdir $user.tmpReal.[string trim [lindex $args 1]]]
	    if {$thing != ""} {
		regsub "rec" [lindex $args 1] "" name
		exec cp /tmp/$user.tmpReal.$name $thing
		set realArr([lindex $args 1]) playback
	    }
	}
    }
    update
}

proc cmidi {nom event channel min max args} {
    
    global cfont type value path color env kill loading prefs  midiIn midiArr 
    append  midiArr(list) "$nom "
    set midiArr(${nom}ti) ""
    if {[winfo exists $path(midi)] == 0} {doPackIrate midi}   
    set args [join $args]
    if {[llength $args] > 0} { 
	set init [lindex $args 0]  
    } else {
	set init 0
    }
    set midiArr($nom) ""
    set midiArr(${nom}sc) ""
    set midiArr(${nom}hd) ""
    set midiArr(${nom}pb) ""
    append midiArr(chan) "${channel}0 "
    switch $event {
	
	veloc { append midiArr($nom) " 
	instr $channel	
	ivel	veloc
	ivel = ((ivel/127)*($max - $min)) + $min
	gk${nom}zz init ivel
	endin
	instr ${channel}0
	gk$nom port gk${nom}zz, portezzz, $init
	;kdump gk$nom, \"filezzz\", 6, 4/kr
	endin
	"
	append midiArr(${nom}sc) "i${channel}0 0 "
	append midiArr(${nom}hd) "gk${nom}zz init $init\ngk${nom} init $init
	"
	}
    }
    
	 	
    append midiArr(${nom}pb) "
	    instr ${channel}
	    endin
	    instr ${channel}0
		k${nom}zz oscil1i	0, 1, p3/(gi${channel}sz/ftlen(${channel}0)),${channel}0 
		gk$nom port k${nom}zz, portezzz,  $init
	    endin
	    "
    set prefs(midi) 1   
    set midiIn 1
    set type($nom) cec_midi
    eval optMenu $path(midival).$nom midiArr(${channel}0rec) {{}} [list $cfont(small)] ${color} 12 1 {k-rate midi_record playback load save}
    label $path(midinam).$nom -text ${nom}-channel${channel} -anchor w
    pack $path(midinam).$nom -side top -anchor e -padx 1 -fill x
    pack $path(midival).$nom -side top -anchor w -padx 1 -fill x
    set kill($nom) "destroy $path(midinam).$nom $path(midival).$nom; unset midiArr($nom) value($nom)value(${nom}_playlag) type($nom)"
    krateSlider ${nom}_playlag i s. h .001 .001 .5 .01 
    trace variable midiArr(${channel}0rec) w dataFilesMidi

}

proc dataFilesMidi {args} {
global currentdir midiArr env user
switch $midiArr([lindex $args 1]) {
    load {set thing [fileselector "Choose a file for control info" $currentdir 0]
    set boo [string trim [lindex $args 1] rec]
     set midiArr(file$boo) $thing
    set midiArr([lindex $args 1]) playback
	    }
    save { 
	set thing [fileselector "Name for control data file:" $currentdir 1]
	if {$thing != ""} {
	    exec cp /tmp/$user.tmpMidi.[string trim [lindex $args 1] rec] $thing
	    set midiArr([lindex $args 1]) playback
	}
	}
    }
    update
}



proc cggraph {nom unit rel min max gen size nam func myspline} {
    global path couleur cfont type genID actif kill loading longnom rtparam
    global color limite  splineLine value initGraph paramode isRealTime
    global relation seuil ambitus resetValue actif unite xScale xUnite tcl_platform
    global gensize data graphidx myidx idx

    set genID($nom) $gen
    if {[string match lo* $rel] && $min <= 0} {
	errFile2 "error in graph $nom:\n min <= 0 (in a log relationship...)"
	return 0
    }
    if {$max <= $min} {
	errFile2 "error in graph $nom:\n min < max!"
	return 0
    }
    set gensize($nom) $size 
    set subKill "gensize($nom)"
    foreach word [split $nam \n] {
	    if {[set sl [string length $word]] > $longnom} {
	    	bug $word the longest yet ($sl chars)
	    	set longnom $sl} 
	   }
	   
    set unite($nom) $unit
    set relation($nom) $rel
    set seuil($nom) $min; set ambitus($nom) [expr $max - $min]


    if {[llength $func] == 1} {
    	
    	if {$func<$min || $func>$max} {
	    	errFile2 "error in graph $nom:\n  min < init < max!"
	    	return 0
	    }
	    
		set floatY($nom) [paramToFloat $func $nom]
		set resetValue($nom) "0.0 $floatY($nom) 1.0 $floatY($nom)"
 		set screenY [floatToScreenY $floatY($nom)]
 		
 	} else {
 		
		set resetValue($nom) ""
		array set vals $func
		foreach point [lsort -real [array names vals]] {
	 		append resetValue($nom) "[expr $point*1.0] [expr [paramToFloat $vals($point) $nom] *1.0] "
	 	}
	 
		set floatY($nom) [paramToFloat [lindex $func 1] $nom]
		set screenY [floatToScreenY $floatY($nom)]
	}

 		set splineLine($nom) $myspline	
   	   
    set data($nom) ""

    # hack pour une bidirectionalite dans l'array
    set myidx($nom) [incr graphidx]
    set idx($graphidx) $nom
	
    set couleur($nom) $couleur([llength [array names data]])
    set couleur(std,$nom) $couleur($nom)
    set couleur(off,$nom) 0

    checkbutton $path(param).check$nom -disabledforeground \#444444 \
	     -selectcolor $couleur($nom) -command "toggleGraph $nom"  

    
    checkbutton $path(param).mode$nom -disabledforeground \#444444 \
	     -variable isRealTime($nom) \
	    -selectcolor $couleur($nom) -command "toggleMode $nom"  
    
    frame $path(param).rt$nom
    
    pack [scale $path(param).rt$nom.s  -borderwidth 1 \
	    -variable rt($nom) -command "VSetAutoWrap $myidx($nom)" \
	    -resolution [expr 1.0*$ambitus($nom)/1000] \
	    -from $min -to $max -highlightcolor [dimcolor $couleur($nom)] -showvalue 0  -orient h] \
	    -fill both -expand t
    bind $path(param).check$nom <Double-Button-1> "toggleSpline $nom"
    if {$tcl_platform(platform) == "windows"} {
	grid $path(param).mode$nom  -column 1 -row $graphidx -sticky e
    }
    bindHelp $path(param).mode$nom bGraphMode
    bindHelp $path(param).rt$nom sRealtime
    
    radiobutton $path(param).select$nom  -border 1 \
	    -indicatoron 0 -disabledforeground \#444444 -width [expr $longnom +1] \
	    -bg [dimcolor $couleur($nom)] -value $nom \
	    -text $nam -selectcolor $couleur($nom) -command "selectGraph $nom"
    
    label $path(param).label$nom -bg [dimcolor $couleur($nom)]  -text $nom  -width [expr $longnom +1]
 
    bind $path(param).check$nom <Double-Button-1> "soloGraph $nom"
    $path(param).check$nom select

    grid $path(param).select$nom  -column 2 -row $graphidx -sticky ew
    grid $path(param).check$nom  	-column 3 -row $graphidx -sticky ew
    
    $path(area) create line $limite(pad) $screenY $limite(supX) $screenY \
	    -width 0 -tags [list line line.$nom] -fill $couleur($nom) -smooth $splineLine($nom)
    $path(area) bind line.$nom <Double-Button-1> "toggleSpline $nom"
    
    bindHelp $path(param).check$nom bGraphCheck
    bindHelp $path(param).mode$nom bGraphMode
    bindHelp $path(param).rt$nom sRealtime
    bindHelp $path(param).select$nom bGraphSelect
    set actif $nom
    greset $nom
    set type($nom) cec_graph
    if {![info exists initGraph]} {set initGraph $nom}
    set kill($nom) "destroy $path(param).check$nom ; $path(area) delete line.$nom; unset data($nom) type($nom) $subKill"
}
    
proc toggleMode {cible} {
    global path myidx
    if [winfo viewable $path(param).rt$cible] {	
	# graph mode
	grid forget $path(param).rt$cible
	grid forget $path(param).label$cible
	grid forget $path(param).label$cible
	grid $path(param).check$cible  	-column 3 -row $myidx($cible) -sticky ewns
	grid $path(param).select$cible  -column 2 -row $myidx($cible) -sticky ewns
	grid $path(param).mode$cible  	-column 1 -row $myidx($cible) -sticky e	
    } {
	# realtime mode
	grid forget $path(param).check$cible
	grid forget $path(param).select$cible
	grid forget $path(param).label$cible
	grid $path(param).rt$cible  	-column 0 -row $myidx($cible) -sticky ewns
	grid $path(param).label$cible  	-column 1 -row $myidx($cible) -sticky ewns
	grid $path(param).mode$cible  	-column 2 -row $myidx($cible) -sticky w
	VSetWrap 55 [expr $myidx($cible) + 100] 10	
    }
}

proc csepar {args} {
    global  path color type b graphidx
    incr b; set nom sepa$b
    incr graphidx
    if {[llength $args] > 1} {  set stuff [lindex $args 1]  } else { set stuff ""}
    label $path(param).select$nom -border 1 -justify center -text $stuff
    label $path(param).check$nom -border 1 -text "\ " 
    grid $path(param).select$nom -column 2 -row $graphidx -sticky ew
    grid $path(param).check$nom -column 3 -row $graphidx -sticky ew
    set type($nom) cec_separateur
}


proc makeValue {win nomx nomy x y} {
    global realArr mouseRange
    set realArr($nomx) [expr (($x/[winfo width $win].0) * \
	    ($mouseRange(xmax)-$mouseRange(xmin))) + $mouseRange(xmin)]
    set realArr($nomy) [expr (($y/[winfo height $win].0)* \
	    ($mouseRange(ymax)-$mouseRange(ymin))) + $mouseRange(ymin)]
}

proc cslider {args} {
    bug making a cslider ($args)
    catch {array set arp [lrange $args 1 end]} ref
    if {$ref != ""} {bell;bell;errFile2 "error in slider definition:\n$args";return}
    array set defaults  {kin k uni x ori h res .01 min 0 max 100 rel lin col gray60 wid 10 lab auto}
    set nom [lindex $args 0]
    foreach ar [array names arp] {
	switch -glob -- [string trim $ar "-"] {
	    la*		{set nam $arp($ar)}
	    mi*		{set min $arp($ar)}
	    ma*		{set max $arp($ar)}
	    rel*	{set rel $arp($ar)}
	    res*	{set res $arp($ar)}
	    ra*		{set kin $arp($ar)}
	    u*		{set uni $arp($ar)}
	    i*		{set ini $arp($ar)}
	    o*		{set ori $arp($ar)}
	    c*		{set col $arp($ar)}
	    w*		{set wid $arp($ar)}
	    l*		{set lab $arp($ar)}
	    default 	{bell;bell;errFile2 "error in slider definition";return} 
	}
    }
    foreach arf [array names defaults] {
	if ![info exists $arf] {
		set $arf $defaults($arf)}
	}
     if {[string match lo* $rel] && $min <= 0} {errFile2 "Warning: resetting log graph\n $nom to 0.001"; set min .001}

    if {$nom == ""} {bell;bell;errFile2 "Error in slider definition: NAME is not defined";return}
    if {[string match lo* $rel] && ($min <= 0)} {
		errFile2 "log sliders must have a minimum higher than 0:\n slider named: $nom"
		return
    }
    if ![info exists nam] {set nam $nom}
    if ![info exists ini] {set ini $min}
    if {$nom == "duree_totale" || $nom == "total_time"} {
	irateSlider $nom $kin $uni $ori $rel $res $min $max $col $ini $wid $lab $nam 
	return
    }
    if {$kin == "k"} {
        if {$col == "gray60"} {set col gray80}
		bug  krateSlider $nom $kin $uni $ori $rel $res $min $max $col $ini $wid $lab $nam
        krateSlider $nom $kin $uni $ori $rel $res $min $max $col $ini $wid $lab $nam
	} {
		bug irateSlider $nom $kin $uni $ori $rel $res $min $max $col $ini $wid $lab $nam 
        irateSlider $nom $kin $uni $ori $rel $res $min $max $col $ini $wid $lab $nam 
    }
}


proc cgraph {nom args} {
global prefs genBank soundOutInfo
    bug preparing a graph ($args)
    catch {array set arp $args} ref
    set genBank [expr $genBank + 1]
    bug buildling a graph ($nom, $args)

    if {$ref != ""} {bell;bell;errFile2 "error in graph definition:\n$ref\n$args";return}
    array set defaults  "spline 0 uni x min 0 max 100 rel lin gen $genBank size $soundOutInfo(userGEN)"
    foreach ar [array names arp] {
	switch -glob -- [string trim $ar "-"] {
	    la*		{set nam $arp($ar)}
	    mi*		{set min $arp($ar)}
	    ma*		{set max $arp($ar)}
	    rel*	{set rel $arp($ar)}
	    u*		{set uni $arp($ar)}
	    i*		{set init $arp($ar)}
	    l*		{set lab $arp($ar)}
	    gen*	{set gen $arp($ar)}
	    size*	{set size $arp($ar)}
	    spline*     {set spline $arp($ar)}
	    fu*		{set func $arp($ar)}
	    default 	{bell;bell;errFile2 "error in graph definition\n$ar\n$args";return} 
	}
    }
    foreach arf [array names defaults] {
	if ![info exists $arf] {set $arf $defaults($arf)}
    }
    if {[string match lo* $rel] && $min <= 0} {errFile2 "Warning: resetting log graph\n $nom to 0.001"; set min .001}
    if ![info exists nam] {set nam $nom}
    if ![info exists func] {
	if ![info exists init] {set func "$min"} {set func $init}
	} {
	if {[expr [llength $func]%2] != 0} {
		errFile2 "Illegal function def: $nom \n(minimum 4 points & even no. of points)"
		return 0
	}
    }
    cggraph $nom $uni $rel $min $max $gen $size $nam $func $spline
}


proc cec_separateur {args} {puts boll;csepar $args}
proc cec_toggle {args} {puts bell;ctoggle $args} 
proc cec_filein {args} {puts bull;cfilein $args} 

proc cec_graph {args} {puts bill;  
    cgraph [lindex $args 0] \
    -unit [lindex $args 1] \
    -rel [lindex $args 2] \
    -min [lindex $args 3] \
    -max [lindex $args 4] \
    -ini [lindex $args 5] \
    -gen [lindex $args 6] \
}

proc cec_slider {args} {puts BUU;
    cslider [lindex $args 0] \
    -ra [lindex $args 1] \
    -uni [lindex $args 2] \
    -ori [lindex $args 3] \
    -res [lindex $args 4] \
    -min [lindex $args 5] \
    -max [lindex $args 6] \
    -ini [lindex $args 7] \
}

proc cec_popup {args} {puts BAA;
    cpopup [lindex $args 0] \
    -val [lrange $args 1 end] \
}
