/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ctk-menu-seperator.h"
#include <glib.h>
#include <math.h>

G_DEFINE_TYPE (CtkMenuSeperator, ctk_menu_seperator, CTK_TYPE_ACTOR);

static void
ctk_menu_seperator_init (CtkMenuSeperator *object)
{
  clutter_actor_set_reactive (CLUTTER_ACTOR (object), FALSE);
}

static void
ctk_menu_seperator_finalize (GObject *object)
{
  G_OBJECT_CLASS (ctk_menu_seperator_parent_class)->finalize (object);
}

static void
ctk_menu_seperator_get_preferred_width (ClutterActor *actor,
                                        gfloat        for_height,
                                        gfloat       *min_width_p,
                                        gfloat       *natural_width_p)
{
  CtkPadding padding;
  ctk_actor_get_padding (CTK_ACTOR (actor), &padding);

  *min_width_p = 1.0f + padding.left + padding.right;
  *natural_width_p = 1.0f + padding.left + padding.right;
}

static void
ctk_menu_seperator_get_preferred_height (ClutterActor *actor,
                                         gfloat        for_height,
                                         gfloat       *min_height_p,
                                         gfloat       *natural_height_p)
{
  CtkPadding padding;
  ctk_actor_get_padding (CTK_ACTOR (actor), &padding);

  *min_height_p = 1.0f + padding.top + padding.bottom;
  *natural_height_p = 1.0f + padding.top + padding.bottom;
}

static void
ctk_menu_paint_seperator_real (ClutterActor *actor, const ClutterColor *color)
{
  float width, height;
  ClutterActorBox allocation;
  CtkPadding padding;

  cogl_set_source_color4ub (color->red,
                            color->green,
                            color->blue,
                            color->alpha);

  ctk_actor_get_padding (CTK_ACTOR (actor), &padding);
  ctk_actor_get_stored_allocation (CTK_ACTOR (actor), &allocation);
  clutter_actor_box_get_size (&allocation, &width, &height);

  width += padding.left + padding.right;
  height += padding.top + padding.bottom;

  cogl_path_rectangle (floor (padding.left),
                       floor (padding.top),
                       floor (width),
                       floor (height));
  cogl_path_fill ();
  return;
}

static void
ctk_menu_seperator_paint (ClutterActor *actor)
{
  guint8 paint_opacity = clutter_actor_get_paint_opacity (actor);
  ClutterColor color = {0xFF, 0xFF, 0xFF, paint_opacity};

  ctk_menu_paint_seperator_real (actor, &color);
}

static void
ctk_menu_seperator_pick (ClutterActor *actor, const ClutterColor *color)
{
  ctk_menu_paint_seperator_real (actor, color);
}

static void
ctk_menu_seperator_class_init (CtkMenuSeperatorClass *klass)
{
  GObjectClass* object_class = G_OBJECT_CLASS (klass);
  ClutterActorClass *act_class = CLUTTER_ACTOR_CLASS (klass);

  act_class->paint                = ctk_menu_seperator_paint;
  act_class->pick                 = ctk_menu_seperator_pick;
  act_class->get_preferred_width  = ctk_menu_seperator_get_preferred_width;
  act_class->get_preferred_height = ctk_menu_seperator_get_preferred_height;

  object_class->finalize = ctk_menu_seperator_finalize;
}

/* constructors */
CtkMenuSeperator *
ctk_menu_seperator_new (void)
{
  CtkMenuSeperator *item;
  item = g_object_new (CTK_TYPE_MENU_SEPERATOR,
                       NULL);
  return item;
}
