/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gord
 *
 */

#ifndef _CTK_MENU_H_
#define _CTK_MENU_H_

#include <glib.h>
#include <clutk/ctk-actor.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define CTK_TYPE_MENU (ctk_menu_get_type ())

#define CTK_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
  CTK_TYPE_MENU, CtkMenu))

#define CTK_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
  CTK_TYPE_MENU, CtkMenuClass))

#define CTK_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
  CTK_TYPE_MENU))

#define CTK_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
  CTK_TYPE_MENU))

#define CTK_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
  CTK_TYPE_MENU, CtkMenuClass))

typedef struct _CtkMenu         CtkMenu;
typedef struct _CtkMenuClass    CtkMenuClass;
typedef struct _CtkMenuPrivate  CtkMenuPrivate;

struct _CtkMenu
{
  CtkActor parent;

  CtkMenuPrivate *priv;
};

struct _CtkMenuClass
{
  /*< private >*/
  CtkActorClass  parent_class;

  /*< signals />*/
  void (*closed)           (CtkMenu *menu);
};

GType  ctk_menu_get_type (void) G_GNUC_CONST;

CtkMenu *ctk_menu_new (void);
CtkMenu *ctk_menu_new_with_background (ClutterActor *background);

void                ctk_menu_set_spacing      (CtkMenu      *menu,
                                              gint          spacing);

gint                ctk_menu_get_spacing      (CtkMenu *menu);
gint                ctk_menu_get_num_items    (CtkMenu *menu);
void                ctk_menu_append           (CtkMenu *menu,
                                               ClutterActor *item,
                                               gboolean is_special);
void                ctk_menu_prepend          (CtkMenu *menu,
                                               ClutterActor *item,
                                               gboolean is_special);

void                ctk_menu_attach_to_actor     (CtkMenu *menu,
                                                  CtkActor *actor);
CtkActor *          ctk_menu_get_attached_actor  (CtkMenu *menu);
void                ctk_menu_set_color           (CtkMenu *menu,
                                                  ClutterColor *color);
void                ctk_menu_set_background      (CtkMenu *menu,
                                                  ClutterActor *background);
ClutterActor *      ctk_menu_get_background      (CtkMenu *menu);
void                ctk_menu_set_detect_clicks   (CtkMenu *menu,
                                                  gboolean value);
void                ctk_menu_set_swallow_clicks  (CtkMenu *menu,
                                                  gboolean value);
void                ctk_menu_remove_all          (CtkMenu *self);

void                ctk_menu_refresh_background_texture (CtkMenu *self);
guint               ctk_menu_get_framebuffer_background (CtkMenu *self);

gboolean            ctk_menu_get_close_on_leave (CtkMenu *self);
void                ctk_menu_set_close_on_leave (CtkMenu *self, gboolean value);

G_END_DECLS

#endif /* _CTK_MENU_H_ */

