/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_PRIVATE_H_
#define _CTK_PRIVATE_H_

G_BEGIN_DECLS

#define CTK_PARAM_READWRITE \
        (G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_STATIC_NICK | \
         G_PARAM_STATIC_NAME | G_PARAM_STATIC_BLURB)

/**
 * CtkCapability:
 * @CTK_CAPABILITY_FBO: GPU has FBO support
 * @CTK_CAPABILITY_GLSL: GPU has GLSL support
 *
 * Capabilities checked by #ctk_init
 **/
typedef enum
{
  CTK_CAPABILITY_FBO=0,
  CTK_CAPABILITY_GLSL,
  CTK_CAPABILITY_SHADER_OBJECTS,
  CTK_CAPABILITY_VERTEX_SHADER,
  CTK_CAPABILITY_FRAGMENT_SHADER,
  CTK_CAPABILITY_VERTEX_PROGRAM,
  CTK_CAPABILITY_FRAGMENT_PROGRAM,
  CTK_CAPABILITY_NON_POWER_OF_TWO_TEXTURE,
  CTK_CAPABILITY_TEXTURE_RECTANGLE,
} CtkCapability;

/**
 * CtkOpenGLVersion:
 *
 * OpenGL version supported by the GPU
 **/
typedef enum
{
  CTK_OPENGL_1_1=0,
  CTK_OPENGL_1_2,
  CTK_OPENGL_1_3,
  CTK_OPENGL_1_4,
  CTK_OPENGL_1_5,
  CTK_OPENGL_2_0,
  CTK_OPENGL_2_1,
  CTK_OPENGL_3_0,
  CTK_OPENGL_3_1,
  CTK_OPENGL_3_2,
} CtkOpenGLVersion;

/**
 * CtkGLSLVersion:
 *
 * GLSL version supported by the GPU
 **/
typedef enum
{
  CTK_GLSL_1_10=0,
  CTK_GLSL_1_20,
  CTK_GLSL_1_30,
  CTK_GLSL_1_40,
} CtkGLSLVersion;

gboolean ctk_has_capability (CtkCapability capability);

gboolean ctk_has_opengl_version (CtkOpenGLVersion version);

gboolean ctk_has_glsl_version (CtkGLSLVersion version);

gboolean ctk_glsl_shaders_compiled_and_ready ();

gboolean ctk_asm_shaders_compiled_and_ready ();

G_END_DECLS

#endif /* _CTK_PRIVATE_H_ */
