/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Authored By Matthew Allum  <mallum@openedhand.com>
 *
 * Copyright (C) 2006 OpenedHand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __CLUTTER_KEYSYMS_H__
#define __CLUTTER_KEYSYMS_H__

/* This file based on GDK's gdkkeysyms.h which in turn
 * I think is from xlibs keysymdef.h
*/

#define CLUTTER_VoidSymbol 0xFFFFFF
#define CLUTTER_BackSpace 0xFF08
#define CLUTTER_Tab 0xFF09
#define CLUTTER_Linefeed 0xFF0A
#define CLUTTER_Clear 0xFF0B
#define CLUTTER_Return 0xFF0D
#define CLUTTER_Pause 0xFF13
#define CLUTTER_Scroll_Lock 0xFF14
#define CLUTTER_Sys_Req 0xFF15
#define CLUTTER_Escape 0xFF1B
#define CLUTTER_Delete 0xFFFF
#define CLUTTER_Multi_key 0xFF20
#define CLUTTER_Codeinput 0xFF37
#define CLUTTER_SingleCandidate 0xFF3C
#define CLUTTER_MultipleCandidate 0xFF3D
#define CLUTTER_PreviousCandidate 0xFF3E
#define CLUTTER_Kanji 0xFF21
#define CLUTTER_Muhenkan 0xFF22
#define CLUTTER_Henkan_Mode 0xFF23
#define CLUTTER_Henkan 0xFF23
#define CLUTTER_Romaji 0xFF24
#define CLUTTER_Hiragana 0xFF25
#define CLUTTER_Katakana 0xFF26
#define CLUTTER_Hiragana_Katakana 0xFF27
#define CLUTTER_Zenkaku 0xFF28
#define CLUTTER_Hankaku 0xFF29
#define CLUTTER_Zenkaku_Hankaku 0xFF2A
#define CLUTTER_Touroku 0xFF2B
#define CLUTTER_Massyo 0xFF2C
#define CLUTTER_Kana_Lock 0xFF2D
#define CLUTTER_Kana_Shift 0xFF2E
#define CLUTTER_Eisu_Shift 0xFF2F
#define CLUTTER_Eisu_toggle 0xFF30
#define CLUTTER_Kanji_Bangou 0xFF37
#define CLUTTER_Zen_Koho 0xFF3D
#define CLUTTER_Mae_Koho 0xFF3E
#define CLUTTER_Home 0xFF50
#define CLUTTER_Left 0xFF51
#define CLUTTER_Up 0xFF52
#define CLUTTER_Right 0xFF53
#define CLUTTER_Down 0xFF54
#define CLUTTER_Prior 0xFF55
#define CLUTTER_Page_Up 0xFF55
#define CLUTTER_Next 0xFF56
#define CLUTTER_Page_Down 0xFF56
#define CLUTTER_End 0xFF57
#define CLUTTER_Begin 0xFF58
#define CLUTTER_Select 0xFF60
#define CLUTTER_Print 0xFF61
#define CLUTTER_Execute 0xFF62
#define CLUTTER_Insert 0xFF63
#define CLUTTER_Undo 0xFF65
#define CLUTTER_Redo 0xFF66
#define CLUTTER_Menu 0xFF67
#define CLUTTER_Find 0xFF68
#define CLUTTER_Cancel 0xFF69
#define CLUTTER_Help 0xFF6A
#define CLUTTER_Break 0xFF6B
#define CLUTTER_Mode_switch 0xFF7E
#define CLUTTER_script_switch 0xFF7E
#define CLUTTER_Num_Lock 0xFF7F
#define CLUTTER_KP_Space 0xFF80
#define CLUTTER_KP_Tab 0xFF89
#define CLUTTER_KP_Enter 0xFF8D
#define CLUTTER_KP_F1 0xFF91
#define CLUTTER_KP_F2 0xFF92
#define CLUTTER_KP_F3 0xFF93
#define CLUTTER_KP_F4 0xFF94
#define CLUTTER_KP_Home 0xFF95
#define CLUTTER_KP_Left 0xFF96
#define CLUTTER_KP_Up 0xFF97
#define CLUTTER_KP_Right 0xFF98
#define CLUTTER_KP_Down 0xFF99
#define CLUTTER_KP_Prior 0xFF9A
#define CLUTTER_KP_Page_Up 0xFF9A
#define CLUTTER_KP_Next 0xFF9B
#define CLUTTER_KP_Page_Down 0xFF9B
#define CLUTTER_KP_End 0xFF9C
#define CLUTTER_KP_Begin 0xFF9D
#define CLUTTER_KP_Insert 0xFF9E
#define CLUTTER_KP_Delete 0xFF9F
#define CLUTTER_KP_Equal 0xFFBD
#define CLUTTER_KP_Multiply 0xFFAA
#define CLUTTER_KP_Add 0xFFAB
#define CLUTTER_KP_Separator 0xFFAC
#define CLUTTER_KP_Subtract 0xFFAD
#define CLUTTER_KP_Decimal 0xFFAE
#define CLUTTER_KP_Divide 0xFFAF
#define CLUTTER_KP_0 0xFFB0
#define CLUTTER_KP_1 0xFFB1
#define CLUTTER_KP_2 0xFFB2
#define CLUTTER_KP_3 0xFFB3
#define CLUTTER_KP_4 0xFFB4
#define CLUTTER_KP_5 0xFFB5
#define CLUTTER_KP_6 0xFFB6
#define CLUTTER_KP_7 0xFFB7
#define CLUTTER_KP_8 0xFFB8
#define CLUTTER_KP_9 0xFFB9
#define CLUTTER_F1 0xFFBE
#define CLUTTER_F2 0xFFBF
#define CLUTTER_F3 0xFFC0
#define CLUTTER_F4 0xFFC1
#define CLUTTER_F5 0xFFC2
#define CLUTTER_F6 0xFFC3
#define CLUTTER_F7 0xFFC4
#define CLUTTER_F8 0xFFC5
#define CLUTTER_F9 0xFFC6
#define CLUTTER_F10 0xFFC7
#define CLUTTER_F11 0xFFC8
#define CLUTTER_L1 0xFFC8
#define CLUTTER_F12 0xFFC9
#define CLUTTER_L2 0xFFC9
#define CLUTTER_F13 0xFFCA
#define CLUTTER_L3 0xFFCA
#define CLUTTER_F14 0xFFCB
#define CLUTTER_L4 0xFFCB
#define CLUTTER_F15 0xFFCC
#define CLUTTER_L5 0xFFCC
#define CLUTTER_F16 0xFFCD
#define CLUTTER_L6 0xFFCD
#define CLUTTER_F17 0xFFCE
#define CLUTTER_L7 0xFFCE
#define CLUTTER_F18 0xFFCF
#define CLUTTER_L8 0xFFCF
#define CLUTTER_F19 0xFFD0
#define CLUTTER_L9 0xFFD0
#define CLUTTER_F20 0xFFD1
#define CLUTTER_L10 0xFFD1
#define CLUTTER_F21 0xFFD2
#define CLUTTER_R1 0xFFD2
#define CLUTTER_F22 0xFFD3
#define CLUTTER_R2 0xFFD3
#define CLUTTER_F23 0xFFD4
#define CLUTTER_R3 0xFFD4
#define CLUTTER_F24 0xFFD5
#define CLUTTER_R4 0xFFD5
#define CLUTTER_F25 0xFFD6
#define CLUTTER_R5 0xFFD6
#define CLUTTER_F26 0xFFD7
#define CLUTTER_R6 0xFFD7
#define CLUTTER_F27 0xFFD8
#define CLUTTER_R7 0xFFD8
#define CLUTTER_F28 0xFFD9
#define CLUTTER_R8 0xFFD9
#define CLUTTER_F29 0xFFDA
#define CLUTTER_R9 0xFFDA
#define CLUTTER_F30 0xFFDB
#define CLUTTER_R10 0xFFDB
#define CLUTTER_F31 0xFFDC
#define CLUTTER_R11 0xFFDC
#define CLUTTER_F32 0xFFDD
#define CLUTTER_R12 0xFFDD
#define CLUTTER_F33 0xFFDE
#define CLUTTER_R13 0xFFDE
#define CLUTTER_F34 0xFFDF
#define CLUTTER_R14 0xFFDF
#define CLUTTER_F35 0xFFE0
#define CLUTTER_R15 0xFFE0
#define CLUTTER_Shift_L 0xFFE1
#define CLUTTER_Shift_R 0xFFE2
#define CLUTTER_Control_L 0xFFE3
#define CLUTTER_Control_R 0xFFE4
#define CLUTTER_Caps_Lock 0xFFE5
#define CLUTTER_Shift_Lock 0xFFE6
#define CLUTTER_Meta_L 0xFFE7
#define CLUTTER_Meta_R 0xFFE8
#define CLUTTER_Alt_L 0xFFE9
#define CLUTTER_Alt_R 0xFFEA
#define CLUTTER_Super_L 0xFFEB
#define CLUTTER_Super_R 0xFFEC
#define CLUTTER_Hyper_L 0xFFED
#define CLUTTER_Hyper_R 0xFFEE
#define CLUTTER_ISO_Lock 0xFE01
#define CLUTTER_ISO_Level2_Latch 0xFE02
#define CLUTTER_ISO_Level3_Shift 0xFE03
#define CLUTTER_ISO_Level3_Latch 0xFE04
#define CLUTTER_ISO_Level3_Lock 0xFE05
#define CLUTTER_ISO_Group_Shift 0xFF7E
#define CLUTTER_ISO_Group_Latch 0xFE06
#define CLUTTER_ISO_Group_Lock 0xFE07
#define CLUTTER_ISO_Next_Group 0xFE08
#define CLUTTER_ISO_Next_Group_Lock 0xFE09
#define CLUTTER_ISO_Prev_Group 0xFE0A
#define CLUTTER_ISO_Prev_Group_Lock 0xFE0B
#define CLUTTER_ISO_First_Group 0xFE0C
#define CLUTTER_ISO_First_Group_Lock 0xFE0D
#define CLUTTER_ISO_Last_Group 0xFE0E
#define CLUTTER_ISO_Last_Group_Lock 0xFE0F
#define CLUTTER_ISO_Left_Tab 0xFE20
#define CLUTTER_ISO_Move_Line_Up 0xFE21
#define CLUTTER_ISO_Move_Line_Down 0xFE22
#define CLUTTER_ISO_Partial_Line_Up 0xFE23
#define CLUTTER_ISO_Partial_Line_Down 0xFE24
#define CLUTTER_ISO_Partial_Space_Left 0xFE25
#define CLUTTER_ISO_Partial_Space_Right 0xFE26
#define CLUTTER_ISO_Set_Margin_Left 0xFE27
#define CLUTTER_ISO_Set_Margin_Right 0xFE28
#define CLUTTER_ISO_Release_Margin_Left 0xFE29
#define CLUTTER_ISO_Release_Margin_Right 0xFE2A
#define CLUTTER_ISO_Release_Both_Margins 0xFE2B
#define CLUTTER_ISO_Fast_Cursor_Left 0xFE2C
#define CLUTTER_ISO_Fast_Cursor_Right 0xFE2D
#define CLUTTER_ISO_Fast_Cursor_Up 0xFE2E
#define CLUTTER_ISO_Fast_Cursor_Down 0xFE2F
#define CLUTTER_ISO_Continuous_Underline 0xFE30
#define CLUTTER_ISO_Discontinuous_Underline 0xFE31
#define CLUTTER_ISO_Emphasize 0xFE32
#define CLUTTER_ISO_Center_Object 0xFE33
#define CLUTTER_ISO_Enter 0xFE34
#define CLUTTER_dead_grave 0xFE50
#define CLUTTER_dead_acute 0xFE51
#define CLUTTER_dead_circumflex 0xFE52
#define CLUTTER_dead_tilde 0xFE53
#define CLUTTER_dead_macron 0xFE54
#define CLUTTER_dead_breve 0xFE55
#define CLUTTER_dead_abovedot 0xFE56
#define CLUTTER_dead_diaeresis 0xFE57
#define CLUTTER_dead_abovering 0xFE58
#define CLUTTER_dead_doubleacute 0xFE59
#define CLUTTER_dead_caron 0xFE5A
#define CLUTTER_dead_cedilla 0xFE5B
#define CLUTTER_dead_ogonek 0xFE5C
#define CLUTTER_dead_iota 0xFE5D
#define CLUTTER_dead_voiced_sound 0xFE5E
#define CLUTTER_dead_semivoiced_sound 0xFE5F
#define CLUTTER_dead_belowdot 0xFE60
#define CLUTTER_dead_hook 0xFE61
#define CLUTTER_dead_horn 0xFE62
#define CLUTTER_First_Virtual_Screen 0xFED0
#define CLUTTER_Prev_Virtual_Screen 0xFED1
#define CLUTTER_Next_Virtual_Screen 0xFED2
#define CLUTTER_Last_Virtual_Screen 0xFED4
#define CLUTTER_Terminate_Server 0xFED5
#define CLUTTER_AccessX_Enable 0xFE70
#define CLUTTER_AccessX_Feedback_Enable 0xFE71
#define CLUTTER_RepeatKeys_Enable 0xFE72
#define CLUTTER_SlowKeys_Enable 0xFE73
#define CLUTTER_BounceKeys_Enable 0xFE74
#define CLUTTER_StickyKeys_Enable 0xFE75
#define CLUTTER_MouseKeys_Enable 0xFE76
#define CLUTTER_MouseKeys_Accel_Enable 0xFE77
#define CLUTTER_Overlay1_Enable 0xFE78
#define CLUTTER_Overlay2_Enable 0xFE79
#define CLUTTER_AudibleBell_Enable 0xFE7A
#define CLUTTER_Pointer_Left 0xFEE0
#define CLUTTER_Pointer_Right 0xFEE1
#define CLUTTER_Pointer_Up 0xFEE2
#define CLUTTER_Pointer_Down 0xFEE3
#define CLUTTER_Pointer_UpLeft 0xFEE4
#define CLUTTER_Pointer_UpRight 0xFEE5
#define CLUTTER_Pointer_DownLeft 0xFEE6
#define CLUTTER_Pointer_DownRight 0xFEE7
#define CLUTTER_Pointer_Button_Dflt 0xFEE8
#define CLUTTER_Pointer_Button1 0xFEE9
#define CLUTTER_Pointer_Button2 0xFEEA
#define CLUTTER_Pointer_Button3 0xFEEB
#define CLUTTER_Pointer_Button4 0xFEEC
#define CLUTTER_Pointer_Button5 0xFEED
#define CLUTTER_Pointer_DblClick_Dflt 0xFEEE
#define CLUTTER_Pointer_DblClick1 0xFEEF
#define CLUTTER_Pointer_DblClick2 0xFEF0
#define CLUTTER_Pointer_DblClick3 0xFEF1
#define CLUTTER_Pointer_DblClick4 0xFEF2
#define CLUTTER_Pointer_DblClick5 0xFEF3
#define CLUTTER_Pointer_Drag_Dflt 0xFEF4
#define CLUTTER_Pointer_Drag1 0xFEF5
#define CLUTTER_Pointer_Drag2 0xFEF6
#define CLUTTER_Pointer_Drag3 0xFEF7
#define CLUTTER_Pointer_Drag4 0xFEF8
#define CLUTTER_Pointer_Drag5 0xFEFD
#define CLUTTER_Pointer_EnableKeys 0xFEF9
#define CLUTTER_Pointer_Accelerate 0xFEFA
#define CLUTTER_Pointer_DfltBtnNext 0xFEFB
#define CLUTTER_Pointer_DfltBtnPrev 0xFEFC
#define CLUTTER_3270_Duplicate 0xFD01
#define CLUTTER_3270_FieldMark 0xFD02
#define CLUTTER_3270_Right2 0xFD03
#define CLUTTER_3270_Left2 0xFD04
#define CLUTTER_3270_BackTab 0xFD05
#define CLUTTER_3270_EraseEOF 0xFD06
#define CLUTTER_3270_EraseInput 0xFD07
#define CLUTTER_3270_Reset 0xFD08
#define CLUTTER_3270_Quit 0xFD09
#define CLUTTER_3270_PA1 0xFD0A
#define CLUTTER_3270_PA2 0xFD0B
#define CLUTTER_3270_PA3 0xFD0C
#define CLUTTER_3270_Test 0xFD0D
#define CLUTTER_3270_Attn 0xFD0E
#define CLUTTER_3270_CursorBlink 0xFD0F
#define CLUTTER_3270_AltCursor 0xFD10
#define CLUTTER_3270_KeyClick 0xFD11
#define CLUTTER_3270_Jump 0xFD12
#define CLUTTER_3270_Ident 0xFD13
#define CLUTTER_3270_Rule 0xFD14
#define CLUTTER_3270_Copy 0xFD15
#define CLUTTER_3270_Play 0xFD16
#define CLUTTER_3270_Setup 0xFD17
#define CLUTTER_3270_Record 0xFD18
#define CLUTTER_3270_ChangeScreen 0xFD19
#define CLUTTER_3270_DeleteWord 0xFD1A
#define CLUTTER_3270_ExSelect 0xFD1B
#define CLUTTER_3270_CursorSelect 0xFD1C
#define CLUTTER_3270_PrintScreen 0xFD1D
#define CLUTTER_3270_Enter 0xFD1E
#define CLUTTER_space 0x020
#define CLUTTER_exclam 0x021
#define CLUTTER_quotedbl 0x022
#define CLUTTER_numbersign 0x023
#define CLUTTER_dollar 0x024
#define CLUTTER_percent 0x025
#define CLUTTER_ampersand 0x026
#define CLUTTER_apostrophe 0x027
#define CLUTTER_quoteright 0x027
#define CLUTTER_parenleft 0x028
#define CLUTTER_parenright 0x029
#define CLUTTER_asterisk 0x02a
#define CLUTTER_plus 0x02b
#define CLUTTER_comma 0x02c
#define CLUTTER_minus 0x02d
#define CLUTTER_period 0x02e
#define CLUTTER_slash 0x02f
#define CLUTTER_0 0x030
#define CLUTTER_1 0x031
#define CLUTTER_2 0x032
#define CLUTTER_3 0x033
#define CLUTTER_4 0x034
#define CLUTTER_5 0x035
#define CLUTTER_6 0x036
#define CLUTTER_7 0x037
#define CLUTTER_8 0x038
#define CLUTTER_9 0x039
#define CLUTTER_colon 0x03a
#define CLUTTER_semicolon 0x03b
#define CLUTTER_less 0x03c
#define CLUTTER_equal 0x03d
#define CLUTTER_greater 0x03e
#define CLUTTER_question 0x03f
#define CLUTTER_at 0x040
#define CLUTTER_A 0x041
#define CLUTTER_B 0x042
#define CLUTTER_C 0x043
#define CLUTTER_D 0x044
#define CLUTTER_E 0x045
#define CLUTTER_F 0x046
#define CLUTTER_G 0x047
#define CLUTTER_H 0x048
#define CLUTTER_I 0x049
#define CLUTTER_J 0x04a
#define CLUTTER_K 0x04b
#define CLUTTER_L 0x04c
#define CLUTTER_M 0x04d
#define CLUTTER_N 0x04e
#define CLUTTER_O 0x04f
#define CLUTTER_P 0x050
#define CLUTTER_Q 0x051
#define CLUTTER_R 0x052
#define CLUTTER_S 0x053
#define CLUTTER_T 0x054
#define CLUTTER_U 0x055
#define CLUTTER_V 0x056
#define CLUTTER_W 0x057
#define CLUTTER_X 0x058
#define CLUTTER_Y 0x059
#define CLUTTER_Z 0x05a
#define CLUTTER_bracketleft 0x05b
#define CLUTTER_backslash 0x05c
#define CLUTTER_bracketright 0x05d
#define CLUTTER_asciicircum 0x05e
#define CLUTTER_underscore 0x05f
#define CLUTTER_grave 0x060
#define CLUTTER_quoteleft 0x060
#define CLUTTER_a 0x061
#define CLUTTER_b 0x062
#define CLUTTER_c 0x063
#define CLUTTER_d 0x064
#define CLUTTER_e 0x065
#define CLUTTER_f 0x066
#define CLUTTER_g 0x067
#define CLUTTER_h 0x068
#define CLUTTER_i 0x069
#define CLUTTER_j 0x06a
#define CLUTTER_k 0x06b
#define CLUTTER_l 0x06c
#define CLUTTER_m 0x06d
#define CLUTTER_n 0x06e
#define CLUTTER_o 0x06f
#define CLUTTER_p 0x070
#define CLUTTER_q 0x071
#define CLUTTER_r 0x072
#define CLUTTER_s 0x073
#define CLUTTER_t 0x074
#define CLUTTER_u 0x075
#define CLUTTER_v 0x076
#define CLUTTER_w 0x077
#define CLUTTER_x 0x078
#define CLUTTER_y 0x079
#define CLUTTER_z 0x07a
#define CLUTTER_braceleft 0x07b
#define CLUTTER_bar 0x07c
#define CLUTTER_braceright 0x07d
#define CLUTTER_asciitilde 0x07e
#define CLUTTER_nobreakspace 0x0a0
#define CLUTTER_exclamdown 0x0a1
#define CLUTTER_cent 0x0a2
#define CLUTTER_sterling 0x0a3
#define CLUTTER_currency 0x0a4
#define CLUTTER_yen 0x0a5
#define CLUTTER_brokenbar 0x0a6
#define CLUTTER_section 0x0a7
#define CLUTTER_diaeresis 0x0a8
#define CLUTTER_copyright 0x0a9
#define CLUTTER_ordfeminine 0x0aa
#define CLUTTER_guillemotleft 0x0ab
#define CLUTTER_notsign 0x0ac
#define CLUTTER_hyphen 0x0ad
#define CLUTTER_registered 0x0ae
#define CLUTTER_macron 0x0af
#define CLUTTER_degree 0x0b0
#define CLUTTER_plusminus 0x0b1
#define CLUTTER_twosuperior 0x0b2
#define CLUTTER_threesuperior 0x0b3
#define CLUTTER_acute 0x0b4
#define CLUTTER_mu 0x0b5
#define CLUTTER_paragraph 0x0b6
#define CLUTTER_periodcentered 0x0b7
#define CLUTTER_cedilla 0x0b8
#define CLUTTER_onesuperior 0x0b9
#define CLUTTER_masculine 0x0ba
#define CLUTTER_guillemotright 0x0bb
#define CLUTTER_onequarter 0x0bc
#define CLUTTER_onehalf 0x0bd
#define CLUTTER_threequarters 0x0be
#define CLUTTER_questiondown 0x0bf
#define CLUTTER_Agrave 0x0c0
#define CLUTTER_Aacute 0x0c1
#define CLUTTER_Acircumflex 0x0c2
#define CLUTTER_Atilde 0x0c3
#define CLUTTER_Adiaeresis 0x0c4
#define CLUTTER_Aring 0x0c5
#define CLUTTER_AE 0x0c6
#define CLUTTER_Ccedilla 0x0c7
#define CLUTTER_Egrave 0x0c8
#define CLUTTER_Eacute 0x0c9
#define CLUTTER_Ecircumflex 0x0ca
#define CLUTTER_Ediaeresis 0x0cb
#define CLUTTER_Igrave 0x0cc
#define CLUTTER_Iacute 0x0cd
#define CLUTTER_Icircumflex 0x0ce
#define CLUTTER_Idiaeresis 0x0cf
#define CLUTTER_ETH 0x0d0
#define CLUTTER_Eth 0x0d0
#define CLUTTER_Ntilde 0x0d1
#define CLUTTER_Ograve 0x0d2
#define CLUTTER_Oacute 0x0d3
#define CLUTTER_Ocircumflex 0x0d4
#define CLUTTER_Otilde 0x0d5
#define CLUTTER_Odiaeresis 0x0d6
#define CLUTTER_multiply 0x0d7
#define CLUTTER_Ooblique 0x0d8
#define CLUTTER_Ugrave 0x0d9
#define CLUTTER_Uacute 0x0da
#define CLUTTER_Ucircumflex 0x0db
#define CLUTTER_Udiaeresis 0x0dc
#define CLUTTER_Yacute 0x0dd
#define CLUTTER_THORN 0x0de
#define CLUTTER_Thorn 0x0de
#define CLUTTER_ssharp 0x0df
#define CLUTTER_agrave 0x0e0
#define CLUTTER_aacute 0x0e1
#define CLUTTER_acircumflex 0x0e2
#define CLUTTER_atilde 0x0e3
#define CLUTTER_adiaeresis 0x0e4
#define CLUTTER_aring 0x0e5
#define CLUTTER_ae 0x0e6
#define CLUTTER_ccedilla 0x0e7
#define CLUTTER_egrave 0x0e8
#define CLUTTER_eacute 0x0e9
#define CLUTTER_ecircumflex 0x0ea
#define CLUTTER_ediaeresis 0x0eb
#define CLUTTER_igrave 0x0ec
#define CLUTTER_iacute 0x0ed
#define CLUTTER_icircumflex 0x0ee
#define CLUTTER_idiaeresis 0x0ef
#define CLUTTER_eth 0x0f0
#define CLUTTER_ntilde 0x0f1
#define CLUTTER_ograve 0x0f2
#define CLUTTER_oacute 0x0f3
#define CLUTTER_ocircumflex 0x0f4
#define CLUTTER_otilde 0x0f5
#define CLUTTER_odiaeresis 0x0f6
#define CLUTTER_division 0x0f7
#define CLUTTER_oslash 0x0f8
#define CLUTTER_ugrave 0x0f9
#define CLUTTER_uacute 0x0fa
#define CLUTTER_ucircumflex 0x0fb
#define CLUTTER_udiaeresis 0x0fc
#define CLUTTER_yacute 0x0fd
#define CLUTTER_thorn 0x0fe
#define CLUTTER_ydiaeresis 0x0ff
#define CLUTTER_Aogonek 0x1a1
#define CLUTTER_breve 0x1a2
#define CLUTTER_Lstroke 0x1a3
#define CLUTTER_Lcaron 0x1a5
#define CLUTTER_Sacute 0x1a6
#define CLUTTER_Scaron 0x1a9
#define CLUTTER_Scedilla 0x1aa
#define CLUTTER_Tcaron 0x1ab
#define CLUTTER_Zacute 0x1ac
#define CLUTTER_Zcaron 0x1ae
#define CLUTTER_Zabovedot 0x1af
#define CLUTTER_aogonek 0x1b1
#define CLUTTER_ogonek 0x1b2
#define CLUTTER_lstroke 0x1b3
#define CLUTTER_lcaron 0x1b5
#define CLUTTER_sacute 0x1b6
#define CLUTTER_caron 0x1b7
#define CLUTTER_scaron 0x1b9
#define CLUTTER_scedilla 0x1ba
#define CLUTTER_tcaron 0x1bb
#define CLUTTER_zacute 0x1bc
#define CLUTTER_doubleacute 0x1bd
#define CLUTTER_zcaron 0x1be
#define CLUTTER_zabovedot 0x1bf
#define CLUTTER_Racute 0x1c0
#define CLUTTER_Abreve 0x1c3
#define CLUTTER_Lacute 0x1c5
#define CLUTTER_Cacute 0x1c6
#define CLUTTER_Ccaron 0x1c8
#define CLUTTER_Eogonek 0x1ca
#define CLUTTER_Ecaron 0x1cc
#define CLUTTER_Dcaron 0x1cf
#define CLUTTER_Dstroke 0x1d0
#define CLUTTER_Nacute 0x1d1
#define CLUTTER_Ncaron 0x1d2
#define CLUTTER_Odoubleacute 0x1d5
#define CLUTTER_Rcaron 0x1d8
#define CLUTTER_Uring 0x1d9
#define CLUTTER_Udoubleacute 0x1db
#define CLUTTER_Tcedilla 0x1de
#define CLUTTER_racute 0x1e0
#define CLUTTER_abreve 0x1e3
#define CLUTTER_lacute 0x1e5
#define CLUTTER_cacute 0x1e6
#define CLUTTER_ccaron 0x1e8
#define CLUTTER_eogonek 0x1ea
#define CLUTTER_ecaron 0x1ec
#define CLUTTER_dcaron 0x1ef
#define CLUTTER_dstroke 0x1f0
#define CLUTTER_nacute 0x1f1
#define CLUTTER_ncaron 0x1f2
#define CLUTTER_odoubleacute 0x1f5
#define CLUTTER_udoubleacute 0x1fb
#define CLUTTER_rcaron 0x1f8
#define CLUTTER_uring 0x1f9
#define CLUTTER_tcedilla 0x1fe
#define CLUTTER_abovedot 0x1ff
#define CLUTTER_Hstroke 0x2a1
#define CLUTTER_Hcircumflex 0x2a6
#define CLUTTER_Iabovedot 0x2a9
#define CLUTTER_Gbreve 0x2ab
#define CLUTTER_Jcircumflex 0x2ac
#define CLUTTER_hstroke 0x2b1
#define CLUTTER_hcircumflex 0x2b6
#define CLUTTER_idotless 0x2b9
#define CLUTTER_gbreve 0x2bb
#define CLUTTER_jcircumflex 0x2bc
#define CLUTTER_Cabovedot 0x2c5
#define CLUTTER_Ccircumflex 0x2c6
#define CLUTTER_Gabovedot 0x2d5
#define CLUTTER_Gcircumflex 0x2d8
#define CLUTTER_Ubreve 0x2dd
#define CLUTTER_Scircumflex 0x2de
#define CLUTTER_cabovedot 0x2e5
#define CLUTTER_ccircumflex 0x2e6
#define CLUTTER_gabovedot 0x2f5
#define CLUTTER_gcircumflex 0x2f8
#define CLUTTER_ubreve 0x2fd
#define CLUTTER_scircumflex 0x2fe
#define CLUTTER_kra 0x3a2
#define CLUTTER_kappa 0x3a2
#define CLUTTER_Rcedilla 0x3a3
#define CLUTTER_Itilde 0x3a5
#define CLUTTER_Lcedilla 0x3a6
#define CLUTTER_Emacron 0x3aa
#define CLUTTER_Gcedilla 0x3ab
#define CLUTTER_Tslash 0x3ac
#define CLUTTER_rcedilla 0x3b3
#define CLUTTER_itilde 0x3b5
#define CLUTTER_lcedilla 0x3b6
#define CLUTTER_emacron 0x3ba
#define CLUTTER_gcedilla 0x3bb
#define CLUTTER_tslash 0x3bc
#define CLUTTER_ENG 0x3bd
#define CLUTTER_eng 0x3bf
#define CLUTTER_Amacron 0x3c0
#define CLUTTER_Iogonek 0x3c7
#define CLUTTER_Eabovedot 0x3cc
#define CLUTTER_Imacron 0x3cf
#define CLUTTER_Ncedilla 0x3d1
#define CLUTTER_Omacron 0x3d2
#define CLUTTER_Kcedilla 0x3d3
#define CLUTTER_Uogonek 0x3d9
#define CLUTTER_Utilde 0x3dd
#define CLUTTER_Umacron 0x3de
#define CLUTTER_amacron 0x3e0
#define CLUTTER_iogonek 0x3e7
#define CLUTTER_eabovedot 0x3ec
#define CLUTTER_imacron 0x3ef
#define CLUTTER_ncedilla 0x3f1
#define CLUTTER_omacron 0x3f2
#define CLUTTER_kcedilla 0x3f3
#define CLUTTER_uogonek 0x3f9
#define CLUTTER_utilde 0x3fd
#define CLUTTER_umacron 0x3fe
#define CLUTTER_OE 0x13bc
#define CLUTTER_oe 0x13bd
#define CLUTTER_Ydiaeresis 0x13be
#define CLUTTER_overline 0x47e
#define CLUTTER_kana_fullstop 0x4a1
#define CLUTTER_kana_openingbracket 0x4a2
#define CLUTTER_kana_closingbracket 0x4a3
#define CLUTTER_kana_comma 0x4a4
#define CLUTTER_kana_conjunctive 0x4a5
#define CLUTTER_kana_middledot 0x4a5
#define CLUTTER_kana_WO 0x4a6
#define CLUTTER_kana_a 0x4a7
#define CLUTTER_kana_i 0x4a8
#define CLUTTER_kana_u 0x4a9
#define CLUTTER_kana_e 0x4aa
#define CLUTTER_kana_o 0x4ab
#define CLUTTER_kana_ya 0x4ac
#define CLUTTER_kana_yu 0x4ad
#define CLUTTER_kana_yo 0x4ae
#define CLUTTER_kana_tsu 0x4af
#define CLUTTER_kana_tu 0x4af
#define CLUTTER_prolongedsound 0x4b0
#define CLUTTER_kana_A 0x4b1
#define CLUTTER_kana_I 0x4b2
#define CLUTTER_kana_U 0x4b3
#define CLUTTER_kana_E 0x4b4
#define CLUTTER_kana_O 0x4b5
#define CLUTTER_kana_KA 0x4b6
#define CLUTTER_kana_KI 0x4b7
#define CLUTTER_kana_KU 0x4b8
#define CLUTTER_kana_KE 0x4b9
#define CLUTTER_kana_KO 0x4ba
#define CLUTTER_kana_SA 0x4bb
#define CLUTTER_kana_SHI 0x4bc
#define CLUTTER_kana_SU 0x4bd
#define CLUTTER_kana_SE 0x4be
#define CLUTTER_kana_SO 0x4bf
#define CLUTTER_kana_TA 0x4c0
#define CLUTTER_kana_CHI 0x4c1
#define CLUTTER_kana_TI 0x4c1
#define CLUTTER_kana_TSU 0x4c2
#define CLUTTER_kana_TU 0x4c2
#define CLUTTER_kana_TE 0x4c3
#define CLUTTER_kana_TO 0x4c4
#define CLUTTER_kana_NA 0x4c5
#define CLUTTER_kana_NI 0x4c6
#define CLUTTER_kana_NU 0x4c7
#define CLUTTER_kana_NE 0x4c8
#define CLUTTER_kana_NO 0x4c9
#define CLUTTER_kana_HA 0x4ca
#define CLUTTER_kana_HI 0x4cb
#define CLUTTER_kana_FU 0x4cc
#define CLUTTER_kana_HU 0x4cc
#define CLUTTER_kana_HE 0x4cd
#define CLUTTER_kana_HO 0x4ce
#define CLUTTER_kana_MA 0x4cf
#define CLUTTER_kana_MI 0x4d0
#define CLUTTER_kana_MU 0x4d1
#define CLUTTER_kana_ME 0x4d2
#define CLUTTER_kana_MO 0x4d3
#define CLUTTER_kana_YA 0x4d4
#define CLUTTER_kana_YU 0x4d5
#define CLUTTER_kana_YO 0x4d6
#define CLUTTER_kana_RA 0x4d7
#define CLUTTER_kana_RI 0x4d8
#define CLUTTER_kana_RU 0x4d9
#define CLUTTER_kana_RE 0x4da
#define CLUTTER_kana_RO 0x4db
#define CLUTTER_kana_WA 0x4dc
#define CLUTTER_kana_N 0x4dd
#define CLUTTER_voicedsound 0x4de
#define CLUTTER_semivoicedsound 0x4df
#define CLUTTER_kana_switch 0xFF7E
#define CLUTTER_Arabic_comma 0x5ac
#define CLUTTER_Arabic_semicolon 0x5bb
#define CLUTTER_Arabic_question_mark 0x5bf
#define CLUTTER_Arabic_hamza 0x5c1
#define CLUTTER_Arabic_maddaonalef 0x5c2
#define CLUTTER_Arabic_hamzaonalef 0x5c3
#define CLUTTER_Arabic_hamzaonwaw 0x5c4
#define CLUTTER_Arabic_hamzaunderalef 0x5c5
#define CLUTTER_Arabic_hamzaonyeh 0x5c6
#define CLUTTER_Arabic_alef 0x5c7
#define CLUTTER_Arabic_beh 0x5c8
#define CLUTTER_Arabic_tehmarbuta 0x5c9
#define CLUTTER_Arabic_teh 0x5ca
#define CLUTTER_Arabic_theh 0x5cb
#define CLUTTER_Arabic_jeem 0x5cc
#define CLUTTER_Arabic_hah 0x5cd
#define CLUTTER_Arabic_khah 0x5ce
#define CLUTTER_Arabic_dal 0x5cf
#define CLUTTER_Arabic_thal 0x5d0
#define CLUTTER_Arabic_ra 0x5d1
#define CLUTTER_Arabic_zain 0x5d2
#define CLUTTER_Arabic_seen 0x5d3
#define CLUTTER_Arabic_sheen 0x5d4
#define CLUTTER_Arabic_sad 0x5d5
#define CLUTTER_Arabic_dad 0x5d6
#define CLUTTER_Arabic_tah 0x5d7
#define CLUTTER_Arabic_zah 0x5d8
#define CLUTTER_Arabic_ain 0x5d9
#define CLUTTER_Arabic_ghain 0x5da
#define CLUTTER_Arabic_tatweel 0x5e0
#define CLUTTER_Arabic_feh 0x5e1
#define CLUTTER_Arabic_qaf 0x5e2
#define CLUTTER_Arabic_kaf 0x5e3
#define CLUTTER_Arabic_lam 0x5e4
#define CLUTTER_Arabic_meem 0x5e5
#define CLUTTER_Arabic_noon 0x5e6
#define CLUTTER_Arabic_ha 0x5e7
#define CLUTTER_Arabic_heh 0x5e7
#define CLUTTER_Arabic_waw 0x5e8
#define CLUTTER_Arabic_alefmaksura 0x5e9
#define CLUTTER_Arabic_yeh 0x5ea
#define CLUTTER_Arabic_fathatan 0x5eb
#define CLUTTER_Arabic_dammatan 0x5ec
#define CLUTTER_Arabic_kasratan 0x5ed
#define CLUTTER_Arabic_fatha 0x5ee
#define CLUTTER_Arabic_damma 0x5ef
#define CLUTTER_Arabic_kasra 0x5f0
#define CLUTTER_Arabic_shadda 0x5f1
#define CLUTTER_Arabic_sukun 0x5f2
#define CLUTTER_Arabic_switch 0xFF7E
#define CLUTTER_Serbian_dje 0x6a1
#define CLUTTER_Macedonia_gje 0x6a2
#define CLUTTER_Cyrillic_io 0x6a3
#define CLUTTER_Ukrainian_ie 0x6a4
#define CLUTTER_Ukranian_je 0x6a4
#define CLUTTER_Macedonia_dse 0x6a5
#define CLUTTER_Ukrainian_i 0x6a6
#define CLUTTER_Ukranian_i 0x6a6
#define CLUTTER_Ukrainian_yi 0x6a7
#define CLUTTER_Ukranian_yi 0x6a7
#define CLUTTER_Cyrillic_je 0x6a8
#define CLUTTER_Serbian_je 0x6a8
#define CLUTTER_Cyrillic_lje 0x6a9
#define CLUTTER_Serbian_lje 0x6a9
#define CLUTTER_Cyrillic_nje 0x6aa
#define CLUTTER_Serbian_nje 0x6aa
#define CLUTTER_Serbian_tshe 0x6ab
#define CLUTTER_Macedonia_kje 0x6ac
#define CLUTTER_Ukrainian_ghe_with_upturn 0x6ad
#define CLUTTER_Byelorussian_shortu 0x6ae
#define CLUTTER_Cyrillic_dzhe 0x6af
#define CLUTTER_Serbian_dze 0x6af
#define CLUTTER_numerosign 0x6b0
#define CLUTTER_Serbian_DJE 0x6b1
#define CLUTTER_Macedonia_GJE 0x6b2
#define CLUTTER_Cyrillic_IO 0x6b3
#define CLUTTER_Ukrainian_IE 0x6b4
#define CLUTTER_Ukranian_JE 0x6b4
#define CLUTTER_Macedonia_DSE 0x6b5
#define CLUTTER_Ukrainian_I 0x6b6
#define CLUTTER_Ukranian_I 0x6b6
#define CLUTTER_Ukrainian_YI 0x6b7
#define CLUTTER_Ukranian_YI 0x6b7
#define CLUTTER_Cyrillic_JE 0x6b8
#define CLUTTER_Serbian_JE 0x6b8
#define CLUTTER_Cyrillic_LJE 0x6b9
#define CLUTTER_Serbian_LJE 0x6b9
#define CLUTTER_Cyrillic_NJE 0x6ba
#define CLUTTER_Serbian_NJE 0x6ba
#define CLUTTER_Serbian_TSHE 0x6bb
#define CLUTTER_Macedonia_KJE 0x6bc
#define CLUTTER_Ukrainian_GHE_WITH_UPTURN 0x6bd
#define CLUTTER_Byelorussian_SHORTU 0x6be
#define CLUTTER_Cyrillic_DZHE 0x6bf
#define CLUTTER_Serbian_DZE 0x6bf
#define CLUTTER_Cyrillic_yu 0x6c0
#define CLUTTER_Cyrillic_a 0x6c1
#define CLUTTER_Cyrillic_be 0x6c2
#define CLUTTER_Cyrillic_tse 0x6c3
#define CLUTTER_Cyrillic_de 0x6c4
#define CLUTTER_Cyrillic_ie 0x6c5
#define CLUTTER_Cyrillic_ef 0x6c6
#define CLUTTER_Cyrillic_ghe 0x6c7
#define CLUTTER_Cyrillic_ha 0x6c8
#define CLUTTER_Cyrillic_i 0x6c9
#define CLUTTER_Cyrillic_shorti 0x6ca
#define CLUTTER_Cyrillic_ka 0x6cb
#define CLUTTER_Cyrillic_el 0x6cc
#define CLUTTER_Cyrillic_em 0x6cd
#define CLUTTER_Cyrillic_en 0x6ce
#define CLUTTER_Cyrillic_o 0x6cf
#define CLUTTER_Cyrillic_pe 0x6d0
#define CLUTTER_Cyrillic_ya 0x6d1
#define CLUTTER_Cyrillic_er 0x6d2
#define CLUTTER_Cyrillic_es 0x6d3
#define CLUTTER_Cyrillic_te 0x6d4
#define CLUTTER_Cyrillic_u 0x6d5
#define CLUTTER_Cyrillic_zhe 0x6d6
#define CLUTTER_Cyrillic_ve 0x6d7
#define CLUTTER_Cyrillic_softsign 0x6d8
#define CLUTTER_Cyrillic_yeru 0x6d9
#define CLUTTER_Cyrillic_ze 0x6da
#define CLUTTER_Cyrillic_sha 0x6db
#define CLUTTER_Cyrillic_e 0x6dc
#define CLUTTER_Cyrillic_shcha 0x6dd
#define CLUTTER_Cyrillic_che 0x6de
#define CLUTTER_Cyrillic_hardsign 0x6df
#define CLUTTER_Cyrillic_YU 0x6e0
#define CLUTTER_Cyrillic_A 0x6e1
#define CLUTTER_Cyrillic_BE 0x6e2
#define CLUTTER_Cyrillic_TSE 0x6e3
#define CLUTTER_Cyrillic_DE 0x6e4
#define CLUTTER_Cyrillic_IE 0x6e5
#define CLUTTER_Cyrillic_EF 0x6e6
#define CLUTTER_Cyrillic_GHE 0x6e7
#define CLUTTER_Cyrillic_HA 0x6e8
#define CLUTTER_Cyrillic_I 0x6e9
#define CLUTTER_Cyrillic_SHORTI 0x6ea
#define CLUTTER_Cyrillic_KA 0x6eb
#define CLUTTER_Cyrillic_EL 0x6ec
#define CLUTTER_Cyrillic_EM 0x6ed
#define CLUTTER_Cyrillic_EN 0x6ee
#define CLUTTER_Cyrillic_O 0x6ef
#define CLUTTER_Cyrillic_PE 0x6f0
#define CLUTTER_Cyrillic_YA 0x6f1
#define CLUTTER_Cyrillic_ER 0x6f2
#define CLUTTER_Cyrillic_ES 0x6f3
#define CLUTTER_Cyrillic_TE 0x6f4
#define CLUTTER_Cyrillic_U 0x6f5
#define CLUTTER_Cyrillic_ZHE 0x6f6
#define CLUTTER_Cyrillic_VE 0x6f7
#define CLUTTER_Cyrillic_SOFTSIGN 0x6f8
#define CLUTTER_Cyrillic_YERU 0x6f9
#define CLUTTER_Cyrillic_ZE 0x6fa
#define CLUTTER_Cyrillic_SHA 0x6fb
#define CLUTTER_Cyrillic_E 0x6fc
#define CLUTTER_Cyrillic_SHCHA 0x6fd
#define CLUTTER_Cyrillic_CHE 0x6fe
#define CLUTTER_Cyrillic_HARDSIGN 0x6ff
#define CLUTTER_Greek_ALPHAaccent 0x7a1
#define CLUTTER_Greek_EPSILONaccent 0x7a2
#define CLUTTER_Greek_ETAaccent 0x7a3
#define CLUTTER_Greek_IOTAaccent 0x7a4
#define CLUTTER_Greek_IOTAdieresis 0x7a5
#define CLUTTER_Greek_IOTAdiaeresis CLUTTER_Greek_IOTAdieresis
#define CLUTTER_Greek_OMICRONaccent 0x7a7
#define CLUTTER_Greek_UPSILONaccent 0x7a8
#define CLUTTER_Greek_UPSILONdieresis 0x7a9
#define CLUTTER_Greek_OMEGAaccent 0x7ab
#define CLUTTER_Greek_accentdieresis 0x7ae
#define CLUTTER_Greek_horizbar 0x7af
#define CLUTTER_Greek_alphaaccent 0x7b1
#define CLUTTER_Greek_epsilonaccent 0x7b2
#define CLUTTER_Greek_etaaccent 0x7b3
#define CLUTTER_Greek_iotaaccent 0x7b4
#define CLUTTER_Greek_iotadieresis 0x7b5
#define CLUTTER_Greek_iotaaccentdieresis 0x7b6
#define CLUTTER_Greek_omicronaccent 0x7b7
#define CLUTTER_Greek_upsilonaccent 0x7b8
#define CLUTTER_Greek_upsilondieresis 0x7b9
#define CLUTTER_Greek_upsilonaccentdieresis 0x7ba
#define CLUTTER_Greek_omegaaccent 0x7bb
#define CLUTTER_Greek_ALPHA 0x7c1
#define CLUTTER_Greek_BETA 0x7c2
#define CLUTTER_Greek_GAMMA 0x7c3
#define CLUTTER_Greek_DELTA 0x7c4
#define CLUTTER_Greek_EPSILON 0x7c5
#define CLUTTER_Greek_ZETA 0x7c6
#define CLUTTER_Greek_ETA 0x7c7
#define CLUTTER_Greek_THETA 0x7c8
#define CLUTTER_Greek_IOTA 0x7c9
#define CLUTTER_Greek_KAPPA 0x7ca
#define CLUTTER_Greek_LAMDA 0x7cb
#define CLUTTER_Greek_LAMBDA 0x7cb
#define CLUTTER_Greek_MU 0x7cc
#define CLUTTER_Greek_NU 0x7cd
#define CLUTTER_Greek_XI 0x7ce
#define CLUTTER_Greek_OMICRON 0x7cf
#define CLUTTER_Greek_PI 0x7d0
#define CLUTTER_Greek_RHO 0x7d1
#define CLUTTER_Greek_SIGMA 0x7d2
#define CLUTTER_Greek_TAU 0x7d4
#define CLUTTER_Greek_UPSILON 0x7d5
#define CLUTTER_Greek_PHI 0x7d6
#define CLUTTER_Greek_CHI 0x7d7
#define CLUTTER_Greek_PSI 0x7d8
#define CLUTTER_Greek_OMEGA 0x7d9
#define CLUTTER_Greek_alpha 0x7e1
#define CLUTTER_Greek_beta 0x7e2
#define CLUTTER_Greek_gamma 0x7e3
#define CLUTTER_Greek_delta 0x7e4
#define CLUTTER_Greek_epsilon 0x7e5
#define CLUTTER_Greek_zeta 0x7e6
#define CLUTTER_Greek_eta 0x7e7
#define CLUTTER_Greek_theta 0x7e8
#define CLUTTER_Greek_iota 0x7e9
#define CLUTTER_Greek_kappa 0x7ea
#define CLUTTER_Greek_lamda 0x7eb
#define CLUTTER_Greek_lambda 0x7eb
#define CLUTTER_Greek_mu 0x7ec
#define CLUTTER_Greek_nu 0x7ed
#define CLUTTER_Greek_xi 0x7ee
#define CLUTTER_Greek_omicron 0x7ef
#define CLUTTER_Greek_pi 0x7f0
#define CLUTTER_Greek_rho 0x7f1
#define CLUTTER_Greek_sigma 0x7f2
#define CLUTTER_Greek_finalsmallsigma 0x7f3
#define CLUTTER_Greek_tau 0x7f4
#define CLUTTER_Greek_upsilon 0x7f5
#define CLUTTER_Greek_phi 0x7f6
#define CLUTTER_Greek_chi 0x7f7
#define CLUTTER_Greek_psi 0x7f8
#define CLUTTER_Greek_omega 0x7f9
#define CLUTTER_Greek_switch 0xFF7E
#define CLUTTER_leftradical 0x8a1
#define CLUTTER_topleftradical 0x8a2
#define CLUTTER_horizconnector 0x8a3
#define CLUTTER_topintegral 0x8a4
#define CLUTTER_botintegral 0x8a5
#define CLUTTER_vertconnector 0x8a6
#define CLUTTER_topleftsqbracket 0x8a7
#define CLUTTER_botleftsqbracket 0x8a8
#define CLUTTER_toprightsqbracket 0x8a9
#define CLUTTER_botrightsqbracket 0x8aa
#define CLUTTER_topleftparens 0x8ab
#define CLUTTER_botleftparens 0x8ac
#define CLUTTER_toprightparens 0x8ad
#define CLUTTER_botrightparens 0x8ae
#define CLUTTER_leftmiddlecurlybrace 0x8af
#define CLUTTER_rightmiddlecurlybrace 0x8b0
#define CLUTTER_topleftsummation 0x8b1
#define CLUTTER_botleftsummation 0x8b2
#define CLUTTER_topvertsummationconnector 0x8b3
#define CLUTTER_botvertsummationconnector 0x8b4
#define CLUTTER_toprightsummation 0x8b5
#define CLUTTER_botrightsummation 0x8b6
#define CLUTTER_rightmiddlesummation 0x8b7
#define CLUTTER_lessthanequal 0x8bc
#define CLUTTER_notequal 0x8bd
#define CLUTTER_greaterthanequal 0x8be
#define CLUTTER_integral 0x8bf
#define CLUTTER_therefore 0x8c0
#define CLUTTER_variation 0x8c1
#define CLUTTER_infinity 0x8c2
#define CLUTTER_nabla 0x8c5
#define CLUTTER_approximate 0x8c8
#define CLUTTER_similarequal 0x8c9
#define CLUTTER_ifonlyif 0x8cd
#define CLUTTER_implies 0x8ce
#define CLUTTER_identical 0x8cf
#define CLUTTER_radical 0x8d6
#define CLUTTER_includedin 0x8da
#define CLUTTER_includes 0x8db
#define CLUTTER_intersection 0x8dc
#define CLUTTER_union 0x8dd
#define CLUTTER_logicaland 0x8de
#define CLUTTER_logicalor 0x8df
#define CLUTTER_partialderivative 0x8ef
#define CLUTTER_function 0x8f6
#define CLUTTER_leftarrow 0x8fb
#define CLUTTER_uparrow 0x8fc
#define CLUTTER_rightarrow 0x8fd
#define CLUTTER_downarrow 0x8fe
#define CLUTTER_blank 0x9df
#define CLUTTER_soliddiamond 0x9e0
#define CLUTTER_checkerboard 0x9e1
#define CLUTTER_ht 0x9e2
#define CLUTTER_ff 0x9e3
#define CLUTTER_cr 0x9e4
#define CLUTTER_lf 0x9e5
#define CLUTTER_nl 0x9e8
#define CLUTTER_vt 0x9e9
#define CLUTTER_lowrightcorner 0x9ea
#define CLUTTER_uprightcorner 0x9eb
#define CLUTTER_upleftcorner 0x9ec
#define CLUTTER_lowleftcorner 0x9ed
#define CLUTTER_crossinglines 0x9ee
#define CLUTTER_horizlinescan1 0x9ef
#define CLUTTER_horizlinescan3 0x9f0
#define CLUTTER_horizlinescan5 0x9f1
#define CLUTTER_horizlinescan7 0x9f2
#define CLUTTER_horizlinescan9 0x9f3
#define CLUTTER_leftt 0x9f4
#define CLUTTER_rightt 0x9f5
#define CLUTTER_bott 0x9f6
#define CLUTTER_topt 0x9f7
#define CLUTTER_vertbar 0x9f8
#define CLUTTER_emspace 0xaa1
#define CLUTTER_enspace 0xaa2
#define CLUTTER_em3space 0xaa3
#define CLUTTER_em4space 0xaa4
#define CLUTTER_digitspace 0xaa5
#define CLUTTER_punctspace 0xaa6
#define CLUTTER_thinspace 0xaa7
#define CLUTTER_hairspace 0xaa8
#define CLUTTER_emdash 0xaa9
#define CLUTTER_endash 0xaaa
#define CLUTTER_signifblank 0xaac
#define CLUTTER_ellipsis 0xaae
#define CLUTTER_doubbaselinedot 0xaaf
#define CLUTTER_onethird 0xab0
#define CLUTTER_twothirds 0xab1
#define CLUTTER_onefifth 0xab2
#define CLUTTER_twofifths 0xab3
#define CLUTTER_threefifths 0xab4
#define CLUTTER_fourfifths 0xab5
#define CLUTTER_onesixth 0xab6
#define CLUTTER_fivesixths 0xab7
#define CLUTTER_careof 0xab8
#define CLUTTER_figdash 0xabb
#define CLUTTER_leftanglebracket 0xabc
#define CLUTTER_decimalpoint 0xabd
#define CLUTTER_rightanglebracket 0xabe
#define CLUTTER_marker 0xabf
#define CLUTTER_oneeighth 0xac3
#define CLUTTER_threeeighths 0xac4
#define CLUTTER_fiveeighths 0xac5
#define CLUTTER_seveneighths 0xac6
#define CLUTTER_trademark 0xac9
#define CLUTTER_signaturemark 0xaca
#define CLUTTER_trademarkincircle 0xacb
#define CLUTTER_leftopentriangle 0xacc
#define CLUTTER_rightopentriangle 0xacd
#define CLUTTER_emopencircle 0xace
#define CLUTTER_emopenrectangle 0xacf
#define CLUTTER_leftsinglequotemark 0xad0
#define CLUTTER_rightsinglequotemark 0xad1
#define CLUTTER_leftdoublequotemark 0xad2
#define CLUTTER_rightdoublequotemark 0xad3
#define CLUTTER_prescription 0xad4
#define CLUTTER_minutes 0xad6
#define CLUTTER_seconds 0xad7
#define CLUTTER_latincross 0xad9
#define CLUTTER_hexagram 0xada
#define CLUTTER_filledrectbullet 0xadb
#define CLUTTER_filledlefttribullet 0xadc
#define CLUTTER_filledrighttribullet 0xadd
#define CLUTTER_emfilledcircle 0xade
#define CLUTTER_emfilledrect 0xadf
#define CLUTTER_enopencircbullet 0xae0
#define CLUTTER_enopensquarebullet 0xae1
#define CLUTTER_openrectbullet 0xae2
#define CLUTTER_opentribulletup 0xae3
#define CLUTTER_opentribulletdown 0xae4
#define CLUTTER_openstar 0xae5
#define CLUTTER_enfilledcircbullet 0xae6
#define CLUTTER_enfilledsqbullet 0xae7
#define CLUTTER_filledtribulletup 0xae8
#define CLUTTER_filledtribulletdown 0xae9
#define CLUTTER_leftpointer 0xaea
#define CLUTTER_rightpointer 0xaeb
#define CLUTTER_club 0xaec
#define CLUTTER_diamond 0xaed
#define CLUTTER_heart 0xaee
#define CLUTTER_maltesecross 0xaf0
#define CLUTTER_dagger 0xaf1
#define CLUTTER_doubledagger 0xaf2
#define CLUTTER_checkmark 0xaf3
#define CLUTTER_ballotcross 0xaf4
#define CLUTTER_musicalsharp 0xaf5
#define CLUTTER_musicalflat 0xaf6
#define CLUTTER_malesymbol 0xaf7
#define CLUTTER_femalesymbol 0xaf8
#define CLUTTER_telephone 0xaf9
#define CLUTTER_telephonerecorder 0xafa
#define CLUTTER_phonographcopyright 0xafb
#define CLUTTER_caret 0xafc
#define CLUTTER_singlelowquotemark 0xafd
#define CLUTTER_doublelowquotemark 0xafe
#define CLUTTER_cursor 0xaff
#define CLUTTER_leftcaret 0xba3
#define CLUTTER_rightcaret 0xba6
#define CLUTTER_downcaret 0xba8
#define CLUTTER_upcaret 0xba9
#define CLUTTER_overbar 0xbc0
#define CLUTTER_downtack 0xbc2
#define CLUTTER_upshoe 0xbc3
#define CLUTTER_downstile 0xbc4
#define CLUTTER_underbar 0xbc6
#define CLUTTER_jot 0xbca
#define CLUTTER_quad 0xbcc
#define CLUTTER_uptack 0xbce
#define CLUTTER_circle 0xbcf
#define CLUTTER_upstile 0xbd3
#define CLUTTER_downshoe 0xbd6
#define CLUTTER_rightshoe 0xbd8
#define CLUTTER_leftshoe 0xbda
#define CLUTTER_lefttack 0xbdc
#define CLUTTER_righttack 0xbfc
#define CLUTTER_hebrew_doublelowline 0xcdf
#define CLUTTER_hebrew_aleph 0xce0
#define CLUTTER_hebrew_bet 0xce1
#define CLUTTER_hebrew_beth 0xce1
#define CLUTTER_hebrew_gimel 0xce2
#define CLUTTER_hebrew_gimmel 0xce2
#define CLUTTER_hebrew_dalet 0xce3
#define CLUTTER_hebrew_daleth 0xce3
#define CLUTTER_hebrew_he 0xce4
#define CLUTTER_hebrew_waw 0xce5
#define CLUTTER_hebrew_zain 0xce6
#define CLUTTER_hebrew_zayin 0xce6
#define CLUTTER_hebrew_chet 0xce7
#define CLUTTER_hebrew_het 0xce7
#define CLUTTER_hebrew_tet 0xce8
#define CLUTTER_hebrew_teth 0xce8
#define CLUTTER_hebrew_yod 0xce9
#define CLUTTER_hebrew_finalkaph 0xcea
#define CLUTTER_hebrew_kaph 0xceb
#define CLUTTER_hebrew_lamed 0xcec
#define CLUTTER_hebrew_finalmem 0xced
#define CLUTTER_hebrew_mem 0xcee
#define CLUTTER_hebrew_finalnun 0xcef
#define CLUTTER_hebrew_nun 0xcf0
#define CLUTTER_hebrew_samech 0xcf1
#define CLUTTER_hebrew_samekh 0xcf1
#define CLUTTER_hebrew_ayin 0xcf2
#define CLUTTER_hebrew_finalpe 0xcf3
#define CLUTTER_hebrew_pe 0xcf4
#define CLUTTER_hebrew_finalzade 0xcf5
#define CLUTTER_hebrew_finalzadi 0xcf5
#define CLUTTER_hebrew_zade 0xcf6
#define CLUTTER_hebrew_zadi 0xcf6
#define CLUTTER_hebrew_qoph 0xcf7
#define CLUTTER_hebrew_kuf 0xcf7
#define CLUTTER_hebrew_resh 0xcf8
#define CLUTTER_hebrew_shin 0xcf9
#define CLUTTER_hebrew_taw 0xcfa
#define CLUTTER_hebrew_taf 0xcfa
#define CLUTTER_Hebrew_switch 0xFF7E
#define CLUTTER_Thai_kokai 0xda1
#define CLUTTER_Thai_khokhai 0xda2
#define CLUTTER_Thai_khokhuat 0xda3
#define CLUTTER_Thai_khokhwai 0xda4
#define CLUTTER_Thai_khokhon 0xda5
#define CLUTTER_Thai_khorakhang 0xda6
#define CLUTTER_Thai_ngongu 0xda7
#define CLUTTER_Thai_chochan 0xda8
#define CLUTTER_Thai_choching 0xda9
#define CLUTTER_Thai_chochang 0xdaa
#define CLUTTER_Thai_soso 0xdab
#define CLUTTER_Thai_chochoe 0xdac
#define CLUTTER_Thai_yoying 0xdad
#define CLUTTER_Thai_dochada 0xdae
#define CLUTTER_Thai_topatak 0xdaf
#define CLUTTER_Thai_thothan 0xdb0
#define CLUTTER_Thai_thonangmontho 0xdb1
#define CLUTTER_Thai_thophuthao 0xdb2
#define CLUTTER_Thai_nonen 0xdb3
#define CLUTTER_Thai_dodek 0xdb4
#define CLUTTER_Thai_totao 0xdb5
#define CLUTTER_Thai_thothung 0xdb6
#define CLUTTER_Thai_thothahan 0xdb7
#define CLUTTER_Thai_thothong 0xdb8
#define CLUTTER_Thai_nonu 0xdb9
#define CLUTTER_Thai_bobaimai 0xdba
#define CLUTTER_Thai_popla 0xdbb
#define CLUTTER_Thai_phophung 0xdbc
#define CLUTTER_Thai_fofa 0xdbd
#define CLUTTER_Thai_phophan 0xdbe
#define CLUTTER_Thai_fofan 0xdbf
#define CLUTTER_Thai_phosamphao 0xdc0
#define CLUTTER_Thai_moma 0xdc1
#define CLUTTER_Thai_yoyak 0xdc2
#define CLUTTER_Thai_rorua 0xdc3
#define CLUTTER_Thai_ru 0xdc4
#define CLUTTER_Thai_loling 0xdc5
#define CLUTTER_Thai_lu 0xdc6
#define CLUTTER_Thai_wowaen 0xdc7
#define CLUTTER_Thai_sosala 0xdc8
#define CLUTTER_Thai_sorusi 0xdc9
#define CLUTTER_Thai_sosua 0xdca
#define CLUTTER_Thai_hohip 0xdcb
#define CLUTTER_Thai_lochula 0xdcc
#define CLUTTER_Thai_oang 0xdcd
#define CLUTTER_Thai_honokhuk 0xdce
#define CLUTTER_Thai_paiyannoi 0xdcf
#define CLUTTER_Thai_saraa 0xdd0
#define CLUTTER_Thai_maihanakat 0xdd1
#define CLUTTER_Thai_saraaa 0xdd2
#define CLUTTER_Thai_saraam 0xdd3
#define CLUTTER_Thai_sarai 0xdd4
#define CLUTTER_Thai_saraii 0xdd5
#define CLUTTER_Thai_saraue 0xdd6
#define CLUTTER_Thai_sarauee 0xdd7
#define CLUTTER_Thai_sarau 0xdd8
#define CLUTTER_Thai_sarauu 0xdd9
#define CLUTTER_Thai_phinthu 0xdda
#define CLUTTER_Thai_maihanakat_maitho 0xdde
#define CLUTTER_Thai_baht 0xddf
#define CLUTTER_Thai_sarae 0xde0
#define CLUTTER_Thai_saraae 0xde1
#define CLUTTER_Thai_sarao 0xde2
#define CLUTTER_Thai_saraaimaimuan 0xde3
#define CLUTTER_Thai_saraaimaimalai 0xde4
#define CLUTTER_Thai_lakkhangyao 0xde5
#define CLUTTER_Thai_maiyamok 0xde6
#define CLUTTER_Thai_maitaikhu 0xde7
#define CLUTTER_Thai_maiek 0xde8
#define CLUTTER_Thai_maitho 0xde9
#define CLUTTER_Thai_maitri 0xdea
#define CLUTTER_Thai_maichattawa 0xdeb
#define CLUTTER_Thai_thanthakhat 0xdec
#define CLUTTER_Thai_nikhahit 0xded
#define CLUTTER_Thai_leksun 0xdf0
#define CLUTTER_Thai_leknung 0xdf1
#define CLUTTER_Thai_leksong 0xdf2
#define CLUTTER_Thai_leksam 0xdf3
#define CLUTTER_Thai_leksi 0xdf4
#define CLUTTER_Thai_lekha 0xdf5
#define CLUTTER_Thai_lekhok 0xdf6
#define CLUTTER_Thai_lekchet 0xdf7
#define CLUTTER_Thai_lekpaet 0xdf8
#define CLUTTER_Thai_lekkao 0xdf9
#define CLUTTER_Hangul 0xff31
#define CLUTTER_Hangul_Start 0xff32
#define CLUTTER_Hangul_End 0xff33
#define CLUTTER_Hangul_Hanja 0xff34
#define CLUTTER_Hangul_Jamo 0xff35
#define CLUTTER_Hangul_Romaja 0xff36
#define CLUTTER_Hangul_Codeinput 0xff37
#define CLUTTER_Hangul_Jeonja 0xff38
#define CLUTTER_Hangul_Banja 0xff39
#define CLUTTER_Hangul_PreHanja 0xff3a
#define CLUTTER_Hangul_PostHanja 0xff3b
#define CLUTTER_Hangul_SingleCandidate 0xff3c
#define CLUTTER_Hangul_MultipleCandidate 0xff3d
#define CLUTTER_Hangul_PreviousCandidate 0xff3e
#define CLUTTER_Hangul_Special 0xff3f
#define CLUTTER_Hangul_switch 0xFF7E
#define CLUTTER_Hangul_Kiyeog 0xea1
#define CLUTTER_Hangul_SsangKiyeog 0xea2
#define CLUTTER_Hangul_KiyeogSios 0xea3
#define CLUTTER_Hangul_Nieun 0xea4
#define CLUTTER_Hangul_NieunJieuj 0xea5
#define CLUTTER_Hangul_NieunHieuh 0xea6
#define CLUTTER_Hangul_Dikeud 0xea7
#define CLUTTER_Hangul_SsangDikeud 0xea8
#define CLUTTER_Hangul_Rieul 0xea9
#define CLUTTER_Hangul_RieulKiyeog 0xeaa
#define CLUTTER_Hangul_RieulMieum 0xeab
#define CLUTTER_Hangul_RieulPieub 0xeac
#define CLUTTER_Hangul_RieulSios 0xead
#define CLUTTER_Hangul_RieulTieut 0xeae
#define CLUTTER_Hangul_RieulPhieuf 0xeaf
#define CLUTTER_Hangul_RieulHieuh 0xeb0
#define CLUTTER_Hangul_Mieum 0xeb1
#define CLUTTER_Hangul_Pieub 0xeb2
#define CLUTTER_Hangul_SsangPieub 0xeb3
#define CLUTTER_Hangul_PieubSios 0xeb4
#define CLUTTER_Hangul_Sios 0xeb5
#define CLUTTER_Hangul_SsangSios 0xeb6
#define CLUTTER_Hangul_Ieung 0xeb7
#define CLUTTER_Hangul_Jieuj 0xeb8
#define CLUTTER_Hangul_SsangJieuj 0xeb9
#define CLUTTER_Hangul_Cieuc 0xeba
#define CLUTTER_Hangul_Khieuq 0xebb
#define CLUTTER_Hangul_Tieut 0xebc
#define CLUTTER_Hangul_Phieuf 0xebd
#define CLUTTER_Hangul_Hieuh 0xebe
#define CLUTTER_Hangul_A 0xebf
#define CLUTTER_Hangul_AE 0xec0
#define CLUTTER_Hangul_YA 0xec1
#define CLUTTER_Hangul_YAE 0xec2
#define CLUTTER_Hangul_EO 0xec3
#define CLUTTER_Hangul_E 0xec4
#define CLUTTER_Hangul_YEO 0xec5
#define CLUTTER_Hangul_YE 0xec6
#define CLUTTER_Hangul_O 0xec7
#define CLUTTER_Hangul_WA 0xec8
#define CLUTTER_Hangul_WAE 0xec9
#define CLUTTER_Hangul_OE 0xeca
#define CLUTTER_Hangul_YO 0xecb
#define CLUTTER_Hangul_U 0xecc
#define CLUTTER_Hangul_WEO 0xecd
#define CLUTTER_Hangul_WE 0xece
#define CLUTTER_Hangul_WI 0xecf
#define CLUTTER_Hangul_YU 0xed0
#define CLUTTER_Hangul_EU 0xed1
#define CLUTTER_Hangul_YI 0xed2
#define CLUTTER_Hangul_I 0xed3
#define CLUTTER_Hangul_J_Kiyeog 0xed4
#define CLUTTER_Hangul_J_SsangKiyeog 0xed5
#define CLUTTER_Hangul_J_KiyeogSios 0xed6
#define CLUTTER_Hangul_J_Nieun 0xed7
#define CLUTTER_Hangul_J_NieunJieuj 0xed8
#define CLUTTER_Hangul_J_NieunHieuh 0xed9
#define CLUTTER_Hangul_J_Dikeud 0xeda
#define CLUTTER_Hangul_J_Rieul 0xedb
#define CLUTTER_Hangul_J_RieulKiyeog 0xedc
#define CLUTTER_Hangul_J_RieulMieum 0xedd
#define CLUTTER_Hangul_J_RieulPieub 0xede
#define CLUTTER_Hangul_J_RieulSios 0xedf
#define CLUTTER_Hangul_J_RieulTieut 0xee0
#define CLUTTER_Hangul_J_RieulPhieuf 0xee1
#define CLUTTER_Hangul_J_RieulHieuh 0xee2
#define CLUTTER_Hangul_J_Mieum 0xee3
#define CLUTTER_Hangul_J_Pieub 0xee4
#define CLUTTER_Hangul_J_PieubSios 0xee5
#define CLUTTER_Hangul_J_Sios 0xee6
#define CLUTTER_Hangul_J_SsangSios 0xee7
#define CLUTTER_Hangul_J_Ieung 0xee8
#define CLUTTER_Hangul_J_Jieuj 0xee9
#define CLUTTER_Hangul_J_Cieuc 0xeea
#define CLUTTER_Hangul_J_Khieuq 0xeeb
#define CLUTTER_Hangul_J_Tieut 0xeec
#define CLUTTER_Hangul_J_Phieuf 0xeed
#define CLUTTER_Hangul_J_Hieuh 0xeee
#define CLUTTER_Hangul_RieulYeorinHieuh 0xeef
#define CLUTTER_Hangul_SunkyeongeumMieum 0xef0
#define CLUTTER_Hangul_SunkyeongeumPieub 0xef1
#define CLUTTER_Hangul_PanSios 0xef2
#define CLUTTER_Hangul_KkogjiDalrinIeung 0xef3
#define CLUTTER_Hangul_SunkyeongeumPhieuf 0xef4
#define CLUTTER_Hangul_YeorinHieuh 0xef5
#define CLUTTER_Hangul_AraeA 0xef6
#define CLUTTER_Hangul_AraeAE 0xef7
#define CLUTTER_Hangul_J_PanSios 0xef8
#define CLUTTER_Hangul_J_KkogjiDalrinIeung 0xef9
#define CLUTTER_Hangul_J_YeorinHieuh 0xefa
#define CLUTTER_Korean_Won 0xeff
#define CLUTTER_EcuSign 0x20a0
#define CLUTTER_ColonSign 0x20a1
#define CLUTTER_CruzeiroSign 0x20a2
#define CLUTTER_FFrancSign 0x20a3
#define CLUTTER_LiraSign 0x20a4
#define CLUTTER_MillSign 0x20a5
#define CLUTTER_NairaSign 0x20a6
#define CLUTTER_PesetaSign 0x20a7
#define CLUTTER_RupeeSign 0x20a8
#define CLUTTER_WonSign 0x20a9
#define CLUTTER_NewSheqelSign 0x20aa
#define CLUTTER_DongSign 0x20ab
#define CLUTTER_EuroSign 0x20ac

#endif /* __CLUTTER_KEYSYMS_H__ */
