/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "colorfilter_options.h"

static int ColorfilterOptionsDisplayPrivateIndex;

static CompMetadata colorfilterOptionsMetadata;

static CompPluginVTable *colorfilterPluginVTable = NULL;
CompPluginVTable colorfilterOptionsVTable;

#define COLORFILTER_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ColorfilterOptions, o)
#define COLORFILTER_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ColorfilterOptions, o)

typedef struct _ColorfilterOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ColorfilterDisplayOptionNum];
    colorfilterDisplayOptionChangeNotifyProc notify[ColorfilterDisplayOptionNum];
} ColorfilterOptionsDisplay;

typedef struct _ColorfilterOptionsScreen
{
    CompOption opt[ColorfilterScreenOptionNum];
    colorfilterScreenOptionChangeNotifyProc notify[ColorfilterScreenOptionNum];
} ColorfilterOptionsScreen;

CompAction * colorfilterGetToggleWindowKey (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleWindowKey].value.action;
}

void colorfilterSetToggleWindowKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleWindowKey].value.action.initiate = init;
}

void colorfilterSetToggleWindowKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleWindowKey].value.action.terminate = term;
}

CompOption * colorfilterGetToggleWindowKeyOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleWindowKey];
}

void colorfilterSetToggleWindowKeyNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionToggleWindowKey] = notify;
}

CompAction * colorfilterGetToggleScreenKey (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleScreenKey].value.action;
}

void colorfilterSetToggleScreenKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleScreenKey].value.action.initiate = init;
}

void colorfilterSetToggleScreenKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleScreenKey].value.action.terminate = term;
}

CompOption * colorfilterGetToggleScreenKeyOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleScreenKey];
}

void colorfilterSetToggleScreenKeyNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionToggleScreenKey] = notify;
}

CompAction * colorfilterGetSwitchFilterKey (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionSwitchFilterKey].value.action;
}

void colorfilterSetSwitchFilterKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionSwitchFilterKey].value.action.initiate = init;
}

void colorfilterSetSwitchFilterKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionSwitchFilterKey].value.action.terminate = term;
}

CompOption * colorfilterGetSwitchFilterKeyOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionSwitchFilterKey];
}

void colorfilterSetSwitchFilterKeyNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionSwitchFilterKey] = notify;
}

CompListValue * colorfilterGetFilters (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilters].value.list;
}

CompOption * colorfilterGetFiltersOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilters];
}

void colorfilterSetFiltersNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilters] = notify;
}

Bool colorfilterGetFilterDecorations (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return os->opt[ColorfilterScreenOptionFilterDecorations].value.b;
}

CompOption * colorfilterGetFilterDecorationsOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterDecorations];
}

void colorfilterSetFilterDecorationsNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilterDecorations] = notify;
}

CompMatch * colorfilterGetFilterMatch (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterMatch].value.match;
}

CompOption * colorfilterGetFilterMatchOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterMatch];
}

void colorfilterSetFilterMatchNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilterMatch] = notify;
}

CompMatch * colorfilterGetExcludeMatch (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionExcludeMatch].value.match;
}

CompOption * colorfilterGetExcludeMatchOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionExcludeMatch];
}

void colorfilterSetExcludeMatchNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionExcludeMatch] = notify;
}

CompOption * colorfilterGetDisplayOption (CompDisplay *d, ColorfilterDisplayOptions num)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * colorfilterGetScreenOption (CompScreen *s, ColorfilterScreenOptions num)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo colorfilterOptionsDisplayOptionInfo[] = {
    { "toggle_window_key", "key", 0, 0, 0 },
    { "toggle_screen_key", "key", 0, 0, 0 },
    { "switch_filter_key", "key", 0, 0, 0 },
};

static Bool colorfilterOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ColorfilterDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ColorfilterDisplayOptionToggleWindowKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionToggleWindowKey])
                (*od->notify[ColorfilterDisplayOptionToggleWindowKey]) (d, o, ColorfilterDisplayOptionToggleWindowKey);
            return TRUE;
        }
        break;
     case ColorfilterDisplayOptionToggleScreenKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionToggleScreenKey])
                (*od->notify[ColorfilterDisplayOptionToggleScreenKey]) (d, o, ColorfilterDisplayOptionToggleScreenKey);
            return TRUE;
        }
        break;
     case ColorfilterDisplayOptionSwitchFilterKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionSwitchFilterKey])
                (*od->notify[ColorfilterDisplayOptionSwitchFilterKey]) (d, o, ColorfilterDisplayOptionSwitchFilterKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * colorfilterOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    *count = ColorfilterDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo colorfilterOptionsScreenOptionInfo[] = {
    { "filters", "list", "<type>string</type>", 0, 0 },
    { "filter_decorations", "bool", 0, 0, 0 },
    { "filter_match", "match", 0, 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
};

static Bool colorfilterOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ColorfilterScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ColorfilterScreenOptionFilters:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilters])
                (*os->notify[ColorfilterScreenOptionFilters]) (s, o, ColorfilterScreenOptionFilters);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionFilterDecorations:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilterDecorations])
                (*os->notify[ColorfilterScreenOptionFilterDecorations]) (s, o, ColorfilterScreenOptionFilterDecorations);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionFilterMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilterMatch])
                (*os->notify[ColorfilterScreenOptionFilterMatch]) (s, o, ColorfilterScreenOptionFilterMatch);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionExcludeMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionExcludeMatch])
                (*os->notify[ColorfilterScreenOptionExcludeMatch]) (s, o, ColorfilterScreenOptionExcludeMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * colorfilterOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    *count = ColorfilterScreenOptionNum;
    return os->opt;
}

static Bool colorfilterOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ColorfilterOptionsScreen *os;
    
    COLORFILTER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ColorfilterOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &colorfilterOptionsMetadata, colorfilterOptionsScreenOptionInfo, os->opt, ColorfilterScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void colorfilterOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ColorfilterScreenOptionNum);

    free (os);
}

static Bool colorfilterOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ColorfilterOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ColorfilterOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ColorfilterOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &colorfilterOptionsMetadata, colorfilterOptionsDisplayOptionInfo, od->opt, ColorfilterDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void colorfilterOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ColorfilterDisplayOptionNum);

    free (od);
}

static Bool colorfilterOptionsInit (CompPlugin *p)
{
    ColorfilterOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ColorfilterOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&colorfilterOptionsMetadata, "colorfilter",colorfilterOptionsDisplayOptionInfo, ColorfilterDisplayOptionNum, colorfilterOptionsScreenOptionInfo, ColorfilterScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&colorfilterOptionsMetadata, "colorfilter");
    if (colorfilterPluginVTable && colorfilterPluginVTable->init)
        return colorfilterPluginVTable->init (p);
    return TRUE;
}

static void colorfilterOptionsFini (CompPlugin *p)
{
    if (colorfilterPluginVTable && colorfilterPluginVTable->fini)
        colorfilterPluginVTable->fini (p);

    if (ColorfilterOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ColorfilterOptionsDisplayPrivateIndex);

    compFiniMetadata (&colorfilterOptionsMetadata);
}

static CompBool colorfilterOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) colorfilterOptionsInitDisplay,
        (InitPluginObjectProc) colorfilterOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void colorfilterOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) colorfilterOptionsFiniDisplay,
        (FiniPluginObjectProc) colorfilterOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool colorfilterOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = colorfilterOptionsInitObject (p, o);
    if (colorfilterPluginVTable->initObject)
        rv &= colorfilterPluginVTable->initObject (p, o);
    return rv;
}

static void colorfilterOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (colorfilterPluginVTable->finiObject)
        colorfilterPluginVTable->finiObject (p, o);
    colorfilterOptionsFiniObject (p, o);
}

static CompOption * colorfilterOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) colorfilterOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) colorfilterOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool colorfilterOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) colorfilterOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) colorfilterOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
colorfilterOptionsGetMetadata (CompPlugin *plugin)
{
    return &colorfilterOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!colorfilterPluginVTable)
    {
        colorfilterPluginVTable = getCompPluginInfo ();
        memcpy(&colorfilterOptionsVTable, colorfilterPluginVTable, sizeof(CompPluginVTable));
        colorfilterOptionsVTable.getMetadata = colorfilterOptionsGetMetadata;
        colorfilterOptionsVTable.init = colorfilterOptionsInit;
        colorfilterOptionsVTable.fini = colorfilterOptionsFini;
        colorfilterOptionsVTable.initObject = colorfilterOptionsInitObjectWrapper;
        colorfilterOptionsVTable.finiObject = colorfilterOptionsFiniObjectWrapper;
        colorfilterOptionsVTable.getObjectOptions = colorfilterOptionsGetObjectOptions;
	colorfilterOptionsVTable.setObjectOption = colorfilterOptionsSetObjectOption;
	
    }
    return &colorfilterOptionsVTable;
}

