/*
 * Copyright (C) 2009 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 */

#ifndef _HAVE_DBUS_PEER_H
#define _HAVE_DBUS_PEER_H

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-bindings.h>

G_BEGIN_DECLS

#define DBUS_TYPE_PEER (dbus_peer_get_type ())

#define DBUS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        DBUS_TYPE_PEER, DbusPeer))

#define DBUS_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        DBUS_TYPE_PEER, DbusPeerClass))

#define DBUS_IS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        DBUS_TYPE_PEER))

#define DBUS_IS_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        DBUS_TYPE_PEER))

#define DBUS_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        DBUS_TYPE_PEER, DbusPeerClass))

typedef struct _DbusPeer DbusPeer;
typedef struct _DbusPeerClass DbusPeerClass;
typedef struct _DbusPeerPrivate DbusPeerPrivate;

/**
 * DbusPeer:
 *
 * All fields in the DbusPeer structure are private and should never be
 * accessed directly
 */
struct _DbusPeer
{
  /*< private >*/
  GObject         parent;
 
  DbusPeerPrivate   *priv;
};

struct _DbusPeerClass
{
  /*< private >*/
  GObjectClass    parent_class;

  /*< public >*/

  /*< signals >*/
  void (*connected)  (DbusPeer *peer, const gchar *peer_name);
  void (*peer_found) (DbusPeer *peer, const gchar *name);
  void (*peer_lost)  (DbusPeer *peer, const gchar *name);

  /*< vtable >*/

  /*< private >*/
  void (*_dbus_peer_1) (void);
  void (*_dbus_peer_2) (void);
  void (*_dbus_peer_3) (void);
  void (*_dbus_peer_4) (void);
};

/**
 * dbus_peer_get_type:
 *
 * The GType of #DbusPeer
 *
 * Return value: the #GType of #DbusPeer
 **/
GType             dbus_peer_get_type       (void) G_GNUC_CONST;

void              dbus_peer_connect        (DbusPeer    *self);

DBusGConnection * dbus_peer_get_connection (DbusPeer *self);

const gchar *     dbus_peer_get_peer_name  (DbusPeer    *self);

void              dbus_peer_set_swarm_name (DbusPeer    *self,
                                            const gchar *swarm_name);

const gchar *     dbus_peer_get_swarm_name (DbusPeer    *self);

G_END_DECLS

#endif /* _HAVE_DBUS_PEER_H */
