/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <time.h>
#include <glib.h>
#include <glib-object.h>

#include <dbusmodel/dbusmodel.h>

gint
main (gint argc, gchar *argv[])
{
  GMainLoop *loop;
  DbusModel *model;
  DbusPeer  *peer;
  
  g_type_init (); 
  g_thread_init (NULL);

  model = dbus_model_new ("com.canonical.Dbus.Model.Example",
                          2,
                          G_TYPE_INT,
                          G_TYPE_STRING);
  g_assert (DBUS_IS_MODEL (model));

  peer = g_object_new (DBUS_TYPE_PEER,
                       "swarm-name", "com.canonical.DbusPeer.Test",
                       NULL);
  dbus_peer_connect (peer);

  peer = g_object_new (DBUS_TYPE_PEER,
                       "swarm-name", "com.canonical.DbusPeer.Test",
                       NULL);
  dbus_peer_connect (peer);  

  peer = g_object_new (DBUS_TYPE_PEER,
                       "swarm-name", "com.canonical.DbusPeer.Test",
                       NULL);
  dbus_peer_connect (peer);  

  loop = g_main_loop_new (g_main_context_default (), TRUE);
  g_main_loop_run (loop);

  return 0;
}
