"""testing desktopcouch/start_local_couchdb.py module"""

import testtools
import os, sys
import desktopcouch.tests as test_environment
import desktopcouch
sys.path.append(
    os.path.join(os.path.split(desktopcouch.__file__)[0], "..", "contrib"))
from mocker import Mocker

DIRS = [
"databases",
  "databases/nocfg",
  "databases/cfg",
  "databases/cfg_and_empty_design",
    "databases/cfg_and_empty_design/_design",
  "databases/cfg_and_design_no_views",
    "databases/cfg_and_design_no_views/_design",
    "databases/cfg_and_design_no_views/_design/doc1",
    "databases/cfg_and_design_no_views/_design/doc1/views",
  "databases/cfg_and_design_one_view_no_map",
    "databases/cfg_and_design_one_view_no_map/_design",
    "databases/cfg_and_design_one_view_no_map/_design/doc1",
    "databases/cfg_and_design_one_view_no_map/_design/doc1/views",
    "databases/cfg_and_design_one_view_no_map/_design/doc1/views/view1",
  "databases/cfg_and_design_one_view_map_no_reduce",
    "databases/cfg_and_design_one_view_map_no_reduce/_design",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views/view1",
  "databases/cfg_and_design_one_view_map_reduce",
    "databases/cfg_and_design_one_view_map_reduce/_design",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1",
  "databases/cfg_and_design_two_views_map_reduce",
    "databases/cfg_and_design_two_views_map_reduce/_design",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2",
  ]

FILES = {
    "databases/cfg/database.cfg": "",
    "databases/cfg_and_empty_design/database.cfg": "",
    "databases/cfg_and_design_no_views/database.cfg": "",
    "databases/cfg_and_design_one_view_no_map/database.cfg": "",
    "databases/cfg_and_design_one_view_map_no_reduce/database.cfg": "",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_one_view_map_no_reduce:map",
    "databases/cfg_and_design_one_view_map_reduce/database.cfg": "",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_one_view_map_reduce:map",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1/"
    "reduce.js": "cfg_and_design_one_view_map_reduce:reduce",
    "databases/cfg_and_design_two_views_map_reduce/database.cfg": "",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_two_views_map_reduce:map1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1/"
    "reduce.js": "cfg_and_design_two_views_map_reduce:reduce1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2/"
    "map.js": "cfg_and_design_two_views_map_reduce:map2",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2/"
    "reduce.js": "cfg_and_design_two_views_map_reduce:reduce2",
}


class TestUpdateDesignDocuments(testtools.TestCase):
    """Testing that the database/designdoc filesystem loader works"""

    def setUp(self):
        # create temp folder with databases and design documents in
        super(TestUpdateDesignDocuments, self).setUp()
        xdg_data = os.path.split(test_environment.test_context.db_dir)[0]
        try:
            os.mkdir(os.path.join(xdg_data, "desktop-couch"))
        except OSError:
            pass # don't worry if the folder already exists
        for d in DIRS:
            os.mkdir(os.path.join(xdg_data, "desktop-couch", d))
        for f, data in FILES.items():
            fp = open(os.path.join(xdg_data, "desktop-couch", f), "w")
            fp.write(data)
            fp.close()

    def test_create_databases_and_design_docs(self):
        """Are databases and design documents correctly
           created from the filesystem?"""
        # Mock CouchDatabase
        mocker = Mocker()
        couchdb = mocker.replace("desktopcouch.records.server.CouchDatabase")

        # databases that should be created
        couchdb("cfg", create=True, ctx=test_environment.test_context)
        couchdb(
            "cfg_and_empty_design", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_no_views", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_one_view_no_map", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_one_view_map_no_reduce", create=True,
            ctx=test_environment.test_context)

        dbmock1 = mocker.mock()
        mocker.result(dbmock1)
        dbmock1.add_view("view1", "cfg_and_design_one_view_map_no_reduce:map",
          None, "doc1")
        couchdb(
            "cfg_and_design_one_view_map_reduce", create=True,
            ctx=test_environment.test_context)
        dbmock2 = mocker.mock()
        mocker.result(dbmock2)
        dbmock2.add_view("view1", "cfg_and_design_one_view_map_reduce:map",
          "cfg_and_design_one_view_map_reduce:reduce", "doc1")
        couchdb(
            "cfg_and_design_two_views_map_reduce", create=True,
            ctx=test_environment.test_context)
        dbmock3 = mocker.mock()
        mocker.result(dbmock3)
        dbmock3.add_view("view1", "cfg_and_design_two_views_map_reduce:map1",
          "cfg_and_design_two_views_map_reduce:reduce1", "doc1")
        dbmock3.add_view("view2", "cfg_and_design_two_views_map_reduce:map2",
          "cfg_and_design_two_views_map_reduce:reduce2", "doc1")

        # actually call update_design_documents to confirm that it creates
        # all the right things
        mocker.replay()
        from desktopcouch.start_local_couchdb import update_design_documents
        update_design_documents(ctx=test_environment.test_context)

        mocker.restore()
        mocker.verify()


