/*
 * User Session Library test for Linux
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file UserSessionTest.c
 *
 * Test of UserSession library
 */

#include <UserSession.h>
#include <stdio.h>

int main()
{
	int result = 0;
	UserSessionStatus status;
	
	result = InitializeUserSessionStatus();
	if (result != 0) {
		printf("initialize fialed!\n");
		return 1;
	}

	status = GetUserSessionStatus();
	switch (status) {
	case USS_ActiveSession:
		printf("Session is active!\n");
		break;
	case USS_ActiveRemoteSession:
		printf("Remote session is active!\n");
		break;
	case USS_InactiveSession:
		printf("Session is inactive!\n");
		break;
	case USS_Uninitialized:
		printf("The library is not uninitialized!\n");
		break;
	default:
		printf("Known error!\n");
	}

	UninitializeUserSessionStatus();

	return 0;
}
