/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_COMMON_H
#define DCS_COMMON_H

#define DCS_VERSION			0x100


#define DCS_TABLET_SENSOR	1
#define DCS_ACCELEROMETER	2
#define DCS_POWER_MANAGER	3
#define DCS_VIRTUAL_KEY		4
#define DCS_EASY_NETWORK_MANAGER 5
#define DCS_POLICY 6

#define DCS_EVENT_NUM_START 100
#define DCS_UNREGISTER_EVENT_NUM_START 300

#define MIN_EVENT_ID 0
#define MAX_EVENT_ID 300
#define MAX_FUNC_ID 20

#define MAX_RETURN_DATA_LEN 8192 

#define MAX_STRING_LEN 256

/** Maximum message length transferred between DCS and clients. */
#define MAX_COMM_LEN 8192 

/** Definition of return codes by DCS APIs. */
typedef enum DCS_Return_Code_E {
	DCS_SUCCESS,		/**< No error */
	DCS_NOT_SUPPORTED,	/**< Request is not supported */
	DCS_REQUEST_DENIED,	/**< Request is denied */
	DCS_MODULE_NOTEXIST,/**< Requested module does not exist */
	DCS_EVENT_NOTEXIST,	/**< Requested event does not exist */
	DCS_FUNC_NOTEXIST,	/**< Request function does not exist */
	DCS_FAIL_OPERATION, /**< fail operation*/
	DCS_CONNECTION_ABORT /**< Server connection is aborted*/
} DCS_Return_Code;

#ifndef CHAR
typedef char CHAR;
#endif
#ifndef BOOL
typedef int BOOL;
#endif
#ifndef UINT
typedef unsigned int UINT;
#endif
#ifndef ULONG
typedef unsigned long ULONG;
#endif
#ifndef UCHAR
typedef unsigned char UCHAR;
#endif

#ifndef PVOID
typedef void* PVOID;
#endif

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN

#ifdef _WINDOWS_
#include <windows.h>
#endif

typedef unsigned long DWORD;
typedef char* DCS_UserID;
typedef DWORD DCS_ProcID;

#ifdef DLLIMPORT
#define DCSAPI __declspec(dllimport)
#else
#define DCSAPI __declspec(dllexport)
#endif
#define CALLBACK __stdcall

#else /* _WIN32 */

#include <unistd.h>
typedef pid_t DCS_ProcID;
typedef uid_t DCS_UserID;
#ifndef LPVOID
typedef void* LPVOID;
#endif
#ifndef BYTE
typedef unsigned char BYTE;
#endif
#ifndef PVOID
typedef void* PVOID;
#endif
typedef int DCS_Socket;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TCHAR
typedef char TCHAR;
#endif
#define DCSAPI
#define CALLBACK
#define WINAPI
#define closesocket close

#ifndef MAX_PATH
#define MAX_PATH PATH_MAX
#endif

#endif
#endif /* DCS_COMMON_H */
