/****************************************************************************
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PowerSchemeMgmt.h

Description:

    This file implements class PowerSchemeMgmt.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "PowerSchemeMgmt.h"
#include <fcntl.h>

extern FILE* pm_log;

PowerSchemeMgmt::PowerSchemeMgmt(string userHomeDir)
{
    //InitSchemeFilePath();
    m_SchemeFilePath = userHomeDir + SCHEMEFILE;

//    fprintf(pm_log, "---filepath is %s\n", m_SchemeFilePath.c_str());
//    fflush(pm_log);
}

PowerSchemeMgmt::~PowerSchemeMgmt()
{
}

/**
** Get the scheme xml file from current user folder.
**/
DCS_Return_Code PowerSchemeMgmt::InitSchemeFilePath()
{
//    char temp[64];
//    char *name = cuserid(temp);
//    struct passwd * pw;
//    if (NULL == name)
//    {
//        return DCS_FAIL_OPERATION;
//    }
//
//    pw = getpwnam(name);
//    m_SchemeFilePath= pw->pw_dir + SCHEMEFILE;

//    char buffer[BUFFER_SIZE];
//    int bytesRead;
//    int fd;
//
//    string fileName = "/etc/ipower-management/config-file-bak/username";
//
//    if((fd = open(fileName.c_str(),O_RDONLY)) == -1)
//    {
//        return DCS_FAIL_OPERATION;
//    }
//
//    while(bytesRead = read(fd, buffer,BUFFER_SIZE))
//    {
//        if(bytesRead==-1)
//        {
//            break;
//        }
//        else if(bytesRead > 0)
//        {
//            m_SchemeFilePath = buffer;
//            m_SchemeFilePath += SCHEMEFILE;
//        }
//    }
//
//    close(fd);

    return DCS_SUCCESS;
}

/**
** Get the schemeID of the active scheme.
**/
DCS_Return_Code PowerSchemeMgmt::GetActiveSchemeId(int &schemeId)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = xmlDoc.FirstChild(SCHEMES);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return DCS_FAIL_OPERATION;
	}

    pNode = xmlRootElement->FirstChild(SCHEME_ACTIVE);
    if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlSubElement = pNode->ToElement();


    xmlSubElement->Attribute(SCHEMEID.c_str(), &schemeId);

	return DCS_SUCCESS;
}

/**
 * Applies a power scheme.
 *
 * @param schemeId	the ID of the power scheme to set active
 */
DCS_Return_Code PowerSchemeMgmt::SetActivePowerScheme(int schemeId)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();


    pNode = xmlRootElement->FirstChild(SCHEME_ACTIVE);
    if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
    xmlSubElement = pNode->ToElement();


    xmlSubElement->SetAttribute(SCHEMEID.c_str(), schemeId);

    if(xmlDoc.SaveFile())
    {
        return DCS_SUCCESS;
    }

    return DCS_FAIL_OPERATION;
}

/**
** Delete the scheme by the given schemeID.
**/
DCS_Return_Code PowerSchemeMgmt::DeletePowerScheme(int schemeId)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();


    pNode = xmlRootElement->FirstChild(SCHEME);

    while(pNode)
    {
        xmlSubElement = pNode->ToElement();
        int idTemp = 0;
        xmlSubElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            if (!(xmlRootElement->RemoveChild(pNode)))
            {
                return DCS_FAIL_OPERATION;

            }

            break;
        }

        pNode = pNode->NextSibling();
    }

    if(xmlDoc.SaveFile())
    {
        return DCS_SUCCESS;
    }

    return DCS_FAIL_OPERATION;
}

DCS_Return_Code PowerSchemeMgmt::GetDefaultSchemeInfo(int schemeId, map<string, int> &acMapping, map<string, int> &dcMapping)
{
    string defaultFile = DEFAULTSCHEMEFILE;

    TiXmlDocument defaultXmlDoc(defaultFile.c_str());
    if ( !defaultXmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = defaultXmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();


    pNode = xmlRootElement->FirstChild(SCHEME);

    while(pNode)
    {
        xmlSubElement = pNode->ToElement();
        int idTemp = 0;
        xmlSubElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            TiXmlElement* xmlItemElement = 0;
            TiXmlElement* xmlValueElement = 0;
            int acValue = 0;
            int dcValue = 0;
            string varName;
            TiXmlNode * child = 0;

            child = xmlSubElement->FirstChild();
            while(child)
            {
                varName = child->ValueStr();

                xmlItemElement = child->ToElement();
                if (NULL == xmlItemElement)
                {
                    return DCS_FAIL_OPERATION;
                }

                xmlValueElement = xmlItemElement->FirstChildElement(ACVALUE);
                if (NULL == xmlValueElement)
                {
                    return DCS_FAIL_OPERATION;
                }
                xmlValueElement->Attribute(VALUE.c_str(), &acValue);
                acMapping.insert(make_pair(varName, acValue));

                xmlValueElement = xmlItemElement->FirstChildElement(DCVALUE);
                if (NULL == xmlValueElement)
                {
                    return DCS_FAIL_OPERATION;
                }
                xmlValueElement->Attribute(VALUE.c_str(), &dcValue);
                dcMapping.insert(make_pair(varName, dcValue));

                child = child->NextSibling();
            }

            return DCS_SUCCESS;
        }

        pNode = pNode->NextSibling();
    }

    return DCS_FAIL_OPERATION;

}

/**
** Add a power scheme. It is non-default.
**/
DCS_Return_Code PowerSchemeMgmt::AddPowerScheme(char *pName, char *pDesc, int copyFrom, int schemeId)
{
    if (pName == NULL)
    {
        return DCS_FAIL_OPERATION;
    }

    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();


    ///
    // Set power scheme infomation
    ///
    xmlSubElement = new TiXmlElement(SCHEME);
    if ( NULL != pName )
    {
        xmlSubElement->SetAttribute(NAME.c_str(), pName);
    }

    xmlSubElement->SetAttribute(SCHEMEID.c_str(), schemeId);
    xmlSubElement->SetAttribute(DEFAULT.c_str(), NONDEFAULT);

    if ( NULL != pDesc )
    {
        xmlSubElement->SetAttribute(DESC.c_str(), pDesc);
    }

    xmlRootElement->LinkEndChild(xmlSubElement);

    ///

    ///
    // Read default power scheme value.
    ///
//    map<string, int> acDefaultMap;
//    map<string, int> dcDefaultMap;
//
//    int copySchemeId = DEFAULT_SCHEMEID[copyFrom];
//    GetDefaultSchemeInfo(copySchemeId, acDefaultMap, dcDefaultMap);

    ///
    // Write value to the new power scheme.
    ///
//    TiXmlElement* xmlItemElement = 0;
//    TiXmlElement* xmlAcValueElement = 0;
//    TiXmlElement* xmlDcValueElement = 0;
//    string varName;
//
//    map<string, int>::const_iterator acMapIt = acDefaultMap.begin();
//
//    while ( acMapIt != acDefaultMap.end() )
//    {
//        varName = acMapIt->first;
//        xmlItemElement = new TiXmlElement(varName);
//        xmlSubElement->LinkEndChild(xmlItemElement);
//
//        xmlAcValueElement = new TiXmlElement(ACVALUE);
//        xmlAcValueElement->SetAttribute(VALUE.c_str(), acDefaultMap[varName]);
//        xmlItemElement->LinkEndChild(xmlAcValueElement);
//
//        xmlDcValueElement = new TiXmlElement(DCVALUE);
//        xmlDcValueElement->SetAttribute(VALUE.c_str(), dcDefaultMap[varName]);
//        xmlItemElement->LinkEndChild(xmlDcValueElement);
//
//        ++acMapIt;
//    }

    if ( xmlDoc.SaveFile() )
    {
        return DCS_SUCCESS;
    }

    return DCS_FAIL_OPERATION;
}

/**
** Set a variable value in a power scheme.
**/
DCS_Return_Code PowerSchemeMgmt::SetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int value)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}

	xmlRootElement = pNode->ToElement();

    pNode = xmlRootElement->FirstChild(SCHEME);

    while(pNode)
    {
        xmlSubElement = pNode->ToElement();
        int idTemp = 0;
        xmlSubElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            TiXmlElement* xmlItemElement = 0;
            TiXmlElement* xmlValueElement = 0;

            xmlItemElement = xmlSubElement->FirstChildElement(pVarName);

            if (NULL == xmlItemElement)
            {
                xmlItemElement = new TiXmlElement(pVarName);
                xmlSubElement->LinkEndChild(xmlItemElement);

               // return DCS_FAIL_OPERATION;
            }
//            else
//            {
                if ( isAC )
                {
                    xmlValueElement = xmlItemElement->FirstChildElement(ACVALUE.c_str());
                    if (NULL == xmlValueElement)
                    {
                        xmlValueElement = new TiXmlElement(ACVALUE);
                        xmlValueElement->SetAttribute(VALUE.c_str(), value);
                        xmlItemElement->LinkEndChild(xmlValueElement);

                        //return DCS_FAIL_OPERATION;
                    }
                    else
                    {
                        xmlValueElement->SetAttribute(VALUE.c_str(), value);
                    }
                }
                else
                {
                    xmlValueElement = xmlItemElement->FirstChildElement(DCVALUE.c_str());
                    if (NULL == xmlValueElement)
                    {
                        xmlValueElement = new TiXmlElement(DCVALUE);
                        xmlValueElement->SetAttribute(VALUE.c_str(), value);
                        xmlItemElement->LinkEndChild(xmlValueElement);

                        //return DCS_FAIL_OPERATION;
                    }
                    else
                    {
                        xmlValueElement->SetAttribute(VALUE.c_str(), value);
                    }
                }
//            }

            break;
        }

        pNode = pNode->NextSibling();
    }

    if(xmlDoc.SaveFile())
    {
        return DCS_SUCCESS;
    }

    return DCS_FAIL_OPERATION;
}

/**
** Get the value of the variable.
**/
DCS_Return_Code PowerSchemeMgmt::GetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = 0;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();

    pNode = xmlRootElement->FirstChild(SCHEME);

    while(pNode)
    {
        xmlSubElement = pNode->ToElement();
        int idTemp = 0;

        xmlSubElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            TiXmlElement* xmlItemElement = 0;
            TiXmlElement* xmlValueElement = 0;

            pNode = xmlSubElement->FirstChild(pVarName);
            if (NULL == pNode)
            {
                return DCS_FAIL_OPERATION;
            }
            xmlItemElement = pNode->ToElement();

            if ( isAC )
            {
                pNode = xmlItemElement->FirstChild(ACVALUE);
                if (NULL == pNode)
                {
                    return DCS_FAIL_OPERATION;
                }
                xmlValueElement = pNode->ToElement();

                xmlValueElement->Attribute(VALUE, pValue);
            }
            else
            {
                pNode = xmlItemElement->FirstChild(DCVALUE);
                if (NULL == pNode)
                {
                    return DCS_FAIL_OPERATION;
                }
                xmlValueElement = pNode->ToElement();

               xmlValueElement->Attribute(VALUE, pValue);
            }

            return DCS_SUCCESS;
        }

        pNode = pNode->NextSibling();
    }

    return DCS_FAIL_OPERATION;
}

DCS_Return_Code PowerSchemeMgmt::GetPowerSchemeNameDesc(int schemeId, string &pSchemeName, string &pSchemeDesc)
{
    if (m_SchemeFilePath.empty())
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlDocument xmlDoc(m_SchemeFilePath.c_str());
    if ( !xmlDoc.LoadFile() )
    {
        return DCS_FAIL_OPERATION;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = 0;

	pNode = xmlDoc.FirstChild(SCHEMES);
	if (NULL == pNode)
	{
	    return DCS_FAIL_OPERATION;
	}
	xmlRootElement = pNode->ToElement();

   pNode = xmlRootElement->FirstChild(SCHEME);

    while(pNode)
    {
        xmlSubElement = pNode->ToElement();
        int idTemp = 0;
        xmlSubElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            pSchemeName = xmlSubElement->Attribute(NAME.c_str());
            pSchemeDesc = xmlSubElement->Attribute(DESC.c_str());

            break;
        }

        pNode = pNode->NextSibling();
    }

	return DCS_SUCCESS;
}



