/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_APPLY_PROFILE_BALLOON_H_
#define _ENM_APPLY_PROFILE_BALLOON_H_

#include <wx/event.h>
#include <wx/timer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/gauge.h>
#include "BitmapDialog.h"

class ENMApplyProfileBalloon : public wxBitmapDialog
{
public:
    ENMApplyProfileBalloon(wxWindow* parent, const wxString& title);
    virtual ~ENMApplyProfileBalloon();

    void OnTimer(wxTimerEvent& event);
    void StartTimer();
    void StopTimer();
    void CallExit();
    void SetApplyProfileName(wxString wxsProfileName);
    void SetTurningOnNetwork(wxString wxsNetworkType);

    wxGauge* m_pGauge;
    wxStaticText* m_profileName;
    wxStaticText* m_networkType;
    wxTimer m_ApplyBalloonTimer;
    int m_iCount;
    wxButton* m_btnClose;

private:
    static const long ID_TIMER_APPLYBALLOON;
    static const long ID_BTN_CLOSE;

    void OnButtonClick(wxCommandEvent& event);

    DECLARE_EVENT_TABLE();

};

#endif // _ENM_APPLY_PROFILE_BALLOON_H_
