# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Messages for the pigment frontend
"""

from elisa.core.components.message import Message

class ViewportWindowCreated(Message):
    """
    Sent over the L{elisa.core.bus.Bus} when the pigment viewport window
    has been created
    
    @ivar hwnd:          the win32 window handle of the created viewport
    @type hwnd:          C{int}
    @ivar viewport:      the Pigment viewport
    @type viewport:      pgm.Viewport
    """
    def __init__(self, hwnd=None, viewport=None):
        self.hwnd = hwnd
        self.viewport = viewport

