# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
A base option screen.
"""

from elisa.plugins.poblesec.configuration.option_screen import OptionScreen

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text

import pgm


class BaseScreenWidget(Widget):

    """
    A widget that contains a title and a summary for option screens.
    """

    style_prefix = 'option-screen'

    def __init__(self):
        super(BaseScreenWidget, self).__init__()

        self._title = Text()
        self.add(self._title)
        self._title.visible = True

        self._summary = Text()
        self.add(self._summary)
        self._summary.visible = True

        self._update_style_properties(self._style.get_items())

    def _update_style_properties(self, props=None):
        super(BaseScreenWidget, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == '%s-title-fg-color' % self.style_prefix:
                self._title.fg_color = value
            elif key == '%s-title-bg-a' % self.style_prefix:
                self._title.bg_a = value
            elif key == '%s-title-weight' % self.style_prefix:
                self._title.weight = eval('pgm.TEXT_WEIGHT_%s' % value.upper())
            elif key == '%s-title-alignment' % self.style_prefix:
                self._title.alignment = eval('pgm.TEXT_ALIGN_%s' % \
                                             value.upper())
            elif key == '%s-title-width' % self.style_prefix:
                self._title.width = value
            elif key == '%s-title-height' % self.style_prefix:
                self._title.height = value
            elif key == '%s-title-x' % self.style_prefix:
                self._title.x = value
            elif key == '%s-title-y' % self.style_prefix:
                self._title.y = value
            elif key == '%s-title-z' % self.style_prefix:
                self._title.z = value
            elif key == '%s-summary-font-height' % self.style_prefix:
                self._summary.font_height = value
            elif key == '%s-summary-fg-color' % self.style_prefix:
                self._summary.fg_color = value
            elif key == '%s-summary-bg-a' % self.style_prefix:
                self._summary.bg_a = value
            elif key == '%s-summary-weight' % self.style_prefix:
                self._summary.weight = eval('pgm.TEXT_WEIGHT_%s' % \
                                            value.upper())
            elif key == '%s-summary-alignment' % self.style_prefix:
                self._summary.alignment = eval('pgm.TEXT_ALIGN_%s' % \
                                               value.upper())
            elif key == '%s-summary-width' % self.style_prefix:
                self._summary.width = value
            elif key == '%s-summary-height' % self.style_prefix:
                self._summary.height = value
            elif key == '%s-summary-x' % self.style_prefix:
                self._summary.x = value
            elif key == '%s-summary-y' % self.style_prefix:
                self._summary.y = value
            elif key == '%s-summary-z' % self.style_prefix:
                self._summary.z = value

    def clean(self):
        self._summary.clean()
        self._summary = None
        self._title.clean()
        self._title = None
        return super(BaseScreenWidget, self).clean()

    def title__get(self):
        return self._title.label

    def title__set(self, label):
        self._title.label = label

    title = property(title__get, title__set)

    def summary__get(self):
        return self._summary.label

    def summary__set(self, label):
        self._summary.label = label

    summary = property(summary__get, summary__set)


class BaseScreen(OptionScreen):

    """
    A base option screen that displays a title and a short text to describe its
    purpose.

    This base class should be inherited and enriched to build more complex
    option screens.
    """

    def initialize(self):
        dfr = super(BaseScreen, self).initialize()
        dfr.addCallback(self._create_widget)
        dfr.addCallback(lambda x: self)
        return dfr

    def _create_widget(self, screen):
        self._base_widget = BaseScreenWidget()
        self.widget.add(self._base_widget)
        self._base_widget.size = (1.0, 1.0)
        self._base_widget.position = (0.0, 0.0, 0.0)
        self._base_widget.visible = True

    def clean(self):
        self._base_widget.clean()
        self._base_widget = None
        return super(BaseScreen, self).clean()

    def title__get(self):
        return self._base_widget.title

    def title__set(self, label):
        self._base_widget.title = label

    title = property(title__get, title__set)

    def summary__get(self):
        return self._base_widget.summary

    def summary__set(self, label):
        self._base_widget.summary = label

    summary = property(summary__get, summary__set)
