import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-flickr',
    version='0.1',
    description='Flickr',
    long_description='Provides access to Flickr services',
    license='GPLv3',
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf'],
                  'elisa.plugins.flickr.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                  },
    entry_points="""\
    """,
    controller_mappings=[('/poblesec/flickr/home',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherPreviewController'),
                         ('/poblesec/flickr',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherController')],
    decorator_mappings=[('/poblesec/pictures/internet',
                         'elisa.plugins.flickr.controller:flickr_decorator')],
    cmdclass=cmdclass)
