/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_H_
#define _PROFILE_H_

#include <vector>
#include <wx/string.h>
using namespace std;

struct NetworkSecuritySet_t
{
    wxString sForbidShareFileAndPrint;
    wxString sForbidShareInternet;
    wxString sStartWindowFirewall;
};

struct IPDNSSet_t
{
    wxString IPvalue;
    wxString SubnetAddress;
    wxString NetGateway;
    wxString DNSvalue;
};

struct ProxySet_t
{
    wxString Proxy;
    wxString Port;
};

struct WEPSecurity_t
{
    wxString value;
    wxString keyIndex;
};

struct WPASecurity_t
{
    wxString value;
};

struct GenernalSettings_t
{
    wxString ConnecType;
};

struct WirelessSettings_t
{
    wxString SSID;
    wxString WirelessType;
    wxString WlanSecurity;

    WPASecurity_t stWPASecurity;
    WEPSecurity_t stWEPSecurity;
};

struct OtherSettings_t
{
    wxString NetworkSecurity;
    wxString AutoRunAppFlag;
    vector<wxString> AutoRunApp;
    wxString IPDNSFlag;
    wxString IsHomepage;
    wxString Homepage;
    wxString ProxyFlag;

    NetworkSecuritySet_t stNetSecurity;
    IPDNSSet_t stIPDNSSet;
    ProxySet_t stProxySet;
};

struct ProfileList_t
{
    wxString sProfileName;
    wxString sPermission;
    wxString sPriority;
    wxString sProfileIcon;
    wxString sShow;

    GenernalSettings_t stGenernalSet;
    WirelessSettings_t stWirelessSet;
    OtherSettings_t stOtherSet;
};

bool operator == (const NetworkSecuritySet_t& s1, const NetworkSecuritySet_t& s2);
bool operator == (const IPDNSSet_t& s1, const IPDNSSet_t& s2);
bool operator == (const ProxySet_t& s1, const ProxySet_t& s2);
bool operator == (const WEPSecurity_t& s1, const WEPSecurity_t& s2);
bool operator == (const WPASecurity_t& s1, const WPASecurity_t& s2);

bool operator == (const GenernalSettings_t& s1, const GenernalSettings_t& s2);
bool operator == (const WirelessSettings_t& s1, const WirelessSettings_t& s2);
bool operator == (const OtherSettings_t& s1, const OtherSettings_t& s2);

bool operator == (const ProfileList_t& pf1, const ProfileList_t& pf2);
bool operator != (const ProfileList_t& pf1, const ProfileList_t& pf2);

#endif // _PROFILE_H_
