/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef ENMUTIL_H_INCLUDED
#define ENMUTIL_H_INCLUDED
#include "wx/string.h"
#include <string>
#include "PopupConfirmDialog.h"
#include "Profile.h"
using namespace std;

class ENMUtil
{
    public:
        static wxString m_appPath;
        static const int CHECK_OK = 0;
        static const int CHECK_ILLEGAL = 1;
        static const int CHECK_EMPTY = 2;
        static const int MAX_IP_ADDRESS = 15;
        static const int MAX_PART_IP = 3;

        static bool FilenameEquals(const wxString& name1, const wxString& name2);
        static void Log(const wxString& file, const wxString& log);
        static string WxStringToString(wxString wxStringValue);
        static wxString StringToWxString(string stringValue);
        static bool IsHexNumber(wxString str);
        static int OnlyLetterAndNum(wxString str);
        static int CheckValide(wxString str);
        static bool IsAdministrator();
        static wxString GetCurrentUserAppDataFolder();
        static string& StringToLowerCase(string& str);
        static bool ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns, int adapterType, const wxString& op);
        static bool GetIPAddress(wxString& ip, wxString& mask, wxString& gateway, wxString& dns, int adapterType);
        static bool DisableInternetSharing();
        static bool EnableInternetSharing();
        static bool AutoRunApp(wxString strAppPath);
        static bool OverwriteHomePage(wxString strHomePage);
        static bool OverwriteProxy(wxString strProxy, wxString strPort);
        static bool IsOnlyNumber(wxString str);
        static bool Enable8021xAuthentication(bool isEnable);
        static bool IsGuest();
        static void ShowSwitchWiredLANDlg();
        static void ShowSwitchWiredSuccDlg();
        static int ShowSwitchWirelessLANDlg();
        static void ShowSwitchWirelessSuccDlg();
        static void ShowNoWirelessAdapterDlg();
        static int ShowSwitchWirelessFailedDlg();
        static void ShowWirelessOnOffDlg(bool isEnable);
        static void ShowAutoConnectionFailedDlg();
        static bool ShowContextHelp(const wxWindow* pWnd, const wxString& section);
        static bool ValidateIPSettings(const IPDNSSet_t& set);
#if defined(__UNIX__)
        static bool IsFirefoxRunning();
        static wxString GetFirefoxConfigFile();
        static wxString GetLocaleFileName(int langCode);

#endif

    private:
        static PopupConfirmDialog* switchWiredSuccDlg;
        static PopupConfirmDialog* switchWirelessSuccDlg;
        static PopupConfirmDialog* noWirelessAdapterDlg;
        static PopupConfirmDialog* wirelessOnOffDlg;
        static PopupConfirmDialog* autoConnectionFailedDlg;
};


#endif // ENMUTIL_H_INCLUDED
