/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "IconPositionCalculator.h"

IconPositionCalculator::IconPositionCalculator()
{
    Reset();
}

IconPositionCalculator::~IconPositionCalculator()
{
}

bool IconPositionCalculator::CalculatePosition(const APStatus& ap, wxPoint& pos, int* charsOfLabel)
{
    int circle = (ap.signalQuality == 100 ? 99 : ap.signalQuality) / 20;
    if ( circle >= 5 )
        return false;
    while ( circle >= 0 && circleButtonCount[circle] >= CIRCLE_AP_COUNT[circle] )
        circle--;
    if ( circle < 0 )
        return false;

    pos.x = POSITION[circle][circleButtonCount[circle]][0];
    pos.y = POSITION[circle][circleButtonCount[circle]][1];
    if ( charsOfLabel != NULL )
    {
        *charsOfLabel = POSITION[circle][circleButtonCount[circle]][2];
    }
    circleButtonCount[circle] ++;
    return true;
}

void IconPositionCalculator::Reset()
{
    for ( size_t i = 0 ; i < CIRCLE_COUNT ; i++ )
        circleButtonCount[i] = 0;
}
