# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

import os
import sys
from subprocess import Popen, PIPE
import classes
import interfaceclasses
import objects

import gettext, locale

from gettext import gettext as _


newmethodos = ['feisty', 'gutsy', 'hardy']
kheaders = os.uname()[2]

def codename():
    """
    Get system codename, can be warty/hoary/breezy/dapper/edgy/etch
    """
    p1 = Popen(['lsb_release', '-c'], stdout=PIPE)
    p = p1.communicate()[0]
    try:
        codename = p.strip()
        tokens = codename.split("\t")
    except AttributeError:
        print 'ERROR: please install lsb-release'
        sys.exit()
    osname = tokens[-1].lower()
    return osname

osname = codename()

def envydependencies():
    '''
    If a user manages to run Envy without installing its dependencies, this function will try to install them.
    If the missing dependencies cannot be installed Envy will exit.
    '''
    dep = classes.Shutilities()
    packages = ['python', 'python-gtk2', 'python-glade2', \
    'python-vte', 'build-essential', 'xserver-xorg-dev', \
    'pkg-config', 'gcc', 'dkms', 'fakeroot', 'devscripts', \
    'dh-make', 'debhelper', 'debconf', 'libstdc++5', 'gksu', \
    'dpkg-dev', 'bash', 'dash', 'dpatch', \
    'lsb-release']
    '''
    DKMS is available in gutsy or higher
    '''

    dep.checkntry(packages)


def removediversion(file):
    check = classes.Shutilities()
    diversions = []
    divert1 = Popen(['dpkg-divert', '--list'], stdout=PIPE)
    divert2 = Popen(['grep', file], stdin=divert1.stdout, stdout=PIPE)
    divout = divert2.communicate()[0]
    output = divout.split('\n')
    #print 'output is ' + str(output)
    #print 'lenoutput is ' + str(len(output))
    if output[0] != '':
        for line in output:
            try:
                diversions.append(line.split(' ')[2])
            except IndexError:
                pass
        if len(diversions) != 0:
            for i in diversions:
                check.cmdoutput( 'sudo dpkg-divert --rename --remove ' + i, 'noverbose')

def glxdiversion():
    removediversion('libglx.so')
    removediversion('libGL')
 
def remove_nvidia_pkg():
    '''
    Solo per il metodo vecchio.
    
    Per quello nuovo servono
    libgl1-mesa-dev libglu1-mesa-dev mesa-common-dev
    
    '''
    packages = ['nvidia-glx', 'nvidia-kernel-' + kheaders, 'nvidia-glx-dev', 'nvidia-kernel-source', 
    'nvidia-glx', 'nvidia-kernel-' + kheaders, 'nvidia-glx-dev', 'nvidia-kernel-source', 'nvidia-glx-new',
    'nvidia-new-kernel-' + kheaders, 'nvidia-glx-new-dev', 'nvidia-new-kernel-source', 
    'nvidia-glx-legacy', 'nvidia-glx-legacy-dev', 'nvidia-legacy-kernel-source', 'nvidia-settings', 'nvidia-xconfig', 
    'nvidia-glx-envy', 'nvidia-glx-dev-envy', 'nvidia-kernel-source-envy', 
    'nvidia-glx-new-envy', 'nvidia-glx-new-dev-envy', 'nvidia-new-kernel-source-envy', 
    'nvidia-glx-legacy-envy', 'nvidia-glx-legacy-dev-envy', 'nvidia-legacy-kernel-source-envy'
    ]
    check = classes.Shutilities()
    check.pkgremove(packages, 'purge')
    files = ['/usr/src/nvidia*.deb', '/usr/lib/xorg/modules/libglx.so']
    dirs = ['/usr/src/modules/nvidia*']
    check.removefiles(files)
    check.removedirs(dirs)



def remove_ati_pkg():
    packages = ['fglrx-control', 'fglrx-kernel-' + kheaders, 'fglrx-kernel-source',
    'xorg-driver-fglrx', 'xorg-driver-fglrx-dev', 'fglrx-amdcccle', 
    'fglrx-kernel-source-envy', 'xorg-driver-fglrx-envy',
    'xorg-driver-fglrx-dev-envy' 
    ]
    check = classes.Shutilities()
    check.pkgremove(packages, 'purge')
    dirs = ['/usr/src/fglrx*.deb']
    files = ['/usr/src/modules/fglrx*']
    check.removefiles(files)
    check.removedirs(dirs)


def dm_stop():
    check = classes.Shutilities()
    c = os.listdir('/etc/init.d/')
    if 'gdm' in c:
        print 'GDM detected'
        check.cmdoutput('sudo /etc/init.d/gdm stop', 'noverbose')
    elif 'kdm' in c:
        print 'KDM detected'
        check.cmdoutput('sudo /etc/init.d/kdm stop', 'noverbose')
    else:
        print _('ENVYNG: No known desktop manager was found.\nPlease stop the xserver manually')
        sys.exit()

def remove_deb():#for both ATI and Nvidia
    check = classes.Shutilities()
    files = ['*.deb']
    check.removefiles(files)

def depmodules():
    check = classes.Shutilities()
    check.cmdoutput('sudo depmod -ae')

def restoremesa():
    check = classes.Shutilities()
    check.cmdoutput('sudo apt-get -y install --reinstall libgl1-mesa-glx libglu1-mesa  libgl1-mesa-dri')

def pcrestart():
    check = classes.Shutilities()
    while 1:
        xsrv = raw_input('Do you want to restart your computer now (Recommended)? (y/n) \ "y" is the default answer\n').strip().lower()
        if xsrv == 'y' or xsrv == '' or xsrv == 'yes':
            check.cmdoutput('sudo reboot')
            break
            sys.exit()
        elif xsrv == 'n':
            print _('Remember to restart your computer manually')
            break
            sys.exit()
        elif xsrv == 'no':
            print _('Remember to restart your computer manually')
            break
            sys.exit()

def dependencies():
    check = classes.Shutilities()
    check.pkginstall('linux-headers-' + kheaders)
    try:#it's useless for recompiled kernels
        '''
        so that linux-headers-generic, -rt, etc. are installed
        and DKMS can build the module when the kernel
        is updated
        '''
        kver3 = kheaders.split('-')[2]#-rt, -generic, etc.
        check.pkginstall('linux-headers-' + kver3)
    except:
        pass


def newdependencies():
    if osname in newmethodos:#Only for the new method with Nvidia cards
        packagestocheck = ['cpio', 'debhelper', 'libqt3-mt-dev', 'kernel-wedge', 'module-init-tools', 'rpm', 'sed', 'sharutils', 'bzip2', 'libgtk2.0-dev', 'libxxf86misc-dev', 'libxtst-dev', 'libxxf86vm-dev', 'libxinerama-dev', 'libstdc++5']
        print 'Checking the Dependencies for the New Method'
        check = classes.Shutilities()
        check.checkntry(packagestocheck)
        if os.uname()[-1] == 'x86_64':
            check.checkntry('libc6-i386')


def xserverstart():
    check = classes.Shutilities()
    gdm = None
    kdm = None
    while 1:
        xsrv = raw_input('Do you want to Start the Xserver now? (y/n) \ "y" is the default answer\n').strip().lower()
        if xsrv == 'y' or xsrv == '' or xsrv == 'yes':
            c = os.listdir('/etc/init.d')
            if 'gdm' in c:
                print 'GDM detected'
                check.cmdoutput('sudo /etc/init.d/gdm restart', 'noverbose')
            elif 'kdm' in c:
                print 'KDM detected'
                check.cmdoutput('sudo /etc/init.d/kdm restart', 'noverbose')
            else:
                print 'ENVYNG: No known desktop manager was found.\nPlease restart the xserver manually'
            #os.system('sudo /etc/init.d/gdm restart; sudo /etc/init.d/kdm restart')
            sys.exit()
            break
        elif xsrv == 'n':
            print 'Remember to start the xserver manually'
            break
            #sys.exit()
        elif xsrv.lower() == 'no':
            print 'Remember to start the xserver manually'
            break
            #sys.exit()


def xorgset():
    answer = raw_input('Do you want your xorg.conf to be automatically configured? (y/n) \ "y" is the default answer\n').strip().lower()
    while 1:
        if answer == 'y' or answer == '':
            return 'y'
        elif answer == 'n':
            return 'n'

def headersCheck():
    check = classes.Shutilities()
    '''
    so that linux-headers-generic, -rt, etc. are installed
    and DKMS can build the module when the kernel
    is updated
    
    NOTE: it throws an error if the -xen flavour is in use
    '''
    #kheaders = os.uname()[2]
    toinstall = []
    all_flavours = ['generic', '386', 'rt', 'server', 'openvz', 'virtual', 'xen']
    unsupported_flavours = ['xen']
    supported_flavours = []
    
    for flavour in all_flavours:
        if flavour not in unsupported_flavours:
            supported_flavours.append(flavour)
    
    
    kver3 = kheaders.strip().split('-')[-1]#-rt, -generic, etc.
    if kver3 in all_flavours:
        if kver3 in unsupported_flavours:
            error = '\nEnvyNG Error: the driver cannot be installed with your current kernel. \
Try installing and booting into one of the following kernel flavours: \
\nlinux-' + ' linux-'.join(supported_flavours)
            raise Exception(error)
        print 'EnvyNG: Ubuntu stock kernel detected (%s)' % (kheaders)
        pkg2 = 'linux-headers-' + kver3
        toinstall.append(pkg2)

    pkg1 = 'linux-headers-' + kheaders
    toinstall.append(pkg1)
    
    for package in toinstall:
        check.pkginstall(package)


if __name__ == '__main__':
    gettext.textdomain("envy")

