/*FreeMind - A Program for creating and viewing Mindmaps
 *Copyright (C) 2000-2006  Joerg Mueller, Daniel Polansky, Christian Foltin, Dimitri Polivaev and others.
 *See COPYING for Details
 *
 *This program is free software; you can redistribute it and/or
 *modify it under the terms of the GNU General Public License
 *as published by the Free Software Foundation; either version 2
 *of the License, or (at your option) any later version.
 *
 *This program is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *GNU General Public License for more details.
 *
 *You should have received a copy of the GNU General Public License
 *along with this program; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/* $Id: AttributeTableCellRenderer.java,v 1.1.2.3 2010/11/06 21:10:25 christianfoltin Exp $ */
package freemind.view.mindmapview.attributeview;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

import freemind.view.mindmapview.MainView;

public class AttributeTableCellRenderer extends DefaultTableCellRenderer {
    
    private boolean isPainting;
	private float zoom;
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        final Component rendererComponent = super.getTableCellRendererComponent(table, value, hasFocus, false,
                row, column);
        if(hasFocus){
            setBorder( UIManager.getBorder("Table.focusCellHighlightBorder") );
        }
        zoom = ((AttributeTable)table).getZoom();
        return rendererComponent;
    }

    public void paint(Graphics g) {
        final Graphics2D g2 = (Graphics2D)g;
	    if(zoom != 1F){
	    	// Dimitry: Workaround because Swing do not use fractional metrics 
	    	// for laying JLabels out 
	    	zoom *= MainView.ZOOM_CORRECTION_FACTOR;
	        final AffineTransform transform = g2.getTransform();                
	        g2.scale(zoom, zoom);
	        isPainting = true;
	        super.paint(g);
	        isPainting = false;
	        g2.setTransform(transform);
	    }
	    else{
	        super.paint(g);
	    }
	}

    /* (non-Javadoc)
     * @see javax.swing.JComponent#getHeight()
     */
    public int getHeight() {
        if(isPainting){
            if(zoom != 1F){
                return (int)(super.getHeight()/zoom);
            }
        }
        return super.getHeight();
    }
    /* (non-Javadoc)
     * @see javax.swing.JComponent#getWidth()
     */
    public int getWidth() {
        if(isPainting){
            if(zoom != 1F){
                return (int)(0.99f+super.getWidth()/zoom);
            }
        }
        return super.getWidth();
    }
}
