
 /************************************************************************
  * Copyright 2005-2010 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

#ifndef G711_ENC_API_H
#define G711_ENC_API_H
/*==================================================================================================

     Header Name: g711_enc_api.h

     General Description:

====================================================================================================
Revision History:
                            Modification     Tracking
Author                          Date          Number     Description of Changes
-------------------------   ------------    ----------   -------------------------------------------
Priyank Saxena              Jun/17/2005                   Initial version
Neha Srivastava             Jan/24/2007                   Elinux Ported Version
Qiu Cunshou                 May/22/2008     engr77040     Add API for version
Lyon Wang                   May/06/2010     engr123230    Add g711_type.h
====================================================================================================
                                         INCLUDE FILES
==================================================================================================*/
#include "g711_type.h"

/*==================================================================================================
                                           CONSTANTS
==================================================================================================*/

/*==================================================================================================
                                            MACROS
==================================================================================================*/

/*==================================================================================================
                                             ENUMS
==================================================================================================*/

/*==================================================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
                                 GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
                                     FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __SYMBIAN32__
#define EXPORT_C __declspec(dllexport)
#else
#define EXPORT_C
#endif
#ifdef __cplusplus
extern "C"
{
#endif
 void g711AlawEncode(G711_U16 size, G711_S16 *inBuf, G711_U8 *outBuf);
 void g711MulawEncode(G711_U16 size, G711_S16 *inBuf, G711_U8 *outBuf);
 void g711Alaw2Mulaw(G711_U16 size, G711_U8 *inBuf, G711_U8 *outBuf);
 void g711Mulaw2Alaw(G711_U16 size, G711_U8 *inBuf, G711_U8 *outBuf);
 const char *G711E_get_version_info(void);
#ifdef __cplusplus
}
#endif

#endif /* G711_ENC_API_H */
